# Cin7\SaleApi

All URIs are relative to https://inventory.dearsystems.com/externalapi/v2, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**deleteSale()**](SaleApi.md#deleteSale) | **DELETE** /sale | Your DELETE endpoint |
| [**deleteSaleCreditnote()**](SaleApi.md#deleteSaleCreditnote) | **DELETE** /sale/creditnote | Your DELETE endpoint |
| [**deleteSaleFulfilment()**](SaleApi.md#deleteSaleFulfilment) | **DELETE** /sale/fulfilment | Your DELETE endpoint |
| [**deleteSaleInvoice()**](SaleApi.md#deleteSaleInvoice) | **DELETE** /sale/invoice | Your DELETE endpoint |
| [**deleteSalePayment()**](SaleApi.md#deleteSalePayment) | **DELETE** /sale/payment | Your DELETE endpoint |
| [**getSale()**](SaleApi.md#getSale) | **GET** /sale | Your GET endpoint |
| [**getSaleCreditNoteList()**](SaleApi.md#getSaleCreditNoteList) | **GET** /saleCreditNoteList | Your GET endpoint |
| [**getSaleCreditnote()**](SaleApi.md#getSaleCreditnote) | **GET** /sale/creditnote | Your GET endpoint |
| [**getSaleFulfilment()**](SaleApi.md#getSaleFulfilment) | **GET** /sale/fulfilment | Your GET endpoint |
| [**getSaleInvoice()**](SaleApi.md#getSaleInvoice) | **GET** /sale/invoice | Your GET endpoint |
| [**getSaleList()**](SaleApi.md#getSaleList) | **GET** /saleList | Your GET endpoint |
| [**getSaleOrder()**](SaleApi.md#getSaleOrder) | **GET** /sale/order | Your GET endpoint |
| [**getSalePayment()**](SaleApi.md#getSalePayment) | **GET** /sale/payment | Your GET endpoint |
| [**postSale()**](SaleApi.md#postSale) | **POST** /sale | Your POST endpoint |
| [**postSaleCreditnote()**](SaleApi.md#postSaleCreditnote) | **POST** /sale/creditnote | Your POST endpoint |
| [**postSaleFulfilment()**](SaleApi.md#postSaleFulfilment) | **POST** /sale/fulfilment | Your POST endpoint |
| [**postSaleInvoice()**](SaleApi.md#postSaleInvoice) | **POST** /sale/invoice | Your POST endpoint |
| [**postSaleOrder()**](SaleApi.md#postSaleOrder) | **POST** /sale/order | Your POST endpoint |
| [**postSalePayment()**](SaleApi.md#postSalePayment) | **POST** /sale/payment | Your POST endpoint |
| [**putSale()**](SaleApi.md#putSale) | **PUT** /sale | Your PUT endpoint |
| [**putSaleInvoice()**](SaleApi.md#putSaleInvoice) | **PUT** /sale/invoice | Your PUT endpoint |
| [**putSalePayment()**](SaleApi.md#putSalePayment) | **PUT** /sale/payment | Your PUT endpoint |


## `deleteSale()`

```php
deleteSale($id, $void): \Cin7\Model\SaleFull
```

Your DELETE endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string
$void = True; // bool

try {
    $result = $apiInstance->deleteSale($id, $void);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->deleteSale: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | [optional] |
| **void** | **bool**|  | [optional] |

### Return type

[**\Cin7\Model\SaleFull**](../Model/SaleFull.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteSaleCreditnote()`

```php
deleteSaleCreditnote($task_id, $void): \Cin7\Model\SaleCreditNotes
```

Your DELETE endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$task_id = 'task_id_example'; // string
$void = True; // bool

try {
    $result = $apiInstance->deleteSaleCreditnote($task_id, $void);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->deleteSaleCreditnote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **task_id** | **string**|  | [optional] |
| **void** | **bool**|  | [optional] |

### Return type

[**\Cin7\Model\SaleCreditNotes**](../Model/SaleCreditNotes.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteSaleFulfilment()`

```php
deleteSaleFulfilment($task_id, $void): \Cin7\Model\SaleFulfilments
```

Your DELETE endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$task_id = 'task_id_example'; // string
$void = True; // bool

try {
    $result = $apiInstance->deleteSaleFulfilment($task_id, $void);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->deleteSaleFulfilment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **task_id** | **string**|  | [optional] |
| **void** | **bool**|  | [optional] |

### Return type

[**\Cin7\Model\SaleFulfilments**](../Model/SaleFulfilments.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteSaleInvoice()`

```php
deleteSaleInvoice($task_id, $void): \Cin7\Model\SaleInvoices
```

Your DELETE endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$task_id = 'task_id_example'; // string
$void = True; // bool

try {
    $result = $apiInstance->deleteSaleInvoice($task_id, $void);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->deleteSaleInvoice: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **task_id** | **string**|  | [optional] |
| **void** | **bool**|  | [optional] |

### Return type

[**\Cin7\Model\SaleInvoices**](../Model/SaleInvoices.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteSalePayment()`

```php
deleteSalePayment($id): \Cin7\Model\DeleteSalePayment200Response
```

Your DELETE endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->deleteSalePayment($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->deleteSalePayment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | [optional] |

### Return type

[**\Cin7\Model\DeleteSalePayment200Response**](../Model/DeleteSalePayment200Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSale()`

```php
getSale($id, $combine_additional_charges, $hide_inventory_movements, $include_transactions, $country_format): \Cin7\Model\SaleFull
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string
$combine_additional_charges = 'combine_additional_charges_example'; // string
$hide_inventory_movements = 'hide_inventory_movements_example'; // string
$include_transactions = 'include_transactions_example'; // string
$country_format = 'country_format_example'; // string

try {
    $result = $apiInstance->getSale($id, $combine_additional_charges, $hide_inventory_movements, $include_transactions, $country_format);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->getSale: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | [optional] |
| **combine_additional_charges** | **string**|  | [optional] |
| **hide_inventory_movements** | **string**|  | [optional] |
| **include_transactions** | **string**|  | [optional] |
| **country_format** | **string**|  | [optional] |

### Return type

[**\Cin7\Model\SaleFull**](../Model/SaleFull.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSaleCreditNoteList()`

```php
getSaleCreditNoteList($page, $limit, $search, $created_since, $updated_since, $credit_note_status, $status): \Cin7\Model\GetSaleCreditNoteList200Response
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 3.4; // float
$limit = 3.4; // float
$search = 'search_example'; // string
$created_since = 'created_since_example'; // string
$updated_since = 'updated_since_example'; // string
$credit_note_status = 'credit_note_status_example'; // string
$status = 'status_example'; // string

try {
    $result = $apiInstance->getSaleCreditNoteList($page, $limit, $search, $created_since, $updated_since, $credit_note_status, $status);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->getSaleCreditNoteList: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **float**|  | [optional] |
| **limit** | **float**|  | [optional] |
| **search** | **string**|  | [optional] |
| **created_since** | **string**|  | [optional] |
| **updated_since** | **string**|  | [optional] |
| **credit_note_status** | **string**|  | [optional] |
| **status** | **string**|  | [optional] |

### Return type

[**\Cin7\Model\GetSaleCreditNoteList200Response**](../Model/GetSaleCreditNoteList200Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSaleCreditnote()`

```php
getSaleCreditnote($sale_id, $combine_additional_charges, $include_product_info, $include_payment_info): \Cin7\Model\SaleCreditNotes
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sale_id = 'sale_id_example'; // string
$combine_additional_charges = 'combine_additional_charges_example'; // string
$include_product_info = 'include_product_info_example'; // string
$include_payment_info = 'include_payment_info_example'; // string

try {
    $result = $apiInstance->getSaleCreditnote($sale_id, $combine_additional_charges, $include_product_info, $include_payment_info);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->getSaleCreditnote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale_id** | **string**|  | [optional] |
| **combine_additional_charges** | **string**|  | [optional] |
| **include_product_info** | **string**|  | [optional] |
| **include_payment_info** | **string**|  | [optional] |

### Return type

[**\Cin7\Model\SaleCreditNotes**](../Model/SaleCreditNotes.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSaleFulfilment()`

```php
getSaleFulfilment($sale_id, $include_product_info): \Cin7\Model\SaleFulfilments
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sale_id = 'sale_id_example'; // string
$include_product_info = 'include_product_info_example'; // string

try {
    $result = $apiInstance->getSaleFulfilment($sale_id, $include_product_info);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->getSaleFulfilment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale_id** | **string**|  | [optional] |
| **include_product_info** | **string**|  | [optional] |

### Return type

[**\Cin7\Model\SaleFulfilments**](../Model/SaleFulfilments.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSaleInvoice()`

```php
getSaleInvoice($sale_id, $combine_additional_charges, $include_product_info)
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sale_id = 'sale_id_example'; // string
$combine_additional_charges = 'combine_additional_charges_example'; // string
$include_product_info = 'include_product_info_example'; // string

try {
    $apiInstance->getSaleInvoice($sale_id, $combine_additional_charges, $include_product_info);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->getSaleInvoice: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale_id** | **string**|  | [optional] |
| **combine_additional_charges** | **string**|  | [optional] |
| **include_product_info** | **string**|  | [optional] |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSaleList()`

```php
getSaleList($page, $limit, $search, $created_since, $updated_since, $ship_by, $quote_status, $order_status, $combined_pick_status, $combined_pack_status, $combined_shipping_status, $combined_invoice_status, $credit_note_status, $external_id, $status, $ready_for_shipping, $order_location_id): \Cin7\Model\GetSaleList200Response
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page = 3.4; // float
$limit = 3.4; // float
$search = 'search_example'; // string
$created_since = 'created_since_example'; // string
$updated_since = 'updated_since_example'; // string
$ship_by = 'ship_by_example'; // string
$quote_status = 'quote_status_example'; // string
$order_status = 'order_status_example'; // string
$combined_pick_status = 'combined_pick_status_example'; // string
$combined_pack_status = 'combined_pack_status_example'; // string
$combined_shipping_status = 'combined_shipping_status_example'; // string
$combined_invoice_status = 'combined_invoice_status_example'; // string
$credit_note_status = 'credit_note_status_example'; // string
$external_id = 'external_id_example'; // string
$status = 'status_example'; // string
$ready_for_shipping = True; // bool
$order_location_id = 'order_location_id_example'; // string

try {
    $result = $apiInstance->getSaleList($page, $limit, $search, $created_since, $updated_since, $ship_by, $quote_status, $order_status, $combined_pick_status, $combined_pack_status, $combined_shipping_status, $combined_invoice_status, $credit_note_status, $external_id, $status, $ready_for_shipping, $order_location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->getSaleList: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **float**|  | [optional] |
| **limit** | **float**|  | [optional] |
| **search** | **string**|  | [optional] |
| **created_since** | **string**|  | [optional] |
| **updated_since** | **string**|  | [optional] |
| **ship_by** | **string**|  | [optional] |
| **quote_status** | **string**|  | [optional] |
| **order_status** | **string**|  | [optional] |
| **combined_pick_status** | **string**|  | [optional] |
| **combined_pack_status** | **string**|  | [optional] |
| **combined_shipping_status** | **string**|  | [optional] |
| **combined_invoice_status** | **string**|  | [optional] |
| **credit_note_status** | **string**|  | [optional] |
| **external_id** | **string**|  | [optional] |
| **status** | **string**|  | [optional] |
| **ready_for_shipping** | **bool**|  | [optional] |
| **order_location_id** | **string**|  | [optional] |

### Return type

[**\Cin7\Model\GetSaleList200Response**](../Model/GetSaleList200Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSaleOrder()`

```php
getSaleOrder($sale_id, $combine_additional_charges, $include_product_info): \Cin7\Model\Order
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sale_id = 'sale_id_example'; // string
$combine_additional_charges = 'combine_additional_charges_example'; // string
$include_product_info = 'include_product_info_example'; // string

try {
    $result = $apiInstance->getSaleOrder($sale_id, $combine_additional_charges, $include_product_info);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->getSaleOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale_id** | **string**|  | [optional] |
| **combine_additional_charges** | **string**|  | [optional] |
| **include_product_info** | **string**|  | [optional] |

### Return type

[**\Cin7\Model\Order**](../Model/Order.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalePayment()`

```php
getSalePayment($sale_id): \Cin7\Model\Payment[]
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sale_id = 'sale_id_example'; // string

try {
    $result = $apiInstance->getSalePayment($sale_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->getSalePayment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale_id** | **string**|  | [optional] |

### Return type

[**\Cin7\Model\Payment[]**](../Model/Payment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSale()`

```php
postSale($sale): \Cin7\Model\SaleFull
```

Your POST endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sale = new \Cin7\Model\Sale(); // \Cin7\Model\Sale

try {
    $result = $apiInstance->postSale($sale);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->postSale: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale** | [**\Cin7\Model\Sale**](../Model/Sale.md)|  | [optional] |

### Return type

[**\Cin7\Model\SaleFull**](../Model/SaleFull.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSaleCreditnote()`

```php
postSaleCreditnote($credit_note): \Cin7\Model\SaleCreditNotes
```

Your POST endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$credit_note = new \Cin7\Model\CreditNote(); // \Cin7\Model\CreditNote

try {
    $result = $apiInstance->postSaleCreditnote($credit_note);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->postSaleCreditnote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **credit_note** | [**\Cin7\Model\CreditNote**](../Model/CreditNote.md)|  | [optional] |

### Return type

[**\Cin7\Model\SaleCreditNotes**](../Model/SaleCreditNotes.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSaleFulfilment()`

```php
postSaleFulfilment($sale_fulfilments): \Cin7\Model\SaleFulfilments
```

Your POST endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sale_fulfilments = new \Cin7\Model\SaleFulfilments(); // \Cin7\Model\SaleFulfilments

try {
    $result = $apiInstance->postSaleFulfilment($sale_fulfilments);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->postSaleFulfilment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale_fulfilments** | [**\Cin7\Model\SaleFulfilments**](../Model/SaleFulfilments.md)|  | [optional] |

### Return type

[**\Cin7\Model\SaleFulfilments**](../Model/SaleFulfilments.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSaleInvoice()`

```php
postSaleInvoice($invoice): \Cin7\Model\SaleInvoices
```

Your POST endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$invoice = new \Cin7\Model\Invoice(); // \Cin7\Model\Invoice

try {
    $result = $apiInstance->postSaleInvoice($invoice);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->postSaleInvoice: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **invoice** | [**\Cin7\Model\Invoice**](../Model/Invoice.md)|  | [optional] |

### Return type

[**\Cin7\Model\SaleInvoices**](../Model/SaleInvoices.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSaleOrder()`

```php
postSaleOrder($order): \Cin7\Model\Order
```

Your POST endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$order = new \Cin7\Model\Order(); // \Cin7\Model\Order

try {
    $result = $apiInstance->postSaleOrder($order);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->postSaleOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order** | [**\Cin7\Model\Order**](../Model/Order.md)|  | [optional] |

### Return type

[**\Cin7\Model\Order**](../Model/Order.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postSalePayment()`

```php
postSalePayment($payment): \Cin7\Model\Payment
```

Your POST endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$payment = new \Cin7\Model\Payment(); // \Cin7\Model\Payment

try {
    $result = $apiInstance->postSalePayment($payment);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->postSalePayment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **payment** | [**\Cin7\Model\Payment**](../Model/Payment.md)|  | [optional] |

### Return type

[**\Cin7\Model\Payment**](../Model/Payment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putSale()`

```php
putSale($sale): \Cin7\Model\SaleFull
```

Your PUT endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sale = new \Cin7\Model\Sale(); // \Cin7\Model\Sale

try {
    $result = $apiInstance->putSale($sale);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->putSale: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sale** | [**\Cin7\Model\Sale**](../Model/Sale.md)|  | [optional] |

### Return type

[**\Cin7\Model\SaleFull**](../Model/SaleFull.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putSaleInvoice()`

```php
putSaleInvoice($invoice): \Cin7\Model\SaleInvoices
```

Your PUT endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$invoice = new \Cin7\Model\Invoice(); // \Cin7\Model\Invoice

try {
    $result = $apiInstance->putSaleInvoice($invoice);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->putSaleInvoice: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **invoice** | [**\Cin7\Model\Invoice**](../Model/Invoice.md)|  | [optional] |

### Return type

[**\Cin7\Model\SaleInvoices**](../Model/SaleInvoices.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putSalePayment()`

```php
putSalePayment($payment): \Cin7\Model\Payment
```

Your PUT endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\SaleApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$payment = new \Cin7\Model\Payment(); // \Cin7\Model\Payment

try {
    $result = $apiInstance->putSalePayment($payment);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SaleApi->putSalePayment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **payment** | [**\Cin7\Model\Payment**](../Model/Payment.md)|  | [optional] |

### Return type

[**\Cin7\Model\Payment**](../Model/Payment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
