# Cin7\ProductApi

All URIs are relative to https://inventory.dearsystems.com/externalapi/v2, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getProduct()**](ProductApi.md#getProduct) | **GET** /product | Your GET endpoint |
| [**postProduct()**](ProductApi.md#postProduct) | **POST** /product | Your POST endpoint |
| [**putProduct()**](ProductApi.md#putProduct) | **PUT** /product | Your PUT endpoint |


## `getProduct()`

```php
getProduct($id, $page, $limit, $name, $sku, $modified_since, $include_deprecated, $include_bom, $include_suppliers, $include_movements, $include_attachments, $include_reorder_levels, $include_custom_prices)
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string
$page = 3.4; // float
$limit = 3.4; // float
$name = 'name_example'; // string
$sku = 'sku_example'; // string
$modified_since = 'modified_since_example'; // string
$include_deprecated = True; // bool
$include_bom = True; // bool
$include_suppliers = True; // bool
$include_movements = True; // bool
$include_attachments = True; // bool
$include_reorder_levels = True; // bool
$include_custom_prices = True; // bool

try {
    $apiInstance->getProduct($id, $page, $limit, $name, $sku, $modified_since, $include_deprecated, $include_bom, $include_suppliers, $include_movements, $include_attachments, $include_reorder_levels, $include_custom_prices);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->getProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | [optional] |
| **page** | **float**|  | [optional] |
| **limit** | **float**|  | [optional] |
| **name** | **string**|  | [optional] |
| **sku** | **string**|  | [optional] |
| **modified_since** | **string**|  | [optional] |
| **include_deprecated** | **bool**|  | [optional] |
| **include_bom** | **bool**|  | [optional] |
| **include_suppliers** | **bool**|  | [optional] |
| **include_movements** | **bool**|  | [optional] |
| **include_attachments** | **bool**|  | [optional] |
| **include_reorder_levels** | **bool**|  | [optional] |
| **include_custom_prices** | **bool**|  | [optional] |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postProduct()`

```php
postProduct($product): \Cin7\Model\Product
```

Your POST endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \Cin7\Model\Product(); // \Cin7\Model\Product

try {
    $result = $apiInstance->postProduct($product);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->postProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product** | [**\Cin7\Model\Product**](../Model/Product.md)|  | [optional] |

### Return type

[**\Cin7\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `putProduct()`

```php
putProduct($product): \Cin7\Model\Product
```

Your PUT endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Cin7\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \Cin7\Model\Product(); // \Cin7\Model\Product

try {
    $result = $apiInstance->putProduct($product);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->putProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product** | [**\Cin7\Model\Product**](../Model/Product.md)|  | [optional] |

### Return type

[**\Cin7\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
