# OpenAPIClient-php

Cin7 Core Inventory API is part of Cin7 Core Inventory web application at https://inventory.dearsystems.com.
https://dearinventory.docs.apiary.io/#introduction/api-introduction


For more information, please visit [Https://tideconnects.com](Https://tideconnects.com).

## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/cin7.git"
    }
  ],
  "require": {
    "talisman/cin7": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Cin7\Api\MeApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getMe();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MeApi->getMe: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://inventory.dearsystems.com/externalapi/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MeApi* | [**getMe**](docs/Api/MeApi.md#getme) | **GET** /me | Get Me
*ProductApi* | [**getProduct**](docs/Api/ProductApi.md#getproduct) | **GET** /product | Your GET endpoint
*ProductApi* | [**postProduct**](docs/Api/ProductApi.md#postproduct) | **POST** /product | Your POST endpoint
*ProductApi* | [**putProduct**](docs/Api/ProductApi.md#putproduct) | **PUT** /product | Your PUT endpoint
*SaleApi* | [**deleteSale**](docs/Api/SaleApi.md#deletesale) | **DELETE** /sale | Your DELETE endpoint
*SaleApi* | [**deleteSaleCreditnote**](docs/Api/SaleApi.md#deletesalecreditnote) | **DELETE** /sale/creditnote | Your DELETE endpoint
*SaleApi* | [**deleteSaleFulfilment**](docs/Api/SaleApi.md#deletesalefulfilment) | **DELETE** /sale/fulfilment | Your DELETE endpoint
*SaleApi* | [**deleteSaleInvoice**](docs/Api/SaleApi.md#deletesaleinvoice) | **DELETE** /sale/invoice | Your DELETE endpoint
*SaleApi* | [**deleteSalePayment**](docs/Api/SaleApi.md#deletesalepayment) | **DELETE** /sale/payment | Your DELETE endpoint
*SaleApi* | [**getSale**](docs/Api/SaleApi.md#getsale) | **GET** /sale | Your GET endpoint
*SaleApi* | [**getSaleCreditNoteList**](docs/Api/SaleApi.md#getsalecreditnotelist) | **GET** /saleCreditNoteList | Your GET endpoint
*SaleApi* | [**getSaleCreditnote**](docs/Api/SaleApi.md#getsalecreditnote) | **GET** /sale/creditnote | Your GET endpoint
*SaleApi* | [**getSaleFulfilment**](docs/Api/SaleApi.md#getsalefulfilment) | **GET** /sale/fulfilment | Your GET endpoint
*SaleApi* | [**getSaleInvoice**](docs/Api/SaleApi.md#getsaleinvoice) | **GET** /sale/invoice | Your GET endpoint
*SaleApi* | [**getSaleList**](docs/Api/SaleApi.md#getsalelist) | **GET** /saleList | Your GET endpoint
*SaleApi* | [**getSaleOrder**](docs/Api/SaleApi.md#getsaleorder) | **GET** /sale/order | Your GET endpoint
*SaleApi* | [**getSalePayment**](docs/Api/SaleApi.md#getsalepayment) | **GET** /sale/payment | Your GET endpoint
*SaleApi* | [**postSale**](docs/Api/SaleApi.md#postsale) | **POST** /sale | Your POST endpoint
*SaleApi* | [**postSaleCreditnote**](docs/Api/SaleApi.md#postsalecreditnote) | **POST** /sale/creditnote | Your POST endpoint
*SaleApi* | [**postSaleFulfilment**](docs/Api/SaleApi.md#postsalefulfilment) | **POST** /sale/fulfilment | Your POST endpoint
*SaleApi* | [**postSaleInvoice**](docs/Api/SaleApi.md#postsaleinvoice) | **POST** /sale/invoice | Your POST endpoint
*SaleApi* | [**postSaleOrder**](docs/Api/SaleApi.md#postsaleorder) | **POST** /sale/order | Your POST endpoint
*SaleApi* | [**postSalePayment**](docs/Api/SaleApi.md#postsalepayment) | **POST** /sale/payment | Your POST endpoint
*SaleApi* | [**putSale**](docs/Api/SaleApi.md#putsale) | **PUT** /sale | Your PUT endpoint
*SaleApi* | [**putSaleInvoice**](docs/Api/SaleApi.md#putsaleinvoice) | **PUT** /sale/invoice | Your PUT endpoint
*SaleApi* | [**putSalePayment**](docs/Api/SaleApi.md#putsalepayment) | **PUT** /sale/payment | Your PUT endpoint

## Models

- [AdditionalAttributes](docs/Model/AdditionalAttributes.md)
- [AdditionalCharge](docs/Model/AdditionalCharge.md)
- [Attachment](docs/Model/Attachment.md)
- [BillOfMaterialsProduct](docs/Model/BillOfMaterialsProduct.md)
- [BillOfMaterialsService](docs/Model/BillOfMaterialsService.md)
- [BillingAddress](docs/Model/BillingAddress.md)
- [Contact](docs/Model/Contact.md)
- [CreditNote](docs/Model/CreditNote.md)
- [CustomPrice](docs/Model/CustomPrice.md)
- [DeleteSalePayment200Response](docs/Model/DeleteSalePayment200Response.md)
- [Fulfilment](docs/Model/Fulfilment.md)
- [GetSaleCreditNoteList200Response](docs/Model/GetSaleCreditNoteList200Response.md)
- [GetSaleList200Response](docs/Model/GetSaleList200Response.md)
- [InventoryMovement](docs/Model/InventoryMovement.md)
- [Invoice](docs/Model/Invoice.md)
- [Line](docs/Model/Line.md)
- [ManualJournal](docs/Model/ManualJournal.md)
- [Me](docs/Model/Me.md)
- [Movement](docs/Model/Movement.md)
- [Order](docs/Model/Order.md)
- [Pack](docs/Model/Pack.md)
- [Payment](docs/Model/Payment.md)
- [Pick](docs/Model/Pick.md)
- [Prepayment](docs/Model/Prepayment.md)
- [PriceTiers](docs/Model/PriceTiers.md)
- [Product](docs/Model/Product.md)
- [Quote](docs/Model/Quote.md)
- [Refund](docs/Model/Refund.md)
- [ReorderLevel](docs/Model/ReorderLevel.md)
- [Restock](docs/Model/Restock.md)
- [Rounding](docs/Model/Rounding.md)
- [Sale](docs/Model/Sale.md)
- [SaleCreditNotes](docs/Model/SaleCreditNotes.md)
- [SaleFulfilments](docs/Model/SaleFulfilments.md)
- [SaleFull](docs/Model/SaleFull.md)
- [SaleInvoices](docs/Model/SaleInvoices.md)
- [SaleSummary](docs/Model/SaleSummary.md)
- [Ship](docs/Model/Ship.md)
- [ShippingAddress](docs/Model/ShippingAddress.md)
- [ShippingLIne](docs/Model/ShippingLIne.md)
- [Supplier](docs/Model/Supplier.md)
- [Transaction](docs/Model/Transaction.md)

## Authorization
Endpoints do not require authorization.

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author

support@tideconnects.com

## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `1.0`
    - Package version: `1.0`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
