# Bigcommerce\WebhooksV3\WebhooksApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createWebhooks()**](WebhooksApi.md#createWebhooks) | **POST** /hooks | Create a Webhook |
| [**deleteAWebhook()**](WebhooksApi.md#deleteAWebhook) | **DELETE** /hooks/{id} | Delete a Webhook |
| [**getAllWebhooks()**](WebhooksApi.md#getAllWebhooks) | **GET** /hooks | Get Webhooks |
| [**getWebhook()**](WebhooksApi.md#getWebhook) | **GET** /hooks/{id} | Get a Webhook |
| [**updateAWebhook()**](WebhooksApi.md#updateAWebhook) | **PUT** /hooks/{id} | Update a Webhook |


## `createWebhooks()`

```php
createWebhooks($webhook_base): \Bigcommerce\WebhooksV3\Model\CreateWebhooks200Response
```

Create a Webhook

Creates a webhook. Only one webhook at a time can be created. Custom headers can be added.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\WebhooksV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\WebhooksV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\WebhooksV3\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$webhook_base = {"scope":"{$$.env.scope}","destination":"{$$.env.destination}","is_active":true}; // \Bigcommerce\WebhooksV3\Model\WebhookBase

try {
    $result = $apiInstance->createWebhooks($webhook_base);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->createWebhooks: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **webhook_base** | [**\Bigcommerce\WebhooksV3\Model\WebhookBase**](../Model/WebhookBase.md)|  | [optional] |

### Return type

[**\Bigcommerce\WebhooksV3\Model\CreateWebhooks200Response**](../Model/CreateWebhooks200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `v3`, `v2`, `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteAWebhook()`

```php
deleteAWebhook($id): \Bigcommerce\WebhooksV3\Model\CreateWebhooks200Response
```

Delete a Webhook

Deletes a webhook. Only one webhook at a time can be deleted. When a webhook is deleted, it is returned in the response as a 200 OK.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\WebhooksV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\WebhooksV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\WebhooksV3\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->deleteAWebhook($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->deleteAWebhook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |

### Return type

[**\Bigcommerce\WebhooksV3\Model\CreateWebhooks200Response**](../Model/CreateWebhooks200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `v3`, `v2`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllWebhooks()`

```php
getAllWebhooks(): \Bigcommerce\WebhooksV3\Model\GetAllWebhooks200Response
```

Get Webhooks

Returns a list of all webhooks on a store associated to the `client_id` used to authenticate the request.  *Note: BigCommerce determines the `client_id` from the `access_token`.*

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\WebhooksV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\WebhooksV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\WebhooksV3\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getAllWebhooks();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->getAllWebhooks: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Bigcommerce\WebhooksV3\Model\GetAllWebhooks200Response**](../Model/GetAllWebhooks200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `v3`, `v2`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getWebhook()`

```php
getWebhook($id): \Bigcommerce\WebhooksV3\Model\CreateWebhooks200Response
```

Get a Webhook

Return a webhook by ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\WebhooksV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\WebhooksV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\WebhooksV3\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->getWebhook($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->getWebhook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |

### Return type

[**\Bigcommerce\WebhooksV3\Model\CreateWebhooks200Response**](../Model/CreateWebhooks200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `v3`, `v2`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateAWebhook()`

```php
updateAWebhook($id, $webhook_base): \Bigcommerce\WebhooksV3\Model\CreateWebhooks200Response
```

Update a Webhook

Updates a webhook. Custom headers can be added.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\WebhooksV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\WebhooksV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\WebhooksV3\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string
$webhook_base = new \Bigcommerce\WebhooksV3\Model\WebhookBase(); // \Bigcommerce\WebhooksV3\Model\WebhookBase

try {
    $result = $apiInstance->updateAWebhook($id, $webhook_base);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->updateAWebhook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |
| **webhook_base** | [**\Bigcommerce\WebhooksV3\Model\WebhookBase**](../Model/WebhookBase.md)|  | [optional] |

### Return type

[**\Bigcommerce\WebhooksV3\Model\CreateWebhooks200Response**](../Model/CreateWebhooks200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `v3`, `v2`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
