# OpenAPIClient-php

Get notified when specific events occur on a BigCommerce store. For more information, see [Webhooks Overview](https://developer.bigcommerce.com/api-docs/store-management/webhooks/overview).


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/bigcommerce.git"
    }
  ],
  "require": {
    "talisman/bigcommerce": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\WebhooksV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\WebhooksV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\WebhooksV3\Api\WebhooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$webhook_base = {"scope":"{$$.env.scope}","destination":"{$$.env.destination}","is_active":true}; // \Bigcommerce\WebhooksV3\Model\WebhookBase

try {
    $result = $apiInstance->createWebhooks($webhook_base);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WebhooksApi->createWebhooks: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*WebhooksApi* | [**createWebhooks**](docs/Api/WebhooksApi.md#createwebhooks) | **POST** /hooks | Create a Webhook
*WebhooksApi* | [**deleteAWebhook**](docs/Api/WebhooksApi.md#deleteawebhook) | **DELETE** /hooks/{id} | Delete a Webhook
*WebhooksApi* | [**getAllWebhooks**](docs/Api/WebhooksApi.md#getallwebhooks) | **GET** /hooks | Get Webhooks
*WebhooksApi* | [**getWebhook**](docs/Api/WebhooksApi.md#getwebhook) | **GET** /hooks/{id} | Get a Webhook
*WebhooksApi* | [**updateAWebhook**](docs/Api/WebhooksApi.md#updateawebhook) | **PUT** /hooks/{id} | Update a Webhook

## Models

- [CreateWebhooks200Response](docs/Model/CreateWebhooks200Response.md)
- [CreateWebhooks422Response](docs/Model/CreateWebhooks422Response.md)
- [CreateWebhooks422ResponseErrors](docs/Model/CreateWebhooks422ResponseErrors.md)
- [ErrorDetailedFull](docs/Model/ErrorDetailedFull.md)
- [ErrorFull](docs/Model/ErrorFull.md)
- [GetAllWebhooks200Response](docs/Model/GetAllWebhooks200Response.md)
- [GetAllWebhooks200ResponseMeta](docs/Model/GetAllWebhooks200ResponseMeta.md)
- [Pagination](docs/Model/Pagination.md)
- [WebhookBase](docs/Model/WebhookBase.md)
- [WebhookFull](docs/Model/WebhookFull.md)

## Authorization

Authentication schemes defined for the API:
### X-Auth-Token

- **Type**: API key
- **API key parameter name**: X-Auth-Token
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: ``
    - Package version: `3`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
