# Bigcommerce\TaxClassesV2\TaxesApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v2, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getATaxClass()**](TaxesApi.md#getATaxClass) | **GET** /tax_classes/{id} | Get a Tax Class |
| [**getAllTaxClasses()**](TaxesApi.md#getAllTaxClasses) | **GET** /tax_classes | Get All Tax Classes |


## `getATaxClass()`

```php
getATaxClass($id): \Bigcommerce\TaxClassesV2\Model\TaxClassFull
```

Get a Tax Class

Returns a single *Tax Class*.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\TaxClassesV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\TaxClassesV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\TaxClassesV2\Api\TaxesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Id of the tax class.

try {
    $result = $apiInstance->getATaxClass($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxesApi->getATaxClass: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**| Id of the tax class. | |

### Return type

[**\Bigcommerce\TaxClassesV2\Model\TaxClassFull**](../Model/TaxClassFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllTaxClasses()`

```php
getAllTaxClasses($page, $limit): \Bigcommerce\TaxClassesV2\Model\TaxClassFull[]
```

Get All Tax Classes

Returns a list of all *Tax Classes* in a store.  Default sorting is by tax-class id, from lowest to highest.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\TaxClassesV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\TaxClassesV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\TaxClassesV2\Api\TaxesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page = 3.4; // float | Optional filter param. Number of pages.
$limit = 3.4; // float | Optional filter param. Number of items per page

try {
    $result = $apiInstance->getAllTaxClasses($page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxesApi->getAllTaxClasses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page** | **float**| Optional filter param. Number of pages. | [optional] |
| **limit** | **float**| Optional filter param. Number of items per page | [optional] |

### Return type

[**\Bigcommerce\TaxClassesV2\Model\TaxClassFull[]**](../Model/TaxClassFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
