# OpenAPIClient-php

Manage tax calculations applied to sales. Tax classes are used to apply different tax rates for specific types of products and orders. This API is read only. Classes must be set using the [Control Panel](https://forum.bigcommerce.com/s/article/Taxes-Video#).


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/bigcommerce.git"
    }
  ],
  "require": {
    "talisman/bigcommerce": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\TaxClassesV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\TaxClassesV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\TaxClassesV2\Api\TaxesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Id of the tax class.

try {
    $result = $apiInstance->getATaxClass($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxesApi->getATaxClass: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://api.bigcommerce.com/stores/store_hash/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*TaxesApi* | [**getATaxClass**](docs/Api/TaxesApi.md#getataxclass) | **GET** /tax_classes/{id} | Get a Tax Class
*TaxesApi* | [**getAllTaxClasses**](docs/Api/TaxesApi.md#getalltaxclasses) | **GET** /tax_classes | Get All Tax Classes

## Models

- [TaxClassFull](docs/Model/TaxClassFull.md)

## Authorization

Authentication schemes defined for the API:
### X-Auth-Token

- **Type**: API key
- **API key parameter name**: X-Auth-Token
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: ``
    - Package version: `3`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
