#!/bin/bash

# Files from https://github.com/bigcommerce/docs/tree/main/reference
# Remove not useful header properties
sed -i -e '/- name: Content-Type/,+4d' -e '/- in: header/,+4d' -e 's/{$$.env.store_hash}/store_hash/' catalog.v3.yml
sed -i -e '/- name: Content-Type/,+4d' -e '/- name: Accept/,+4d' customers.v3.yml

Also remove the basePath as creates


docker run --rm -v "D:\bigcommerce:/local" openapitools/openapi-generator-cli:v7.13.0 generate -i /local/swagger/catalog.v3.yml -c /local/swagger/config-catalog-v3.json -g php -o /local/catalogV3
docker run --rm -v "D:\bigcommerce:/local" openapitools/openapi-generator-cli:v7.13.0 generate -i /local/swagger/customers.v2.yml -c /local/swagger/config-customers-v2.json  -g php -o /local/customersV2
docker run --rm -v "D:\bigcommerce:/local" openapitools/openapi-generator-cli:v7.13.0 generate -i /local/swagger/customers.v3.yml -c /local/swagger/config-customers-v3.json  -g php -o /local/customersV3
docker run --rm -v "D:\bigcommerce:/local" openapitools/openapi-generator-cli:v7.13.0 generate -i /local/swagger/orders.v2.yml -c /local/swagger/config-orders-v2.json -g php -o /local/ordersV2
docker run --rm -v "D:\bigcommerce:/local" openapitools/openapi-generator-cli:v7.13.0 generate -i /local/swagger/orders.v3.yml -c /local/swagger/config-orders-v3.json -g php -o /local/ordersV3
docker run --rm -v "D:\bigcommerce:/local" openapitools/openapi-generator-cli:v7.13.0 generate -i /local/swagger/store_information.v2.yml -c /local/swagger/config-store_information-v2.json -g php -o /local/store_informationV2
docker run --rm -v "D:\bigcommerce:/local" openapitools/openapi-generator-cli:v7.13.0 generate -i /local/swagger/tax_classes.v2.yml -c /local/swagger/config-tax_classes-v2.json -g php -o /local/tax_classesV2
docker run --rm -v "D:\bigcommerce:/local" openapitools/openapi-generator-cli:v7.13.0 generate -i /local/swagger/webhooks.v3.yml -c /local/swagger/config-webhooks-v3.json -g php -o /local/webhooksV3
docker run --rm -v "D:\bigcommerce:/local" openapitools/openapi-generator-cli:v7.13.0 generate -i /local/swagger/form_fields.sf.yml -c /local/swagger/config-form_fields-sf.json -g php -o /local/form_fields_sf



