<?php
/**
 * Timezone
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\StoreInformationV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Store Information
 *
 * Get Store Information endpoint, manage store profile settings.
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\StoreInformationV2\Model;

use \ArrayAccess;
use \Bigcommerce\StoreInformationV2\ObjectSerializer;

/**
 * Timezone Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\StoreInformationV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Timezone implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Timezone';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'raw_offset' => 'int',
        'dst_offset' => 'int',
        'dst_correction' => 'bool',
        'date_format' => '\Bigcommerce\StoreInformationV2\Model\DateFormat'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'raw_offset' => null,
        'dst_offset' => null,
        'dst_correction' => null,
        'date_format' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'name' => false,
        'raw_offset' => false,
        'dst_offset' => false,
        'dst_correction' => false,
        'date_format' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'raw_offset' => 'raw_offset',
        'dst_offset' => 'dst_offset',
        'dst_correction' => 'dst_correction',
        'date_format' => 'date_format'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'raw_offset' => 'setRawOffset',
        'dst_offset' => 'setDstOffset',
        'dst_correction' => 'setDstCorrection',
        'date_format' => 'setDateFormat'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'raw_offset' => 'getRawOffset',
        'dst_offset' => 'getDstOffset',
        'dst_correction' => 'getDstCorrection',
        'date_format' => 'getDateFormat'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('raw_offset', $data ?? [], null);
        $this->setIfExists('dst_offset', $data ?? [], null);
        $this->setIfExists('dst_correction', $data ?? [], null);
        $this->setIfExists('date_format', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name a string identifying the time zone, in the format: <Continent-name>/<City-name>.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets raw_offset
     *
     * @return int|null
     */
    public function getRawOffset()
    {
        return $this->container['raw_offset'];
    }

    /**
     * Sets raw_offset
     *
     * @param int|null $raw_offset a negative or positive number, identifying the offset from UTC/GMT, in seconds, during winter/standard time.
     *
     * @return self
     */
    public function setRawOffset($raw_offset)
    {
        if (is_null($raw_offset)) {
            throw new \InvalidArgumentException('non-nullable raw_offset cannot be null');
        }
        $this->container['raw_offset'] = $raw_offset;

        return $this;
    }

    /**
     * Gets dst_offset
     *
     * @return int|null
     */
    public function getDstOffset()
    {
        return $this->container['dst_offset'];
    }

    /**
     * Sets dst_offset
     *
     * @param int|null $dst_offset \"-/+\" offset from UTC/GMT, in seconds, during summer/daylight saving time.
     *
     * @return self
     */
    public function setDstOffset($dst_offset)
    {
        if (is_null($dst_offset)) {
            throw new \InvalidArgumentException('non-nullable dst_offset cannot be null');
        }
        $this->container['dst_offset'] = $dst_offset;

        return $this;
    }

    /**
     * Gets dst_correction
     *
     * @return bool|null
     */
    public function getDstCorrection()
    {
        return $this->container['dst_correction'];
    }

    /**
     * Sets dst_correction
     *
     * @param bool|null $dst_correction a boolean indicating whether this time zone observes daylight saving time.
     *
     * @return self
     */
    public function setDstCorrection($dst_correction)
    {
        if (is_null($dst_correction)) {
            throw new \InvalidArgumentException('non-nullable dst_correction cannot be null');
        }
        $this->container['dst_correction'] = $dst_correction;

        return $this;
    }

    /**
     * Gets date_format
     *
     * @return \Bigcommerce\StoreInformationV2\Model\DateFormat|null
     */
    public function getDateFormat()
    {
        return $this->container['date_format'];
    }

    /**
     * Sets date_format
     *
     * @param \Bigcommerce\StoreInformationV2\Model\DateFormat|null $date_format date_format
     *
     * @return self
     */
    public function setDateFormat($date_format)
    {
        if (is_null($date_format)) {
            throw new \InvalidArgumentException('non-nullable date_format cannot be null');
        }
        $this->container['date_format'] = $date_format;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


