<?php
/**
 * StoreInformationFeatures
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\StoreInformationV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Store Information
 *
 * Get Store Information endpoint, manage store profile settings.
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\StoreInformationV2\Model;

use \ArrayAccess;
use \Bigcommerce\StoreInformationV2\ObjectSerializer;

/**
 * StoreInformationFeatures Class Doc Comment
 *
 * @category Class
 * @description + &#x60;stencil_enabled&#x60;: &#x60;true&#x60; (boolean)     + &#x60;sitewidehttps_enabled&#x60;: &#x60;false&#x60; (boolean)     + &#x60;facebook_catalog_id&#x60; (string)
 * @package  Bigcommerce\StoreInformationV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StoreInformationFeatures implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StoreInformation_features';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'stencil_enabled' => 'bool',
        'sitewidehttps_enabled' => 'string',
        'facebook_catalog_id' => 'string',
        'checkout_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'stencil_enabled' => null,
        'sitewidehttps_enabled' => null,
        'facebook_catalog_id' => null,
        'checkout_type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'stencil_enabled' => false,
        'sitewidehttps_enabled' => false,
        'facebook_catalog_id' => false,
        'checkout_type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'stencil_enabled' => 'stencil_enabled',
        'sitewidehttps_enabled' => 'sitewidehttps_enabled',
        'facebook_catalog_id' => 'facebook_catalog_id',
        'checkout_type' => 'checkout_type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'stencil_enabled' => 'setStencilEnabled',
        'sitewidehttps_enabled' => 'setSitewidehttpsEnabled',
        'facebook_catalog_id' => 'setFacebookCatalogId',
        'checkout_type' => 'setCheckoutType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'stencil_enabled' => 'getStencilEnabled',
        'sitewidehttps_enabled' => 'getSitewidehttpsEnabled',
        'facebook_catalog_id' => 'getFacebookCatalogId',
        'checkout_type' => 'getCheckoutType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('stencil_enabled', $data ?? [], null);
        $this->setIfExists('sitewidehttps_enabled', $data ?? [], null);
        $this->setIfExists('facebook_catalog_id', $data ?? [], null);
        $this->setIfExists('checkout_type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets stencil_enabled
     *
     * @return bool|null
     */
    public function getStencilEnabled()
    {
        return $this->container['stencil_enabled'];
    }

    /**
     * Sets stencil_enabled
     *
     * @param bool|null $stencil_enabled Indicates whether a store is using a Stencil theme.
     *
     * @return self
     */
    public function setStencilEnabled($stencil_enabled)
    {
        if (is_null($stencil_enabled)) {
            throw new \InvalidArgumentException('non-nullable stencil_enabled cannot be null');
        }
        $this->container['stencil_enabled'] = $stencil_enabled;

        return $this;
    }

    /**
     * Gets sitewidehttps_enabled
     *
     * @return string|null
     */
    public function getSitewidehttpsEnabled()
    {
        return $this->container['sitewidehttps_enabled'];
    }

    /**
     * Sets sitewidehttps_enabled
     *
     * @param string|null $sitewidehttps_enabled Indicates if there is sitewide https.
     *
     * @return self
     */
    public function setSitewidehttpsEnabled($sitewidehttps_enabled)
    {
        if (is_null($sitewidehttps_enabled)) {
            throw new \InvalidArgumentException('non-nullable sitewidehttps_enabled cannot be null');
        }
        $this->container['sitewidehttps_enabled'] = $sitewidehttps_enabled;

        return $this;
    }

    /**
     * Gets facebook_catalog_id
     *
     * @return string|null
     */
    public function getFacebookCatalogId()
    {
        return $this->container['facebook_catalog_id'];
    }

    /**
     * Sets facebook_catalog_id
     *
     * @param string|null $facebook_catalog_id Id of the facebook catalog. If there is none, it returns an empty string.
     *
     * @return self
     */
    public function setFacebookCatalogId($facebook_catalog_id)
    {
        if (is_null($facebook_catalog_id)) {
            throw new \InvalidArgumentException('non-nullable facebook_catalog_id cannot be null');
        }
        $this->container['facebook_catalog_id'] = $facebook_catalog_id;

        return $this;
    }

    /**
     * Gets checkout_type
     *
     * @return string|null
     */
    public function getCheckoutType()
    {
        return $this->container['checkout_type'];
    }

    /**
     * Sets checkout_type
     *
     * @param string|null $checkout_type What type of checkout is enabled on the store. Possible values returned are optimized, single (one page), single_customizable (one page for developers), klarna.
     *
     * @return self
     */
    public function setCheckoutType($checkout_type)
    {
        if (is_null($checkout_type)) {
            throw new \InvalidArgumentException('non-nullable checkout_type cannot be null');
        }
        $this->container['checkout_type'] = $checkout_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


