<?php
/**
 * StoreInformation
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\StoreInformationV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Store Information
 *
 * Get Store Information endpoint, manage store profile settings.
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\StoreInformationV2\Model;

use \ArrayAccess;
use \Bigcommerce\StoreInformationV2\ObjectSerializer;

/**
 * StoreInformation Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\StoreInformationV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StoreInformation implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StoreInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'domain' => 'string',
        'secure_url' => 'string',
        'control_panel_base_url' => 'string',
        'name' => 'string',
        'first_name' => 'string',
        'last_name' => 'string',
        'address' => 'string',
        'country' => 'string',
        'phone' => 'string',
        'admin_email' => 'string',
        'order_email' => 'string',
        'timezone' => '\Bigcommerce\StoreInformationV2\Model\Timezone',
        'language' => 'string',
        'currency' => 'string',
        'currency_symbol' => 'string',
        'decimal_separator' => 'string',
        'thousands_separator' => 'string',
        'decimal_places' => 'int',
        'currency_symbol_location' => 'string',
        'weight_units' => 'string',
        'dimension_units' => 'string',
        'dimension_decimal_places' => 'int',
        'dimension_decimal_token' => 'string',
        'dimension_thousands_token_' => 'string',
        'plan_name' => 'string',
        'plan_level' => 'string',
        'industry' => 'string',
        'logo' => '\Bigcommerce\StoreInformationV2\Model\StoreInformationLogo',
        'is_price_entered_with_tax' => 'bool',
        'active_comparison_modules' => 'object[]',
        'features' => '\Bigcommerce\StoreInformationV2\Model\StoreInformationFeatures'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'domain' => null,
        'secure_url' => null,
        'control_panel_base_url' => null,
        'name' => null,
        'first_name' => null,
        'last_name' => null,
        'address' => null,
        'country' => null,
        'phone' => null,
        'admin_email' => null,
        'order_email' => null,
        'timezone' => null,
        'language' => null,
        'currency' => null,
        'currency_symbol' => null,
        'decimal_separator' => null,
        'thousands_separator' => null,
        'decimal_places' => null,
        'currency_symbol_location' => null,
        'weight_units' => null,
        'dimension_units' => null,
        'dimension_decimal_places' => null,
        'dimension_decimal_token' => null,
        'dimension_thousands_token_' => null,
        'plan_name' => null,
        'plan_level' => null,
        'industry' => null,
        'logo' => null,
        'is_price_entered_with_tax' => null,
        'active_comparison_modules' => null,
        'features' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'domain' => false,
        'secure_url' => false,
        'control_panel_base_url' => false,
        'name' => false,
        'first_name' => false,
        'last_name' => false,
        'address' => false,
        'country' => false,
        'phone' => false,
        'admin_email' => false,
        'order_email' => false,
        'timezone' => false,
        'language' => false,
        'currency' => false,
        'currency_symbol' => false,
        'decimal_separator' => false,
        'thousands_separator' => false,
        'decimal_places' => false,
        'currency_symbol_location' => false,
        'weight_units' => false,
        'dimension_units' => false,
        'dimension_decimal_places' => false,
        'dimension_decimal_token' => false,
        'dimension_thousands_token_' => false,
        'plan_name' => false,
        'plan_level' => false,
        'industry' => false,
        'logo' => false,
        'is_price_entered_with_tax' => false,
        'active_comparison_modules' => false,
        'features' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'domain' => 'domain',
        'secure_url' => 'secure_URL',
        'control_panel_base_url' => 'control_panel_base_url',
        'name' => 'name',
        'first_name' => 'first_name',
        'last_name' => 'last_name',
        'address' => 'address',
        'country' => 'country',
        'phone' => 'phone',
        'admin_email' => 'admin_email',
        'order_email' => 'order_email',
        'timezone' => 'timezone',
        'language' => 'language',
        'currency' => 'currency',
        'currency_symbol' => 'currency_symbol',
        'decimal_separator' => 'decimal_separator',
        'thousands_separator' => 'thousands_separator',
        'decimal_places' => 'decimal_places',
        'currency_symbol_location' => 'currency_symbol_location',
        'weight_units' => 'weight_units',
        'dimension_units' => 'dimension_units',
        'dimension_decimal_places' => 'dimension_decimal_places',
        'dimension_decimal_token' => 'dimension_decimal_token',
        'dimension_thousands_token_' => 'dimension_thousands_token:',
        'plan_name' => 'plan_name',
        'plan_level' => 'plan_level',
        'industry' => 'industry',
        'logo' => 'logo',
        'is_price_entered_with_tax' => 'is_price_entered_with_tax',
        'active_comparison_modules' => 'active_comparison_modules',
        'features' => 'features'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'domain' => 'setDomain',
        'secure_url' => 'setSecureUrl',
        'control_panel_base_url' => 'setControlPanelBaseUrl',
        'name' => 'setName',
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'address' => 'setAddress',
        'country' => 'setCountry',
        'phone' => 'setPhone',
        'admin_email' => 'setAdminEmail',
        'order_email' => 'setOrderEmail',
        'timezone' => 'setTimezone',
        'language' => 'setLanguage',
        'currency' => 'setCurrency',
        'currency_symbol' => 'setCurrencySymbol',
        'decimal_separator' => 'setDecimalSeparator',
        'thousands_separator' => 'setThousandsSeparator',
        'decimal_places' => 'setDecimalPlaces',
        'currency_symbol_location' => 'setCurrencySymbolLocation',
        'weight_units' => 'setWeightUnits',
        'dimension_units' => 'setDimensionUnits',
        'dimension_decimal_places' => 'setDimensionDecimalPlaces',
        'dimension_decimal_token' => 'setDimensionDecimalToken',
        'dimension_thousands_token_' => 'setDimensionThousandsToken',
        'plan_name' => 'setPlanName',
        'plan_level' => 'setPlanLevel',
        'industry' => 'setIndustry',
        'logo' => 'setLogo',
        'is_price_entered_with_tax' => 'setIsPriceEnteredWithTax',
        'active_comparison_modules' => 'setActiveComparisonModules',
        'features' => 'setFeatures'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'domain' => 'getDomain',
        'secure_url' => 'getSecureUrl',
        'control_panel_base_url' => 'getControlPanelBaseUrl',
        'name' => 'getName',
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'address' => 'getAddress',
        'country' => 'getCountry',
        'phone' => 'getPhone',
        'admin_email' => 'getAdminEmail',
        'order_email' => 'getOrderEmail',
        'timezone' => 'getTimezone',
        'language' => 'getLanguage',
        'currency' => 'getCurrency',
        'currency_symbol' => 'getCurrencySymbol',
        'decimal_separator' => 'getDecimalSeparator',
        'thousands_separator' => 'getThousandsSeparator',
        'decimal_places' => 'getDecimalPlaces',
        'currency_symbol_location' => 'getCurrencySymbolLocation',
        'weight_units' => 'getWeightUnits',
        'dimension_units' => 'getDimensionUnits',
        'dimension_decimal_places' => 'getDimensionDecimalPlaces',
        'dimension_decimal_token' => 'getDimensionDecimalToken',
        'dimension_thousands_token_' => 'getDimensionThousandsToken',
        'plan_name' => 'getPlanName',
        'plan_level' => 'getPlanLevel',
        'industry' => 'getIndustry',
        'logo' => 'getLogo',
        'is_price_entered_with_tax' => 'getIsPriceEnteredWithTax',
        'active_comparison_modules' => 'getActiveComparisonModules',
        'features' => 'getFeatures'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('domain', $data ?? [], null);
        $this->setIfExists('secure_url', $data ?? [], null);
        $this->setIfExists('control_panel_base_url', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('first_name', $data ?? [], null);
        $this->setIfExists('last_name', $data ?? [], null);
        $this->setIfExists('address', $data ?? [], null);
        $this->setIfExists('country', $data ?? [], null);
        $this->setIfExists('phone', $data ?? [], null);
        $this->setIfExists('admin_email', $data ?? [], null);
        $this->setIfExists('order_email', $data ?? [], null);
        $this->setIfExists('timezone', $data ?? [], null);
        $this->setIfExists('language', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('currency_symbol', $data ?? [], null);
        $this->setIfExists('decimal_separator', $data ?? [], null);
        $this->setIfExists('thousands_separator', $data ?? [], null);
        $this->setIfExists('decimal_places', $data ?? [], null);
        $this->setIfExists('currency_symbol_location', $data ?? [], null);
        $this->setIfExists('weight_units', $data ?? [], null);
        $this->setIfExists('dimension_units', $data ?? [], null);
        $this->setIfExists('dimension_decimal_places', $data ?? [], null);
        $this->setIfExists('dimension_decimal_token', $data ?? [], null);
        $this->setIfExists('dimension_thousands_token_', $data ?? [], null);
        $this->setIfExists('plan_name', $data ?? [], null);
        $this->setIfExists('plan_level', $data ?? [], null);
        $this->setIfExists('industry', $data ?? [], null);
        $this->setIfExists('logo', $data ?? [], null);
        $this->setIfExists('is_price_entered_with_tax', $data ?? [], null);
        $this->setIfExists('active_comparison_modules', $data ?? [], null);
        $this->setIfExists('features', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Unique store identifier.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets domain
     *
     * @return string|null
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     *
     * @param string|null $domain Primary domain name.
     *
     * @return self
     */
    public function setDomain($domain)
    {
        if (is_null($domain)) {
            throw new \InvalidArgumentException('non-nullable domain cannot be null');
        }
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets secure_url
     *
     * @return string|null
     */
    public function getSecureUrl()
    {
        return $this->container['secure_url'];
    }

    /**
     * Sets secure_url
     *
     * @param string|null $secure_url Store’s current HTTPS URL.
     *
     * @return self
     */
    public function setSecureUrl($secure_url)
    {
        if (is_null($secure_url)) {
            throw new \InvalidArgumentException('non-nullable secure_url cannot be null');
        }
        $this->container['secure_url'] = $secure_url;

        return $this;
    }

    /**
     * Gets control_panel_base_url
     *
     * @return string|null
     */
    public function getControlPanelBaseUrl()
    {
        return $this->container['control_panel_base_url'];
    }

    /**
     * Sets control_panel_base_url
     *
     * @param string|null $control_panel_base_url The secure hostname of the control panel.
     *
     * @return self
     */
    public function setControlPanelBaseUrl($control_panel_base_url)
    {
        if (is_null($control_panel_base_url)) {
            throw new \InvalidArgumentException('non-nullable control_panel_base_url cannot be null');
        }
        $this->container['control_panel_base_url'] = $control_panel_base_url;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Store's name.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets first_name
     *
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param string|null $first_name Primary contact’s first name (as defined during the store sign-up process).
     *
     * @return self
     */
    public function setFirstName($first_name)
    {
        if (is_null($first_name)) {
            throw new \InvalidArgumentException('non-nullable first_name cannot be null');
        }
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets last_name
     *
     * @return string|null
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param string|null $last_name Primary contact’s last name (as defined during the store sign-up process).
     *
     * @return self
     */
    public function setLastName($last_name)
    {
        if (is_null($last_name)) {
            throw new \InvalidArgumentException('non-nullable last_name cannot be null');
        }
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets address
     *
     * @return string|null
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     *
     * @param string|null $address Display address.
     *
     * @return self
     */
    public function setAddress($address)
    {
        if (is_null($address)) {
            throw new \InvalidArgumentException('non-nullable address cannot be null');
        }
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets country
     *
     * @return string|null
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param string|null $country Country where the store is located (as defined during the store sign-up process).
     *
     * @return self
     */
    public function setCountry($country)
    {
        if (is_null($country)) {
            throw new \InvalidArgumentException('non-nullable country cannot be null');
        }
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string|null $phone Display phone number.
     *
     * @return self
     */
    public function setPhone($phone)
    {
        if (is_null($phone)) {
            throw new \InvalidArgumentException('non-nullable phone cannot be null');
        }
        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets admin_email
     *
     * @return string|null
     */
    public function getAdminEmail()
    {
        return $this->container['admin_email'];
    }

    /**
     * Sets admin_email
     *
     * @param string|null $admin_email Email address of the store administrator/owner.
     *
     * @return self
     */
    public function setAdminEmail($admin_email)
    {
        if (is_null($admin_email)) {
            throw new \InvalidArgumentException('non-nullable admin_email cannot be null');
        }
        $this->container['admin_email'] = $admin_email;

        return $this;
    }

    /**
     * Gets order_email
     *
     * @return string|null
     */
    public function getOrderEmail()
    {
        return $this->container['order_email'];
    }

    /**
     * Sets order_email
     *
     * @param string|null $order_email Email address for orders and fulfillment.
     *
     * @return self
     */
    public function setOrderEmail($order_email)
    {
        if (is_null($order_email)) {
            throw new \InvalidArgumentException('non-nullable order_email cannot be null');
        }
        $this->container['order_email'] = $order_email;

        return $this;
    }

    /**
     * Gets timezone
     *
     * @return \Bigcommerce\StoreInformationV2\Model\Timezone|null
     */
    public function getTimezone()
    {
        return $this->container['timezone'];
    }

    /**
     * Sets timezone
     *
     * @param \Bigcommerce\StoreInformationV2\Model\Timezone|null $timezone timezone
     *
     * @return self
     */
    public function setTimezone($timezone)
    {
        if (is_null($timezone)) {
            throw new \InvalidArgumentException('non-nullable timezone cannot be null');
        }
        $this->container['timezone'] = $timezone;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string|null $language Default language code.
     *
     * @return self
     */
    public function setLanguage($language)
    {
        if (is_null($language)) {
            throw new \InvalidArgumentException('non-nullable language cannot be null');
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency Default currency code
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets currency_symbol
     *
     * @return string|null
     */
    public function getCurrencySymbol()
    {
        return $this->container['currency_symbol'];
    }

    /**
     * Sets currency_symbol
     *
     * @param string|null $currency_symbol Default symbol for values in the currency.
     *
     * @return self
     */
    public function setCurrencySymbol($currency_symbol)
    {
        if (is_null($currency_symbol)) {
            throw new \InvalidArgumentException('non-nullable currency_symbol cannot be null');
        }
        $this->container['currency_symbol'] = $currency_symbol;

        return $this;
    }

    /**
     * Gets decimal_separator
     *
     * @return string|null
     */
    public function getDecimalSeparator()
    {
        return $this->container['decimal_separator'];
    }

    /**
     * Sets decimal_separator
     *
     * @param string|null $decimal_separator Default decimal separator for values in the currency.
     *
     * @return self
     */
    public function setDecimalSeparator($decimal_separator)
    {
        if (is_null($decimal_separator)) {
            throw new \InvalidArgumentException('non-nullable decimal_separator cannot be null');
        }
        $this->container['decimal_separator'] = $decimal_separator;

        return $this;
    }

    /**
     * Gets thousands_separator
     *
     * @return string|null
     */
    public function getThousandsSeparator()
    {
        return $this->container['thousands_separator'];
    }

    /**
     * Sets thousands_separator
     *
     * @param string|null $thousands_separator Default thousands separator for values in the currency.
     *
     * @return self
     */
    public function setThousandsSeparator($thousands_separator)
    {
        if (is_null($thousands_separator)) {
            throw new \InvalidArgumentException('non-nullable thousands_separator cannot be null');
        }
        $this->container['thousands_separator'] = $thousands_separator;

        return $this;
    }

    /**
     * Gets decimal_places
     *
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->container['decimal_places'];
    }

    /**
     * Sets decimal_places
     *
     * @param int|null $decimal_places Default decimal places for values in the currency.
     *
     * @return self
     */
    public function setDecimalPlaces($decimal_places)
    {
        if (is_null($decimal_places)) {
            throw new \InvalidArgumentException('non-nullable decimal_places cannot be null');
        }
        $this->container['decimal_places'] = $decimal_places;

        return $this;
    }

    /**
     * Gets currency_symbol_location
     *
     * @return string|null
     */
    public function getCurrencySymbolLocation()
    {
        return $this->container['currency_symbol_location'];
    }

    /**
     * Sets currency_symbol_location
     *
     * @param string|null $currency_symbol_location Default position of the currency symbol (left or right).
     *
     * @return self
     */
    public function setCurrencySymbolLocation($currency_symbol_location)
    {
        if (is_null($currency_symbol_location)) {
            throw new \InvalidArgumentException('non-nullable currency_symbol_location cannot be null');
        }
        $this->container['currency_symbol_location'] = $currency_symbol_location;

        return $this;
    }

    /**
     * Gets weight_units
     *
     * @return string|null
     */
    public function getWeightUnits()
    {
        return $this->container['weight_units'];
    }

    /**
     * Sets weight_units
     *
     * @param string|null $weight_units Default weight units (metric or imperial).
     *
     * @return self
     */
    public function setWeightUnits($weight_units)
    {
        if (is_null($weight_units)) {
            throw new \InvalidArgumentException('non-nullable weight_units cannot be null');
        }
        $this->container['weight_units'] = $weight_units;

        return $this;
    }

    /**
     * Gets dimension_units
     *
     * @return string|null
     */
    public function getDimensionUnits()
    {
        return $this->container['dimension_units'];
    }

    /**
     * Sets dimension_units
     *
     * @param string|null $dimension_units Default dimension units (metric or imperial).
     *
     * @return self
     */
    public function setDimensionUnits($dimension_units)
    {
        if (is_null($dimension_units)) {
            throw new \InvalidArgumentException('non-nullable dimension_units cannot be null');
        }
        $this->container['dimension_units'] = $dimension_units;

        return $this;
    }

    /**
     * Gets dimension_decimal_places
     *
     * @return int|null
     */
    public function getDimensionDecimalPlaces()
    {
        return $this->container['dimension_decimal_places'];
    }

    /**
     * Sets dimension_decimal_places
     *
     * @param int|null $dimension_decimal_places The number of decimal places.
     *
     * @return self
     */
    public function setDimensionDecimalPlaces($dimension_decimal_places)
    {
        if (is_null($dimension_decimal_places)) {
            throw new \InvalidArgumentException('non-nullable dimension_decimal_places cannot be null');
        }
        $this->container['dimension_decimal_places'] = $dimension_decimal_places;

        return $this;
    }

    /**
     * Gets dimension_decimal_token
     *
     * @return string|null
     */
    public function getDimensionDecimalToken()
    {
        return $this->container['dimension_decimal_token'];
    }

    /**
     * Sets dimension_decimal_token
     *
     * @param string|null $dimension_decimal_token The symbol that separates the whole numbers from the decimal points.
     *
     * @return self
     */
    public function setDimensionDecimalToken($dimension_decimal_token)
    {
        if (is_null($dimension_decimal_token)) {
            throw new \InvalidArgumentException('non-nullable dimension_decimal_token cannot be null');
        }
        $this->container['dimension_decimal_token'] = $dimension_decimal_token;

        return $this;
    }

    /**
     * Gets dimension_thousands_token_
     *
     * @return string|null
     */
    public function getDimensionThousandsToken()
    {
        return $this->container['dimension_thousands_token_'];
    }

    /**
     * Sets dimension_thousands_token_
     *
     * @param string|null $dimension_thousands_token_ The symbol used to denote thousands.
     *
     * @return self
     */
    public function setDimensionThousandsToken($dimension_thousands_token_)
    {
        if (is_null($dimension_thousands_token_)) {
            throw new \InvalidArgumentException('non-nullable dimension_thousands_token_ cannot be null');
        }
        $this->container['dimension_thousands_token_'] = $dimension_thousands_token_;

        return $this;
    }

    /**
     * Gets plan_name
     *
     * @return string|null
     */
    public function getPlanName()
    {
        return $this->container['plan_name'];
    }

    /**
     * Sets plan_name
     *
     * @param string|null $plan_name Name of the BigCommerce plan to which this store is subscribed.
     *
     * @return self
     */
    public function setPlanName($plan_name)
    {
        if (is_null($plan_name)) {
            throw new \InvalidArgumentException('non-nullable plan_name cannot be null');
        }
        $this->container['plan_name'] = $plan_name;

        return $this;
    }

    /**
     * Gets plan_level
     *
     * @return string|null
     */
    public function getPlanLevel()
    {
        return $this->container['plan_level'];
    }

    /**
     * Sets plan_level
     *
     * @param string|null $plan_level Level of the BigCommerce plan to which this store is subscribed.
     *
     * @return self
     */
    public function setPlanLevel($plan_level)
    {
        if (is_null($plan_level)) {
            throw new \InvalidArgumentException('non-nullable plan_level cannot be null');
        }
        $this->container['plan_level'] = $plan_level;

        return $this;
    }

    /**
     * Gets industry
     *
     * @return string|null
     */
    public function getIndustry()
    {
        return $this->container['industry'];
    }

    /**
     * Sets industry
     *
     * @param string|null $industry Industry, or vertical category, in which the business operates. (As selected from drop-down list during the store sign-up process.)
     *
     * @return self
     */
    public function setIndustry($industry)
    {
        if (is_null($industry)) {
            throw new \InvalidArgumentException('non-nullable industry cannot be null');
        }
        $this->container['industry'] = $industry;

        return $this;
    }

    /**
     * Gets logo
     *
     * @return \Bigcommerce\StoreInformationV2\Model\StoreInformationLogo|null
     */
    public function getLogo()
    {
        return $this->container['logo'];
    }

    /**
     * Sets logo
     *
     * @param \Bigcommerce\StoreInformationV2\Model\StoreInformationLogo|null $logo logo
     *
     * @return self
     */
    public function setLogo($logo)
    {
        if (is_null($logo)) {
            throw new \InvalidArgumentException('non-nullable logo cannot be null');
        }
        $this->container['logo'] = $logo;

        return $this;
    }

    /**
     * Gets is_price_entered_with_tax
     *
     * @return bool|null
     */
    public function getIsPriceEnteredWithTax()
    {
        return $this->container['is_price_entered_with_tax'];
    }

    /**
     * Sets is_price_entered_with_tax
     *
     * @param bool|null $is_price_entered_with_tax A Boolean value that indicates whether or not prices are entered with tax.
     *
     * @return self
     */
    public function setIsPriceEnteredWithTax($is_price_entered_with_tax)
    {
        if (is_null($is_price_entered_with_tax)) {
            throw new \InvalidArgumentException('non-nullable is_price_entered_with_tax cannot be null');
        }
        $this->container['is_price_entered_with_tax'] = $is_price_entered_with_tax;

        return $this;
    }

    /**
     * Gets active_comparison_modules
     *
     * @return object[]|null
     */
    public function getActiveComparisonModules()
    {
        return $this->container['active_comparison_modules'];
    }

    /**
     * Sets active_comparison_modules
     *
     * @param object[]|null $active_comparison_modules 
     *
     * @return self
     */
    public function setActiveComparisonModules($active_comparison_modules)
    {
        if (is_null($active_comparison_modules)) {
            throw new \InvalidArgumentException('non-nullable active_comparison_modules cannot be null');
        }
        $this->container['active_comparison_modules'] = $active_comparison_modules;

        return $this;
    }

    /**
     * Gets features
     *
     * @return \Bigcommerce\StoreInformationV2\Model\StoreInformationFeatures|null
     */
    public function getFeatures()
    {
        return $this->container['features'];
    }

    /**
     * Sets features
     *
     * @param \Bigcommerce\StoreInformationV2\Model\StoreInformationFeatures|null $features features
     *
     * @return self
     */
    public function setFeatures($features)
    {
        if (is_null($features)) {
            throw new \InvalidArgumentException('non-nullable features cannot be null');
        }
        $this->container['features'] = $features;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


