# Bigcommerce\StoreInformationV2\TimeZoneApi

All URIs are relative to https://api.bigcommerce.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**timeGet()**](TimeZoneApi.md#timeGet) | **GET** /time | Get System Timestamp |


## `timeGet()`

```php
timeGet(): \Bigcommerce\StoreInformationV2\Model\TimeStampFull
```

Get System Timestamp

Returns the system timestamp at the time of the request. The time resource is useful for validating API authentication details and testing client connections.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\StoreInformationV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\StoreInformationV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\StoreInformationV2\Api\TimeZoneApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->timeGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TimeZoneApi->timeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Bigcommerce\StoreInformationV2\Model\TimeStampFull**](../Model/TimeStampFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
