# Bigcommerce\StoreInformationV2\StoreInformationApi

All URIs are relative to https://api.bigcommerce.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**storeGet()**](StoreInformationApi.md#storeGet) | **GET** /store | Get Store Information |


## `storeGet()`

```php
storeGet(): \Bigcommerce\StoreInformationV2\Model\StoreInformation
```

Get Store Information

Returns metadata about a store.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\StoreInformationV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\StoreInformationV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\StoreInformationV2\Api\StoreInformationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->storeGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StoreInformationApi->storeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Bigcommerce\StoreInformationV2\Model\StoreInformation**](../Model/StoreInformation.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `Time`, `application/json`, `Response Schema`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
