# OpenAPIClient-php

Get Store Information endpoint, manage store profile settings.


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/bigcommerce.git"
    }
  ],
  "require": {
    "talisman/bigcommerce": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\StoreInformationV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\StoreInformationV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\StoreInformationV2\Api\StoreInformationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->storeGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StoreInformationApi->storeGet: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://api.bigcommerce.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*StoreInformationApi* | [**storeGet**](docs/Api/StoreInformationApi.md#storeget) | **GET** /store | Get Store Information
*TimeZoneApi* | [**timeGet**](docs/Api/TimeZoneApi.md#timeget) | **GET** /time | Get System Timestamp

## Models

- [DateFormat](docs/Model/DateFormat.md)
- [StoreInformation](docs/Model/StoreInformation.md)
- [StoreInformationFeatures](docs/Model/StoreInformationFeatures.md)
- [StoreInformationLogo](docs/Model/StoreInformationLogo.md)
- [TimeStampFull](docs/Model/TimeStampFull.md)
- [Timezone](docs/Model/Timezone.md)

## Authorization

Authentication schemes defined for the API:
### X-Auth-Token

- **Type**: API key
- **API key parameter name**: X-Auth-Token
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: ``
    - Package version: `2`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
