<?php
/**
 * Transaction
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V3
 *
 * Surfaces endpoints related to payment processing. The `/orders/{id}/transactions` endpoint returns transaction details for the specified order. To programmatically create, update, and delete orders themselves, see [Orders v2](https://developer.bigcommerce.com/api-reference/store-management/orders). To process payments, see [Payment Processing](https://developer.bigcommerce.com/api-reference/payments/payments-process-payments).  - [Authentication](#authentication) - [Order Transactions](#order-transactions) - [Order refunds](#order-refunds) - [Resources](#resources)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` in the request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  | UI Name| Permission |Parameter| |----------------------------------------------|------------|----------| | Order Transactions|modify|`store_v2_transactions`| | Order Transactions|read-only  |`store_v2_transactions_read_only`| | Orders| modify|`store_v2_orders`| | Orders| read-only|`store_v2_orders_read_only`|  ## Order Transactions The `/orders/{id}/transactions` endpoint returns details about the payment instruments used to pay for an order. Depending on the payment method used, different details will be available. Not all credit card payment gateways return full card or fraud details. Transactions endpoints are primarily used to get detailed gateway response information for credit card transactions; however they will also return any available information about digital wallet and offline payments.  **Note**: transactions are not created for the following payment methods: * Test Payment Gateway * PayPal Express * Amazon Pay  ## Order Refunds The Order API refund endpoints allow developers to process refunds against orders with settled payments. Refund endpoints are useful when building order management or payment integrations. They make embedding refund functionality directly into the application possible without requiring merchants to return to their BigCommerce Control Panel.  ## Resources * [Orders Overview](https://developer.bigcommerce.com/api-docs/orders/orders-overview) * [Orders V2](https://developer.bigcommerce.com/api-reference/store-management/orders)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV3\Model;

use \ArrayAccess;
use \Bigcommerce\OrdersV3\ObjectSerializer;

/**
 * Transaction Class Doc Comment
 *
 * @category Class
 * @description A BigCommerce Transaction object describes a single transaction.
 * @package  Bigcommerce\OrdersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Transaction implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Transaction';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'event' => 'string',
        'method' => 'string',
        'amount' => 'float',
        'currency' => 'string',
        'gateway' => 'string',
        'gateway_transaction_id' => 'string',
        'date_created' => '\DateTime',
        'test' => 'bool',
        'status' => 'string',
        'fraud_review' => 'bool',
        'reference_transaction_id' => 'int',
        'offline' => '\Bigcommerce\OrdersV3\Model\Offline1',
        'custom' => '\Bigcommerce\OrdersV3\Model\Custom1',
        'payment_method_id' => 'string',
        'id' => 'int',
        'order_id' => 'string',
        'payment_instrument_token' => 'string',
        'avs_result' => '\Bigcommerce\OrdersV3\Model\AVSResults',
        'cvv_result' => '\Bigcommerce\OrdersV3\Model\CVVResult',
        'credit_card' => '\Bigcommerce\OrdersV3\Model\CreditCard',
        'gift_certificate' => '\Bigcommerce\OrdersV3\Model\GiftCertificate',
        'store_credit' => '\Bigcommerce\OrdersV3\Model\TransactionAllOfStoreCredit'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'event' => null,
        'method' => null,
        'amount' => 'float',
        'currency' => 'ISO-4217',
        'gateway' => null,
        'gateway_transaction_id' => null,
        'date_created' => 'date-time',
        'test' => null,
        'status' => null,
        'fraud_review' => null,
        'reference_transaction_id' => null,
        'offline' => null,
        'custom' => null,
        'payment_method_id' => null,
        'id' => null,
        'order_id' => null,
        'payment_instrument_token' => null,
        'avs_result' => null,
        'cvv_result' => null,
        'credit_card' => null,
        'gift_certificate' => null,
        'store_credit' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'event' => false,
        'method' => false,
        'amount' => false,
        'currency' => false,
        'gateway' => false,
        'gateway_transaction_id' => false,
        'date_created' => false,
        'test' => false,
        'status' => false,
        'fraud_review' => false,
        'reference_transaction_id' => false,
        'offline' => false,
        'custom' => false,
        'payment_method_id' => false,
        'id' => false,
        'order_id' => false,
        'payment_instrument_token' => false,
        'avs_result' => false,
        'cvv_result' => false,
        'credit_card' => false,
        'gift_certificate' => false,
        'store_credit' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'event' => 'event',
        'method' => 'method',
        'amount' => 'amount',
        'currency' => 'currency',
        'gateway' => 'gateway',
        'gateway_transaction_id' => 'gateway_transaction_id',
        'date_created' => 'date_created',
        'test' => 'test',
        'status' => 'status',
        'fraud_review' => 'fraud_review',
        'reference_transaction_id' => 'reference_transaction_id',
        'offline' => 'offline',
        'custom' => 'custom',
        'payment_method_id' => 'payment_method_id',
        'id' => 'id',
        'order_id' => 'order_id',
        'payment_instrument_token' => 'payment_instrument_token',
        'avs_result' => 'avs_result',
        'cvv_result' => 'cvv_result',
        'credit_card' => 'credit_card',
        'gift_certificate' => 'gift_certificate',
        'store_credit' => 'store_credit'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'event' => 'setEvent',
        'method' => 'setMethod',
        'amount' => 'setAmount',
        'currency' => 'setCurrency',
        'gateway' => 'setGateway',
        'gateway_transaction_id' => 'setGatewayTransactionId',
        'date_created' => 'setDateCreated',
        'test' => 'setTest',
        'status' => 'setStatus',
        'fraud_review' => 'setFraudReview',
        'reference_transaction_id' => 'setReferenceTransactionId',
        'offline' => 'setOffline',
        'custom' => 'setCustom',
        'payment_method_id' => 'setPaymentMethodId',
        'id' => 'setId',
        'order_id' => 'setOrderId',
        'payment_instrument_token' => 'setPaymentInstrumentToken',
        'avs_result' => 'setAvsResult',
        'cvv_result' => 'setCvvResult',
        'credit_card' => 'setCreditCard',
        'gift_certificate' => 'setGiftCertificate',
        'store_credit' => 'setStoreCredit'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'event' => 'getEvent',
        'method' => 'getMethod',
        'amount' => 'getAmount',
        'currency' => 'getCurrency',
        'gateway' => 'getGateway',
        'gateway_transaction_id' => 'getGatewayTransactionId',
        'date_created' => 'getDateCreated',
        'test' => 'getTest',
        'status' => 'getStatus',
        'fraud_review' => 'getFraudReview',
        'reference_transaction_id' => 'getReferenceTransactionId',
        'offline' => 'getOffline',
        'custom' => 'getCustom',
        'payment_method_id' => 'getPaymentMethodId',
        'id' => 'getId',
        'order_id' => 'getOrderId',
        'payment_instrument_token' => 'getPaymentInstrumentToken',
        'avs_result' => 'getAvsResult',
        'cvv_result' => 'getCvvResult',
        'credit_card' => 'getCreditCard',
        'gift_certificate' => 'getGiftCertificate',
        'store_credit' => 'getStoreCredit'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const EVENT_PURCHASE = 'purchase';
    public const EVENT_AUTHORIZATION = 'authorization';
    public const EVENT_CAPTURE = 'capture';
    public const EVENT_REFUND = 'refund';
    public const EVENT_VOID = 'void';
    public const EVENT_PENDING = 'pending';
    public const EVENT_SETTLED = 'settled';
    public const METHOD_CREDIT_CARD = 'credit_card';
    public const METHOD_ELECTRONIC_WALLET = 'electronic_wallet';
    public const METHOD_GIFT_CERTIFICATE = 'gift_certificate';
    public const METHOD_STORE_CREDIT = 'store_credit';
    public const METHOD_APPLE_PAY_CARD = 'apple_pay_card';
    public const METHOD_APPLE_PAY_TOKEN = 'apple_pay_token';
    public const METHOD_TOKEN = 'token';
    public const METHOD_CUSTOM = 'custom';
    public const METHOD_OFFSITE = 'offsite';
    public const METHOD_OFFLINE = 'offline';
    public const METHOD_NONCE = 'nonce';
    public const GATEWAY__2CHECKOUT = '2checkout';
    public const GATEWAY_ADYEN = 'adyen';
    public const GATEWAY_AMAZON = 'amazon';
    public const GATEWAY_AUTHORIZENET = 'authorizenet';
    public const GATEWAY_BANKDEPOSIT = 'bankdeposit';
    public const GATEWAY_BRAINTREE = 'braintree';
    public const GATEWAY_CHEQUE = 'cheque';
    public const GATEWAY_COD = 'cod';
    public const GATEWAY_CUSTOM = 'custom';
    public const GATEWAY_FIRSTDATAGGE4 = 'firstdatagge4';
    public const GATEWAY_GIFTCERTIFICATE = 'giftcertificate';
    public const GATEWAY_HPS = 'hps';
    public const GATEWAY_INSTORE = 'instore';
    public const GATEWAY_KLARNA = 'klarna';
    public const GATEWAY_MIGS = 'migs';
    public const GATEWAY_MONEYORDER = 'moneyorder';
    public const GATEWAY_NMI = 'nmi';
    public const GATEWAY_PAYPALEXPRESS = 'paypalexpress';
    public const GATEWAY_PAYPALPAYMENTSPROUS = 'paypalpaymentsprous';
    public const GATEWAY_PAYPALPAYMENTSPROUK = 'paypalpaymentsprouk';
    public const GATEWAY_PLUGNPAY = 'plugnpay';
    public const GATEWAY_QBMSV2 = 'qbmsv2';
    public const GATEWAY_SECURENET = 'securenet';
    public const GATEWAY_SQUARE = 'square';
    public const GATEWAY_STORECREDIT = 'storecredit';
    public const GATEWAY_STRIPE = 'stripe';
    public const GATEWAY_TESTGATEWAY = 'testgateway';
    public const GATEWAY_USAEPAY = 'usaepay';
    public const STATUS_OK = 'ok';
    public const STATUS_ERROR = 'error';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getEventAllowableValues()
    {
        return [
            self::EVENT_PURCHASE,
            self::EVENT_AUTHORIZATION,
            self::EVENT_CAPTURE,
            self::EVENT_REFUND,
            self::EVENT_VOID,
            self::EVENT_PENDING,
            self::EVENT_SETTLED,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getMethodAllowableValues()
    {
        return [
            self::METHOD_CREDIT_CARD,
            self::METHOD_ELECTRONIC_WALLET,
            self::METHOD_GIFT_CERTIFICATE,
            self::METHOD_STORE_CREDIT,
            self::METHOD_APPLE_PAY_CARD,
            self::METHOD_APPLE_PAY_TOKEN,
            self::METHOD_TOKEN,
            self::METHOD_CUSTOM,
            self::METHOD_OFFSITE,
            self::METHOD_OFFLINE,
            self::METHOD_NONCE,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getGatewayAllowableValues()
    {
        return [
            self::GATEWAY__2CHECKOUT,
            self::GATEWAY_ADYEN,
            self::GATEWAY_AMAZON,
            self::GATEWAY_AUTHORIZENET,
            self::GATEWAY_BANKDEPOSIT,
            self::GATEWAY_BRAINTREE,
            self::GATEWAY_CHEQUE,
            self::GATEWAY_COD,
            self::GATEWAY_CUSTOM,
            self::GATEWAY_FIRSTDATAGGE4,
            self::GATEWAY_GIFTCERTIFICATE,
            self::GATEWAY_HPS,
            self::GATEWAY_INSTORE,
            self::GATEWAY_KLARNA,
            self::GATEWAY_MIGS,
            self::GATEWAY_MONEYORDER,
            self::GATEWAY_NMI,
            self::GATEWAY_PAYPALEXPRESS,
            self::GATEWAY_PAYPALPAYMENTSPROUS,
            self::GATEWAY_PAYPALPAYMENTSPROUK,
            self::GATEWAY_PLUGNPAY,
            self::GATEWAY_QBMSV2,
            self::GATEWAY_SECURENET,
            self::GATEWAY_SQUARE,
            self::GATEWAY_STORECREDIT,
            self::GATEWAY_STRIPE,
            self::GATEWAY_TESTGATEWAY,
            self::GATEWAY_USAEPAY,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_OK,
            self::STATUS_ERROR,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('event', $data ?? [], null);
        $this->setIfExists('method', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('gateway', $data ?? [], null);
        $this->setIfExists('gateway_transaction_id', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('test', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('fraud_review', $data ?? [], null);
        $this->setIfExists('reference_transaction_id', $data ?? [], null);
        $this->setIfExists('offline', $data ?? [], null);
        $this->setIfExists('custom', $data ?? [], null);
        $this->setIfExists('payment_method_id', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('payment_instrument_token', $data ?? [], null);
        $this->setIfExists('avs_result', $data ?? [], null);
        $this->setIfExists('cvv_result', $data ?? [], null);
        $this->setIfExists('credit_card', $data ?? [], null);
        $this->setIfExists('gift_certificate', $data ?? [], null);
        $this->setIfExists('store_credit', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['event'] === null) {
            $invalidProperties[] = "'event' can't be null";
        }
        $allowedValues = $this->getEventAllowableValues();
        if (!is_null($this->container['event']) && !in_array($this->container['event'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'event', must be one of '%s'",
                $this->container['event'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['method'] === null) {
            $invalidProperties[] = "'method' can't be null";
        }
        $allowedValues = $this->getMethodAllowableValues();
        if (!is_null($this->container['method']) && !in_array($this->container['method'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'method', must be one of '%s'",
                $this->container['method'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['amount'] === null) {
            $invalidProperties[] = "'amount' can't be null";
        }
        if ($this->container['currency'] === null) {
            $invalidProperties[] = "'currency' can't be null";
        }
        if ($this->container['gateway'] === null) {
            $invalidProperties[] = "'gateway' can't be null";
        }
        $allowedValues = $this->getGatewayAllowableValues();
        if (!is_null($this->container['gateway']) && !in_array($this->container['gateway'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'gateway', must be one of '%s'",
                $this->container['gateway'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets event
     *
     * @return string
     */
    public function getEvent()
    {
        return $this->container['event'];
    }

    /**
     * Sets event
     *
     * @param string $event Store event that created the transaction.
     *
     * @return self
     */
    public function setEvent($event)
    {
        if (is_null($event)) {
            throw new \InvalidArgumentException('non-nullable event cannot be null');
        }
        $allowedValues = $this->getEventAllowableValues();
        if (!in_array($event, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'event', must be one of '%s'",
                    $event,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['event'] = $event;

        return $this;
    }

    /**
     * Gets method
     *
     * @return string
     */
    public function getMethod()
    {
        return $this->container['method'];
    }

    /**
     * Sets method
     *
     * @param string $method The payment method: `credit_card` - a credit-card transaction; `electronic_wallet` - an online wallet; `store_credit` - a transaction using store credit; `gift_certificate` - a transaction using a gift certificate; `custom` - manual payment methods; `token` - payment token; `nonce` - temporary payment token; `offsite` - online payment off the site; `offline` - payment method that takes place offline.
     *
     * @return self
     */
    public function setMethod($method)
    {
        if (is_null($method)) {
            throw new \InvalidArgumentException('non-nullable method cannot be null');
        }
        $allowedValues = $this->getMethodAllowableValues();
        if (!in_array($method, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'method', must be one of '%s'",
                    $method,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['method'] = $method;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param float $amount Amount of money in the transaction.
     *
     * @return self
     */
    public function setAmount($amount)
    {
        if (is_null($amount)) {
            throw new \InvalidArgumentException('non-nullable amount cannot be null');
        }
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string $currency Currency used for the transaction.
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets gateway
     *
     * @return string
     */
    public function getGateway()
    {
        return $this->container['gateway'];
    }

    /**
     * Sets gateway
     *
     * @param string $gateway The payment gateway, where applicable.
     *
     * @return self
     */
    public function setGateway($gateway)
    {
        if (is_null($gateway)) {
            throw new \InvalidArgumentException('non-nullable gateway cannot be null');
        }
        $allowedValues = $this->getGatewayAllowableValues();
        if (!in_array($gateway, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'gateway', must be one of '%s'",
                    $gateway,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['gateway'] = $gateway;

        return $this;
    }

    /**
     * Gets gateway_transaction_id
     *
     * @return string|null
     */
    public function getGatewayTransactionId()
    {
        return $this->container['gateway_transaction_id'];
    }

    /**
     * Sets gateway_transaction_id
     *
     * @param string|null $gateway_transaction_id The transaction ID returned by the payment gateway for this transaction item.
     *
     * @return self
     */
    public function setGatewayTransactionId($gateway_transaction_id)
    {
        if (is_null($gateway_transaction_id)) {
            throw new \InvalidArgumentException('non-nullable gateway_transaction_id cannot be null');
        }
        $this->container['gateway_transaction_id'] = $gateway_transaction_id;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created The datetime of the transaction.
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets test
     *
     * @return bool|null
     */
    public function getTest()
    {
        return $this->container['test'];
    }

    /**
     * Sets test
     *
     * @param bool|null $test True if the transaction performed was a test, or if the gateway is in test mode.
     *
     * @return self
     */
    public function setTest($test)
    {
        if (is_null($test)) {
            throw new \InvalidArgumentException('non-nullable test cannot be null');
        }
        $this->container['test'] = $test;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Status of the transaction.
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $allowedValues = $this->getStatusAllowableValues();
        if (!in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets fraud_review
     *
     * @return bool|null
     */
    public function getFraudReview()
    {
        return $this->container['fraud_review'];
    }

    /**
     * Sets fraud_review
     *
     * @param bool|null $fraud_review Result of gateway fraud review, if any. Default is `false`.
     *
     * @return self
     */
    public function setFraudReview($fraud_review)
    {
        if (is_null($fraud_review)) {
            throw new \InvalidArgumentException('non-nullable fraud_review cannot be null');
        }
        $this->container['fraud_review'] = $fraud_review;

        return $this;
    }

    /**
     * Gets reference_transaction_id
     *
     * @return int|null
     */
    public function getReferenceTransactionId()
    {
        return $this->container['reference_transaction_id'];
    }

    /**
     * Sets reference_transaction_id
     *
     * @param int|null $reference_transaction_id Identifier for an existing transaction upon which this transaction acts.
     *
     * @return self
     */
    public function setReferenceTransactionId($reference_transaction_id)
    {
        if (is_null($reference_transaction_id)) {
            throw new \InvalidArgumentException('non-nullable reference_transaction_id cannot be null');
        }
        $this->container['reference_transaction_id'] = $reference_transaction_id;

        return $this;
    }

    /**
     * Gets offline
     *
     * @return \Bigcommerce\OrdersV3\Model\Offline1|null
     */
    public function getOffline()
    {
        return $this->container['offline'];
    }

    /**
     * Sets offline
     *
     * @param \Bigcommerce\OrdersV3\Model\Offline1|null $offline offline
     *
     * @return self
     */
    public function setOffline($offline)
    {
        if (is_null($offline)) {
            throw new \InvalidArgumentException('non-nullable offline cannot be null');
        }
        $this->container['offline'] = $offline;

        return $this;
    }

    /**
     * Gets custom
     *
     * @return \Bigcommerce\OrdersV3\Model\Custom1|null
     */
    public function getCustom()
    {
        return $this->container['custom'];
    }

    /**
     * Sets custom
     *
     * @param \Bigcommerce\OrdersV3\Model\Custom1|null $custom custom
     *
     * @return self
     */
    public function setCustom($custom)
    {
        if (is_null($custom)) {
            throw new \InvalidArgumentException('non-nullable custom cannot be null');
        }
        $this->container['custom'] = $custom;

        return $this;
    }

    /**
     * Gets payment_method_id
     *
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->container['payment_method_id'];
    }

    /**
     * Sets payment_method_id
     *
     * @param string|null $payment_method_id The payment method ID used for this transaction
     *
     * @return self
     */
    public function setPaymentMethodId($payment_method_id)
    {
        if (is_null($payment_method_id)) {
            throw new \InvalidArgumentException('non-nullable payment_method_id cannot be null');
        }
        $this->container['payment_method_id'] = $payment_method_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Unique identifier for the transaction.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id Identifier for the BigCommerce Order with which this transaction is associated.
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets payment_instrument_token
     *
     * @return string|null
     */
    public function getPaymentInstrumentToken()
    {
        return $this->container['payment_instrument_token'];
    }

    /**
     * Sets payment_instrument_token
     *
     * @param string|null $payment_instrument_token This field contains internal BigPay token for stored card that is then mapped to the actual third-party token. We currently do not offer a way to get third party tokens.These tokens are read-only and do not return any information about the payment.
     *
     * @return self
     */
    public function setPaymentInstrumentToken($payment_instrument_token)
    {
        if (is_null($payment_instrument_token)) {
            throw new \InvalidArgumentException('non-nullable payment_instrument_token cannot be null');
        }
        $this->container['payment_instrument_token'] = $payment_instrument_token;

        return $this;
    }

    /**
     * Gets avs_result
     *
     * @return \Bigcommerce\OrdersV3\Model\AVSResults|null
     */
    public function getAvsResult()
    {
        return $this->container['avs_result'];
    }

    /**
     * Sets avs_result
     *
     * @param \Bigcommerce\OrdersV3\Model\AVSResults|null $avs_result avs_result
     *
     * @return self
     */
    public function setAvsResult($avs_result)
    {
        if (is_null($avs_result)) {
            throw new \InvalidArgumentException('non-nullable avs_result cannot be null');
        }
        $this->container['avs_result'] = $avs_result;

        return $this;
    }

    /**
     * Gets cvv_result
     *
     * @return \Bigcommerce\OrdersV3\Model\CVVResult|null
     */
    public function getCvvResult()
    {
        return $this->container['cvv_result'];
    }

    /**
     * Sets cvv_result
     *
     * @param \Bigcommerce\OrdersV3\Model\CVVResult|null $cvv_result cvv_result
     *
     * @return self
     */
    public function setCvvResult($cvv_result)
    {
        if (is_null($cvv_result)) {
            throw new \InvalidArgumentException('non-nullable cvv_result cannot be null');
        }
        $this->container['cvv_result'] = $cvv_result;

        return $this;
    }

    /**
     * Gets credit_card
     *
     * @return \Bigcommerce\OrdersV3\Model\CreditCard|null
     */
    public function getCreditCard()
    {
        return $this->container['credit_card'];
    }

    /**
     * Sets credit_card
     *
     * @param \Bigcommerce\OrdersV3\Model\CreditCard|null $credit_card credit_card
     *
     * @return self
     */
    public function setCreditCard($credit_card)
    {
        if (is_null($credit_card)) {
            throw new \InvalidArgumentException('non-nullable credit_card cannot be null');
        }
        $this->container['credit_card'] = $credit_card;

        return $this;
    }

    /**
     * Gets gift_certificate
     *
     * @return \Bigcommerce\OrdersV3\Model\GiftCertificate|null
     */
    public function getGiftCertificate()
    {
        return $this->container['gift_certificate'];
    }

    /**
     * Sets gift_certificate
     *
     * @param \Bigcommerce\OrdersV3\Model\GiftCertificate|null $gift_certificate gift_certificate
     *
     * @return self
     */
    public function setGiftCertificate($gift_certificate)
    {
        if (is_null($gift_certificate)) {
            throw new \InvalidArgumentException('non-nullable gift_certificate cannot be null');
        }
        $this->container['gift_certificate'] = $gift_certificate;

        return $this;
    }

    /**
     * Gets store_credit
     *
     * @return \Bigcommerce\OrdersV3\Model\TransactionAllOfStoreCredit|null
     */
    public function getStoreCredit()
    {
        return $this->container['store_credit'];
    }

    /**
     * Sets store_credit
     *
     * @param \Bigcommerce\OrdersV3\Model\TransactionAllOfStoreCredit|null $store_credit store_credit
     *
     * @return self
     */
    public function setStoreCredit($store_credit)
    {
        if (is_null($store_credit)) {
            throw new \InvalidArgumentException('non-nullable store_credit cannot be null');
        }
        $this->container['store_credit'] = $store_credit;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


