<?php
/**
 * RefundQuoteFull
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V3
 *
 * Surfaces endpoints related to payment processing. The `/orders/{id}/transactions` endpoint returns transaction details for the specified order. To programmatically create, update, and delete orders themselves, see [Orders v2](https://developer.bigcommerce.com/api-reference/store-management/orders). To process payments, see [Payment Processing](https://developer.bigcommerce.com/api-reference/payments/payments-process-payments).  - [Authentication](#authentication) - [Order Transactions](#order-transactions) - [Order refunds](#order-refunds) - [Resources](#resources)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` in the request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  | UI Name| Permission |Parameter| |----------------------------------------------|------------|----------| | Order Transactions|modify|`store_v2_transactions`| | Order Transactions|read-only  |`store_v2_transactions_read_only`| | Orders| modify|`store_v2_orders`| | Orders| read-only|`store_v2_orders_read_only`|  ## Order Transactions The `/orders/{id}/transactions` endpoint returns details about the payment instruments used to pay for an order. Depending on the payment method used, different details will be available. Not all credit card payment gateways return full card or fraud details. Transactions endpoints are primarily used to get detailed gateway response information for credit card transactions; however they will also return any available information about digital wallet and offline payments.  **Note**: transactions are not created for the following payment methods: * Test Payment Gateway * PayPal Express * Amazon Pay  ## Order Refunds The Order API refund endpoints allow developers to process refunds against orders with settled payments. Refund endpoints are useful when building order management or payment integrations. They make embedding refund functionality directly into the application possible without requiring merchants to return to their BigCommerce Control Panel.  ## Resources * [Orders Overview](https://developer.bigcommerce.com/api-docs/orders/orders-overview) * [Orders V2](https://developer.bigcommerce.com/api-reference/store-management/orders)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV3\Model;

use \ArrayAccess;
use \Bigcommerce\OrdersV3\ObjectSerializer;

/**
 * RefundQuoteFull Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\OrdersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class RefundQuoteFull implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'RefundQuote_Full';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_id' => 'int',
        'total_refund_amount' => 'float',
        'total_refund_tax_amount' => 'float',
        'rounding' => 'float',
        'adjustment' => 'float',
        'tax_inclusive' => 'bool',
        'refund_methods' => 'array[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_id' => null,
        'total_refund_amount' => 'float',
        'total_refund_tax_amount' => null,
        'rounding' => null,
        'adjustment' => 'float',
        'tax_inclusive' => null,
        'refund_methods' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'order_id' => false,
        'total_refund_amount' => false,
        'total_refund_tax_amount' => false,
        'rounding' => false,
        'adjustment' => false,
        'tax_inclusive' => false,
        'refund_methods' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_id' => 'order_id',
        'total_refund_amount' => 'total_refund_amount',
        'total_refund_tax_amount' => 'total_refund_tax_amount',
        'rounding' => 'rounding',
        'adjustment' => 'adjustment',
        'tax_inclusive' => 'tax_inclusive',
        'refund_methods' => 'refund_methods'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_id' => 'setOrderId',
        'total_refund_amount' => 'setTotalRefundAmount',
        'total_refund_tax_amount' => 'setTotalRefundTaxAmount',
        'rounding' => 'setRounding',
        'adjustment' => 'setAdjustment',
        'tax_inclusive' => 'setTaxInclusive',
        'refund_methods' => 'setRefundMethods'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_id' => 'getOrderId',
        'total_refund_amount' => 'getTotalRefundAmount',
        'total_refund_tax_amount' => 'getTotalRefundTaxAmount',
        'rounding' => 'getRounding',
        'adjustment' => 'getAdjustment',
        'tax_inclusive' => 'getTaxInclusive',
        'refund_methods' => 'getRefundMethods'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('total_refund_amount', $data ?? [], null);
        $this->setIfExists('total_refund_tax_amount', $data ?? [], null);
        $this->setIfExists('rounding', $data ?? [], null);
        $this->setIfExists('adjustment', $data ?? [], null);
        $this->setIfExists('tax_inclusive', $data ?? [], null);
        $this->setIfExists('refund_methods', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets order_id
     *
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param int|null $order_id ID of the order to be refunded
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets total_refund_amount
     *
     * @return float|null
     */
    public function getTotalRefundAmount()
    {
        return $this->container['total_refund_amount'];
    }

    /**
     * Sets total_refund_amount
     *
     * @param float|null $total_refund_amount A non-negative 2 decimal place rounded value that represents that amount that can be charged/refunded via payment providers
     *
     * @return self
     */
    public function setTotalRefundAmount($total_refund_amount)
    {
        if (is_null($total_refund_amount)) {
            throw new \InvalidArgumentException('non-nullable total_refund_amount cannot be null');
        }
        $this->container['total_refund_amount'] = $total_refund_amount;

        return $this;
    }

    /**
     * Gets total_refund_tax_amount
     *
     * @return float|null
     */
    public function getTotalRefundTaxAmount()
    {
        return $this->container['total_refund_tax_amount'];
    }

    /**
     * Sets total_refund_tax_amount
     *
     * @param float|null $total_refund_tax_amount total_refund_tax_amount
     *
     * @return self
     */
    public function setTotalRefundTaxAmount($total_refund_tax_amount)
    {
        if (is_null($total_refund_tax_amount)) {
            throw new \InvalidArgumentException('non-nullable total_refund_tax_amount cannot be null');
        }
        $this->container['total_refund_tax_amount'] = $total_refund_tax_amount;

        return $this;
    }

    /**
     * Gets rounding
     *
     * @return float|null
     */
    public function getRounding()
    {
        return $this->container['rounding'];
    }

    /**
     * Sets rounding
     *
     * @param float|null $rounding Indicates rounding value to bring refund_total to an amount refundable via payment providers (in this case to 2 decimal places)
     *
     * @return self
     */
    public function setRounding($rounding)
    {
        if (is_null($rounding)) {
            throw new \InvalidArgumentException('non-nullable rounding cannot be null');
        }
        $this->container['rounding'] = $rounding;

        return $this;
    }

    /**
     * Gets adjustment
     *
     * @return float|null
     */
    public function getAdjustment()
    {
        return $this->container['adjustment'];
    }

    /**
     * Sets adjustment
     *
     * @param float|null $adjustment A non-negative 2 decimal place rounded value that represents that amount that can be charged/refunded via payment providers
     *
     * @return self
     */
    public function setAdjustment($adjustment)
    {
        if (is_null($adjustment)) {
            throw new \InvalidArgumentException('non-nullable adjustment cannot be null');
        }
        $this->container['adjustment'] = $adjustment;

        return $this;
    }

    /**
     * Gets tax_inclusive
     *
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->container['tax_inclusive'];
    }

    /**
     * Sets tax_inclusive
     *
     * @param bool|null $tax_inclusive Indicate if total_refund_amount includes tax amount
     *
     * @return self
     */
    public function setTaxInclusive($tax_inclusive)
    {
        if (is_null($tax_inclusive)) {
            throw new \InvalidArgumentException('non-nullable tax_inclusive cannot be null');
        }
        $this->container['tax_inclusive'] = $tax_inclusive;

        return $this;
    }

    /**
     * Gets refund_methods
     *
     * @return array[]|null
     */
    public function getRefundMethods()
    {
        return $this->container['refund_methods'];
    }

    /**
     * Sets refund_methods
     *
     * @param array[]|null $refund_methods An array of available refund methods.  Note that `refund_methods` is an array of refund methods, with each refund method being an array of payment options.  For example, if the order was placed by a combination of store credit and bank deposit the  refund methods would be: ```json {   \"refund_methods\": [     [       {         \"provider_id\": \"storecredit\",         \"provider_description\": \"Store Credit\",         \"amount\": 119.35,         \"offline\": false,         \"offline_provider\": false,         \"offline_reason\": \"\"       }     ],     [       {         \"provider_id\": \"custom\",         \"provider_description\": \"Custom\",         \"amount\": 119.35,         \"offline\": true,         \"offline_provider\": true,         \"offline_reason\": \"This is an offline payment provider.\"       }     ],     [       {         \"provider_id\": \"bankdeposit\",         \"provider_description\": \"Bank Deposit\",         \"amount\": 80.35,         \"offline\": true,         \"offline_provider\": true,         \"offline_reason\": \"This is an offline payment provider.\"       },       {         \"provider_id\": \"storecredit\",         \"provider_description\": \"Store Credit\",         \"amount\": 39,         \"offline\": false,         \"offline_provider\": false,         \"offline_reason\": \"\"       }     ]   ] } ```  In this case there are three refund methods available to the merchant: 1. Refund up to the entire order amount to store credit. 2. Mark an amount up to the full order amount as refunded externally, through a provider or means not represented directly in BC (\"custom\"). 3. Refund the amount paid by store credit to store credit, and the amount paid by bank deposit via a manual refund, which will be recorded as being refunded against the bank deposit.  >
     *
     * @return self
     */
    public function setRefundMethods($refund_methods)
    {
        if (is_null($refund_methods)) {
            throw new \InvalidArgumentException('non-nullable refund_methods cannot be null');
        }
        $this->container['refund_methods'] = $refund_methods;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


