<?php
/**
 * InlineObject7
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V3
 *
 * Surfaces endpoints related to payment processing. The `/orders/{id}/transactions` endpoint returns transaction details for the specified order. To programmatically create, update, and delete orders themselves, see [Orders v2](https://developer.bigcommerce.com/api-reference/store-management/orders). To process payments, see [Payment Processing](https://developer.bigcommerce.com/api-reference/payments/payments-process-payments).  - [Authentication](#authentication) - [Order Transactions](#order-transactions) - [Order refunds](#order-refunds) - [Resources](#resources)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` in the request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  | UI Name| Permission |Parameter| |----------------------------------------------|------------|----------| | Order Transactions|modify|`store_v2_transactions`| | Order Transactions|read-only  |`store_v2_transactions_read_only`| | Orders| modify|`store_v2_orders`| | Orders| read-only|`store_v2_orders_read_only`|  ## Order Transactions The `/orders/{id}/transactions` endpoint returns details about the payment instruments used to pay for an order. Depending on the payment method used, different details will be available. Not all credit card payment gateways return full card or fraud details. Transactions endpoints are primarily used to get detailed gateway response information for credit card transactions; however they will also return any available information about digital wallet and offline payments.  **Note**: transactions are not created for the following payment methods: * Test Payment Gateway * PayPal Express * Amazon Pay  ## Order Refunds The Order API refund endpoints allow developers to process refunds against orders with settled payments. Refund endpoints are useful when building order management or payment integrations. They make embedding refund functionality directly into the application possible without requiring merchants to return to their BigCommerce Control Panel.  ## Resources * [Orders Overview](https://developer.bigcommerce.com/api-docs/orders/orders-overview) * [Orders V2](https://developer.bigcommerce.com/api-reference/store-management/orders)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV3\Model;

use \ArrayAccess;
use \Bigcommerce\OrdersV3\ObjectSerializer;

/**
 * InlineObject7 Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\OrdersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class InlineObject7 implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'inline_object_7';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'data' => '\Bigcommerce\OrdersV3\Model\TransactionPost',
        'id' => 'int',
        'order_id' => 'string',
        'date_created' => '\DateTime',
        'payment_instrument_token' => 'string',
        'avs_result' => '\Bigcommerce\OrdersV3\Model\AVSResult',
        'cvv_result' => '\Bigcommerce\OrdersV3\Model\CVVResult',
        'credit_card' => '\Bigcommerce\OrdersV3\Model\CreditCard',
        'gift_certificate' => '\Bigcommerce\OrdersV3\Model\GiftCertificate',
        'store_credit' => '\Bigcommerce\OrdersV3\Model\StoreCredit',
        'meta' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'data' => null,
        'id' => null,
        'order_id' => null,
        'date_created' => 'date-time',
        'payment_instrument_token' => null,
        'avs_result' => null,
        'cvv_result' => null,
        'credit_card' => null,
        'gift_certificate' => null,
        'store_credit' => null,
        'meta' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'data' => false,
        'id' => false,
        'order_id' => false,
        'date_created' => false,
        'payment_instrument_token' => false,
        'avs_result' => false,
        'cvv_result' => false,
        'credit_card' => false,
        'gift_certificate' => false,
        'store_credit' => false,
        'meta' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'data' => 'data',
        'id' => 'id',
        'order_id' => 'order_id',
        'date_created' => 'date_created',
        'payment_instrument_token' => 'payment_instrument_token',
        'avs_result' => 'avs_result',
        'cvv_result' => 'cvv_result',
        'credit_card' => 'credit_card',
        'gift_certificate' => 'gift_certificate',
        'store_credit' => 'store_credit',
        'meta' => 'meta'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'data' => 'setData',
        'id' => 'setId',
        'order_id' => 'setOrderId',
        'date_created' => 'setDateCreated',
        'payment_instrument_token' => 'setPaymentInstrumentToken',
        'avs_result' => 'setAvsResult',
        'cvv_result' => 'setCvvResult',
        'credit_card' => 'setCreditCard',
        'gift_certificate' => 'setGiftCertificate',
        'store_credit' => 'setStoreCredit',
        'meta' => 'setMeta'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'data' => 'getData',
        'id' => 'getId',
        'order_id' => 'getOrderId',
        'date_created' => 'getDateCreated',
        'payment_instrument_token' => 'getPaymentInstrumentToken',
        'avs_result' => 'getAvsResult',
        'cvv_result' => 'getCvvResult',
        'credit_card' => 'getCreditCard',
        'gift_certificate' => 'getGiftCertificate',
        'store_credit' => 'getStoreCredit',
        'meta' => 'getMeta'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('data', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('payment_instrument_token', $data ?? [], null);
        $this->setIfExists('avs_result', $data ?? [], null);
        $this->setIfExists('cvv_result', $data ?? [], null);
        $this->setIfExists('credit_card', $data ?? [], null);
        $this->setIfExists('gift_certificate', $data ?? [], null);
        $this->setIfExists('store_credit', $data ?? [], null);
        $this->setIfExists('meta', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets data
     *
     * @return \Bigcommerce\OrdersV3\Model\TransactionPost|null
     */
    public function getData()
    {
        return $this->container['data'];
    }

    /**
     * Sets data
     *
     * @param \Bigcommerce\OrdersV3\Model\TransactionPost|null $data data
     *
     * @return self
     */
    public function setData($data)
    {
        if (is_null($data)) {
            throw new \InvalidArgumentException('non-nullable data cannot be null');
        }
        $this->container['data'] = $data;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Unique identifier for the transaction.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id Identifier for the BigCommerce Order with which this transaction is associated.
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created The datetime of the transaction.
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets payment_instrument_token
     *
     * @return string|null
     */
    public function getPaymentInstrumentToken()
    {
        return $this->container['payment_instrument_token'];
    }

    /**
     * Sets payment_instrument_token
     *
     * @param string|null $payment_instrument_token This field contains internal BigPay token for stored card that is then mapped to the actual third-party token. We currently do not offer a way to get third party tokens.These tokens are read-only and do not return any information about the payment.
     *
     * @return self
     */
    public function setPaymentInstrumentToken($payment_instrument_token)
    {
        if (is_null($payment_instrument_token)) {
            throw new \InvalidArgumentException('non-nullable payment_instrument_token cannot be null');
        }
        $this->container['payment_instrument_token'] = $payment_instrument_token;

        return $this;
    }

    /**
     * Gets avs_result
     *
     * @return \Bigcommerce\OrdersV3\Model\AVSResult|null
     */
    public function getAvsResult()
    {
        return $this->container['avs_result'];
    }

    /**
     * Sets avs_result
     *
     * @param \Bigcommerce\OrdersV3\Model\AVSResult|null $avs_result avs_result
     *
     * @return self
     */
    public function setAvsResult($avs_result)
    {
        if (is_null($avs_result)) {
            throw new \InvalidArgumentException('non-nullable avs_result cannot be null');
        }
        $this->container['avs_result'] = $avs_result;

        return $this;
    }

    /**
     * Gets cvv_result
     *
     * @return \Bigcommerce\OrdersV3\Model\CVVResult|null
     */
    public function getCvvResult()
    {
        return $this->container['cvv_result'];
    }

    /**
     * Sets cvv_result
     *
     * @param \Bigcommerce\OrdersV3\Model\CVVResult|null $cvv_result cvv_result
     *
     * @return self
     */
    public function setCvvResult($cvv_result)
    {
        if (is_null($cvv_result)) {
            throw new \InvalidArgumentException('non-nullable cvv_result cannot be null');
        }
        $this->container['cvv_result'] = $cvv_result;

        return $this;
    }

    /**
     * Gets credit_card
     *
     * @return \Bigcommerce\OrdersV3\Model\CreditCard|null
     */
    public function getCreditCard()
    {
        return $this->container['credit_card'];
    }

    /**
     * Sets credit_card
     *
     * @param \Bigcommerce\OrdersV3\Model\CreditCard|null $credit_card credit_card
     *
     * @return self
     */
    public function setCreditCard($credit_card)
    {
        if (is_null($credit_card)) {
            throw new \InvalidArgumentException('non-nullable credit_card cannot be null');
        }
        $this->container['credit_card'] = $credit_card;

        return $this;
    }

    /**
     * Gets gift_certificate
     *
     * @return \Bigcommerce\OrdersV3\Model\GiftCertificate|null
     */
    public function getGiftCertificate()
    {
        return $this->container['gift_certificate'];
    }

    /**
     * Sets gift_certificate
     *
     * @param \Bigcommerce\OrdersV3\Model\GiftCertificate|null $gift_certificate gift_certificate
     *
     * @return self
     */
    public function setGiftCertificate($gift_certificate)
    {
        if (is_null($gift_certificate)) {
            throw new \InvalidArgumentException('non-nullable gift_certificate cannot be null');
        }
        $this->container['gift_certificate'] = $gift_certificate;

        return $this;
    }

    /**
     * Gets store_credit
     *
     * @return \Bigcommerce\OrdersV3\Model\StoreCredit|null
     */
    public function getStoreCredit()
    {
        return $this->container['store_credit'];
    }

    /**
     * Sets store_credit
     *
     * @param \Bigcommerce\OrdersV3\Model\StoreCredit|null $store_credit store_credit
     *
     * @return self
     */
    public function setStoreCredit($store_credit)
    {
        if (is_null($store_credit)) {
            throw new \InvalidArgumentException('non-nullable store_credit cannot be null');
        }
        $this->container['store_credit'] = $store_credit;

        return $this;
    }

    /**
     * Gets meta
     *
     * @return object|null
     */
    public function getMeta()
    {
        return $this->container['meta'];
    }

    /**
     * Sets meta
     *
     * @param object|null $meta meta
     *
     * @return self
     */
    public function setMeta($meta)
    {
        if (is_null($meta)) {
            throw new \InvalidArgumentException('non-nullable meta cannot be null');
        }
        $this->container['meta'] = $meta;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


