<?php
/**
 * CreditCard
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V3
 *
 * Surfaces endpoints related to payment processing. The `/orders/{id}/transactions` endpoint returns transaction details for the specified order. To programmatically create, update, and delete orders themselves, see [Orders v2](https://developer.bigcommerce.com/api-reference/store-management/orders). To process payments, see [Payment Processing](https://developer.bigcommerce.com/api-reference/payments/payments-process-payments).  - [Authentication](#authentication) - [Order Transactions](#order-transactions) - [Order refunds](#order-refunds) - [Resources](#resources)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` in the request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  | UI Name| Permission |Parameter| |----------------------------------------------|------------|----------| | Order Transactions|modify|`store_v2_transactions`| | Order Transactions|read-only  |`store_v2_transactions_read_only`| | Orders| modify|`store_v2_orders`| | Orders| read-only|`store_v2_orders_read_only`|  ## Order Transactions The `/orders/{id}/transactions` endpoint returns details about the payment instruments used to pay for an order. Depending on the payment method used, different details will be available. Not all credit card payment gateways return full card or fraud details. Transactions endpoints are primarily used to get detailed gateway response information for credit card transactions; however they will also return any available information about digital wallet and offline payments.  **Note**: transactions are not created for the following payment methods: * Test Payment Gateway * PayPal Express * Amazon Pay  ## Order Refunds The Order API refund endpoints allow developers to process refunds against orders with settled payments. Refund endpoints are useful when building order management or payment integrations. They make embedding refund functionality directly into the application possible without requiring merchants to return to their BigCommerce Control Panel.  ## Resources * [Orders Overview](https://developer.bigcommerce.com/api-docs/orders/orders-overview) * [Orders V2](https://developer.bigcommerce.com/api-reference/store-management/orders)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV3\Model;

use \ArrayAccess;
use \Bigcommerce\OrdersV3\ObjectSerializer;

/**
 * CreditCard Class Doc Comment
 *
 * @category Class
 * @description A credit-card model.
 * @package  Bigcommerce\OrdersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CreditCard implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreditCard';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'card_type' => 'string',
        'card_iin' => 'string',
        'card_last4' => 'string',
        'card_expiry_month' => 'int',
        'card_expiry_year' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'card_type' => null,
        'card_iin' => null,
        'card_last4' => null,
        'card_expiry_month' => null,
        'card_expiry_year' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'card_type' => false,
        'card_iin' => false,
        'card_last4' => false,
        'card_expiry_month' => false,
        'card_expiry_year' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'card_type' => 'card_type',
        'card_iin' => 'card_iin',
        'card_last4' => 'card_last4',
        'card_expiry_month' => 'card_expiry_month',
        'card_expiry_year' => 'card_expiry_year'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'card_type' => 'setCardType',
        'card_iin' => 'setCardIin',
        'card_last4' => 'setCardLast4',
        'card_expiry_month' => 'setCardExpiryMonth',
        'card_expiry_year' => 'setCardExpiryYear'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'card_type' => 'getCardType',
        'card_iin' => 'getCardIin',
        'card_last4' => 'getCardLast4',
        'card_expiry_month' => 'getCardExpiryMonth',
        'card_expiry_year' => 'getCardExpiryYear'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const CARD_TYPE_ALELO = 'alelo';
    public const CARD_TYPE_ALIA = 'alia';
    public const CARD_TYPE_AMERICAN_EXPRESS = 'american_express';
    public const CARD_TYPE_CABAL = 'cabal';
    public const CARD_TYPE_CARNET = 'carnet';
    public const CARD_TYPE_DANKORT = 'dankort';
    public const CARD_TYPE_DINERS_CLUB = 'diners_club';
    public const CARD_TYPE_DISCOVER = 'discover';
    public const CARD_TYPE_ELO = 'elo';
    public const CARD_TYPE_FORBRUGSFORENINGEN = 'forbrugsforeningen';
    public const CARD_TYPE_JCB = 'jcb';
    public const CARD_TYPE_MAESTRO = 'maestro';
    public const CARD_TYPE_MASTER = 'master';
    public const CARD_TYPE_NARANJA = 'naranja';
    public const CARD_TYPE_SODEXO = 'sodexo';
    public const CARD_TYPE_UNIONPAY = 'unionpay';
    public const CARD_TYPE_VISA = 'visa';
    public const CARD_TYPE_VR = 'vr';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getCardTypeAllowableValues()
    {
        return [
            self::CARD_TYPE_ALELO,
            self::CARD_TYPE_ALIA,
            self::CARD_TYPE_AMERICAN_EXPRESS,
            self::CARD_TYPE_CABAL,
            self::CARD_TYPE_CARNET,
            self::CARD_TYPE_DANKORT,
            self::CARD_TYPE_DINERS_CLUB,
            self::CARD_TYPE_DISCOVER,
            self::CARD_TYPE_ELO,
            self::CARD_TYPE_FORBRUGSFORENINGEN,
            self::CARD_TYPE_JCB,
            self::CARD_TYPE_MAESTRO,
            self::CARD_TYPE_MASTER,
            self::CARD_TYPE_NARANJA,
            self::CARD_TYPE_SODEXO,
            self::CARD_TYPE_UNIONPAY,
            self::CARD_TYPE_VISA,
            self::CARD_TYPE_VR,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('card_type', $data ?? [], null);
        $this->setIfExists('card_iin', $data ?? [], null);
        $this->setIfExists('card_last4', $data ?? [], null);
        $this->setIfExists('card_expiry_month', $data ?? [], null);
        $this->setIfExists('card_expiry_year', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getCardTypeAllowableValues();
        if (!is_null($this->container['card_type']) && !in_array($this->container['card_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'card_type', must be one of '%s'",
                $this->container['card_type'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['card_expiry_month']) && ($this->container['card_expiry_month'] > 12)) {
            $invalidProperties[] = "invalid value for 'card_expiry_month', must be smaller than or equal to 12.";
        }

        if (!is_null($this->container['card_expiry_month']) && ($this->container['card_expiry_month'] < 1)) {
            $invalidProperties[] = "invalid value for 'card_expiry_month', must be bigger than or equal to 1.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets card_type
     *
     * @return string|null
     */
    public function getCardType()
    {
        return $this->container['card_type'];
    }

    /**
     * Sets card_type
     *
     * @param string|null $card_type **Allowed values**: alelo, alia, american_express, cabal, carnet, dankort, diners_club, discover, elo, forbrugsforeningen, jcb, maestro, master, naranja, sodexo, unionpay, visa, vr
     *
     * @return self
     */
    public function setCardType($card_type)
    {
        if (is_null($card_type)) {
            throw new \InvalidArgumentException('non-nullable card_type cannot be null');
        }
        $allowedValues = $this->getCardTypeAllowableValues();
        if (!in_array($card_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'card_type', must be one of '%s'",
                    $card_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['card_type'] = $card_type;

        return $this;
    }

    /**
     * Gets card_iin
     *
     * @return string|null
     */
    public function getCardIin()
    {
        return $this->container['card_iin'];
    }

    /**
     * Sets card_iin
     *
     * @param string|null $card_iin The IIN of a credit-card number.
     *
     * @return self
     */
    public function setCardIin($card_iin)
    {
        if (is_null($card_iin)) {
            throw new \InvalidArgumentException('non-nullable card_iin cannot be null');
        }
        $this->container['card_iin'] = $card_iin;

        return $this;
    }

    /**
     * Gets card_last4
     *
     * @return string|null
     */
    public function getCardLast4()
    {
        return $this->container['card_last4'];
    }

    /**
     * Sets card_last4
     *
     * @param string|null $card_last4 The last 4 digits of a credit-card number.
     *
     * @return self
     */
    public function setCardLast4($card_last4)
    {
        if (is_null($card_last4)) {
            throw new \InvalidArgumentException('non-nullable card_last4 cannot be null');
        }
        $this->container['card_last4'] = $card_last4;

        return $this;
    }

    /**
     * Gets card_expiry_month
     *
     * @return int|null
     */
    public function getCardExpiryMonth()
    {
        return $this->container['card_expiry_month'];
    }

    /**
     * Sets card_expiry_month
     *
     * @param int|null $card_expiry_month The expiry month of a credit-card.
     *
     * @return self
     */
    public function setCardExpiryMonth($card_expiry_month)
    {
        if (is_null($card_expiry_month)) {
            throw new \InvalidArgumentException('non-nullable card_expiry_month cannot be null');
        }

        if (($card_expiry_month > 12)) {
            throw new \InvalidArgumentException('invalid value for $card_expiry_month when calling CreditCard., must be smaller than or equal to 12.');
        }
        if (($card_expiry_month < 1)) {
            throw new \InvalidArgumentException('invalid value for $card_expiry_month when calling CreditCard., must be bigger than or equal to 1.');
        }

        $this->container['card_expiry_month'] = $card_expiry_month;

        return $this;
    }

    /**
     * Gets card_expiry_year
     *
     * @return int|null
     */
    public function getCardExpiryYear()
    {
        return $this->container['card_expiry_year'];
    }

    /**
     * Sets card_expiry_year
     *
     * @param int|null $card_expiry_year The expiry year of a credit-card.
     *
     * @return self
     */
    public function setCardExpiryYear($card_expiry_year)
    {
        if (is_null($card_expiry_year)) {
            throw new \InvalidArgumentException('non-nullable card_expiry_year cannot be null');
        }
        $this->container['card_expiry_year'] = $card_expiry_year;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


