<?php
/**
 * OrderRefundsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V3
 *
 * Surfaces endpoints related to payment processing. The `/orders/{id}/transactions` endpoint returns transaction details for the specified order. To programmatically create, update, and delete orders themselves, see [Orders v2](https://developer.bigcommerce.com/api-reference/store-management/orders). To process payments, see [Payment Processing](https://developer.bigcommerce.com/api-reference/payments/payments-process-payments).  - [Authentication](#authentication) - [Order Transactions](#order-transactions) - [Order refunds](#order-refunds) - [Resources](#resources)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` in the request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  | UI Name| Permission |Parameter| |----------------------------------------------|------------|----------| | Order Transactions|modify|`store_v2_transactions`| | Order Transactions|read-only  |`store_v2_transactions_read_only`| | Orders| modify|`store_v2_orders`| | Orders| read-only|`store_v2_orders_read_only`|  ## Order Transactions The `/orders/{id}/transactions` endpoint returns details about the payment instruments used to pay for an order. Depending on the payment method used, different details will be available. Not all credit card payment gateways return full card or fraud details. Transactions endpoints are primarily used to get detailed gateway response information for credit card transactions; however they will also return any available information about digital wallet and offline payments.  **Note**: transactions are not created for the following payment methods: * Test Payment Gateway * PayPal Express * Amazon Pay  ## Order Refunds The Order API refund endpoints allow developers to process refunds against orders with settled payments. Refund endpoints are useful when building order management or payment integrations. They make embedding refund functionality directly into the application possible without requiring merchants to return to their BigCommerce Control Panel.  ## Resources * [Orders Overview](https://developer.bigcommerce.com/api-docs/orders/orders-overview) * [Orders V2](https://developer.bigcommerce.com/api-reference/store-management/orders)
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\OrdersV3\ApiException;
use Bigcommerce\OrdersV3\Configuration;
use Bigcommerce\OrdersV3\FormDataProcessor;
use Bigcommerce\OrdersV3\HeaderSelector;
use Bigcommerce\OrdersV3\ObjectSerializer;

/**
 * OrderRefundsApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\OrdersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrderRefundsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getorderrefunds' => [
            'application/json',
        ],
        'getrefunds' => [
            'application/json',
        ],
        'postrefund' => [
            'application/json',
        ],
        'postrefundquote' => [
            'application/json',
        ],
        'postrefundquotes' => [
            'application/json',
        ],
        'postrefunds' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getorderrefunds
     *
     * Get Refunds for Order
     *
     * @param  string $order_id order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getorderrefunds'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV3\Model\Getrefunds200Response
     */
    public function getorderrefunds($order_id, string $contentType = self::contentTypes['getorderrefunds'][0])
    {
        list($response) = $this->getorderrefundsWithHttpInfo($order_id, $contentType);
        return $response;
    }

    /**
     * Operation getorderrefundsWithHttpInfo
     *
     * Get Refunds for Order
     *
     * @param  string $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getorderrefunds'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV3\Model\Getrefunds200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getorderrefundsWithHttpInfo($order_id, string $contentType = self::contentTypes['getorderrefunds'][0])
    {
        $request = $this->getorderrefundsRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV3\Model\Getrefunds200Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV3\Model\Getrefunds200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV3\Model\Getrefunds200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getorderrefundsAsync
     *
     * Get Refunds for Order
     *
     * @param  string $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getorderrefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getorderrefundsAsync($order_id, string $contentType = self::contentTypes['getorderrefunds'][0])
    {
        return $this->getorderrefundsAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getorderrefundsAsyncWithHttpInfo
     *
     * Get Refunds for Order
     *
     * @param  string $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getorderrefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getorderrefundsAsyncWithHttpInfo($order_id, string $contentType = self::contentTypes['getorderrefunds'][0])
    {
        $returnType = '\Bigcommerce\OrdersV3\Model\Getrefunds200Response';
        $request = $this->getorderrefundsRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getorderrefunds'
     *
     * @param  string $order_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getorderrefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getorderrefundsRequest($order_id, string $contentType = self::contentTypes['getorderrefunds'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling getorderrefunds'
            );
        }


        $resourcePath = '/orders/{order_id}/payment_actions/refunds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getrefunds
     *
     * Get All Refunds
     *
     * @param  int[]|null $order_id_in Filter by &#x60;order_id&#x60;. Accepts multiple as comma-separated values. (optional)
     * @param  int[]|null $id_in Filter by refund &#x60;id&#x60;. Accepts multiple as comma-separated values. (optional)
     * @param  \DateTime|null $created_min Filter results so they are later than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. &#x60;2020-01-15T01:02:34-01:00&#x60; is RFC 3339 format. Url-encoded this will be &#x60;2020-01-15T01%3A02%3A34%2B01%3A00&#x60; (optional)
     * @param  \DateTime|null $created_max Filter results so they are earlier than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. &#x60;2020-01-15T01:02:34-01:00&#x60; is RFC 3339 format. Url-encoded this will be &#x60;2020-01-15T01%3A02%3A34%2B01%3A00&#x60; (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of items. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of items. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getrefunds'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV3\Model\Getrefunds200Response
     */
    public function getrefunds($order_id_in = null, $id_in = null, $created_min = null, $created_max = null, $page = null, $limit = null, string $contentType = self::contentTypes['getrefunds'][0])
    {
        list($response) = $this->getrefundsWithHttpInfo($order_id_in, $id_in, $created_min, $created_max, $page, $limit, $contentType);
        return $response;
    }

    /**
     * Operation getrefundsWithHttpInfo
     *
     * Get All Refunds
     *
     * @param  int[]|null $order_id_in Filter by &#x60;order_id&#x60;. Accepts multiple as comma-separated values. (optional)
     * @param  int[]|null $id_in Filter by refund &#x60;id&#x60;. Accepts multiple as comma-separated values. (optional)
     * @param  \DateTime|null $created_min Filter results so they are later than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. &#x60;2020-01-15T01:02:34-01:00&#x60; is RFC 3339 format. Url-encoded this will be &#x60;2020-01-15T01%3A02%3A34%2B01%3A00&#x60; (optional)
     * @param  \DateTime|null $created_max Filter results so they are earlier than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. &#x60;2020-01-15T01:02:34-01:00&#x60; is RFC 3339 format. Url-encoded this will be &#x60;2020-01-15T01%3A02%3A34%2B01%3A00&#x60; (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of items. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of items. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getrefunds'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV3\Model\Getrefunds200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function getrefundsWithHttpInfo($order_id_in = null, $id_in = null, $created_min = null, $created_max = null, $page = null, $limit = null, string $contentType = self::contentTypes['getrefunds'][0])
    {
        $request = $this->getrefundsRequest($order_id_in, $id_in, $created_min, $created_max, $page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV3\Model\Getrefunds200Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV3\Model\Getrefunds200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV3\Model\Getrefunds200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getrefundsAsync
     *
     * Get All Refunds
     *
     * @param  int[]|null $order_id_in Filter by &#x60;order_id&#x60;. Accepts multiple as comma-separated values. (optional)
     * @param  int[]|null $id_in Filter by refund &#x60;id&#x60;. Accepts multiple as comma-separated values. (optional)
     * @param  \DateTime|null $created_min Filter results so they are later than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. &#x60;2020-01-15T01:02:34-01:00&#x60; is RFC 3339 format. Url-encoded this will be &#x60;2020-01-15T01%3A02%3A34%2B01%3A00&#x60; (optional)
     * @param  \DateTime|null $created_max Filter results so they are earlier than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. &#x60;2020-01-15T01:02:34-01:00&#x60; is RFC 3339 format. Url-encoded this will be &#x60;2020-01-15T01%3A02%3A34%2B01%3A00&#x60; (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of items. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of items. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getrefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getrefundsAsync($order_id_in = null, $id_in = null, $created_min = null, $created_max = null, $page = null, $limit = null, string $contentType = self::contentTypes['getrefunds'][0])
    {
        return $this->getrefundsAsyncWithHttpInfo($order_id_in, $id_in, $created_min, $created_max, $page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getrefundsAsyncWithHttpInfo
     *
     * Get All Refunds
     *
     * @param  int[]|null $order_id_in Filter by &#x60;order_id&#x60;. Accepts multiple as comma-separated values. (optional)
     * @param  int[]|null $id_in Filter by refund &#x60;id&#x60;. Accepts multiple as comma-separated values. (optional)
     * @param  \DateTime|null $created_min Filter results so they are later than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. &#x60;2020-01-15T01:02:34-01:00&#x60; is RFC 3339 format. Url-encoded this will be &#x60;2020-01-15T01%3A02%3A34%2B01%3A00&#x60; (optional)
     * @param  \DateTime|null $created_max Filter results so they are earlier than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. &#x60;2020-01-15T01:02:34-01:00&#x60; is RFC 3339 format. Url-encoded this will be &#x60;2020-01-15T01%3A02%3A34%2B01%3A00&#x60; (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of items. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of items. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getrefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getrefundsAsyncWithHttpInfo($order_id_in = null, $id_in = null, $created_min = null, $created_max = null, $page = null, $limit = null, string $contentType = self::contentTypes['getrefunds'][0])
    {
        $returnType = '\Bigcommerce\OrdersV3\Model\Getrefunds200Response';
        $request = $this->getrefundsRequest($order_id_in, $id_in, $created_min, $created_max, $page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getrefunds'
     *
     * @param  int[]|null $order_id_in Filter by &#x60;order_id&#x60;. Accepts multiple as comma-separated values. (optional)
     * @param  int[]|null $id_in Filter by refund &#x60;id&#x60;. Accepts multiple as comma-separated values. (optional)
     * @param  \DateTime|null $created_min Filter results so they are later than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. &#x60;2020-01-15T01:02:34-01:00&#x60; is RFC 3339 format. Url-encoded this will be &#x60;2020-01-15T01%3A02%3A34%2B01%3A00&#x60; (optional)
     * @param  \DateTime|null $created_max Filter results so they are earlier than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. &#x60;2020-01-15T01:02:34-01:00&#x60; is RFC 3339 format. Url-encoded this will be &#x60;2020-01-15T01%3A02%3A34%2B01%3A00&#x60; (optional)
     * @param  int|null $page Specifies the page number in a limited (paginated) list of items. (optional)
     * @param  int|null $limit Controls the number of items per page in a limited (paginated) list of items. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getrefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getrefundsRequest($order_id_in = null, $id_in = null, $created_min = null, $created_max = null, $page = null, $limit = null, string $contentType = self::contentTypes['getrefunds'][0])
    {








        $resourcePath = '/orders/payment_actions/refunds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_id_in,
            'order_id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_in,
            'id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_min,
            'created:min', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_max,
            'created:max', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postrefund
     *
     * Create a Refund
     *
     * @param  int $order_id order id (required)
     * @param  \Bigcommerce\OrdersV3\Model\RefundRequestPost $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefund'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV3\Model\Postrefund201Response|\Bigcommerce\OrdersV3\Model\Postrefund503Response
     */
    public function postrefund($order_id, $body, string $contentType = self::contentTypes['postrefund'][0])
    {
        list($response) = $this->postrefundWithHttpInfo($order_id, $body, $contentType);
        return $response;
    }

    /**
     * Operation postrefundWithHttpInfo
     *
     * Create a Refund
     *
     * @param  int $order_id order id (required)
     * @param  \Bigcommerce\OrdersV3\Model\RefundRequestPost $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefund'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV3\Model\Postrefund201Response|\Bigcommerce\OrdersV3\Model\Postrefund503Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function postrefundWithHttpInfo($order_id, $body, string $contentType = self::contentTypes['postrefund'][0])
    {
        $request = $this->postrefundRequest($order_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV3\Model\Postrefund201Response',
                        $request,
                        $response,
                    );
                case 503:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV3\Model\Postrefund503Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV3\Model\Postrefund201Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV3\Model\Postrefund201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV3\Model\Postrefund503Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postrefundAsync
     *
     * Create a Refund
     *
     * @param  int $order_id order id (required)
     * @param  \Bigcommerce\OrdersV3\Model\RefundRequestPost $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postrefundAsync($order_id, $body, string $contentType = self::contentTypes['postrefund'][0])
    {
        return $this->postrefundAsyncWithHttpInfo($order_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postrefundAsyncWithHttpInfo
     *
     * Create a Refund
     *
     * @param  int $order_id order id (required)
     * @param  \Bigcommerce\OrdersV3\Model\RefundRequestPost $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postrefundAsyncWithHttpInfo($order_id, $body, string $contentType = self::contentTypes['postrefund'][0])
    {
        $returnType = '\Bigcommerce\OrdersV3\Model\Postrefund201Response';
        $request = $this->postrefundRequest($order_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postrefund'
     *
     * @param  int $order_id order id (required)
     * @param  \Bigcommerce\OrdersV3\Model\RefundRequestPost $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postrefundRequest($order_id, $body, string $contentType = self::contentTypes['postrefund'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling postrefund'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling postrefund'
            );
        }


        $resourcePath = '/orders/{order_id}/payment_actions/refunds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postrefundquote
     *
     * Create a Refund Quote
     *
     * @param  int $order_id Order id (required)
     * @param  \Bigcommerce\OrdersV3\Model\RefundQuotePost $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefundquote'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV3\Model\Postrefundquote201Response|\Bigcommerce\OrdersV3\Model\ErrorResponse
     */
    public function postrefundquote($order_id, $body, string $contentType = self::contentTypes['postrefundquote'][0])
    {
        list($response) = $this->postrefundquoteWithHttpInfo($order_id, $body, $contentType);
        return $response;
    }

    /**
     * Operation postrefundquoteWithHttpInfo
     *
     * Create a Refund Quote
     *
     * @param  int $order_id Order id (required)
     * @param  \Bigcommerce\OrdersV3\Model\RefundQuotePost $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefundquote'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV3\Model\Postrefundquote201Response|\Bigcommerce\OrdersV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postrefundquoteWithHttpInfo($order_id, $body, string $contentType = self::contentTypes['postrefundquote'][0])
    {
        $request = $this->postrefundquoteRequest($order_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV3\Model\Postrefundquote201Response',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV3\Model\Postrefundquote201Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV3\Model\Postrefundquote201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postrefundquoteAsync
     *
     * Create a Refund Quote
     *
     * @param  int $order_id Order id (required)
     * @param  \Bigcommerce\OrdersV3\Model\RefundQuotePost $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefundquote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postrefundquoteAsync($order_id, $body, string $contentType = self::contentTypes['postrefundquote'][0])
    {
        return $this->postrefundquoteAsyncWithHttpInfo($order_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postrefundquoteAsyncWithHttpInfo
     *
     * Create a Refund Quote
     *
     * @param  int $order_id Order id (required)
     * @param  \Bigcommerce\OrdersV3\Model\RefundQuotePost $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefundquote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postrefundquoteAsyncWithHttpInfo($order_id, $body, string $contentType = self::contentTypes['postrefundquote'][0])
    {
        $returnType = '\Bigcommerce\OrdersV3\Model\Postrefundquote201Response';
        $request = $this->postrefundquoteRequest($order_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postrefundquote'
     *
     * @param  int $order_id Order id (required)
     * @param  \Bigcommerce\OrdersV3\Model\RefundQuotePost $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefundquote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postrefundquoteRequest($order_id, $body, string $contentType = self::contentTypes['postrefundquote'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling postrefundquote'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling postrefundquote'
            );
        }


        $resourcePath = '/orders/{order_id}/payment_actions/refund_quotes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postrefundquotes
     *
     * Create Refund Quotes - BATCH
     *
     * @param  \Bigcommerce\OrdersV3\Model\RefundQuotePost[] $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefundquotes'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV3\Model\Postrefundquotes201Response|\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response|\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response
     */
    public function postrefundquotes($body, string $contentType = self::contentTypes['postrefundquotes'][0])
    {
        list($response) = $this->postrefundquotesWithHttpInfo($body, $contentType);
        return $response;
    }

    /**
     * Operation postrefundquotesWithHttpInfo
     *
     * Create Refund Quotes - BATCH
     *
     * @param  \Bigcommerce\OrdersV3\Model\RefundQuotePost[] $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefundquotes'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV3\Model\Postrefundquotes201Response|\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response|\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function postrefundquotesWithHttpInfo($body, string $contentType = self::contentTypes['postrefundquotes'][0])
    {
        $request = $this->postrefundquotesRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response',
                        $request,
                        $response,
                    );
                case 503:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postrefundquotesAsync
     *
     * Create Refund Quotes - BATCH
     *
     * @param  \Bigcommerce\OrdersV3\Model\RefundQuotePost[] $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefundquotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postrefundquotesAsync($body, string $contentType = self::contentTypes['postrefundquotes'][0])
    {
        return $this->postrefundquotesAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postrefundquotesAsyncWithHttpInfo
     *
     * Create Refund Quotes - BATCH
     *
     * @param  \Bigcommerce\OrdersV3\Model\RefundQuotePost[] $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefundquotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postrefundquotesAsyncWithHttpInfo($body, string $contentType = self::contentTypes['postrefundquotes'][0])
    {
        $returnType = '\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response';
        $request = $this->postrefundquotesRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postrefundquotes'
     *
     * @param  \Bigcommerce\OrdersV3\Model\RefundQuotePost[] $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefundquotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postrefundquotesRequest($body, string $contentType = self::contentTypes['postrefundquotes'][0])
    {

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling postrefundquotes'
            );
        }


        $resourcePath = '/orders/payment_actions/refund_quotes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'Example 1', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postrefunds
     *
     * Create Refunds - BATCH
     *
     * @param  \Bigcommerce\OrdersV3\Model\RefundRequestPost[] $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefunds'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV3\Model\Postrefunds201Response|\Bigcommerce\OrdersV3\Model\Postrefunds422Response|\Bigcommerce\OrdersV3\Model\Postrefunds422Response
     */
    public function postrefunds($body, string $contentType = self::contentTypes['postrefunds'][0])
    {
        list($response) = $this->postrefundsWithHttpInfo($body, $contentType);
        return $response;
    }

    /**
     * Operation postrefundsWithHttpInfo
     *
     * Create Refunds - BATCH
     *
     * @param  \Bigcommerce\OrdersV3\Model\RefundRequestPost[] $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefunds'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV3\Model\Postrefunds201Response|\Bigcommerce\OrdersV3\Model\Postrefunds422Response|\Bigcommerce\OrdersV3\Model\Postrefunds422Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function postrefundsWithHttpInfo($body, string $contentType = self::contentTypes['postrefunds'][0])
    {
        $request = $this->postrefundsRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV3\Model\Postrefunds201Response',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV3\Model\Postrefunds422Response',
                        $request,
                        $response,
                    );
                case 503:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV3\Model\Postrefunds422Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV3\Model\Postrefunds201Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV3\Model\Postrefunds201Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV3\Model\Postrefunds422Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 503:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV3\Model\Postrefunds422Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation postrefundsAsync
     *
     * Create Refunds - BATCH
     *
     * @param  \Bigcommerce\OrdersV3\Model\RefundRequestPost[] $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postrefundsAsync($body, string $contentType = self::contentTypes['postrefunds'][0])
    {
        return $this->postrefundsAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postrefundsAsyncWithHttpInfo
     *
     * Create Refunds - BATCH
     *
     * @param  \Bigcommerce\OrdersV3\Model\RefundRequestPost[] $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postrefundsAsyncWithHttpInfo($body, string $contentType = self::contentTypes['postrefunds'][0])
    {
        $returnType = '\Bigcommerce\OrdersV3\Model\Postrefunds201Response';
        $request = $this->postrefundsRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postrefunds'
     *
     * @param  \Bigcommerce\OrdersV3\Model\RefundRequestPost[] $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['postrefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postrefundsRequest($body, string $contentType = self::contentTypes['postrefunds'][0])
    {

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling postrefunds'
            );
        }


        $resourcePath = '/orders/payment_actions/refunds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'Example 1', 'All failure response. 
HTTP status code for the entire batch request to roll up to the most severe individual failure to the whole request.', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
