# # RefundQuoteFull

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**order_id** | **int** | ID of the order to be refunded | [optional]
**total_refund_amount** | **float** | A non-negative 2 decimal place rounded value that represents that amount that can be charged/refunded via payment providers | [optional]
**total_refund_tax_amount** | **float** |  | [optional]
**rounding** | **float** | Indicates rounding value to bring refund_total to an amount refundable via payment providers (in this case to 2 decimal places) | [optional]
**adjustment** | **float** | A non-negative 2 decimal place rounded value that represents that amount that can be charged/refunded via payment providers | [optional]
**tax_inclusive** | **bool** | Indicate if total_refund_amount includes tax amount | [optional]
**refund_methods** | **array[]** | An array of available refund methods.  Note that &#x60;refund_methods&#x60; is an array of refund methods, with each refund method being an array of payment options.  For example, if the order was placed by a combination of store credit and bank deposit the  refund methods would be: &#x60;&#x60;&#x60;json {   \&quot;refund_methods\&quot;: [     [       {         \&quot;provider_id\&quot;: \&quot;storecredit\&quot;,         \&quot;provider_description\&quot;: \&quot;Store Credit\&quot;,         \&quot;amount\&quot;: 119.35,         \&quot;offline\&quot;: false,         \&quot;offline_provider\&quot;: false,         \&quot;offline_reason\&quot;: \&quot;\&quot;       }     ],     [       {         \&quot;provider_id\&quot;: \&quot;custom\&quot;,         \&quot;provider_description\&quot;: \&quot;Custom\&quot;,         \&quot;amount\&quot;: 119.35,         \&quot;offline\&quot;: true,         \&quot;offline_provider\&quot;: true,         \&quot;offline_reason\&quot;: \&quot;This is an offline payment provider.\&quot;       }     ],     [       {         \&quot;provider_id\&quot;: \&quot;bankdeposit\&quot;,         \&quot;provider_description\&quot;: \&quot;Bank Deposit\&quot;,         \&quot;amount\&quot;: 80.35,         \&quot;offline\&quot;: true,         \&quot;offline_provider\&quot;: true,         \&quot;offline_reason\&quot;: \&quot;This is an offline payment provider.\&quot;       },       {         \&quot;provider_id\&quot;: \&quot;storecredit\&quot;,         \&quot;provider_description\&quot;: \&quot;Store Credit\&quot;,         \&quot;amount\&quot;: 39,         \&quot;offline\&quot;: false,         \&quot;offline_provider\&quot;: false,         \&quot;offline_reason\&quot;: \&quot;\&quot;       }     ]   ] } &#x60;&#x60;&#x60;  In this case there are three refund methods available to the merchant: 1. Refund up to the entire order amount to store credit. 2. Mark an amount up to the full order amount as refunded externally, through a provider or means not represented directly in BC (\&quot;custom\&quot;). 3. Refund the amount paid by store credit to store credit, and the amount paid by bank deposit via a manual refund, which will be recorded as being refunded against the bank deposit.  &gt; | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
