# Bigcommerce\OrdersV3\TransactionsApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getTransactions()**](TransactionsApi.md#getTransactions) | **GET** /orders/{order_id}/transactions | Get Transactions |


## `getTransactions()`

```php
getTransactions($order_id): \Bigcommerce\OrdersV3\Model\GetTransactions200Response
```

Get Transactions

Returns an **order's** transactions.   **Usage Notes** * Depending on the payment method, different information will be available (not all payment gateways return full card or fraud detail). * Transactions are not created for the following payment methods:  * Test Payment Gateway  * PayPal Express  * Amazon Pay

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | The ID of the `Order` to which the transactions belong.

try {
    $result = $apiInstance->getTransactions($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->getTransactions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| The ID of the &#x60;Order&#x60; to which the transactions belong. | |

### Return type

[**\Bigcommerce\OrdersV3\Model\GetTransactions200Response**](../Model/GetTransactions200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
