# Bigcommerce\OrdersV3\OrderRefundsApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getorderrefunds()**](OrderRefundsApi.md#getorderrefunds) | **GET** /orders/{order_id}/payment_actions/refunds | Get Refunds for Order |
| [**getrefunds()**](OrderRefundsApi.md#getrefunds) | **GET** /orders/payment_actions/refunds | Get All Refunds |
| [**postrefund()**](OrderRefundsApi.md#postrefund) | **POST** /orders/{order_id}/payment_actions/refunds | Create a Refund |
| [**postrefundquote()**](OrderRefundsApi.md#postrefundquote) | **POST** /orders/{order_id}/payment_actions/refund_quotes | Create a Refund Quote |
| [**postrefundquotes()**](OrderRefundsApi.md#postrefundquotes) | **POST** /orders/payment_actions/refund_quotes | Create Refund Quotes - BATCH |
| [**postrefunds()**](OrderRefundsApi.md#postrefunds) | **POST** /orders/payment_actions/refunds | Create Refunds - BATCH |


## `getorderrefunds()`

```php
getorderrefunds($order_id): \Bigcommerce\OrdersV3\Model\Getrefunds200Response
```

Get Refunds for Order

Returns a list of refunds ordered by refund ID in ascending order for the given order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\OrderRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 'order_id_example'; // string

try {
    $result = $apiInstance->getorderrefunds($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderRefundsApi->getorderrefunds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**|  | |

### Return type

[**\Bigcommerce\OrdersV3\Model\Getrefunds200Response**](../Model/Getrefunds200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getrefunds()`

```php
getrefunds($order_id_in, $id_in, $created_min, $created_max, $page, $limit): \Bigcommerce\OrdersV3\Model\Getrefunds200Response
```

Get All Refunds

Returns a list of refunds ordered by refund ID in ascending order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\OrderRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id_in = array(56); // int[] | Filter by `order_id`. Accepts multiple as comma-separated values.
$id_in = array(56); // int[] | Filter by refund `id`. Accepts multiple as comma-separated values.
$created_min = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter results so they are later than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. `2020-01-15T01:02:34-01:00` is RFC 3339 format. Url-encoded this will be `2020-01-15T01%3A02%3A34%2B01%3A00`
$created_max = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Filter results so they are earlier than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. `2020-01-15T01:02:34-01:00` is RFC 3339 format. Url-encoded this will be `2020-01-15T01%3A02%3A34%2B01%3A00`
$page = 56; // int | Specifies the page number in a limited (paginated) list of items.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of items.

try {
    $result = $apiInstance->getrefunds($order_id_in, $id_in, $created_min, $created_max, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderRefundsApi->getrefunds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id_in** | [**int[]**](../Model/int.md)| Filter by &#x60;order_id&#x60;. Accepts multiple as comma-separated values. | [optional] |
| **id_in** | [**int[]**](../Model/int.md)| Filter by refund &#x60;id&#x60;. Accepts multiple as comma-separated values. | [optional] |
| **created_min** | **\DateTime**| Filter results so they are later than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. &#x60;2020-01-15T01:02:34-01:00&#x60; is RFC 3339 format. Url-encoded this will be &#x60;2020-01-15T01%3A02%3A34%2B01%3A00&#x60; | [optional] |
| **created_max** | **\DateTime**| Filter results so they are earlier than or equal to provided date.   Must be in url-encoded RFC 3339 format. e.g. &#x60;2020-01-15T01:02:34-01:00&#x60; is RFC 3339 format. Url-encoded this will be &#x60;2020-01-15T01%3A02%3A34%2B01%3A00&#x60; | [optional] |
| **page** | **int**| Specifies the page number in a limited (paginated) list of items. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of items. | [optional] |

### Return type

[**\Bigcommerce\OrdersV3\Model\Getrefunds200Response**](../Model/Getrefunds200Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postrefund()`

```php
postrefund($order_id, $body): \Bigcommerce\OrdersV3\Model\Postrefund201Response
```

Create a Refund

Creates a refund.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\OrderRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | order id
$body = new \Bigcommerce\OrdersV3\Model\RefundRequestPost(); // \Bigcommerce\OrdersV3\Model\RefundRequestPost

try {
    $result = $apiInstance->postrefund($order_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderRefundsApi->postrefund: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| order id | |
| **body** | [**\Bigcommerce\OrdersV3\Model\RefundRequestPost**](../Model/RefundRequestPost.md)|  | |

### Return type

[**\Bigcommerce\OrdersV3\Model\Postrefund201Response**](../Model/Postrefund201Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postrefundquote()`

```php
postrefundquote($order_id, $body): \Bigcommerce\OrdersV3\Model\Postrefundquote201Response
```

Create a Refund Quote

Calculate the tax amount, total refund amount and get availble payment options for an order refund by providing items and costs or quantities to refund.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\OrderRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | Order id
$body = new \Bigcommerce\OrdersV3\Model\RefundQuotePost(); // \Bigcommerce\OrdersV3\Model\RefundQuotePost

try {
    $result = $apiInstance->postrefundquote($order_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderRefundsApi->postrefundquote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| Order id | |
| **body** | [**\Bigcommerce\OrdersV3\Model\RefundQuotePost**](../Model/RefundQuotePost.md)|  | |

### Return type

[**\Bigcommerce\OrdersV3\Model\Postrefundquote201Response**](../Model/Postrefundquote201Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postrefundquotes()`

```php
postrefundquotes($body): \Bigcommerce\OrdersV3\Model\Postrefundquotes201Response
```

Create Refund Quotes - BATCH

Calculate the tax amount, total refund amount and get availble payment options for an order refund by providing items and costs or quantities to refund.  This endpoint will accept a batch of one or more.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\OrderRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = array(new \Bigcommerce\OrdersV3\Model\RefundQuotePost()); // \Bigcommerce\OrdersV3\Model\RefundQuotePost[]

try {
    $result = $apiInstance->postrefundquotes($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderRefundsApi->postrefundquotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Bigcommerce\OrdersV3\Model\RefundQuotePost[]**](../Model/RefundQuotePost.md)|  | |

### Return type

[**\Bigcommerce\OrdersV3\Model\Postrefundquotes201Response**](../Model/Postrefundquotes201Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `Example 1`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `postrefunds()`

```php
postrefunds($body): \Bigcommerce\OrdersV3\Model\Postrefunds201Response
```

Create Refunds - BATCH

Creates a refund. This endpoint will accept a batch of one or more.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\OrderRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = array(new \Bigcommerce\OrdersV3\Model\RefundRequestPost()); // \Bigcommerce\OrdersV3\Model\RefundRequestPost[]

try {
    $result = $apiInstance->postrefunds($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderRefundsApi->postrefunds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Bigcommerce\OrdersV3\Model\RefundRequestPost[]**](../Model/RefundRequestPost.md)|  | |

### Return type

[**\Bigcommerce\OrdersV3\Model\Postrefunds201Response**](../Model/Postrefunds201Response.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `Example 1`, `All failure response. 
HTTP status code for the entire batch request to roll up to the most severe individual failure to the whole request.`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
