# Bigcommerce\OrdersV3\MetafieldsApi

All URIs are relative to https://api.bigcommerce.com/stores/store_hash/v3, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createOrderMetafield()**](MetafieldsApi.md#createOrderMetafield) | **POST** /orders/{order_id}/metafields | Create Metafields |
| [**deleteOrderMetafieldById()**](MetafieldsApi.md#deleteOrderMetafieldById) | **DELETE** /orders/{order_id}/metafields/{metafield_id} | Delete a Metafield |
| [**getOrderMetafieldByOrderIdAndMetafieldId()**](MetafieldsApi.md#getOrderMetafieldByOrderIdAndMetafieldId) | **GET** /orders/{order_id}/metafields/{metafield_id} | Get a Metafield |
| [**getOrderMetafieldsByOrderId()**](MetafieldsApi.md#getOrderMetafieldsByOrderId) | **GET** /orders/{order_id}/metafields | Get Metafields |
| [**updateOrderMetafield()**](MetafieldsApi.md#updateOrderMetafield) | **PUT** /orders/{order_id}/metafields/{metafield_id} | Update a Metafield |


## `createOrderMetafield()`

```php
createOrderMetafield($order_id, $metafield): \Bigcommerce\OrdersV3\Model\MetafieldResponse
```

Create Metafields

Creates an order `Metafield`.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\MetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | The ID of the `Order` to which the transactions belong.
$metafield = new \Bigcommerce\OrdersV3\Model\MetafieldPost(); // \Bigcommerce\OrdersV3\Model\MetafieldPost | A `Metafield` object.

try {
    $result = $apiInstance->createOrderMetafield($order_id, $metafield);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MetafieldsApi->createOrderMetafield: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| The ID of the &#x60;Order&#x60; to which the transactions belong. | |
| **metafield** | [**\Bigcommerce\OrdersV3\Model\MetafieldPost**](../Model/MetafieldPost.md)| A &#x60;Metafield&#x60; object. | |

### Return type

[**\Bigcommerce\OrdersV3\Model\MetafieldResponse**](../Model/MetafieldResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteOrderMetafieldById()`

```php
deleteOrderMetafieldById($order_id, $metafield_id)
```

Delete a Metafield

Deletes a `Metafield`.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\MetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | The ID of the `Order` to which the transactions belong.
$metafield_id = 56; // int | The ID of the `Metafield`.

try {
    $apiInstance->deleteOrderMetafieldById($order_id, $metafield_id);
} catch (Exception $e) {
    echo 'Exception when calling MetafieldsApi->deleteOrderMetafieldById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| The ID of the &#x60;Order&#x60; to which the transactions belong. | |
| **metafield_id** | **int**| The ID of the &#x60;Metafield&#x60;. | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderMetafieldByOrderIdAndMetafieldId()`

```php
getOrderMetafieldByOrderIdAndMetafieldId($order_id, $metafield_id): \Bigcommerce\OrdersV3\Model\MetafieldResponse
```

Get a Metafield

Gets a `Metafield`, by `order_id`.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\MetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | The ID of the `Order` to which the transactions belong.
$metafield_id = 56; // int | The ID of the `Metafield`.

try {
    $result = $apiInstance->getOrderMetafieldByOrderIdAndMetafieldId($order_id, $metafield_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MetafieldsApi->getOrderMetafieldByOrderIdAndMetafieldId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| The ID of the &#x60;Order&#x60; to which the transactions belong. | |
| **metafield_id** | **int**| The ID of the &#x60;Metafield&#x60;. | |

### Return type

[**\Bigcommerce\OrdersV3\Model\MetafieldResponse**](../Model/MetafieldResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderMetafieldsByOrderId()`

```php
getOrderMetafieldsByOrderId($order_id, $page, $limit, $key, $namespace, $direction): \Bigcommerce\OrdersV3\Model\MetaFieldCollectionResponse
```

Get Metafields

Gets a `Metafield` object list, by `order_id`.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\MetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | The ID of the `Order` to which the transactions belong.
$page = 56; // int | Specifies the page number in a limited (paginated) list of products.
$limit = 56; // int | Controls the number of items per page in a limited (paginated) list of products.
$key = 'key_example'; // string | Filter based on a metafield's key.
$namespace = 'namespace_example'; // string | Filter based on a metafield's key.
$direction = 'direction_example'; // string | Sort direction. Acceptable values are: `asc`, `desc`.

try {
    $result = $apiInstance->getOrderMetafieldsByOrderId($order_id, $page, $limit, $key, $namespace, $direction);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MetafieldsApi->getOrderMetafieldsByOrderId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| The ID of the &#x60;Order&#x60; to which the transactions belong. | |
| **page** | **int**| Specifies the page number in a limited (paginated) list of products. | [optional] |
| **limit** | **int**| Controls the number of items per page in a limited (paginated) list of products. | [optional] |
| **key** | **string**| Filter based on a metafield&#39;s key. | [optional] |
| **namespace** | **string**| Filter based on a metafield&#39;s key. | [optional] |
| **direction** | **string**| Sort direction. Acceptable values are: &#x60;asc&#x60;, &#x60;desc&#x60;. | [optional] |

### Return type

[**\Bigcommerce\OrdersV3\Model\MetaFieldCollectionResponse**](../Model/MetaFieldCollectionResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateOrderMetafield()`

```php
updateOrderMetafield($order_id, $metafield_id, $metafield): \Bigcommerce\OrdersV3\Model\MetafieldResponse
```

Update a Metafield

Updates a `Metafield` object.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\MetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | The ID of the `Order` to which the transactions belong.
$metafield_id = 56; // int | The ID of the `Metafield`.
$metafield = new \Bigcommerce\OrdersV3\Model\MetafieldPut(); // \Bigcommerce\OrdersV3\Model\MetafieldPut | A `Metafield` object.

try {
    $result = $apiInstance->updateOrderMetafield($order_id, $metafield_id, $metafield);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MetafieldsApi->updateOrderMetafield: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| The ID of the &#x60;Order&#x60; to which the transactions belong. | |
| **metafield_id** | **int**| The ID of the &#x60;Metafield&#x60;. | |
| **metafield** | [**\Bigcommerce\OrdersV3\Model\MetafieldPut**](../Model/MetafieldPut.md)| A &#x60;Metafield&#x60; object. | |

### Return type

[**\Bigcommerce\OrdersV3\Model\MetafieldResponse**](../Model/MetafieldResponse.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
