# OpenAPIClient-php

Surfaces endpoints related to payment processing. The `/orders/{id}/transactions` endpoint returns transaction details for the specified order. To programmatically create, update, and delete orders themselves, see [Orders
v2](https://developer.bigcommerce.com/api-reference/store-management/orders). To process payments, see [Payment
Processing](https://developer.bigcommerce.com/api-reference/payments/payments-process-payments).

- [Authentication](#authentication)
- [Order Transactions](#order-transactions)
- [Order refunds](#order-refunds)
- [Resources](#resources)

## Authentication

Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` in the request header.

```http
GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}}
Content-Type: application/json
X-Auth-Token: {{ACCESS_TOKEN}}
```

### OAuth Scopes

| UI Name| Permission |Parameter|
|----------------------------------------------|------------|----------|
| Order Transactions|modify|`store_v2_transactions`|
| Order Transactions|read-only  |`store_v2_transactions_read_only`|
| Orders| modify|`store_v2_orders`|
| Orders| read-only|`store_v2_orders_read_only`|

## Order Transactions
The `/orders/{id}/transactions` endpoint returns details about the payment instruments used to pay for an order. Depending on the payment method used, different details will be available. Not all credit card payment gateways return full card or fraud details. Transactions endpoints are primarily used to get detailed gateway response information for credit card transactions; however they will also return any available information about digital wallet and offline payments.

**Note**: transactions are not created for the following payment methods:
* Test Payment Gateway
* PayPal Express
* Amazon Pay

## Order Refunds
The Order API refund endpoints allow developers to process refunds against orders with settled payments. Refund endpoints are useful when building order management or payment integrations. They make embedding refund functionality directly into the application possible without requiring merchants to return to their BigCommerce Control Panel.

## Resources
* [Orders
Overview](https://developer.bigcommerce.com/api-docs/orders/orders-overview)
* [Orders
V2](https://developer.bigcommerce.com/api-reference/store-management/orders)


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/bigcommerce.git"
    }
  ],
  "require": {
    "talisman/bigcommerce": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV3\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV3\Api\MetafieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | The ID of the `Order` to which the transactions belong.
$metafield = new \Bigcommerce\OrdersV3\Model\MetafieldPost(); // \Bigcommerce\OrdersV3\Model\MetafieldPost | A `Metafield` object.

try {
    $result = $apiInstance->createOrderMetafield($order_id, $metafield);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MetafieldsApi->createOrderMetafield: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://api.bigcommerce.com/stores/store_hash/v3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*MetafieldsApi* | [**createOrderMetafield**](docs/Api/MetafieldsApi.md#createordermetafield) | **POST** /orders/{order_id}/metafields | Create Metafields
*MetafieldsApi* | [**deleteOrderMetafieldById**](docs/Api/MetafieldsApi.md#deleteordermetafieldbyid) | **DELETE** /orders/{order_id}/metafields/{metafield_id} | Delete a Metafield
*MetafieldsApi* | [**getOrderMetafieldByOrderIdAndMetafieldId**](docs/Api/MetafieldsApi.md#getordermetafieldbyorderidandmetafieldid) | **GET** /orders/{order_id}/metafields/{metafield_id} | Get a Metafield
*MetafieldsApi* | [**getOrderMetafieldsByOrderId**](docs/Api/MetafieldsApi.md#getordermetafieldsbyorderid) | **GET** /orders/{order_id}/metafields | Get Metafields
*MetafieldsApi* | [**updateOrderMetafield**](docs/Api/MetafieldsApi.md#updateordermetafield) | **PUT** /orders/{order_id}/metafields/{metafield_id} | Update a Metafield
*OrderRefundsApi* | [**getorderrefunds**](docs/Api/OrderRefundsApi.md#getorderrefunds) | **GET** /orders/{order_id}/payment_actions/refunds | Get Refunds for Order
*OrderRefundsApi* | [**getrefunds**](docs/Api/OrderRefundsApi.md#getrefunds) | **GET** /orders/payment_actions/refunds | Get All Refunds
*OrderRefundsApi* | [**postrefund**](docs/Api/OrderRefundsApi.md#postrefund) | **POST** /orders/{order_id}/payment_actions/refunds | Create a Refund
*OrderRefundsApi* | [**postrefundquote**](docs/Api/OrderRefundsApi.md#postrefundquote) | **POST** /orders/{order_id}/payment_actions/refund_quotes | Create a Refund Quote
*OrderRefundsApi* | [**postrefundquotes**](docs/Api/OrderRefundsApi.md#postrefundquotes) | **POST** /orders/payment_actions/refund_quotes | Create Refund Quotes - BATCH
*OrderRefundsApi* | [**postrefunds**](docs/Api/OrderRefundsApi.md#postrefunds) | **POST** /orders/payment_actions/refunds | Create Refunds - BATCH
*TransactionsApi* | [**getTransactions**](docs/Api/TransactionsApi.md#gettransactions) | **GET** /orders/{order_id}/transactions | Get Transactions

## Models

- [AVSResult](docs/Model/AVSResult.md)
- [AVSResults](docs/Model/AVSResults.md)
- [AmountBoundItem](docs/Model/AmountBoundItem.md)
- [BatchOperationMeta](docs/Model/BatchOperationMeta.md)
- [CVVResult](docs/Model/CVVResult.md)
- [CollectionMeta](docs/Model/CollectionMeta.md)
- [CreateReturnRequest](docs/Model/CreateReturnRequest.md)
- [CreateReturnRequestItem](docs/Model/CreateReturnRequestItem.md)
- [CreditCard](docs/Model/CreditCard.md)
- [Custom](docs/Model/Custom.md)
- [Custom1](docs/Model/Custom1.md)
- [ErrorBase](docs/Model/ErrorBase.md)
- [ErrorDetailedFull](docs/Model/ErrorDetailedFull.md)
- [ErrorResponse](docs/Model/ErrorResponse.md)
- [FailedQuoteError](docs/Model/FailedQuoteError.md)
- [GetReturnableItemsInner](docs/Model/GetReturnableItemsInner.md)
- [GetReturnableItemsInnerOptionsInner](docs/Model/GetReturnableItemsInnerOptionsInner.md)
- [GetReturnsSettings](docs/Model/GetReturnsSettings.md)
- [GetTransactions200Response](docs/Model/GetTransactions200Response.md)
- [Getrefunds200Response](docs/Model/Getrefunds200Response.md)
- [GiftCertificate](docs/Model/GiftCertificate.md)
- [InlineObject](docs/Model/InlineObject.md)
- [InlineObject1](docs/Model/InlineObject1.md)
- [InlineObject2](docs/Model/InlineObject2.md)
- [InlineObject3](docs/Model/InlineObject3.md)
- [InlineObject4](docs/Model/InlineObject4.md)
- [InlineObject5](docs/Model/InlineObject5.md)
- [InlineObject6](docs/Model/InlineObject6.md)
- [InlineObject7](docs/Model/InlineObject7.md)
- [InlineObjectMeta](docs/Model/InlineObjectMeta.md)
- [ItemReferenceId](docs/Model/ItemReferenceId.md)
- [LinksFull](docs/Model/LinksFull.md)
- [Meta](docs/Model/Meta.md)
- [MetaCollectionFull](docs/Model/MetaCollectionFull.md)
- [MetaFieldCollectionResponse](docs/Model/MetaFieldCollectionResponse.md)
- [MetaRefund](docs/Model/MetaRefund.md)
- [Metafield](docs/Model/Metafield.md)
- [MetafieldBase](docs/Model/MetafieldBase.md)
- [MetafieldPost](docs/Model/MetafieldPost.md)
- [MetafieldPut](docs/Model/MetafieldPut.md)
- [MetafieldResponse](docs/Model/MetafieldResponse.md)
- [NoContent](docs/Model/NoContent.md)
- [NotFound](docs/Model/NotFound.md)
- [Offline](docs/Model/Offline.md)
- [Offline1](docs/Model/Offline1.md)
- [Pagination](docs/Model/Pagination.md)
- [Pagination1](docs/Model/Pagination1.md)
- [PaginationFull](docs/Model/PaginationFull.md)
- [PaginationLinks](docs/Model/PaginationLinks.md)
- [PaymentOption](docs/Model/PaymentOption.md)
- [PaymentRequest](docs/Model/PaymentRequest.md)
- [Postrefund201Response](docs/Model/Postrefund201Response.md)
- [Postrefund503Response](docs/Model/Postrefund503Response.md)
- [Postrefundquote201Response](docs/Model/Postrefundquote201Response.md)
- [Postrefundquotes201Response](docs/Model/Postrefundquotes201Response.md)
- [Postrefunds201Response](docs/Model/Postrefunds201Response.md)
- [Postrefunds422Response](docs/Model/Postrefunds422Response.md)
- [PreferredOutcome](docs/Model/PreferredOutcome.md)
- [Problem](docs/Model/Problem.md)
- [QuantityBoundItem](docs/Model/QuantityBoundItem.md)
- [Reason](docs/Model/Reason.md)
- [ReceivedItemsBaseInner](docs/Model/ReceivedItemsBaseInner.md)
- [ReceivedItemsPutInner](docs/Model/ReceivedItemsPutInner.md)
- [Refund](docs/Model/Refund.md)
- [RefundItem](docs/Model/RefundItem.md)
- [RefundPayment](docs/Model/RefundPayment.md)
- [RefundQuoteFull](docs/Model/RefundQuoteFull.md)
- [RefundQuotePost](docs/Model/RefundQuotePost.md)
- [RefundRequestPost](docs/Model/RefundRequestPost.md)
- [ReturnFull](docs/Model/ReturnFull.md)
- [ReturnFullCustomer](docs/Model/ReturnFullCustomer.md)
- [ReturnItem](docs/Model/ReturnItem.md)
- [ReturnItemPreferredOutcome](docs/Model/ReturnItemPreferredOutcome.md)
- [ReturnItemReason](docs/Model/ReturnItemReason.md)
- [ReturnItemReceivedState](docs/Model/ReturnItemReceivedState.md)
- [ReturnItemReviewState](docs/Model/ReturnItemReviewState.md)
- [ReviewedItemsBaseInner](docs/Model/ReviewedItemsBaseInner.md)
- [ReviewedItemsPutInner](docs/Model/ReviewedItemsPutInner.md)
- [StatusFull](docs/Model/StatusFull.md)
- [StatusUpdateFull](docs/Model/StatusUpdateFull.md)
- [StoreCredit](docs/Model/StoreCredit.md)
- [TaxExemptItem](docs/Model/TaxExemptItem.md)
- [Transaction](docs/Model/Transaction.md)
- [TransactionAllOfStoreCredit](docs/Model/TransactionAllOfStoreCredit.md)
- [TransactionPost](docs/Model/TransactionPost.md)
- [UpdateReturnStatusesInner](docs/Model/UpdateReturnStatusesInner.md)

## Authorization

Authentication schemes defined for the API:
### X-Auth-Token

- **Type**: API key
- **API key parameter name**: X-Auth-Token
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: ``
    - Package version: `3`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
