<?php
/**
 * OrderCatalogProductPutTest
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V2
 *
 * Manage order coupons, messages, products, shipping addresses, statuses, taxes, shipments, and shipping address quotes.  - [Authentication](#authentication) - [Order](#order)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  |  **UI Name** | **Permission** | **Parameter** | | --- | --- | --- | |  Orders | modify | `store_v2_orders` | |  Orders | read-only | `store_v2_orders_read_only` |   ## Order  The Order object contains a record of the purchase agreement between a shopper and a merchant. To learn more about creating orders, see [Orders API Guide](/api-docs/orders/orders-api-overview).  ### Currency Fields  The **default** currency refers to the transactional currency which is the currency the shopper pays in.  The **display** currency refers to the presentational currency used to present prices to the shopper on the storefront.  * `currency_id` - the display currency ID. Depending on the currency selected, the value may be different from the transactional currency. * `currency_code` - the currency code of the display currency used to present prices to the shopper on the storefront. Depending on the currency selected, the value may be different from the transactional currency. * `currency_exchange_rate` - the exchange rate between the store's default currency and the display currency. For orders created using the V2 endpoints, this value is always 1 (only in the storefront this value can be different to 1). * `default_currency_id` - the transactional currency ID. * `default_currency_code` - the currency code of the transactional currency the shopper pays in.  The following additional fields are returned on orders when Multi-Currency is enabled on the store:  * `store_default_currency_code` - the currency code of the store's default currency. * `store_default_to_transactional_exchange_rate` - the exchange rate between the store's default currency and the transactional currency used in the order.  **Example:**  ```json {   ...   \"currency_id\": 4,   \"currency_code\": \"EUR\",   \"currency_exchange_rate\": 1,   \"default_currency_id\": 4,   \"default_currency_code\": \"EUR\",   \"store_default_currency_code\": \"USD\",   \"store_default_to_transactional_exchange_rate\": \"100.0000000000\"   ... } ```
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the model.
 */

namespace Bigcommerce\OrdersV2\Test\Model;

use PHPUnit\Framework\TestCase;

/**
 * OrderCatalogProductPutTest Class Doc Comment
 *
 * @category    Class
 * @description To &#x60;add&#x60; product to an existing order, don&#39;t include &#x60;id&#x60; in the payload. And note that the &#x60;product_options&#x60; are required if adding a product with variants. To &#x60;update&#x60; an order product line, &#x60;id&#x60; is required. The payload should only contain the fields that needs to be updated. Those fields that are omitted will not be changed. Note: - &#x60;xxx&#x60; and &#x60;xxx_customer&#x60; always hold the same value, updating either &#x60;xxx&#x60; or &#x60;xxx_customer&#x60; will change value for both of those fields. - If both fields &#x60;xxx&#x60; and &#x60;xxx_customer&#x60; are present, they must have same value. - Empty strings &#x60;&#39;&#39;&#x60; and &#x60;null&#x60; are invalid for &#x60;xxx&#x60;, &#x60;xxx_customer&#x60;, and &#x60;xxx_merchant&#x60;. - When updating and existing order product without changing the variant, product or product options, if &#x60;xxx_merchant&#x60; is not part of the request it will not be updated. - When updating an existing order product, if both fields &#x60;xxx&#x60; and &#x60;xxx_customer&#x60; not part of the request they will not be updated. - When adding a product to and existing order or changing the variant, product, or product options. - Empty strings &#x60;&#39;&#39;&#x60; and &#x60;null&#x60; are invalid for &#x60;xxx&#x60;, &#x60;xxx_customer, and &#x60;xxx_merchant&#x60; if &#x60;xxx_merchant&#x60; is omitted, it will default to have the catalog value. - If both fields &#x60;xxx&#x60; and &#x60;xxx_customer&#x60; are omitted from the request, they will default to the catalog value.
 * @package     Bigcommerce\OrdersV2
 * @author      OpenAPI Generator team
 * @link        https://openapi-generator.tech
 */
class OrderCatalogProductPutTest extends TestCase
{

    /**
     * Setup before running any test case
     */
    public static function setUpBeforeClass(): void
    {
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test "OrderCatalogProductPut"
     */
    public function testOrderCatalogProductPut()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "product_id"
     */
    public function testPropertyProductId()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "name"
     */
    public function testPropertyName()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "name_customer"
     */
    public function testPropertyNameCustomer()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "name_merchant"
     */
    public function testPropertyNameMerchant()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "product_options"
     */
    public function testPropertyProductOptions()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "quantity"
     */
    public function testPropertyQuantity()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "price_inc_tax"
     */
    public function testPropertyPriceIncTax()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "price_ex_tax"
     */
    public function testPropertyPriceExTax()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "upc"
     */
    public function testPropertyUpc()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "variant_id"
     */
    public function testPropertyVariantId()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "wrapping_name"
     */
    public function testPropertyWrappingName()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "wrapping_message"
     */
    public function testPropertyWrappingMessage()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "wrapping_cost_ex_tax"
     */
    public function testPropertyWrappingCostExTax()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "wrapping_cost_inc_tax"
     */
    public function testPropertyWrappingCostIncTax()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }

    /**
     * Test attribute "id"
     */
    public function testPropertyId()
    {
        // TODO: implement
        self::markTestIncomplete('Not implemented');
    }
}
