<?php
/**
 * OrderRespOnly
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V2
 *
 * Manage order coupons, messages, products, shipping addresses, statuses, taxes, shipments, and shipping address quotes.  - [Authentication](#authentication) - [Order](#order)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  |  **UI Name** | **Permission** | **Parameter** | | --- | --- | --- | |  Orders | modify | `store_v2_orders` | |  Orders | read-only | `store_v2_orders_read_only` |   ## Order  The Order object contains a record of the purchase agreement between a shopper and a merchant. To learn more about creating orders, see [Orders API Guide](/api-docs/orders/orders-api-overview).  ### Currency Fields  The **default** currency refers to the transactional currency which is the currency the shopper pays in.  The **display** currency refers to the presentational currency used to present prices to the shopper on the storefront.  * `currency_id` - the display currency ID. Depending on the currency selected, the value may be different from the transactional currency. * `currency_code` - the currency code of the display currency used to present prices to the shopper on the storefront. Depending on the currency selected, the value may be different from the transactional currency. * `currency_exchange_rate` - the exchange rate between the store's default currency and the display currency. For orders created using the V2 endpoints, this value is always 1 (only in the storefront this value can be different to 1). * `default_currency_id` - the transactional currency ID. * `default_currency_code` - the currency code of the transactional currency the shopper pays in.  The following additional fields are returned on orders when Multi-Currency is enabled on the store:  * `store_default_currency_code` - the currency code of the store's default currency. * `store_default_to_transactional_exchange_rate` - the exchange rate between the store's default currency and the transactional currency used in the order.  **Example:**  ```json {   ...   \"currency_id\": 4,   \"currency_code\": \"EUR\",   \"currency_exchange_rate\": 1,   \"default_currency_id\": 4,   \"default_currency_code\": \"EUR\",   \"store_default_currency_code\": \"USD\",   \"store_default_to_transactional_exchange_rate\": \"100.0000000000\"   ... } ```
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV2\Model;

use \ArrayAccess;
use \Bigcommerce\OrdersV2\ObjectSerializer;

/**
 * OrderRespOnly Class Doc Comment
 *
 * @category Class
 * @description Properties that are only for order response bodies.
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderRespOnly implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'order_RespOnly';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'date_modified' => 'string',
        'date_shipped' => 'string',
        'cart_id' => 'string',
        'status' => 'string',
        'subtotal_tax' => 'string',
        'shipping_cost_tax' => 'string',
        'shipping_cost_tax_class_id' => 'int',
        'handling_cost_tax' => 'string',
        'handling_cost_tax_class_id' => 'int',
        'wrapping_cost_tax' => 'string',
        'wrapping_cost_tax_class_id' => 'int',
        'payment_status' => 'string',
        'store_credit_amount' => 'string',
        'gift_certificate_amount' => 'string',
        'currency_id' => 'int',
        'currency_code' => 'string',
        'currency_exchange_rate' => 'string',
        'default_currency_id' => 'int',
        'coupon_discount' => 'string',
        'shipping_address_count' => 'float',
        'is_email_opt_in' => 'bool',
        'order_source' => 'string',
        'products' => '\Bigcommerce\OrdersV2\Model\ProductsResource',
        'shipping_addresses' => '\Bigcommerce\OrdersV2\Model\ShippingAddressesResource',
        'coupons' => '\Bigcommerce\OrdersV2\Model\CouponsResource',
        'status_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'date_modified' => null,
        'date_shipped' => null,
        'cart_id' => null,
        'status' => null,
        'subtotal_tax' => null,
        'shipping_cost_tax' => null,
        'shipping_cost_tax_class_id' => null,
        'handling_cost_tax' => null,
        'handling_cost_tax_class_id' => null,
        'wrapping_cost_tax' => null,
        'wrapping_cost_tax_class_id' => null,
        'payment_status' => null,
        'store_credit_amount' => null,
        'gift_certificate_amount' => null,
        'currency_id' => null,
        'currency_code' => null,
        'currency_exchange_rate' => null,
        'default_currency_id' => null,
        'coupon_discount' => null,
        'shipping_address_count' => null,
        'is_email_opt_in' => null,
        'order_source' => null,
        'products' => null,
        'shipping_addresses' => null,
        'coupons' => null,
        'status_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'date_modified' => false,
        'date_shipped' => false,
        'cart_id' => false,
        'status' => false,
        'subtotal_tax' => false,
        'shipping_cost_tax' => false,
        'shipping_cost_tax_class_id' => false,
        'handling_cost_tax' => false,
        'handling_cost_tax_class_id' => false,
        'wrapping_cost_tax' => false,
        'wrapping_cost_tax_class_id' => false,
        'payment_status' => false,
        'store_credit_amount' => false,
        'gift_certificate_amount' => false,
        'currency_id' => false,
        'currency_code' => false,
        'currency_exchange_rate' => false,
        'default_currency_id' => false,
        'coupon_discount' => false,
        'shipping_address_count' => false,
        'is_email_opt_in' => false,
        'order_source' => false,
        'products' => false,
        'shipping_addresses' => false,
        'coupons' => false,
        'status_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'date_modified' => 'date_modified',
        'date_shipped' => 'date_shipped',
        'cart_id' => 'cart_id',
        'status' => 'status',
        'subtotal_tax' => 'subtotal_tax',
        'shipping_cost_tax' => 'shipping_cost_tax',
        'shipping_cost_tax_class_id' => 'shipping_cost_tax_class_id',
        'handling_cost_tax' => 'handling_cost_tax',
        'handling_cost_tax_class_id' => 'handling_cost_tax_class_id',
        'wrapping_cost_tax' => 'wrapping_cost_tax',
        'wrapping_cost_tax_class_id' => 'wrapping_cost_tax_class_id',
        'payment_status' => 'payment_status',
        'store_credit_amount' => 'store_credit_amount',
        'gift_certificate_amount' => 'gift_certificate_amount',
        'currency_id' => 'currency_id',
        'currency_code' => 'currency_code',
        'currency_exchange_rate' => 'currency_exchange_rate',
        'default_currency_id' => 'default_currency_id',
        'coupon_discount' => 'coupon_discount',
        'shipping_address_count' => 'shipping_address_count',
        'is_email_opt_in' => 'is_email_opt_in',
        'order_source' => 'order_source',
        'products' => 'products',
        'shipping_addresses' => 'shipping_addresses',
        'coupons' => 'coupons',
        'status_id' => 'status_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'date_modified' => 'setDateModified',
        'date_shipped' => 'setDateShipped',
        'cart_id' => 'setCartId',
        'status' => 'setStatus',
        'subtotal_tax' => 'setSubtotalTax',
        'shipping_cost_tax' => 'setShippingCostTax',
        'shipping_cost_tax_class_id' => 'setShippingCostTaxClassId',
        'handling_cost_tax' => 'setHandlingCostTax',
        'handling_cost_tax_class_id' => 'setHandlingCostTaxClassId',
        'wrapping_cost_tax' => 'setWrappingCostTax',
        'wrapping_cost_tax_class_id' => 'setWrappingCostTaxClassId',
        'payment_status' => 'setPaymentStatus',
        'store_credit_amount' => 'setStoreCreditAmount',
        'gift_certificate_amount' => 'setGiftCertificateAmount',
        'currency_id' => 'setCurrencyId',
        'currency_code' => 'setCurrencyCode',
        'currency_exchange_rate' => 'setCurrencyExchangeRate',
        'default_currency_id' => 'setDefaultCurrencyId',
        'coupon_discount' => 'setCouponDiscount',
        'shipping_address_count' => 'setShippingAddressCount',
        'is_email_opt_in' => 'setIsEmailOptIn',
        'order_source' => 'setOrderSource',
        'products' => 'setProducts',
        'shipping_addresses' => 'setShippingAddresses',
        'coupons' => 'setCoupons',
        'status_id' => 'setStatusId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'date_modified' => 'getDateModified',
        'date_shipped' => 'getDateShipped',
        'cart_id' => 'getCartId',
        'status' => 'getStatus',
        'subtotal_tax' => 'getSubtotalTax',
        'shipping_cost_tax' => 'getShippingCostTax',
        'shipping_cost_tax_class_id' => 'getShippingCostTaxClassId',
        'handling_cost_tax' => 'getHandlingCostTax',
        'handling_cost_tax_class_id' => 'getHandlingCostTaxClassId',
        'wrapping_cost_tax' => 'getWrappingCostTax',
        'wrapping_cost_tax_class_id' => 'getWrappingCostTaxClassId',
        'payment_status' => 'getPaymentStatus',
        'store_credit_amount' => 'getStoreCreditAmount',
        'gift_certificate_amount' => 'getGiftCertificateAmount',
        'currency_id' => 'getCurrencyId',
        'currency_code' => 'getCurrencyCode',
        'currency_exchange_rate' => 'getCurrencyExchangeRate',
        'default_currency_id' => 'getDefaultCurrencyId',
        'coupon_discount' => 'getCouponDiscount',
        'shipping_address_count' => 'getShippingAddressCount',
        'is_email_opt_in' => 'getIsEmailOptIn',
        'order_source' => 'getOrderSource',
        'products' => 'getProducts',
        'shipping_addresses' => 'getShippingAddresses',
        'coupons' => 'getCoupons',
        'status_id' => 'getStatusId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('date_modified', $data ?? [], null);
        $this->setIfExists('date_shipped', $data ?? [], null);
        $this->setIfExists('cart_id', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('subtotal_tax', $data ?? [], null);
        $this->setIfExists('shipping_cost_tax', $data ?? [], null);
        $this->setIfExists('shipping_cost_tax_class_id', $data ?? [], null);
        $this->setIfExists('handling_cost_tax', $data ?? [], null);
        $this->setIfExists('handling_cost_tax_class_id', $data ?? [], null);
        $this->setIfExists('wrapping_cost_tax', $data ?? [], null);
        $this->setIfExists('wrapping_cost_tax_class_id', $data ?? [], null);
        $this->setIfExists('payment_status', $data ?? [], null);
        $this->setIfExists('store_credit_amount', $data ?? [], null);
        $this->setIfExists('gift_certificate_amount', $data ?? [], null);
        $this->setIfExists('currency_id', $data ?? [], null);
        $this->setIfExists('currency_code', $data ?? [], null);
        $this->setIfExists('currency_exchange_rate', $data ?? [], null);
        $this->setIfExists('default_currency_id', $data ?? [], null);
        $this->setIfExists('coupon_discount', $data ?? [], null);
        $this->setIfExists('shipping_address_count', $data ?? [], null);
        $this->setIfExists('is_email_opt_in', $data ?? [], null);
        $this->setIfExists('order_source', $data ?? [], null);
        $this->setIfExists('products', $data ?? [], null);
        $this->setIfExists('shipping_addresses', $data ?? [], null);
        $this->setIfExists('coupons', $data ?? [], null);
        $this->setIfExists('status_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Read-only. The ID of the order.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets date_modified
     *
     * @return string|null
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     *
     * @param string|null $date_modified A read-only value representing the last modification of the order. Do not attempt to modify or set this value in a POST or PUT operation. RFC-2822
     *
     * @return self
     */
    public function setDateModified($date_modified)
    {
        if (is_null($date_modified)) {
            throw new \InvalidArgumentException('non-nullable date_modified cannot be null');
        }
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets date_shipped
     *
     * @return string|null
     */
    public function getDateShipped()
    {
        return $this->container['date_shipped'];
    }

    /**
     * Sets date_shipped
     *
     * @param string|null $date_shipped A read-only value representing the date of shipment. Do not attempt to modify or set this value in a POST or PUT operation. RFC-2822
     *
     * @return self
     */
    public function setDateShipped($date_shipped)
    {
        if (is_null($date_shipped)) {
            throw new \InvalidArgumentException('non-nullable date_shipped cannot be null');
        }
        $this->container['date_shipped'] = $date_shipped;

        return $this;
    }

    /**
     * Gets cart_id
     *
     * @return string|null
     */
    public function getCartId()
    {
        return $this->container['cart_id'];
    }

    /**
     * Sets cart_id
     *
     * @param string|null $cart_id The cart ID from which this order originated, if applicable. Correlates with the Cart API. This is a READ-ONLY field; do not set or modify its value in a POST or PUT request.
     *
     * @return self
     */
    public function setCartId($cart_id)
    {
        if (is_null($cart_id)) {
            throw new \InvalidArgumentException('non-nullable cart_id cannot be null');
        }
        $this->container['cart_id'] = $cart_id;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status The status will include one of the (string, optiona) - values defined under Order Statuses. This value is read-only. Do not attempt to modify or set this value in a POST or PUT operation.
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets subtotal_tax
     *
     * @return string|null
     */
    public function getSubtotalTax()
    {
        return $this->container['subtotal_tax'];
    }

    /**
     * Sets subtotal_tax
     *
     * @param string|null $subtotal_tax A read-only value. Do not attempt to set or modify this value in a POST or PUT operation. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setSubtotalTax($subtotal_tax)
    {
        if (is_null($subtotal_tax)) {
            throw new \InvalidArgumentException('non-nullable subtotal_tax cannot be null');
        }
        $this->container['subtotal_tax'] = $subtotal_tax;

        return $this;
    }

    /**
     * Gets shipping_cost_tax
     *
     * @return string|null
     */
    public function getShippingCostTax()
    {
        return $this->container['shipping_cost_tax'];
    }

    /**
     * Sets shipping_cost_tax
     *
     * @param string|null $shipping_cost_tax A read-only value. Do not attempt to modify or set this value in a POST or PUT operation. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setShippingCostTax($shipping_cost_tax)
    {
        if (is_null($shipping_cost_tax)) {
            throw new \InvalidArgumentException('non-nullable shipping_cost_tax cannot be null');
        }
        $this->container['shipping_cost_tax'] = $shipping_cost_tax;

        return $this;
    }

    /**
     * Gets shipping_cost_tax_class_id
     *
     * @return int|null
     */
    public function getShippingCostTaxClassId()
    {
        return $this->container['shipping_cost_tax_class_id'];
    }

    /**
     * Sets shipping_cost_tax_class_id
     *
     * @param int|null $shipping_cost_tax_class_id Shipping-cost tax class. A read-only value. Do not attempt to modify or set this value in a POST or PUT operation. (NOTE: Value ignored if automatic tax is enabled on the store.)
     *
     * @return self
     */
    public function setShippingCostTaxClassId($shipping_cost_tax_class_id)
    {
        if (is_null($shipping_cost_tax_class_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_cost_tax_class_id cannot be null');
        }
        $this->container['shipping_cost_tax_class_id'] = $shipping_cost_tax_class_id;

        return $this;
    }

    /**
     * Gets handling_cost_tax
     *
     * @return string|null
     */
    public function getHandlingCostTax()
    {
        return $this->container['handling_cost_tax'];
    }

    /**
     * Sets handling_cost_tax
     *
     * @param string|null $handling_cost_tax A read-only value. Do not attempt to modify or set this value in a POST or PUT operation. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setHandlingCostTax($handling_cost_tax)
    {
        if (is_null($handling_cost_tax)) {
            throw new \InvalidArgumentException('non-nullable handling_cost_tax cannot be null');
        }
        $this->container['handling_cost_tax'] = $handling_cost_tax;

        return $this;
    }

    /**
     * Gets handling_cost_tax_class_id
     *
     * @return int|null
     */
    public function getHandlingCostTaxClassId()
    {
        return $this->container['handling_cost_tax_class_id'];
    }

    /**
     * Sets handling_cost_tax_class_id
     *
     * @param int|null $handling_cost_tax_class_id A read-only value. Do not attempt to set or modify this value in a POST or PUT operation. (NOTE: Value ignored if automatic tax is enabled on the store.)
     *
     * @return self
     */
    public function setHandlingCostTaxClassId($handling_cost_tax_class_id)
    {
        if (is_null($handling_cost_tax_class_id)) {
            throw new \InvalidArgumentException('non-nullable handling_cost_tax_class_id cannot be null');
        }
        $this->container['handling_cost_tax_class_id'] = $handling_cost_tax_class_id;

        return $this;
    }

    /**
     * Gets wrapping_cost_tax
     *
     * @return string|null
     */
    public function getWrappingCostTax()
    {
        return $this->container['wrapping_cost_tax'];
    }

    /**
     * Sets wrapping_cost_tax
     *
     * @param string|null $wrapping_cost_tax A read-only value. Do not attempt to modify or set this value in a POST or PUT operation. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setWrappingCostTax($wrapping_cost_tax)
    {
        if (is_null($wrapping_cost_tax)) {
            throw new \InvalidArgumentException('non-nullable wrapping_cost_tax cannot be null');
        }
        $this->container['wrapping_cost_tax'] = $wrapping_cost_tax;

        return $this;
    }

    /**
     * Gets wrapping_cost_tax_class_id
     *
     * @return int|null
     */
    public function getWrappingCostTaxClassId()
    {
        return $this->container['wrapping_cost_tax_class_id'];
    }

    /**
     * Sets wrapping_cost_tax_class_id
     *
     * @param int|null $wrapping_cost_tax_class_id A read-only value. Do not attempt to set or modify this value in a POST or PUT operation. (NOTE: Value ignored if automatic tax is enabled on the store.)
     *
     * @return self
     */
    public function setWrappingCostTaxClassId($wrapping_cost_tax_class_id)
    {
        if (is_null($wrapping_cost_tax_class_id)) {
            throw new \InvalidArgumentException('non-nullable wrapping_cost_tax_class_id cannot be null');
        }
        $this->container['wrapping_cost_tax_class_id'] = $wrapping_cost_tax_class_id;

        return $this;
    }

    /**
     * Gets payment_status
     *
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->container['payment_status'];
    }

    /**
     * Sets payment_status
     *
     * @param string|null $payment_status A read-only value. Do not attempt to set or modify this value in a POST or PUT operation.
     *
     * @return self
     */
    public function setPaymentStatus($payment_status)
    {
        if (is_null($payment_status)) {
            throw new \InvalidArgumentException('non-nullable payment_status cannot be null');
        }
        $this->container['payment_status'] = $payment_status;

        return $this;
    }

    /**
     * Gets store_credit_amount
     *
     * @return string|null
     */
    public function getStoreCreditAmount()
    {
        return $this->container['store_credit_amount'];
    }

    /**
     * Sets store_credit_amount
     *
     * @param string|null $store_credit_amount Represents the store credit that the shopper has redeemed on this individual order. This is a read-only value. Do not pass in a POST or PUT. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setStoreCreditAmount($store_credit_amount)
    {
        if (is_null($store_credit_amount)) {
            throw new \InvalidArgumentException('non-nullable store_credit_amount cannot be null');
        }
        $this->container['store_credit_amount'] = $store_credit_amount;

        return $this;
    }

    /**
     * Gets gift_certificate_amount
     *
     * @return string|null
     */
    public function getGiftCertificateAmount()
    {
        return $this->container['gift_certificate_amount'];
    }

    /**
     * Sets gift_certificate_amount
     *
     * @param string|null $gift_certificate_amount A read-only value. Do not pass in a POST or PUT. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setGiftCertificateAmount($gift_certificate_amount)
    {
        if (is_null($gift_certificate_amount)) {
            throw new \InvalidArgumentException('non-nullable gift_certificate_amount cannot be null');
        }
        $this->container['gift_certificate_amount'] = $gift_certificate_amount;

        return $this;
    }

    /**
     * Gets currency_id
     *
     * @return int|null
     */
    public function getCurrencyId()
    {
        return $this->container['currency_id'];
    }

    /**
     * Sets currency_id
     *
     * @param int|null $currency_id The display currency ID. May be different from transactional currency. A read-only value. Do not pass in a POST or PUT.
     *
     * @return self
     */
    public function setCurrencyId($currency_id)
    {
        if (is_null($currency_id)) {
            throw new \InvalidArgumentException('non-nullable currency_id cannot be null');
        }
        $this->container['currency_id'] = $currency_id;

        return $this;
    }

    /**
     * Gets currency_code
     *
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->container['currency_code'];
    }

    /**
     * Sets currency_code
     *
     * @param string|null $currency_code The currency code of the display currency used to present prices on the storefront. A read-only value. Do not pass in a POST or PUT.
     *
     * @return self
     */
    public function setCurrencyCode($currency_code)
    {
        if (is_null($currency_code)) {
            throw new \InvalidArgumentException('non-nullable currency_code cannot be null');
        }
        $this->container['currency_code'] = $currency_code;

        return $this;
    }

    /**
     * Gets currency_exchange_rate
     *
     * @return string|null
     */
    public function getCurrencyExchangeRate()
    {
        return $this->container['currency_exchange_rate'];
    }

    /**
     * Sets currency_exchange_rate
     *
     * @param string|null $currency_exchange_rate The exchange rate between the store's default currency and the display currency. A read-only value. Do not pass in a POST or PUT. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setCurrencyExchangeRate($currency_exchange_rate)
    {
        if (is_null($currency_exchange_rate)) {
            throw new \InvalidArgumentException('non-nullable currency_exchange_rate cannot be null');
        }
        $this->container['currency_exchange_rate'] = $currency_exchange_rate;

        return $this;
    }

    /**
     * Gets default_currency_id
     *
     * @return int|null
     */
    public function getDefaultCurrencyId()
    {
        return $this->container['default_currency_id'];
    }

    /**
     * Sets default_currency_id
     *
     * @param int|null $default_currency_id The transactional currency ID. A read-only value. Do not pass in a POST or PUT.
     *
     * @return self
     */
    public function setDefaultCurrencyId($default_currency_id)
    {
        if (is_null($default_currency_id)) {
            throw new \InvalidArgumentException('non-nullable default_currency_id cannot be null');
        }
        $this->container['default_currency_id'] = $default_currency_id;

        return $this;
    }

    /**
     * Gets coupon_discount
     *
     * @return string|null
     */
    public function getCouponDiscount()
    {
        return $this->container['coupon_discount'];
    }

    /**
     * Sets coupon_discount
     *
     * @param string|null $coupon_discount A read-only value. Do not pass in a POST or PUT. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setCouponDiscount($coupon_discount)
    {
        if (is_null($coupon_discount)) {
            throw new \InvalidArgumentException('non-nullable coupon_discount cannot be null');
        }
        $this->container['coupon_discount'] = $coupon_discount;

        return $this;
    }

    /**
     * Gets shipping_address_count
     *
     * @return float|null
     */
    public function getShippingAddressCount()
    {
        return $this->container['shipping_address_count'];
    }

    /**
     * Sets shipping_address_count
     *
     * @param float|null $shipping_address_count The number of shipping addresses associated with this transaction. A read-only value. Do not pass in a POST or PUT.
     *
     * @return self
     */
    public function setShippingAddressCount($shipping_address_count)
    {
        if (is_null($shipping_address_count)) {
            throw new \InvalidArgumentException('non-nullable shipping_address_count cannot be null');
        }
        $this->container['shipping_address_count'] = $shipping_address_count;

        return $this;
    }

    /**
     * Gets is_email_opt_in
     *
     * @return bool|null
     */
    public function getIsEmailOptIn()
    {
        return $this->container['is_email_opt_in'];
    }

    /**
     * Sets is_email_opt_in
     *
     * @param bool|null $is_email_opt_in Indicates whether the shopper has selected an opt-in check box (on the checkout page) to receive emails. A read-only value. Do not pass in a POST or PUT.
     *
     * @return self
     */
    public function setIsEmailOptIn($is_email_opt_in)
    {
        if (is_null($is_email_opt_in)) {
            throw new \InvalidArgumentException('non-nullable is_email_opt_in cannot be null');
        }
        $this->container['is_email_opt_in'] = $is_email_opt_in;

        return $this;
    }

    /**
     * Gets order_source
     *
     * @return string|null
     */
    public function getOrderSource()
    {
        return $this->container['order_source'];
    }

    /**
     * Sets order_source
     *
     * @param string|null $order_source Orders submitted via the store's website will include a `www` value. Orders submitted via the API will be set to `external`. A read-only value. Do not pass in a POST or PUT.
     *
     * @return self
     */
    public function setOrderSource($order_source)
    {
        if (is_null($order_source)) {
            throw new \InvalidArgumentException('non-nullable order_source cannot be null');
        }
        $this->container['order_source'] = $order_source;

        return $this;
    }

    /**
     * Gets products
     *
     * @return \Bigcommerce\OrdersV2\Model\ProductsResource|null
     */
    public function getProducts()
    {
        return $this->container['products'];
    }

    /**
     * Sets products
     *
     * @param \Bigcommerce\OrdersV2\Model\ProductsResource|null $products products
     *
     * @return self
     */
    public function setProducts($products)
    {
        if (is_null($products)) {
            throw new \InvalidArgumentException('non-nullable products cannot be null');
        }
        $this->container['products'] = $products;

        return $this;
    }

    /**
     * Gets shipping_addresses
     *
     * @return \Bigcommerce\OrdersV2\Model\ShippingAddressesResource|null
     */
    public function getShippingAddresses()
    {
        return $this->container['shipping_addresses'];
    }

    /**
     * Sets shipping_addresses
     *
     * @param \Bigcommerce\OrdersV2\Model\ShippingAddressesResource|null $shipping_addresses shipping_addresses
     *
     * @return self
     */
    public function setShippingAddresses($shipping_addresses)
    {
        if (is_null($shipping_addresses)) {
            throw new \InvalidArgumentException('non-nullable shipping_addresses cannot be null');
        }
        $this->container['shipping_addresses'] = $shipping_addresses;

        return $this;
    }

    /**
     * Gets coupons
     *
     * @return \Bigcommerce\OrdersV2\Model\CouponsResource|null
     */
    public function getCoupons()
    {
        return $this->container['coupons'];
    }

    /**
     * Sets coupons
     *
     * @param \Bigcommerce\OrdersV2\Model\CouponsResource|null $coupons coupons
     *
     * @return self
     */
    public function setCoupons($coupons)
    {
        if (is_null($coupons)) {
            throw new \InvalidArgumentException('non-nullable coupons cannot be null');
        }
        $this->container['coupons'] = $coupons;

        return $this;
    }

    /**
     * Gets status_id
     *
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->container['status_id'];
    }

    /**
     * Sets status_id
     *
     * @param int|null $status_id The staus ID of the order.
     *
     * @return self
     */
    public function setStatusId($status_id)
    {
        if (is_null($status_id)) {
            throw new \InvalidArgumentException('non-nullable status_id cannot be null');
        }
        $this->container['status_id'] = $status_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


