<?php
/**
 * OrderPut
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V2
 *
 * Manage order coupons, messages, products, shipping addresses, statuses, taxes, shipments, and shipping address quotes.  - [Authentication](#authentication) - [Order](#order)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  |  **UI Name** | **Permission** | **Parameter** | | --- | --- | --- | |  Orders | modify | `store_v2_orders` | |  Orders | read-only | `store_v2_orders_read_only` |   ## Order  The Order object contains a record of the purchase agreement between a shopper and a merchant. To learn more about creating orders, see [Orders API Guide](/api-docs/orders/orders-api-overview).  ### Currency Fields  The **default** currency refers to the transactional currency which is the currency the shopper pays in.  The **display** currency refers to the presentational currency used to present prices to the shopper on the storefront.  * `currency_id` - the display currency ID. Depending on the currency selected, the value may be different from the transactional currency. * `currency_code` - the currency code of the display currency used to present prices to the shopper on the storefront. Depending on the currency selected, the value may be different from the transactional currency. * `currency_exchange_rate` - the exchange rate between the store's default currency and the display currency. For orders created using the V2 endpoints, this value is always 1 (only in the storefront this value can be different to 1). * `default_currency_id` - the transactional currency ID. * `default_currency_code` - the currency code of the transactional currency the shopper pays in.  The following additional fields are returned on orders when Multi-Currency is enabled on the store:  * `store_default_currency_code` - the currency code of the store's default currency. * `store_default_to_transactional_exchange_rate` - the exchange rate between the store's default currency and the transactional currency used in the order.  **Example:**  ```json {   ...   \"currency_id\": 4,   \"currency_code\": \"EUR\",   \"currency_exchange_rate\": 1,   \"default_currency_id\": 4,   \"default_currency_code\": \"EUR\",   \"store_default_currency_code\": \"USD\",   \"store_default_to_transactional_exchange_rate\": \"100.0000000000\"   ... } ```
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV2\Model;

use \ArrayAccess;
use \Bigcommerce\OrdersV2\ObjectSerializer;

/**
 * OrderPut Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderPut implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'order_Put';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'base_handling_cost' => 'string',
        'base_shipping_cost' => 'string',
        'base_wrapping_cost' => 'string',
        'billing_address' => '\Bigcommerce\OrdersV2\Model\BillingAddressFull',
        'channel_id' => 'int',
        'customer_id' => 'float',
        'customer_message' => 'string',
        'date_created' => 'string',
        'default_currency_code' => 'string',
        'discount_amount' => 'string',
        'ebay_order_id' => 'string',
        'external_id' => 'string',
        'external_source' => 'string',
        'geoip_country' => 'string',
        'geoip_country_iso2' => 'string',
        'handling_cost_ex_tax' => 'string',
        'handling_cost_inc_tax' => 'string',
        'ip_address' => 'string',
        'is_deleted' => 'bool',
        'items_shipped' => 'float',
        'items_total' => 'float',
        'order_is_digital' => 'bool',
        'payment_method' => 'string',
        'payment_provider_id' => 'string',
        'refunded_amount' => 'string',
        'shipping_cost_ex_tax' => 'string',
        'shipping_cost_inc_tax' => 'string',
        'staff_notes' => 'string',
        'status_id' => 'int',
        'subtotal_ex_tax' => 'string',
        'subtotal_inc_tax' => 'string',
        'tax_provider_id' => 'string',
        'customer_locale' => 'string',
        'total_ex_tax' => 'string',
        'total_inc_tax' => 'string',
        'wrapping_cost_ex_tax' => 'string',
        'wrapping_cost_inc_tax' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'base_handling_cost' => null,
        'base_shipping_cost' => null,
        'base_wrapping_cost' => null,
        'billing_address' => null,
        'channel_id' => null,
        'customer_id' => null,
        'customer_message' => null,
        'date_created' => null,
        'default_currency_code' => null,
        'discount_amount' => null,
        'ebay_order_id' => null,
        'external_id' => null,
        'external_source' => null,
        'geoip_country' => null,
        'geoip_country_iso2' => null,
        'handling_cost_ex_tax' => null,
        'handling_cost_inc_tax' => null,
        'ip_address' => null,
        'is_deleted' => null,
        'items_shipped' => null,
        'items_total' => null,
        'order_is_digital' => null,
        'payment_method' => null,
        'payment_provider_id' => null,
        'refunded_amount' => null,
        'shipping_cost_ex_tax' => null,
        'shipping_cost_inc_tax' => null,
        'staff_notes' => null,
        'status_id' => null,
        'subtotal_ex_tax' => null,
        'subtotal_inc_tax' => null,
        'tax_provider_id' => null,
        'customer_locale' => null,
        'total_ex_tax' => null,
        'total_inc_tax' => null,
        'wrapping_cost_ex_tax' => null,
        'wrapping_cost_inc_tax' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'base_handling_cost' => false,
        'base_shipping_cost' => false,
        'base_wrapping_cost' => false,
        'billing_address' => false,
        'channel_id' => false,
        'customer_id' => false,
        'customer_message' => false,
        'date_created' => false,
        'default_currency_code' => false,
        'discount_amount' => false,
        'ebay_order_id' => false,
        'external_id' => false,
        'external_source' => false,
        'geoip_country' => false,
        'geoip_country_iso2' => false,
        'handling_cost_ex_tax' => false,
        'handling_cost_inc_tax' => false,
        'ip_address' => false,
        'is_deleted' => false,
        'items_shipped' => false,
        'items_total' => false,
        'order_is_digital' => false,
        'payment_method' => false,
        'payment_provider_id' => false,
        'refunded_amount' => false,
        'shipping_cost_ex_tax' => false,
        'shipping_cost_inc_tax' => false,
        'staff_notes' => false,
        'status_id' => false,
        'subtotal_ex_tax' => false,
        'subtotal_inc_tax' => false,
        'tax_provider_id' => false,
        'customer_locale' => false,
        'total_ex_tax' => false,
        'total_inc_tax' => false,
        'wrapping_cost_ex_tax' => false,
        'wrapping_cost_inc_tax' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'base_handling_cost' => 'base_handling_cost',
        'base_shipping_cost' => 'base_shipping_cost',
        'base_wrapping_cost' => 'base_wrapping_cost',
        'billing_address' => 'billing_address',
        'channel_id' => 'channel_id',
        'customer_id' => 'customer_id',
        'customer_message' => 'customer_message',
        'date_created' => 'date_created',
        'default_currency_code' => 'default_currency_code',
        'discount_amount' => 'discount_amount',
        'ebay_order_id' => 'ebay_order_id',
        'external_id' => 'external_id',
        'external_source' => 'external_source',
        'geoip_country' => 'geoip_country',
        'geoip_country_iso2' => 'geoip_country_iso2',
        'handling_cost_ex_tax' => 'handling_cost_ex_tax',
        'handling_cost_inc_tax' => 'handling_cost_inc_tax',
        'ip_address' => 'ip_address',
        'is_deleted' => 'is_deleted',
        'items_shipped' => 'items_shipped',
        'items_total' => 'items_total',
        'order_is_digital' => 'order_is_digital',
        'payment_method' => 'payment_method',
        'payment_provider_id' => 'payment_provider_id',
        'refunded_amount' => 'refunded_amount',
        'shipping_cost_ex_tax' => 'shipping_cost_ex_tax',
        'shipping_cost_inc_tax' => 'shipping_cost_inc_tax',
        'staff_notes' => 'staff_notes',
        'status_id' => 'status_id',
        'subtotal_ex_tax' => 'subtotal_ex_tax',
        'subtotal_inc_tax' => 'subtotal_inc_tax',
        'tax_provider_id' => 'tax_provider_id',
        'customer_locale' => 'customer_locale',
        'total_ex_tax' => 'total_ex_tax',
        'total_inc_tax' => 'total_inc_tax',
        'wrapping_cost_ex_tax' => 'wrapping_cost_ex_tax',
        'wrapping_cost_inc_tax' => 'wrapping_cost_inc_tax'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'base_handling_cost' => 'setBaseHandlingCost',
        'base_shipping_cost' => 'setBaseShippingCost',
        'base_wrapping_cost' => 'setBaseWrappingCost',
        'billing_address' => 'setBillingAddress',
        'channel_id' => 'setChannelId',
        'customer_id' => 'setCustomerId',
        'customer_message' => 'setCustomerMessage',
        'date_created' => 'setDateCreated',
        'default_currency_code' => 'setDefaultCurrencyCode',
        'discount_amount' => 'setDiscountAmount',
        'ebay_order_id' => 'setEbayOrderId',
        'external_id' => 'setExternalId',
        'external_source' => 'setExternalSource',
        'geoip_country' => 'setGeoipCountry',
        'geoip_country_iso2' => 'setGeoipCountryIso2',
        'handling_cost_ex_tax' => 'setHandlingCostExTax',
        'handling_cost_inc_tax' => 'setHandlingCostIncTax',
        'ip_address' => 'setIpAddress',
        'is_deleted' => 'setIsDeleted',
        'items_shipped' => 'setItemsShipped',
        'items_total' => 'setItemsTotal',
        'order_is_digital' => 'setOrderIsDigital',
        'payment_method' => 'setPaymentMethod',
        'payment_provider_id' => 'setPaymentProviderId',
        'refunded_amount' => 'setRefundedAmount',
        'shipping_cost_ex_tax' => 'setShippingCostExTax',
        'shipping_cost_inc_tax' => 'setShippingCostIncTax',
        'staff_notes' => 'setStaffNotes',
        'status_id' => 'setStatusId',
        'subtotal_ex_tax' => 'setSubtotalExTax',
        'subtotal_inc_tax' => 'setSubtotalIncTax',
        'tax_provider_id' => 'setTaxProviderId',
        'customer_locale' => 'setCustomerLocale',
        'total_ex_tax' => 'setTotalExTax',
        'total_inc_tax' => 'setTotalIncTax',
        'wrapping_cost_ex_tax' => 'setWrappingCostExTax',
        'wrapping_cost_inc_tax' => 'setWrappingCostIncTax'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'base_handling_cost' => 'getBaseHandlingCost',
        'base_shipping_cost' => 'getBaseShippingCost',
        'base_wrapping_cost' => 'getBaseWrappingCost',
        'billing_address' => 'getBillingAddress',
        'channel_id' => 'getChannelId',
        'customer_id' => 'getCustomerId',
        'customer_message' => 'getCustomerMessage',
        'date_created' => 'getDateCreated',
        'default_currency_code' => 'getDefaultCurrencyCode',
        'discount_amount' => 'getDiscountAmount',
        'ebay_order_id' => 'getEbayOrderId',
        'external_id' => 'getExternalId',
        'external_source' => 'getExternalSource',
        'geoip_country' => 'getGeoipCountry',
        'geoip_country_iso2' => 'getGeoipCountryIso2',
        'handling_cost_ex_tax' => 'getHandlingCostExTax',
        'handling_cost_inc_tax' => 'getHandlingCostIncTax',
        'ip_address' => 'getIpAddress',
        'is_deleted' => 'getIsDeleted',
        'items_shipped' => 'getItemsShipped',
        'items_total' => 'getItemsTotal',
        'order_is_digital' => 'getOrderIsDigital',
        'payment_method' => 'getPaymentMethod',
        'payment_provider_id' => 'getPaymentProviderId',
        'refunded_amount' => 'getRefundedAmount',
        'shipping_cost_ex_tax' => 'getShippingCostExTax',
        'shipping_cost_inc_tax' => 'getShippingCostIncTax',
        'staff_notes' => 'getStaffNotes',
        'status_id' => 'getStatusId',
        'subtotal_ex_tax' => 'getSubtotalExTax',
        'subtotal_inc_tax' => 'getSubtotalIncTax',
        'tax_provider_id' => 'getTaxProviderId',
        'customer_locale' => 'getCustomerLocale',
        'total_ex_tax' => 'getTotalExTax',
        'total_inc_tax' => 'getTotalIncTax',
        'wrapping_cost_ex_tax' => 'getWrappingCostExTax',
        'wrapping_cost_inc_tax' => 'getWrappingCostIncTax'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TAX_PROVIDER_ID_BASIC_TAX_PROVIDER = 'BasicTaxProvider';
    public const TAX_PROVIDER_ID_AVA_TAX_PROVIDER = 'AvaTaxProvider';
    public const TAX_PROVIDER_ID_EMPTY = '';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTaxProviderIdAllowableValues()
    {
        return [
            self::TAX_PROVIDER_ID_BASIC_TAX_PROVIDER,
            self::TAX_PROVIDER_ID_AVA_TAX_PROVIDER,
            self::TAX_PROVIDER_ID_EMPTY,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('base_handling_cost', $data ?? [], null);
        $this->setIfExists('base_shipping_cost', $data ?? [], null);
        $this->setIfExists('base_wrapping_cost', $data ?? [], null);
        $this->setIfExists('billing_address', $data ?? [], null);
        $this->setIfExists('channel_id', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('customer_message', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('default_currency_code', $data ?? [], null);
        $this->setIfExists('discount_amount', $data ?? [], null);
        $this->setIfExists('ebay_order_id', $data ?? [], null);
        $this->setIfExists('external_id', $data ?? [], null);
        $this->setIfExists('external_source', $data ?? [], null);
        $this->setIfExists('geoip_country', $data ?? [], null);
        $this->setIfExists('geoip_country_iso2', $data ?? [], null);
        $this->setIfExists('handling_cost_ex_tax', $data ?? [], null);
        $this->setIfExists('handling_cost_inc_tax', $data ?? [], null);
        $this->setIfExists('ip_address', $data ?? [], null);
        $this->setIfExists('is_deleted', $data ?? [], null);
        $this->setIfExists('items_shipped', $data ?? [], null);
        $this->setIfExists('items_total', $data ?? [], null);
        $this->setIfExists('order_is_digital', $data ?? [], null);
        $this->setIfExists('payment_method', $data ?? [], null);
        $this->setIfExists('payment_provider_id', $data ?? [], null);
        $this->setIfExists('refunded_amount', $data ?? [], null);
        $this->setIfExists('shipping_cost_ex_tax', $data ?? [], null);
        $this->setIfExists('shipping_cost_inc_tax', $data ?? [], null);
        $this->setIfExists('staff_notes', $data ?? [], null);
        $this->setIfExists('status_id', $data ?? [], null);
        $this->setIfExists('subtotal_ex_tax', $data ?? [], null);
        $this->setIfExists('subtotal_inc_tax', $data ?? [], null);
        $this->setIfExists('tax_provider_id', $data ?? [], null);
        $this->setIfExists('customer_locale', $data ?? [], null);
        $this->setIfExists('total_ex_tax', $data ?? [], null);
        $this->setIfExists('total_inc_tax', $data ?? [], null);
        $this->setIfExists('wrapping_cost_ex_tax', $data ?? [], null);
        $this->setIfExists('wrapping_cost_inc_tax', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getTaxProviderIdAllowableValues();
        if (!is_null($this->container['tax_provider_id']) && !in_array($this->container['tax_provider_id'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'tax_provider_id', must be one of '%s'",
                $this->container['tax_provider_id'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets base_handling_cost
     *
     * @return string|null
     */
    public function getBaseHandlingCost()
    {
        return $this->container['base_handling_cost'];
    }

    /**
     * Sets base_handling_cost
     *
     * @param string|null $base_handling_cost The value of the base handling cost. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setBaseHandlingCost($base_handling_cost)
    {
        if (is_null($base_handling_cost)) {
            throw new \InvalidArgumentException('non-nullable base_handling_cost cannot be null');
        }
        $this->container['base_handling_cost'] = $base_handling_cost;

        return $this;
    }

    /**
     * Gets base_shipping_cost
     *
     * @return string|null
     */
    public function getBaseShippingCost()
    {
        return $this->container['base_shipping_cost'];
    }

    /**
     * Sets base_shipping_cost
     *
     * @param string|null $base_shipping_cost The value of the base shipping cost. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setBaseShippingCost($base_shipping_cost)
    {
        if (is_null($base_shipping_cost)) {
            throw new \InvalidArgumentException('non-nullable base_shipping_cost cannot be null');
        }
        $this->container['base_shipping_cost'] = $base_shipping_cost;

        return $this;
    }

    /**
     * Gets base_wrapping_cost
     *
     * @return string|null
     */
    public function getBaseWrappingCost()
    {
        return $this->container['base_wrapping_cost'];
    }

    /**
     * Sets base_wrapping_cost
     *
     * @param string|null $base_wrapping_cost The value of the base wrapping cost. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setBaseWrappingCost($base_wrapping_cost)
    {
        if (is_null($base_wrapping_cost)) {
            throw new \InvalidArgumentException('non-nullable base_wrapping_cost cannot be null');
        }
        $this->container['base_wrapping_cost'] = $base_wrapping_cost;

        return $this;
    }

    /**
     * Gets billing_address
     *
     * @return \Bigcommerce\OrdersV2\Model\BillingAddressFull|null
     */
    public function getBillingAddress()
    {
        return $this->container['billing_address'];
    }

    /**
     * Sets billing_address
     *
     * @param \Bigcommerce\OrdersV2\Model\BillingAddressFull|null $billing_address billing_address
     *
     * @return self
     */
    public function setBillingAddress($billing_address)
    {
        if (is_null($billing_address)) {
            throw new \InvalidArgumentException('non-nullable billing_address cannot be null');
        }
        $this->container['billing_address'] = $billing_address;

        return $this;
    }

    /**
     * Gets channel_id
     *
     * @return int|null
     */
    public function getChannelId()
    {
        return $this->container['channel_id'];
    }

    /**
     * Sets channel_id
     *
     * @param int|null $channel_id Shows where the order originated. The channel_id will default to 1.
     *
     * @return self
     */
    public function setChannelId($channel_id)
    {
        if (is_null($channel_id)) {
            throw new \InvalidArgumentException('non-nullable channel_id cannot be null');
        }
        $this->container['channel_id'] = $channel_id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return float|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param float|null $customer_id customer_id
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            throw new \InvalidArgumentException('non-nullable customer_id cannot be null');
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets customer_message
     *
     * @return string|null
     */
    public function getCustomerMessage()
    {
        return $this->container['customer_message'];
    }

    /**
     * Sets customer_message
     *
     * @param string|null $customer_message Message that the customer entered (number, optional) -o the `Order Comments` box during checkout.
     *
     * @return self
     */
    public function setCustomerMessage($customer_message)
    {
        if (is_null($customer_message)) {
            throw new \InvalidArgumentException('non-nullable customer_message cannot be null');
        }
        $this->container['customer_message'] = $customer_message;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return string|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param string|null $date_created The date this order was created. If not specified, will default to the current time. The date should be in RFC 2822 format.
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets default_currency_code
     *
     * @return string|null
     */
    public function getDefaultCurrencyCode()
    {
        return $this->container['default_currency_code'];
    }

    /**
     * Sets default_currency_code
     *
     * @param string|null $default_currency_code The currency code of the transactional currency the shopper pays in; writeable when multi-currency is enabled.
     *
     * @return self
     */
    public function setDefaultCurrencyCode($default_currency_code)
    {
        if (is_null($default_currency_code)) {
            throw new \InvalidArgumentException('non-nullable default_currency_code cannot be null');
        }
        $this->container['default_currency_code'] = $default_currency_code;

        return $this;
    }

    /**
     * Gets discount_amount
     *
     * @return string|null
     */
    public function getDiscountAmount()
    {
        return $this->container['discount_amount'];
    }

    /**
     * Sets discount_amount
     *
     * @param string|null $discount_amount Amount of discount for this transaction. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setDiscountAmount($discount_amount)
    {
        if (is_null($discount_amount)) {
            throw new \InvalidArgumentException('non-nullable discount_amount cannot be null');
        }
        $this->container['discount_amount'] = $discount_amount;

        return $this;
    }

    /**
     * Gets ebay_order_id
     *
     * @return string|null
     */
    public function getEbayOrderId()
    {
        return $this->container['ebay_order_id'];
    }

    /**
     * Sets ebay_order_id
     *
     * @param string|null $ebay_order_id If the order was placed through eBay, the eBay order number will be included. Otherwise, the value will be `0`.
     *
     * @return self
     */
    public function setEbayOrderId($ebay_order_id)
    {
        if (is_null($ebay_order_id)) {
            throw new \InvalidArgumentException('non-nullable ebay_order_id cannot be null');
        }
        $this->container['ebay_order_id'] = $ebay_order_id;

        return $this;
    }

    /**
     * Gets external_id
     *
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->container['external_id'];
    }

    /**
     * Sets external_id
     *
     * @param string|null $external_id ID of the order in another system. For example, the Amazon Order ID if this is an Amazon order.This field can be updated in a /POST, but using a /PUT to update the order will return a 400 error. The field 'external_id' cannot be written to. Please remove it from your request before trying again. It can not be overwritten once set.
     *
     * @return self
     */
    public function setExternalId($external_id)
    {
        if (is_null($external_id)) {
            throw new \InvalidArgumentException('non-nullable external_id cannot be null');
        }
        $this->container['external_id'] = $external_id;

        return $this;
    }

    /**
     * Gets external_source
     *
     * @return string|null
     */
    public function getExternalSource()
    {
        return $this->container['external_source'];
    }

    /**
     * Sets external_source
     *
     * @param string|null $external_source For orders submitted or modified via the API, using a PUT or POST operation, you can optionally pass in a value identifying the system used to generate the order. For example: `POS`. Otherwise, the value will be null.
     *
     * @return self
     */
    public function setExternalSource($external_source)
    {
        if (is_null($external_source)) {
            throw new \InvalidArgumentException('non-nullable external_source cannot be null');
        }
        $this->container['external_source'] = $external_source;

        return $this;
    }

    /**
     * Gets geoip_country
     *
     * @return string|null
     */
    public function getGeoipCountry()
    {
        return $this->container['geoip_country'];
    }

    /**
     * Sets geoip_country
     *
     * @param string|null $geoip_country The full name of the country where the customer made the purchase, based on the IP.
     *
     * @return self
     */
    public function setGeoipCountry($geoip_country)
    {
        if (is_null($geoip_country)) {
            throw new \InvalidArgumentException('non-nullable geoip_country cannot be null');
        }
        $this->container['geoip_country'] = $geoip_country;

        return $this;
    }

    /**
     * Gets geoip_country_iso2
     *
     * @return string|null
     */
    public function getGeoipCountryIso2()
    {
        return $this->container['geoip_country_iso2'];
    }

    /**
     * Sets geoip_country_iso2
     *
     * @param string|null $geoip_country_iso2 The country where the customer made the purchase, in ISO2 format, based on the IP.
     *
     * @return self
     */
    public function setGeoipCountryIso2($geoip_country_iso2)
    {
        if (is_null($geoip_country_iso2)) {
            throw new \InvalidArgumentException('non-nullable geoip_country_iso2 cannot be null');
        }
        $this->container['geoip_country_iso2'] = $geoip_country_iso2;

        return $this;
    }

    /**
     * Gets handling_cost_ex_tax
     *
     * @return string|null
     */
    public function getHandlingCostExTax()
    {
        return $this->container['handling_cost_ex_tax'];
    }

    /**
     * Sets handling_cost_ex_tax
     *
     * @param string|null $handling_cost_ex_tax The value of the handling cost, excluding tax. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setHandlingCostExTax($handling_cost_ex_tax)
    {
        if (is_null($handling_cost_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable handling_cost_ex_tax cannot be null');
        }
        $this->container['handling_cost_ex_tax'] = $handling_cost_ex_tax;

        return $this;
    }

    /**
     * Gets handling_cost_inc_tax
     *
     * @return string|null
     */
    public function getHandlingCostIncTax()
    {
        return $this->container['handling_cost_inc_tax'];
    }

    /**
     * Sets handling_cost_inc_tax
     *
     * @param string|null $handling_cost_inc_tax The value of the handling cost, including tax. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setHandlingCostIncTax($handling_cost_inc_tax)
    {
        if (is_null($handling_cost_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable handling_cost_inc_tax cannot be null');
        }
        $this->container['handling_cost_inc_tax'] = $handling_cost_inc_tax;

        return $this;
    }

    /**
     * Gets ip_address
     *
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->container['ip_address'];
    }

    /**
     * Sets ip_address
     *
     * @param string|null $ip_address IP Address of the customer, if known.
     *
     * @return self
     */
    public function setIpAddress($ip_address)
    {
        if (is_null($ip_address)) {
            throw new \InvalidArgumentException('non-nullable ip_address cannot be null');
        }
        $this->container['ip_address'] = $ip_address;

        return $this;
    }

    /**
     * Gets is_deleted
     *
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return $this->container['is_deleted'];
    }

    /**
     * Sets is_deleted
     *
     * @param bool|null $is_deleted Indicates whether the order was deleted (archived). Set to to true, to archive an order.
     *
     * @return self
     */
    public function setIsDeleted($is_deleted)
    {
        if (is_null($is_deleted)) {
            throw new \InvalidArgumentException('non-nullable is_deleted cannot be null');
        }
        $this->container['is_deleted'] = $is_deleted;

        return $this;
    }

    /**
     * Gets items_shipped
     *
     * @return float|null
     */
    public function getItemsShipped()
    {
        return $this->container['items_shipped'];
    }

    /**
     * Sets items_shipped
     *
     * @param float|null $items_shipped The number of items that have been shipped.
     *
     * @return self
     */
    public function setItemsShipped($items_shipped)
    {
        if (is_null($items_shipped)) {
            throw new \InvalidArgumentException('non-nullable items_shipped cannot be null');
        }
        $this->container['items_shipped'] = $items_shipped;

        return $this;
    }

    /**
     * Gets items_total
     *
     * @return float|null
     */
    public function getItemsTotal()
    {
        return $this->container['items_total'];
    }

    /**
     * Sets items_total
     *
     * @param float|null $items_total The total number of items in the order.
     *
     * @return self
     */
    public function setItemsTotal($items_total)
    {
        if (is_null($items_total)) {
            throw new \InvalidArgumentException('non-nullable items_total cannot be null');
        }
        $this->container['items_total'] = $items_total;

        return $this;
    }

    /**
     * Gets order_is_digital
     *
     * @return bool|null
     */
    public function getOrderIsDigital()
    {
        return $this->container['order_is_digital'];
    }

    /**
     * Sets order_is_digital
     *
     * @param bool|null $order_is_digital Whether this is an order for digital products.
     *
     * @return self
     */
    public function setOrderIsDigital($order_is_digital)
    {
        if (is_null($order_is_digital)) {
            throw new \InvalidArgumentException('non-nullable order_is_digital cannot be null');
        }
        $this->container['order_is_digital'] = $order_is_digital;

        return $this;
    }

    /**
     * Gets payment_method
     *
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->container['payment_method'];
    }

    /**
     * Sets payment_method
     *
     * @param string|null $payment_method The payment method for this order. Can be one of the following: `Manual`, `Credit Card`, `cash`, `Test Payment Gateway`, etc.
     *
     * @return self
     */
    public function setPaymentMethod($payment_method)
    {
        if (is_null($payment_method)) {
            throw new \InvalidArgumentException('non-nullable payment_method cannot be null');
        }
        $this->container['payment_method'] = $payment_method;

        return $this;
    }

    /**
     * Gets payment_provider_id
     *
     * @return string|null
     */
    public function getPaymentProviderId()
    {
        return $this->container['payment_provider_id'];
    }

    /**
     * Sets payment_provider_id
     *
     * @param string|null $payment_provider_id The external Transaction ID/Payment ID within this order's payment provider (if a payment provider was used).
     *
     * @return self
     */
    public function setPaymentProviderId($payment_provider_id)
    {
        if (is_null($payment_provider_id)) {
            throw new \InvalidArgumentException('non-nullable payment_provider_id cannot be null');
        }
        $this->container['payment_provider_id'] = $payment_provider_id;

        return $this;
    }

    /**
     * Gets refunded_amount
     *
     * @return string|null
     */
    public function getRefundedAmount()
    {
        return $this->container['refunded_amount'];
    }

    /**
     * Sets refunded_amount
     *
     * @param string|null $refunded_amount The amount refunded from this transaction. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setRefundedAmount($refunded_amount)
    {
        if (is_null($refunded_amount)) {
            throw new \InvalidArgumentException('non-nullable refunded_amount cannot be null');
        }
        $this->container['refunded_amount'] = $refunded_amount;

        return $this;
    }

    /**
     * Gets shipping_cost_ex_tax
     *
     * @return string|null
     */
    public function getShippingCostExTax()
    {
        return $this->container['shipping_cost_ex_tax'];
    }

    /**
     * Sets shipping_cost_ex_tax
     *
     * @param string|null $shipping_cost_ex_tax The value of shipping cost, excluding tax. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setShippingCostExTax($shipping_cost_ex_tax)
    {
        if (is_null($shipping_cost_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable shipping_cost_ex_tax cannot be null');
        }
        $this->container['shipping_cost_ex_tax'] = $shipping_cost_ex_tax;

        return $this;
    }

    /**
     * Gets shipping_cost_inc_tax
     *
     * @return string|null
     */
    public function getShippingCostIncTax()
    {
        return $this->container['shipping_cost_inc_tax'];
    }

    /**
     * Sets shipping_cost_inc_tax
     *
     * @param string|null $shipping_cost_inc_tax The value of shipping cost, including tax. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setShippingCostIncTax($shipping_cost_inc_tax)
    {
        if (is_null($shipping_cost_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable shipping_cost_inc_tax cannot be null');
        }
        $this->container['shipping_cost_inc_tax'] = $shipping_cost_inc_tax;

        return $this;
    }

    /**
     * Gets staff_notes
     *
     * @return string|null
     */
    public function getStaffNotes()
    {
        return $this->container['staff_notes'];
    }

    /**
     * Sets staff_notes
     *
     * @param string|null $staff_notes Any additional notes for staff.
     *
     * @return self
     */
    public function setStaffNotes($staff_notes)
    {
        if (is_null($staff_notes)) {
            throw new \InvalidArgumentException('non-nullable staff_notes cannot be null');
        }
        $this->container['staff_notes'] = $staff_notes;

        return $this;
    }

    /**
     * Gets status_id
     *
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->container['status_id'];
    }

    /**
     * Sets status_id
     *
     * @param int|null $status_id The status ID of the order.
     *
     * @return self
     */
    public function setStatusId($status_id)
    {
        if (is_null($status_id)) {
            throw new \InvalidArgumentException('non-nullable status_id cannot be null');
        }
        $this->container['status_id'] = $status_id;

        return $this;
    }

    /**
     * Gets subtotal_ex_tax
     *
     * @return string|null
     */
    public function getSubtotalExTax()
    {
        return $this->container['subtotal_ex_tax'];
    }

    /**
     * Sets subtotal_ex_tax
     *
     * @param string|null $subtotal_ex_tax Override value for subtotal excluding tax. If specified, the field `subtotal_inc_tax` is also required. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setSubtotalExTax($subtotal_ex_tax)
    {
        if (is_null($subtotal_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable subtotal_ex_tax cannot be null');
        }
        $this->container['subtotal_ex_tax'] = $subtotal_ex_tax;

        return $this;
    }

    /**
     * Gets subtotal_inc_tax
     *
     * @return string|null
     */
    public function getSubtotalIncTax()
    {
        return $this->container['subtotal_inc_tax'];
    }

    /**
     * Sets subtotal_inc_tax
     *
     * @param string|null $subtotal_inc_tax Override value for subtotal including tax. If specified, the field `subtotal_ex_tax` is also required. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setSubtotalIncTax($subtotal_inc_tax)
    {
        if (is_null($subtotal_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable subtotal_inc_tax cannot be null');
        }
        $this->container['subtotal_inc_tax'] = $subtotal_inc_tax;

        return $this;
    }

    /**
     * Gets tax_provider_id
     *
     * @return string|null
     */
    public function getTaxProviderId()
    {
        return $this->container['tax_provider_id'];
    }

    /**
     * Sets tax_provider_id
     *
     * @param string|null $tax_provider_id BasicTaxProvider - Tax is set to manual.  AvaTaxProvider - This is for when the tax provider has been set to automatic and the order was NOT created by the API. Used for Avalara.  \"\" (blank) - When the tax provider is unknown. This includes legacy orders and orders previously created via API. This can be set when creating an order using a POST.
     *
     * @return self
     */
    public function setTaxProviderId($tax_provider_id)
    {
        if (is_null($tax_provider_id)) {
            throw new \InvalidArgumentException('non-nullable tax_provider_id cannot be null');
        }
        $allowedValues = $this->getTaxProviderIdAllowableValues();
        if (!in_array($tax_provider_id, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'tax_provider_id', must be one of '%s'",
                    $tax_provider_id,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['tax_provider_id'] = $tax_provider_id;

        return $this;
    }

    /**
     * Gets customer_locale
     *
     * @return string|null
     */
    public function getCustomerLocale()
    {
        return $this->container['customer_locale'];
    }

    /**
     * Sets customer_locale
     *
     * @param string|null $customer_locale The customer's locale
     *
     * @return self
     */
    public function setCustomerLocale($customer_locale)
    {
        if (is_null($customer_locale)) {
            throw new \InvalidArgumentException('non-nullable customer_locale cannot be null');
        }
        $this->container['customer_locale'] = $customer_locale;

        return $this;
    }

    /**
     * Gets total_ex_tax
     *
     * @return string|null
     */
    public function getTotalExTax()
    {
        return $this->container['total_ex_tax'];
    }

    /**
     * Sets total_ex_tax
     *
     * @param string|null $total_ex_tax Override value for the total, excluding tax. If specified, the field `total_inc_tax` is also required. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setTotalExTax($total_ex_tax)
    {
        if (is_null($total_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable total_ex_tax cannot be null');
        }
        $this->container['total_ex_tax'] = $total_ex_tax;

        return $this;
    }

    /**
     * Gets total_inc_tax
     *
     * @return string|null
     */
    public function getTotalIncTax()
    {
        return $this->container['total_inc_tax'];
    }

    /**
     * Sets total_inc_tax
     *
     * @param string|null $total_inc_tax Override value for the total, including tax. If specified, the field `total_ex_tax` is also required. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setTotalIncTax($total_inc_tax)
    {
        if (is_null($total_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable total_inc_tax cannot be null');
        }
        $this->container['total_inc_tax'] = $total_inc_tax;

        return $this;
    }

    /**
     * Gets wrapping_cost_ex_tax
     *
     * @return string|null
     */
    public function getWrappingCostExTax()
    {
        return $this->container['wrapping_cost_ex_tax'];
    }

    /**
     * Sets wrapping_cost_ex_tax
     *
     * @param string|null $wrapping_cost_ex_tax The value of the wrapping cost, excluding tax. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setWrappingCostExTax($wrapping_cost_ex_tax)
    {
        if (is_null($wrapping_cost_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable wrapping_cost_ex_tax cannot be null');
        }
        $this->container['wrapping_cost_ex_tax'] = $wrapping_cost_ex_tax;

        return $this;
    }

    /**
     * Gets wrapping_cost_inc_tax
     *
     * @return string|null
     */
    public function getWrappingCostIncTax()
    {
        return $this->container['wrapping_cost_inc_tax'];
    }

    /**
     * Sets wrapping_cost_inc_tax
     *
     * @param string|null $wrapping_cost_inc_tax The value of the wrapping cost, including tax. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setWrappingCostIncTax($wrapping_cost_inc_tax)
    {
        if (is_null($wrapping_cost_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable wrapping_cost_inc_tax cannot be null');
        }
        $this->container['wrapping_cost_inc_tax'] = $wrapping_cost_inc_tax;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


