<?php
/**
 * OrderProducts
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V2
 *
 * Manage order coupons, messages, products, shipping addresses, statuses, taxes, shipments, and shipping address quotes.  - [Authentication](#authentication) - [Order](#order)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  |  **UI Name** | **Permission** | **Parameter** | | --- | --- | --- | |  Orders | modify | `store_v2_orders` | |  Orders | read-only | `store_v2_orders_read_only` |   ## Order  The Order object contains a record of the purchase agreement between a shopper and a merchant. To learn more about creating orders, see [Orders API Guide](/api-docs/orders/orders-api-overview).  ### Currency Fields  The **default** currency refers to the transactional currency which is the currency the shopper pays in.  The **display** currency refers to the presentational currency used to present prices to the shopper on the storefront.  * `currency_id` - the display currency ID. Depending on the currency selected, the value may be different from the transactional currency. * `currency_code` - the currency code of the display currency used to present prices to the shopper on the storefront. Depending on the currency selected, the value may be different from the transactional currency. * `currency_exchange_rate` - the exchange rate between the store's default currency and the display currency. For orders created using the V2 endpoints, this value is always 1 (only in the storefront this value can be different to 1). * `default_currency_id` - the transactional currency ID. * `default_currency_code` - the currency code of the transactional currency the shopper pays in.  The following additional fields are returned on orders when Multi-Currency is enabled on the store:  * `store_default_currency_code` - the currency code of the store's default currency. * `store_default_to_transactional_exchange_rate` - the exchange rate between the store's default currency and the transactional currency used in the order.  **Example:**  ```json {   ...   \"currency_id\": 4,   \"currency_code\": \"EUR\",   \"currency_exchange_rate\": 1,   \"default_currency_id\": 4,   \"default_currency_code\": \"EUR\",   \"store_default_currency_code\": \"USD\",   \"store_default_to_transactional_exchange_rate\": \"100.0000000000\"   ... } ```
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV2\Model;

use \ArrayAccess;
use \Bigcommerce\OrdersV2\ObjectSerializer;

/**
 * OrderProducts Class Doc Comment
 *
 * @category Class
 * @description 
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderProducts implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'orderProducts';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'order_id' => 'int',
        'product_id' => 'int',
        'order_address_id' => 'int',
        'name' => 'string',
        'sku' => 'string',
        'type' => 'string',
        'base_price' => 'string',
        'price_ex_tax' => 'string',
        'price_inc_tax' => 'string',
        'price_tax' => 'string',
        'base_total' => 'string',
        'total_ex_tax' => 'string',
        'total_inc_tax' => 'string',
        'total_tax' => 'string',
        'quantity' => 'float',
        'base_cost_price' => 'string',
        'cost_price_inc_tax' => 'string',
        'cost_price_ex_tax' => 'string',
        'weight' => 'string',
        'cost_price_tax' => 'string',
        'is_refunded' => 'bool',
        'refunded_amount' => 'string',
        'return_id' => 'float',
        'wrapping_name' => 'string',
        'base_wrapping_cost' => 'string',
        'wrapping_cost_ex_tax' => 'string',
        'wrapping_cost_inc_tax' => 'string',
        'wrapping_cost_tax' => 'string',
        'wrapping_message' => 'string',
        'quantity_shipped' => 'float',
        'event_name' => 'string',
        'event_date' => '\DateTime',
        'fixed_shipping_cost' => 'string',
        'ebay_item_id' => 'string',
        'ebay_transaction_id' => 'string',
        'option_set_id' => 'int',
        'parent_order_product_id' => 'int',
        'is_bundled_product' => 'bool',
        'bin_picking_number' => 'string',
        'applied_discounts' => '\Bigcommerce\OrdersV2\Model\OrderProductAppliedDiscounts[]',
        'product_options' => '\Bigcommerce\OrdersV2\Model\OrderProductOptions[]',
        'external_id' => 'string',
        'upc' => 'string',
        'variant_id' => 'int',
        'name_customer' => 'string',
        'name_merchant' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'order_id' => null,
        'product_id' => null,
        'order_address_id' => null,
        'name' => null,
        'sku' => null,
        'type' => null,
        'base_price' => null,
        'price_ex_tax' => null,
        'price_inc_tax' => null,
        'price_tax' => null,
        'base_total' => null,
        'total_ex_tax' => null,
        'total_inc_tax' => null,
        'total_tax' => null,
        'quantity' => null,
        'base_cost_price' => null,
        'cost_price_inc_tax' => null,
        'cost_price_ex_tax' => null,
        'weight' => null,
        'cost_price_tax' => null,
        'is_refunded' => null,
        'refunded_amount' => null,
        'return_id' => null,
        'wrapping_name' => null,
        'base_wrapping_cost' => null,
        'wrapping_cost_ex_tax' => null,
        'wrapping_cost_inc_tax' => null,
        'wrapping_cost_tax' => null,
        'wrapping_message' => null,
        'quantity_shipped' => null,
        'event_name' => null,
        'event_date' => 'date',
        'fixed_shipping_cost' => null,
        'ebay_item_id' => null,
        'ebay_transaction_id' => null,
        'option_set_id' => null,
        'parent_order_product_id' => null,
        'is_bundled_product' => null,
        'bin_picking_number' => null,
        'applied_discounts' => null,
        'product_options' => null,
        'external_id' => null,
        'upc' => null,
        'variant_id' => null,
        'name_customer' => null,
        'name_merchant' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'order_id' => false,
        'product_id' => false,
        'order_address_id' => false,
        'name' => false,
        'sku' => false,
        'type' => false,
        'base_price' => false,
        'price_ex_tax' => false,
        'price_inc_tax' => false,
        'price_tax' => false,
        'base_total' => false,
        'total_ex_tax' => false,
        'total_inc_tax' => false,
        'total_tax' => false,
        'quantity' => false,
        'base_cost_price' => false,
        'cost_price_inc_tax' => false,
        'cost_price_ex_tax' => false,
        'weight' => false,
        'cost_price_tax' => false,
        'is_refunded' => false,
        'refunded_amount' => false,
        'return_id' => false,
        'wrapping_name' => false,
        'base_wrapping_cost' => false,
        'wrapping_cost_ex_tax' => false,
        'wrapping_cost_inc_tax' => false,
        'wrapping_cost_tax' => false,
        'wrapping_message' => false,
        'quantity_shipped' => false,
        'event_name' => false,
        'event_date' => true,
        'fixed_shipping_cost' => false,
        'ebay_item_id' => false,
        'ebay_transaction_id' => false,
        'option_set_id' => false,
        'parent_order_product_id' => false,
        'is_bundled_product' => false,
        'bin_picking_number' => false,
        'applied_discounts' => false,
        'product_options' => false,
        'external_id' => false,
        'upc' => false,
        'variant_id' => false,
        'name_customer' => false,
        'name_merchant' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'order_id' => 'order_id',
        'product_id' => 'product_id',
        'order_address_id' => 'order_address_id',
        'name' => 'name',
        'sku' => 'sku',
        'type' => 'type',
        'base_price' => 'base_price',
        'price_ex_tax' => 'price_ex_tax',
        'price_inc_tax' => 'price_inc_tax',
        'price_tax' => 'price_tax',
        'base_total' => 'base_total',
        'total_ex_tax' => 'total_ex_tax',
        'total_inc_tax' => 'total_inc_tax',
        'total_tax' => 'total_tax',
        'quantity' => 'quantity',
        'base_cost_price' => 'base_cost_price',
        'cost_price_inc_tax' => 'cost_price_inc_tax',
        'cost_price_ex_tax' => 'cost_price_ex_tax',
        'weight' => 'weight',
        'cost_price_tax' => 'cost_price_tax',
        'is_refunded' => 'is_refunded',
        'refunded_amount' => 'refunded_amount',
        'return_id' => 'return_id',
        'wrapping_name' => 'wrapping_name',
        'base_wrapping_cost' => 'base_wrapping_cost',
        'wrapping_cost_ex_tax' => 'wrapping_cost_ex_tax',
        'wrapping_cost_inc_tax' => 'wrapping_cost_inc_tax',
        'wrapping_cost_tax' => 'wrapping_cost_tax',
        'wrapping_message' => 'wrapping_message',
        'quantity_shipped' => 'quantity_shipped',
        'event_name' => 'event_name',
        'event_date' => 'event_date',
        'fixed_shipping_cost' => 'fixed_shipping_cost',
        'ebay_item_id' => 'ebay_item_id',
        'ebay_transaction_id' => 'ebay_transaction_id',
        'option_set_id' => 'option_set_id',
        'parent_order_product_id' => 'parent_order_product_id',
        'is_bundled_product' => 'is_bundled_product',
        'bin_picking_number' => 'bin_picking_number',
        'applied_discounts' => 'applied_discounts',
        'product_options' => 'product_options',
        'external_id' => 'external_id',
        'upc' => 'upc',
        'variant_id' => 'variant_id',
        'name_customer' => 'name_customer',
        'name_merchant' => 'name_merchant'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'order_id' => 'setOrderId',
        'product_id' => 'setProductId',
        'order_address_id' => 'setOrderAddressId',
        'name' => 'setName',
        'sku' => 'setSku',
        'type' => 'setType',
        'base_price' => 'setBasePrice',
        'price_ex_tax' => 'setPriceExTax',
        'price_inc_tax' => 'setPriceIncTax',
        'price_tax' => 'setPriceTax',
        'base_total' => 'setBaseTotal',
        'total_ex_tax' => 'setTotalExTax',
        'total_inc_tax' => 'setTotalIncTax',
        'total_tax' => 'setTotalTax',
        'quantity' => 'setQuantity',
        'base_cost_price' => 'setBaseCostPrice',
        'cost_price_inc_tax' => 'setCostPriceIncTax',
        'cost_price_ex_tax' => 'setCostPriceExTax',
        'weight' => 'setWeight',
        'cost_price_tax' => 'setCostPriceTax',
        'is_refunded' => 'setIsRefunded',
        'refunded_amount' => 'setRefundedAmount',
        'return_id' => 'setReturnId',
        'wrapping_name' => 'setWrappingName',
        'base_wrapping_cost' => 'setBaseWrappingCost',
        'wrapping_cost_ex_tax' => 'setWrappingCostExTax',
        'wrapping_cost_inc_tax' => 'setWrappingCostIncTax',
        'wrapping_cost_tax' => 'setWrappingCostTax',
        'wrapping_message' => 'setWrappingMessage',
        'quantity_shipped' => 'setQuantityShipped',
        'event_name' => 'setEventName',
        'event_date' => 'setEventDate',
        'fixed_shipping_cost' => 'setFixedShippingCost',
        'ebay_item_id' => 'setEbayItemId',
        'ebay_transaction_id' => 'setEbayTransactionId',
        'option_set_id' => 'setOptionSetId',
        'parent_order_product_id' => 'setParentOrderProductId',
        'is_bundled_product' => 'setIsBundledProduct',
        'bin_picking_number' => 'setBinPickingNumber',
        'applied_discounts' => 'setAppliedDiscounts',
        'product_options' => 'setProductOptions',
        'external_id' => 'setExternalId',
        'upc' => 'setUpc',
        'variant_id' => 'setVariantId',
        'name_customer' => 'setNameCustomer',
        'name_merchant' => 'setNameMerchant'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'order_id' => 'getOrderId',
        'product_id' => 'getProductId',
        'order_address_id' => 'getOrderAddressId',
        'name' => 'getName',
        'sku' => 'getSku',
        'type' => 'getType',
        'base_price' => 'getBasePrice',
        'price_ex_tax' => 'getPriceExTax',
        'price_inc_tax' => 'getPriceIncTax',
        'price_tax' => 'getPriceTax',
        'base_total' => 'getBaseTotal',
        'total_ex_tax' => 'getTotalExTax',
        'total_inc_tax' => 'getTotalIncTax',
        'total_tax' => 'getTotalTax',
        'quantity' => 'getQuantity',
        'base_cost_price' => 'getBaseCostPrice',
        'cost_price_inc_tax' => 'getCostPriceIncTax',
        'cost_price_ex_tax' => 'getCostPriceExTax',
        'weight' => 'getWeight',
        'cost_price_tax' => 'getCostPriceTax',
        'is_refunded' => 'getIsRefunded',
        'refunded_amount' => 'getRefundedAmount',
        'return_id' => 'getReturnId',
        'wrapping_name' => 'getWrappingName',
        'base_wrapping_cost' => 'getBaseWrappingCost',
        'wrapping_cost_ex_tax' => 'getWrappingCostExTax',
        'wrapping_cost_inc_tax' => 'getWrappingCostIncTax',
        'wrapping_cost_tax' => 'getWrappingCostTax',
        'wrapping_message' => 'getWrappingMessage',
        'quantity_shipped' => 'getQuantityShipped',
        'event_name' => 'getEventName',
        'event_date' => 'getEventDate',
        'fixed_shipping_cost' => 'getFixedShippingCost',
        'ebay_item_id' => 'getEbayItemId',
        'ebay_transaction_id' => 'getEbayTransactionId',
        'option_set_id' => 'getOptionSetId',
        'parent_order_product_id' => 'getParentOrderProductId',
        'is_bundled_product' => 'getIsBundledProduct',
        'bin_picking_number' => 'getBinPickingNumber',
        'applied_discounts' => 'getAppliedDiscounts',
        'product_options' => 'getProductOptions',
        'external_id' => 'getExternalId',
        'upc' => 'getUpc',
        'variant_id' => 'getVariantId',
        'name_customer' => 'getNameCustomer',
        'name_merchant' => 'getNameMerchant'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TYPE_PHYSICAL = 'physical';
    public const TYPE_DIGITAL = 'digital';
    public const TYPE_GIFTCERTIFICATE = 'giftcertificate';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_PHYSICAL,
            self::TYPE_DIGITAL,
            self::TYPE_GIFTCERTIFICATE,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('product_id', $data ?? [], null);
        $this->setIfExists('order_address_id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('base_price', $data ?? [], null);
        $this->setIfExists('price_ex_tax', $data ?? [], null);
        $this->setIfExists('price_inc_tax', $data ?? [], null);
        $this->setIfExists('price_tax', $data ?? [], null);
        $this->setIfExists('base_total', $data ?? [], null);
        $this->setIfExists('total_ex_tax', $data ?? [], null);
        $this->setIfExists('total_inc_tax', $data ?? [], null);
        $this->setIfExists('total_tax', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('base_cost_price', $data ?? [], null);
        $this->setIfExists('cost_price_inc_tax', $data ?? [], null);
        $this->setIfExists('cost_price_ex_tax', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('cost_price_tax', $data ?? [], null);
        $this->setIfExists('is_refunded', $data ?? [], null);
        $this->setIfExists('refunded_amount', $data ?? [], null);
        $this->setIfExists('return_id', $data ?? [], null);
        $this->setIfExists('wrapping_name', $data ?? [], null);
        $this->setIfExists('base_wrapping_cost', $data ?? [], null);
        $this->setIfExists('wrapping_cost_ex_tax', $data ?? [], null);
        $this->setIfExists('wrapping_cost_inc_tax', $data ?? [], null);
        $this->setIfExists('wrapping_cost_tax', $data ?? [], null);
        $this->setIfExists('wrapping_message', $data ?? [], null);
        $this->setIfExists('quantity_shipped', $data ?? [], null);
        $this->setIfExists('event_name', $data ?? [], null);
        $this->setIfExists('event_date', $data ?? [], null);
        $this->setIfExists('fixed_shipping_cost', $data ?? [], null);
        $this->setIfExists('ebay_item_id', $data ?? [], null);
        $this->setIfExists('ebay_transaction_id', $data ?? [], null);
        $this->setIfExists('option_set_id', $data ?? [], null);
        $this->setIfExists('parent_order_product_id', $data ?? [], null);
        $this->setIfExists('is_bundled_product', $data ?? [], null);
        $this->setIfExists('bin_picking_number', $data ?? [], null);
        $this->setIfExists('applied_discounts', $data ?? [], null);
        $this->setIfExists('product_options', $data ?? [], null);
        $this->setIfExists('external_id', $data ?? [], null);
        $this->setIfExists('upc', $data ?? [], null);
        $this->setIfExists('variant_id', $data ?? [], null);
        $this->setIfExists('name_customer', $data ?? [], null);
        $this->setIfExists('name_merchant', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['name']) && (mb_strlen($this->container['name']) < 1)) {
            $invalidProperties[] = "invalid value for 'name', the character length must be bigger than or equal to 1.";
        }

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['upc']) && (mb_strlen($this->container['upc']) > 255)) {
            $invalidProperties[] = "invalid value for 'upc', the character length must be smaller than or equal to 255.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id Numeric ID of this product within this order.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param int|null $order_id Numeric ID of the associated order.
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return int|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param int|null $product_id Numeric ID of the product.
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        if (is_null($product_id)) {
            throw new \InvalidArgumentException('non-nullable product_id cannot be null');
        }
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets order_address_id
     *
     * @return int|null
     */
    public function getOrderAddressId()
    {
        return $this->container['order_address_id'];
    }

    /**
     * Sets order_address_id
     *
     * @param int|null $order_address_id Numeric ID of the associated order address.
     *
     * @return self
     */
    public function setOrderAddressId($order_address_id)
    {
        if (is_null($order_address_id)) {
            throw new \InvalidArgumentException('non-nullable order_address_id cannot be null');
        }
        $this->container['order_address_id'] = $order_address_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Alias for name_customer - The product name that is shown to customer in storefront.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }

        if ((mb_strlen($name) < 1)) {
            throw new \InvalidArgumentException('invalid length for $name when calling OrderProducts., must be bigger than or equal to 1.');
        }

        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku User-defined product code/stock keeping unit (SKU).
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type Type of product
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets base_price
     *
     * @return string|null
     */
    public function getBasePrice()
    {
        return $this->container['base_price'];
    }

    /**
     * Sets base_price
     *
     * @param string|null $base_price The product's base price. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setBasePrice($base_price)
    {
        if (is_null($base_price)) {
            throw new \InvalidArgumentException('non-nullable base_price cannot be null');
        }
        $this->container['base_price'] = $base_price;

        return $this;
    }

    /**
     * Gets price_ex_tax
     *
     * @return string|null
     */
    public function getPriceExTax()
    {
        return $this->container['price_ex_tax'];
    }

    /**
     * Sets price_ex_tax
     *
     * @param string|null $price_ex_tax The product’s price excluding tax. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setPriceExTax($price_ex_tax)
    {
        if (is_null($price_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable price_ex_tax cannot be null');
        }
        $this->container['price_ex_tax'] = $price_ex_tax;

        return $this;
    }

    /**
     * Gets price_inc_tax
     *
     * @return string|null
     */
    public function getPriceIncTax()
    {
        return $this->container['price_inc_tax'];
    }

    /**
     * Sets price_inc_tax
     *
     * @param string|null $price_inc_tax The product’s price including tax. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setPriceIncTax($price_inc_tax)
    {
        if (is_null($price_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_inc_tax cannot be null');
        }
        $this->container['price_inc_tax'] = $price_inc_tax;

        return $this;
    }

    /**
     * Gets price_tax
     *
     * @return string|null
     */
    public function getPriceTax()
    {
        return $this->container['price_tax'];
    }

    /**
     * Sets price_tax
     *
     * @param string|null $price_tax Amount of tax applied to a single product.  Price tax is calculated as: `price_tax = price_inc_tax - price_ex_tax`  (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setPriceTax($price_tax)
    {
        if (is_null($price_tax)) {
            throw new \InvalidArgumentException('non-nullable price_tax cannot be null');
        }
        $this->container['price_tax'] = $price_tax;

        return $this;
    }

    /**
     * Gets base_total
     *
     * @return string|null
     */
    public function getBaseTotal()
    {
        return $this->container['base_total'];
    }

    /**
     * Sets base_total
     *
     * @param string|null $base_total Total base price. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setBaseTotal($base_total)
    {
        if (is_null($base_total)) {
            throw new \InvalidArgumentException('non-nullable base_total cannot be null');
        }
        $this->container['base_total'] = $base_total;

        return $this;
    }

    /**
     * Gets total_ex_tax
     *
     * @return string|null
     */
    public function getTotalExTax()
    {
        return $this->container['total_ex_tax'];
    }

    /**
     * Sets total_ex_tax
     *
     * @param string|null $total_ex_tax Total base price excluding tax. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setTotalExTax($total_ex_tax)
    {
        if (is_null($total_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable total_ex_tax cannot be null');
        }
        $this->container['total_ex_tax'] = $total_ex_tax;

        return $this;
    }

    /**
     * Gets total_inc_tax
     *
     * @return string|null
     */
    public function getTotalIncTax()
    {
        return $this->container['total_inc_tax'];
    }

    /**
     * Sets total_inc_tax
     *
     * @param string|null $total_inc_tax Total base price including tax. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setTotalIncTax($total_inc_tax)
    {
        if (is_null($total_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable total_inc_tax cannot be null');
        }
        $this->container['total_inc_tax'] = $total_inc_tax;

        return $this;
    }

    /**
     * Gets total_tax
     *
     * @return string|null
     */
    public function getTotalTax()
    {
        return $this->container['total_tax'];
    }

    /**
     * Sets total_tax
     *
     * @param string|null $total_tax Total tax applied to products. For example, if quantity if 2, base price is 5 and tax rate is 10%. price_tax will be $.50 and total_tax will be $1.00.  If there is a manual discount applied total_tax is calcuted as the following: `(price_ex_tax - discount)*tax_rate=total_tax`. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setTotalTax($total_tax)
    {
        if (is_null($total_tax)) {
            throw new \InvalidArgumentException('non-nullable total_tax cannot be null');
        }
        $this->container['total_tax'] = $total_tax;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param float|null $quantity Quantity of the product ordered.
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets base_cost_price
     *
     * @return string|null
     */
    public function getBaseCostPrice()
    {
        return $this->container['base_cost_price'];
    }

    /**
     * Sets base_cost_price
     *
     * @param string|null $base_cost_price The product's cost price.  This can be set using the Catalog API. (Float, Float-As-String, Integer) Read Only
     *
     * @return self
     */
    public function setBaseCostPrice($base_cost_price)
    {
        if (is_null($base_cost_price)) {
            throw new \InvalidArgumentException('non-nullable base_cost_price cannot be null');
        }
        $this->container['base_cost_price'] = $base_cost_price;

        return $this;
    }

    /**
     * Gets cost_price_inc_tax
     *
     * @return string|null
     */
    public function getCostPriceIncTax()
    {
        return $this->container['cost_price_inc_tax'];
    }

    /**
     * Sets cost_price_inc_tax
     *
     * @param string|null $cost_price_inc_tax The product's cost price including tax. (Float, Float-As-String, Integer) The cost of your products to you; this is never shown to customers, but can be used for accounting purposes. Read Only
     *
     * @return self
     */
    public function setCostPriceIncTax($cost_price_inc_tax)
    {
        if (is_null($cost_price_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable cost_price_inc_tax cannot be null');
        }
        $this->container['cost_price_inc_tax'] = $cost_price_inc_tax;

        return $this;
    }

    /**
     * Gets cost_price_ex_tax
     *
     * @return string|null
     */
    public function getCostPriceExTax()
    {
        return $this->container['cost_price_ex_tax'];
    }

    /**
     * Sets cost_price_ex_tax
     *
     * @param string|null $cost_price_ex_tax The products cost price excluding tax. (Float, Float-As-String, Integer) The cost of your products to you; this is never shown to customers, but can be used for accounting purposes. Read Only
     *
     * @return self
     */
    public function setCostPriceExTax($cost_price_ex_tax)
    {
        if (is_null($cost_price_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable cost_price_ex_tax cannot be null');
        }
        $this->container['cost_price_ex_tax'] = $cost_price_ex_tax;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return string|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param string|null $weight Weight of the product. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets cost_price_tax
     *
     * @return string|null
     */
    public function getCostPriceTax()
    {
        return $this->container['cost_price_tax'];
    }

    /**
     * Sets cost_price_tax
     *
     * @param string|null $cost_price_tax Tax applied to the product’s cost price. (Float, Float-As-String, Integer) The cost of your products to you; this is never shown to customers, but can be used for accounting purposes. Read Only
     *
     * @return self
     */
    public function setCostPriceTax($cost_price_tax)
    {
        if (is_null($cost_price_tax)) {
            throw new \InvalidArgumentException('non-nullable cost_price_tax cannot be null');
        }
        $this->container['cost_price_tax'] = $cost_price_tax;

        return $this;
    }

    /**
     * Gets is_refunded
     *
     * @return bool|null
     */
    public function getIsRefunded()
    {
        return $this->container['is_refunded'];
    }

    /**
     * Sets is_refunded
     *
     * @param bool|null $is_refunded Whether the product has been refunded.
     *
     * @return self
     */
    public function setIsRefunded($is_refunded)
    {
        if (is_null($is_refunded)) {
            throw new \InvalidArgumentException('non-nullable is_refunded cannot be null');
        }
        $this->container['is_refunded'] = $is_refunded;

        return $this;
    }

    /**
     * Gets refunded_amount
     *
     * @return string|null
     */
    public function getRefundedAmount()
    {
        return $this->container['refunded_amount'];
    }

    /**
     * Sets refunded_amount
     *
     * @param string|null $refunded_amount The amount refunded from this transaction. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setRefundedAmount($refunded_amount)
    {
        if (is_null($refunded_amount)) {
            throw new \InvalidArgumentException('non-nullable refunded_amount cannot be null');
        }
        $this->container['refunded_amount'] = $refunded_amount;

        return $this;
    }

    /**
     * Gets return_id
     *
     * @return float|null
     */
    public function getReturnId()
    {
        return $this->container['return_id'];
    }

    /**
     * Sets return_id
     *
     * @param float|null $return_id Numeric ID for the refund.
     *
     * @return self
     */
    public function setReturnId($return_id)
    {
        if (is_null($return_id)) {
            throw new \InvalidArgumentException('non-nullable return_id cannot be null');
        }
        $this->container['return_id'] = $return_id;

        return $this;
    }

    /**
     * Gets wrapping_name
     *
     * @return string|null
     */
    public function getWrappingName()
    {
        return $this->container['wrapping_name'];
    }

    /**
     * Sets wrapping_name
     *
     * @param string|null $wrapping_name Name of gift-wrapping option
     *
     * @return self
     */
    public function setWrappingName($wrapping_name)
    {
        if (is_null($wrapping_name)) {
            throw new \InvalidArgumentException('non-nullable wrapping_name cannot be null');
        }
        $this->container['wrapping_name'] = $wrapping_name;

        return $this;
    }

    /**
     * Gets base_wrapping_cost
     *
     * @return string|null
     */
    public function getBaseWrappingCost()
    {
        return $this->container['base_wrapping_cost'];
    }

    /**
     * Sets base_wrapping_cost
     *
     * @param string|null $base_wrapping_cost The value of the base wrapping cost. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setBaseWrappingCost($base_wrapping_cost)
    {
        if (is_null($base_wrapping_cost)) {
            throw new \InvalidArgumentException('non-nullable base_wrapping_cost cannot be null');
        }
        $this->container['base_wrapping_cost'] = $base_wrapping_cost;

        return $this;
    }

    /**
     * Gets wrapping_cost_ex_tax
     *
     * @return string|null
     */
    public function getWrappingCostExTax()
    {
        return $this->container['wrapping_cost_ex_tax'];
    }

    /**
     * Sets wrapping_cost_ex_tax
     *
     * @param string|null $wrapping_cost_ex_tax The value of the wrapping cost, excluding tax. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setWrappingCostExTax($wrapping_cost_ex_tax)
    {
        if (is_null($wrapping_cost_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable wrapping_cost_ex_tax cannot be null');
        }
        $this->container['wrapping_cost_ex_tax'] = $wrapping_cost_ex_tax;

        return $this;
    }

    /**
     * Gets wrapping_cost_inc_tax
     *
     * @return string|null
     */
    public function getWrappingCostIncTax()
    {
        return $this->container['wrapping_cost_inc_tax'];
    }

    /**
     * Sets wrapping_cost_inc_tax
     *
     * @param string|null $wrapping_cost_inc_tax The value of the wrapping cost, including tax. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setWrappingCostIncTax($wrapping_cost_inc_tax)
    {
        if (is_null($wrapping_cost_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable wrapping_cost_inc_tax cannot be null');
        }
        $this->container['wrapping_cost_inc_tax'] = $wrapping_cost_inc_tax;

        return $this;
    }

    /**
     * Gets wrapping_cost_tax
     *
     * @return string|null
     */
    public function getWrappingCostTax()
    {
        return $this->container['wrapping_cost_tax'];
    }

    /**
     * Sets wrapping_cost_tax
     *
     * @param string|null $wrapping_cost_tax Tax applied to gift-wrapping option. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setWrappingCostTax($wrapping_cost_tax)
    {
        if (is_null($wrapping_cost_tax)) {
            throw new \InvalidArgumentException('non-nullable wrapping_cost_tax cannot be null');
        }
        $this->container['wrapping_cost_tax'] = $wrapping_cost_tax;

        return $this;
    }

    /**
     * Gets wrapping_message
     *
     * @return string|null
     */
    public function getWrappingMessage()
    {
        return $this->container['wrapping_message'];
    }

    /**
     * Sets wrapping_message
     *
     * @param string|null $wrapping_message Message to accompany gift-wrapping option.
     *
     * @return self
     */
    public function setWrappingMessage($wrapping_message)
    {
        if (is_null($wrapping_message)) {
            throw new \InvalidArgumentException('non-nullable wrapping_message cannot be null');
        }
        $this->container['wrapping_message'] = $wrapping_message;

        return $this;
    }

    /**
     * Gets quantity_shipped
     *
     * @return float|null
     */
    public function getQuantityShipped()
    {
        return $this->container['quantity_shipped'];
    }

    /**
     * Sets quantity_shipped
     *
     * @param float|null $quantity_shipped Quantity of this item shipped.
     *
     * @return self
     */
    public function setQuantityShipped($quantity_shipped)
    {
        if (is_null($quantity_shipped)) {
            throw new \InvalidArgumentException('non-nullable quantity_shipped cannot be null');
        }
        $this->container['quantity_shipped'] = $quantity_shipped;

        return $this;
    }

    /**
     * Gets event_name
     *
     * @return string|null
     */
    public function getEventName()
    {
        return $this->container['event_name'];
    }

    /**
     * Sets event_name
     *
     * @param string|null $event_name Name of promotional event/delivery date.
     *
     * @return self
     */
    public function setEventName($event_name)
    {
        if (is_null($event_name)) {
            throw new \InvalidArgumentException('non-nullable event_name cannot be null');
        }
        $this->container['event_name'] = $event_name;

        return $this;
    }

    /**
     * Gets event_date
     *
     * @return \DateTime|null
     */
    public function getEventDate()
    {
        return $this->container['event_date'];
    }

    /**
     * Sets event_date
     *
     * @param \DateTime|null $event_date Date of the promotional event/scheduled delivery.
     *
     * @return self
     */
    public function setEventDate($event_date)
    {
        if (is_null($event_date)) {
            array_push($this->openAPINullablesSetToNull, 'event_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('event_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['event_date'] = $event_date;

        return $this;
    }

    /**
     * Gets fixed_shipping_cost
     *
     * @return string|null
     */
    public function getFixedShippingCost()
    {
        return $this->container['fixed_shipping_cost'];
    }

    /**
     * Sets fixed_shipping_cost
     *
     * @param string|null $fixed_shipping_cost Fixed shipping cost for this product. (Float, Float-As-String, Integer)
     *
     * @return self
     */
    public function setFixedShippingCost($fixed_shipping_cost)
    {
        if (is_null($fixed_shipping_cost)) {
            throw new \InvalidArgumentException('non-nullable fixed_shipping_cost cannot be null');
        }
        $this->container['fixed_shipping_cost'] = $fixed_shipping_cost;

        return $this;
    }

    /**
     * Gets ebay_item_id
     *
     * @return string|null
     */
    public function getEbayItemId()
    {
        return $this->container['ebay_item_id'];
    }

    /**
     * Sets ebay_item_id
     *
     * @param string|null $ebay_item_id Item ID for this product on eBay.
     *
     * @return self
     */
    public function setEbayItemId($ebay_item_id)
    {
        if (is_null($ebay_item_id)) {
            throw new \InvalidArgumentException('non-nullable ebay_item_id cannot be null');
        }
        $this->container['ebay_item_id'] = $ebay_item_id;

        return $this;
    }

    /**
     * Gets ebay_transaction_id
     *
     * @return string|null
     */
    public function getEbayTransactionId()
    {
        return $this->container['ebay_transaction_id'];
    }

    /**
     * Sets ebay_transaction_id
     *
     * @param string|null $ebay_transaction_id Transaction ID for this product on eBay.
     *
     * @return self
     */
    public function setEbayTransactionId($ebay_transaction_id)
    {
        if (is_null($ebay_transaction_id)) {
            throw new \InvalidArgumentException('non-nullable ebay_transaction_id cannot be null');
        }
        $this->container['ebay_transaction_id'] = $ebay_transaction_id;

        return $this;
    }

    /**
     * Gets option_set_id
     *
     * @return int|null
     */
    public function getOptionSetId()
    {
        return $this->container['option_set_id'];
    }

    /**
     * Sets option_set_id
     *
     * @param int|null $option_set_id Numeric ID of the option set applied to the product.
     *
     * @return self
     */
    public function setOptionSetId($option_set_id)
    {
        if (is_null($option_set_id)) {
            throw new \InvalidArgumentException('non-nullable option_set_id cannot be null');
        }
        $this->container['option_set_id'] = $option_set_id;

        return $this;
    }

    /**
     * Gets parent_order_product_id
     *
     * @return int|null
     */
    public function getParentOrderProductId()
    {
        return $this->container['parent_order_product_id'];
    }

    /**
     * Sets parent_order_product_id
     *
     * @param int|null $parent_order_product_id ID of a parent product.
     *
     * @return self
     */
    public function setParentOrderProductId($parent_order_product_id)
    {
        if (is_null($parent_order_product_id)) {
            throw new \InvalidArgumentException('non-nullable parent_order_product_id cannot be null');
        }
        $this->container['parent_order_product_id'] = $parent_order_product_id;

        return $this;
    }

    /**
     * Gets is_bundled_product
     *
     * @return bool|null
     */
    public function getIsBundledProduct()
    {
        return $this->container['is_bundled_product'];
    }

    /**
     * Sets is_bundled_product
     *
     * @param bool|null $is_bundled_product Whether this product is bundled with other products.
     *
     * @return self
     */
    public function setIsBundledProduct($is_bundled_product)
    {
        if (is_null($is_bundled_product)) {
            throw new \InvalidArgumentException('non-nullable is_bundled_product cannot be null');
        }
        $this->container['is_bundled_product'] = $is_bundled_product;

        return $this;
    }

    /**
     * Gets bin_picking_number
     *
     * @return string|null
     */
    public function getBinPickingNumber()
    {
        return $this->container['bin_picking_number'];
    }

    /**
     * Sets bin_picking_number
     *
     * @param string|null $bin_picking_number Bin picking number for the physical product.
     *
     * @return self
     */
    public function setBinPickingNumber($bin_picking_number)
    {
        if (is_null($bin_picking_number)) {
            throw new \InvalidArgumentException('non-nullable bin_picking_number cannot be null');
        }
        $this->container['bin_picking_number'] = $bin_picking_number;

        return $this;
    }

    /**
     * Gets applied_discounts
     *
     * @return \Bigcommerce\OrdersV2\Model\OrderProductAppliedDiscounts[]|null
     */
    public function getAppliedDiscounts()
    {
        return $this->container['applied_discounts'];
    }

    /**
     * Sets applied_discounts
     *
     * @param \Bigcommerce\OrdersV2\Model\OrderProductAppliedDiscounts[]|null $applied_discounts Array of objects containing discounts applied to the product.
     *
     * @return self
     */
    public function setAppliedDiscounts($applied_discounts)
    {
        if (is_null($applied_discounts)) {
            throw new \InvalidArgumentException('non-nullable applied_discounts cannot be null');
        }
        $this->container['applied_discounts'] = $applied_discounts;

        return $this;
    }

    /**
     * Gets product_options
     *
     * @return \Bigcommerce\OrdersV2\Model\OrderProductOptions[]|null
     */
    public function getProductOptions()
    {
        return $this->container['product_options'];
    }

    /**
     * Sets product_options
     *
     * @param \Bigcommerce\OrdersV2\Model\OrderProductOptions[]|null $product_options Array of product option objects.
     *
     * @return self
     */
    public function setProductOptions($product_options)
    {
        if (is_null($product_options)) {
            throw new \InvalidArgumentException('non-nullable product_options cannot be null');
        }
        $this->container['product_options'] = $product_options;

        return $this;
    }

    /**
     * Gets external_id
     *
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->container['external_id'];
    }

    /**
     * Sets external_id
     *
     * @param string|null $external_id ID of the order in another system. For example, the Amazon Order ID if this is an Amazon order.This field can be updated in a /POST, but using a /PUT to update the order will return a 400 error. The field 'external_id' cannot be written to. Please remove it from your request before trying again. It can not be overwritten once set.
     *
     * @return self
     */
    public function setExternalId($external_id)
    {
        if (is_null($external_id)) {
            throw new \InvalidArgumentException('non-nullable external_id cannot be null');
        }
        $this->container['external_id'] = $external_id;

        return $this;
    }

    /**
     * Gets upc
     *
     * @return string|null
     */
    public function getUpc()
    {
        return $this->container['upc'];
    }

    /**
     * Sets upc
     *
     * @param string|null $upc Universal Product Code. Can be written to for custom products and catalog products.
     *
     * @return self
     */
    public function setUpc($upc)
    {
        if (is_null($upc)) {
            throw new \InvalidArgumentException('non-nullable upc cannot be null');
        }
        if ((mb_strlen($upc) > 255)) {
            throw new \InvalidArgumentException('invalid length for $upc when calling OrderProducts., must be smaller than or equal to 255.');
        }

        $this->container['upc'] = $upc;

        return $this;
    }

    /**
     * Gets variant_id
     *
     * @return int|null
     */
    public function getVariantId()
    {
        return $this->container['variant_id'];
    }

    /**
     * Sets variant_id
     *
     * @param int|null $variant_id Products `variant_id`. PUT or POST. This field is not available for custom products.
     *
     * @return self
     */
    public function setVariantId($variant_id)
    {
        if (is_null($variant_id)) {
            throw new \InvalidArgumentException('non-nullable variant_id cannot be null');
        }
        $this->container['variant_id'] = $variant_id;

        return $this;
    }

    /**
     * Gets name_customer
     *
     * @return string|null
     */
    public function getNameCustomer()
    {
        return $this->container['name_customer'];
    }

    /**
     * Sets name_customer
     *
     * @param string|null $name_customer The product name that is shown to customer in storefront.
     *
     * @return self
     */
    public function setNameCustomer($name_customer)
    {
        if (is_null($name_customer)) {
            throw new \InvalidArgumentException('non-nullable name_customer cannot be null');
        }
        $this->container['name_customer'] = $name_customer;

        return $this;
    }

    /**
     * Gets name_merchant
     *
     * @return string|null
     */
    public function getNameMerchant()
    {
        return $this->container['name_merchant'];
    }

    /**
     * Sets name_merchant
     *
     * @param string|null $name_merchant The product name that is shown to merchant in Control Panel.
     *
     * @return self
     */
    public function setNameMerchant($name_merchant)
    {
        if (is_null($name_merchant)) {
            throw new \InvalidArgumentException('non-nullable name_merchant cannot be null');
        }
        $this->container['name_merchant'] = $name_merchant;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


