<?php
/**
 * OrderProductOptions
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V2
 *
 * Manage order coupons, messages, products, shipping addresses, statuses, taxes, shipments, and shipping address quotes.  - [Authentication](#authentication) - [Order](#order)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  |  **UI Name** | **Permission** | **Parameter** | | --- | --- | --- | |  Orders | modify | `store_v2_orders` | |  Orders | read-only | `store_v2_orders_read_only` |   ## Order  The Order object contains a record of the purchase agreement between a shopper and a merchant. To learn more about creating orders, see [Orders API Guide](/api-docs/orders/orders-api-overview).  ### Currency Fields  The **default** currency refers to the transactional currency which is the currency the shopper pays in.  The **display** currency refers to the presentational currency used to present prices to the shopper on the storefront.  * `currency_id` - the display currency ID. Depending on the currency selected, the value may be different from the transactional currency. * `currency_code` - the currency code of the display currency used to present prices to the shopper on the storefront. Depending on the currency selected, the value may be different from the transactional currency. * `currency_exchange_rate` - the exchange rate between the store's default currency and the display currency. For orders created using the V2 endpoints, this value is always 1 (only in the storefront this value can be different to 1). * `default_currency_id` - the transactional currency ID. * `default_currency_code` - the currency code of the transactional currency the shopper pays in.  The following additional fields are returned on orders when Multi-Currency is enabled on the store:  * `store_default_currency_code` - the currency code of the store's default currency. * `store_default_to_transactional_exchange_rate` - the exchange rate between the store's default currency and the transactional currency used in the order.  **Example:**  ```json {   ...   \"currency_id\": 4,   \"currency_code\": \"EUR\",   \"currency_exchange_rate\": 1,   \"default_currency_id\": 4,   \"default_currency_code\": \"EUR\",   \"store_default_currency_code\": \"USD\",   \"store_default_to_transactional_exchange_rate\": \"100.0000000000\"   ... } ```
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV2\Model;

use \ArrayAccess;
use \Bigcommerce\OrdersV2\ObjectSerializer;

/**
 * OrderProductOptions Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderProductOptions implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'orderProductOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'option_id' => 'int',
        'order_product_id' => 'int',
        'product_option_id' => 'int',
        'display_name' => 'string',
        'display_value' => 'string',
        'value' => 'string',
        'type' => 'string',
        'name' => 'string',
        'display_style' => 'string',
        'display_name_customer' => 'string',
        'display_name_merchant' => 'string',
        'display_value_customer' => 'string',
        'display_value_merchant' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'option_id' => null,
        'order_product_id' => null,
        'product_option_id' => null,
        'display_name' => null,
        'display_value' => null,
        'value' => null,
        'type' => null,
        'name' => null,
        'display_style' => null,
        'display_name_customer' => null,
        'display_name_merchant' => null,
        'display_value_customer' => null,
        'display_value_merchant' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'option_id' => false,
        'order_product_id' => false,
        'product_option_id' => false,
        'display_name' => false,
        'display_value' => false,
        'value' => false,
        'type' => false,
        'name' => false,
        'display_style' => false,
        'display_name_customer' => false,
        'display_name_merchant' => false,
        'display_value_customer' => false,
        'display_value_merchant' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'option_id' => 'option_id',
        'order_product_id' => 'order_product_id',
        'product_option_id' => 'product_option_id',
        'display_name' => 'display_name',
        'display_value' => 'display_value',
        'value' => 'value',
        'type' => 'type',
        'name' => 'name',
        'display_style' => 'display_style',
        'display_name_customer' => 'display_name_customer',
        'display_name_merchant' => 'display_name_merchant',
        'display_value_customer' => 'display_value_customer',
        'display_value_merchant' => 'display_value_merchant'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'option_id' => 'setOptionId',
        'order_product_id' => 'setOrderProductId',
        'product_option_id' => 'setProductOptionId',
        'display_name' => 'setDisplayName',
        'display_value' => 'setDisplayValue',
        'value' => 'setValue',
        'type' => 'setType',
        'name' => 'setName',
        'display_style' => 'setDisplayStyle',
        'display_name_customer' => 'setDisplayNameCustomer',
        'display_name_merchant' => 'setDisplayNameMerchant',
        'display_value_customer' => 'setDisplayValueCustomer',
        'display_value_merchant' => 'setDisplayValueMerchant'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'option_id' => 'getOptionId',
        'order_product_id' => 'getOrderProductId',
        'product_option_id' => 'getProductOptionId',
        'display_name' => 'getDisplayName',
        'display_value' => 'getDisplayValue',
        'value' => 'getValue',
        'type' => 'getType',
        'name' => 'getName',
        'display_style' => 'getDisplayStyle',
        'display_name_customer' => 'getDisplayNameCustomer',
        'display_name_merchant' => 'getDisplayNameMerchant',
        'display_value_customer' => 'getDisplayValueCustomer',
        'display_value_merchant' => 'getDisplayValueMerchant'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TYPE_CHECKBOX = 'Checkbox';
    public const TYPE_DATE_FIELD = 'Date field';
    public const TYPE_FILE_UPLOAD = 'File Upload';
    public const TYPE_MULTI_LINE_TEXT_FIELD = 'Multi-line text field';
    public const TYPE_MULTIPLE_CHOICE = 'Multiple choice';
    public const TYPE_PRODUCT_PICK_LIST = 'Product Pick List';
    public const TYPE_SWATCH = 'Swatch';
    public const TYPE_TEXT_FIELD = 'Text field';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_CHECKBOX,
            self::TYPE_DATE_FIELD,
            self::TYPE_FILE_UPLOAD,
            self::TYPE_MULTI_LINE_TEXT_FIELD,
            self::TYPE_MULTIPLE_CHOICE,
            self::TYPE_PRODUCT_PICK_LIST,
            self::TYPE_SWATCH,
            self::TYPE_TEXT_FIELD,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('option_id', $data ?? [], null);
        $this->setIfExists('order_product_id', $data ?? [], null);
        $this->setIfExists('product_option_id', $data ?? [], null);
        $this->setIfExists('display_name', $data ?? [], null);
        $this->setIfExists('display_value', $data ?? [], null);
        $this->setIfExists('value', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('display_style', $data ?? [], null);
        $this->setIfExists('display_name_customer', $data ?? [], null);
        $this->setIfExists('display_name_merchant', $data ?? [], null);
        $this->setIfExists('display_value_customer', $data ?? [], null);
        $this->setIfExists('display_value_merchant', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The unique numerical ID of the option; increments sequentially.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets option_id
     *
     * @return int|null
     */
    public function getOptionId()
    {
        return $this->container['option_id'];
    }

    /**
     * Sets option_id
     *
     * @param int|null $option_id Numeric ID of the associated option.
     *
     * @return self
     */
    public function setOptionId($option_id)
    {
        if (is_null($option_id)) {
            throw new \InvalidArgumentException('non-nullable option_id cannot be null');
        }
        $this->container['option_id'] = $option_id;

        return $this;
    }

    /**
     * Gets order_product_id
     *
     * @return int|null
     */
    public function getOrderProductId()
    {
        return $this->container['order_product_id'];
    }

    /**
     * Sets order_product_id
     *
     * @param int|null $order_product_id 
     *
     * @return self
     */
    public function setOrderProductId($order_product_id)
    {
        if (is_null($order_product_id)) {
            throw new \InvalidArgumentException('non-nullable order_product_id cannot be null');
        }
        $this->container['order_product_id'] = $order_product_id;

        return $this;
    }

    /**
     * Gets product_option_id
     *
     * @return int|null
     */
    public function getProductOptionId()
    {
        return $this->container['product_option_id'];
    }

    /**
     * Sets product_option_id
     *
     * @param int|null $product_option_id 
     *
     * @return self
     */
    public function setProductOptionId($product_option_id)
    {
        if (is_null($product_option_id)) {
            throw new \InvalidArgumentException('non-nullable product_option_id cannot be null');
        }
        $this->container['product_option_id'] = $product_option_id;

        return $this;
    }

    /**
     * Gets display_name
     *
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->container['display_name'];
    }

    /**
     * Sets display_name
     *
     * @param string|null $display_name Alias for display_name_customer. The product option name that is shown to customer in the storefront.
     *
     * @return self
     */
    public function setDisplayName($display_name)
    {
        if (is_null($display_name)) {
            throw new \InvalidArgumentException('non-nullable display_name cannot be null');
        }
        $this->container['display_name'] = $display_name;

        return $this;
    }

    /**
     * Gets display_value
     *
     * @return string|null
     */
    public function getDisplayValue()
    {
        return $this->container['display_value'];
    }

    /**
     * Sets display_value
     *
     * @param string|null $display_value Alias for display_value_customer. The product option value that is shown to customer in storefront.
     *
     * @return self
     */
    public function setDisplayValue($display_value)
    {
        if (is_null($display_value)) {
            throw new \InvalidArgumentException('non-nullable display_value cannot be null');
        }
        $this->container['display_value'] = $display_value;

        return $this;
    }

    /**
     * Gets value
     *
     * @return string|null
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param string|null $value This value is used to access the Customer File Upload.
     *
     * @return self
     */
    public function setValue($value)
    {
        if (is_null($value)) {
            throw new \InvalidArgumentException('non-nullable value cannot be null');
        }
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type Option Type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The option’s name, as used internally. Must be unique.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets display_style
     *
     * @return string|null
     */
    public function getDisplayStyle()
    {
        return $this->container['display_style'];
    }

    /**
     * Sets display_style
     *
     * @param string|null $display_style How it is displayed on the storefront. Examples include Drop-down, radio buttons, or rectangles.
     *
     * @return self
     */
    public function setDisplayStyle($display_style)
    {
        if (is_null($display_style)) {
            throw new \InvalidArgumentException('non-nullable display_style cannot be null');
        }
        $this->container['display_style'] = $display_style;

        return $this;
    }

    /**
     * Gets display_name_customer
     *
     * @return string|null
     */
    public function getDisplayNameCustomer()
    {
        return $this->container['display_name_customer'];
    }

    /**
     * Sets display_name_customer
     *
     * @param string|null $display_name_customer The product option name that is shown to customer in storefront.
     *
     * @return self
     */
    public function setDisplayNameCustomer($display_name_customer)
    {
        if (is_null($display_name_customer)) {
            throw new \InvalidArgumentException('non-nullable display_name_customer cannot be null');
        }
        $this->container['display_name_customer'] = $display_name_customer;

        return $this;
    }

    /**
     * Gets display_name_merchant
     *
     * @return string|null
     */
    public function getDisplayNameMerchant()
    {
        return $this->container['display_name_merchant'];
    }

    /**
     * Sets display_name_merchant
     *
     * @param string|null $display_name_merchant The product option name that is shown to merchant in Control Panel.
     *
     * @return self
     */
    public function setDisplayNameMerchant($display_name_merchant)
    {
        if (is_null($display_name_merchant)) {
            throw new \InvalidArgumentException('non-nullable display_name_merchant cannot be null');
        }
        $this->container['display_name_merchant'] = $display_name_merchant;

        return $this;
    }

    /**
     * Gets display_value_customer
     *
     * @return string|null
     */
    public function getDisplayValueCustomer()
    {
        return $this->container['display_value_customer'];
    }

    /**
     * Sets display_value_customer
     *
     * @param string|null $display_value_customer The product option value that is shown to customer in storefront.
     *
     * @return self
     */
    public function setDisplayValueCustomer($display_value_customer)
    {
        if (is_null($display_value_customer)) {
            throw new \InvalidArgumentException('non-nullable display_value_customer cannot be null');
        }
        $this->container['display_value_customer'] = $display_value_customer;

        return $this;
    }

    /**
     * Gets display_value_merchant
     *
     * @return string|null
     */
    public function getDisplayValueMerchant()
    {
        return $this->container['display_value_merchant'];
    }

    /**
     * Sets display_value_merchant
     *
     * @param string|null $display_value_merchant The product option value that is shown to merchant in Control Panel.
     *
     * @return self
     */
    public function setDisplayValueMerchant($display_value_merchant)
    {
        if (is_null($display_value_merchant)) {
            throw new \InvalidArgumentException('non-nullable display_value_merchant cannot be null');
        }
        $this->container['display_value_merchant'] = $display_value_merchant;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


