<?php
/**
 * OrderCustomProductPut
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V2
 *
 * Manage order coupons, messages, products, shipping addresses, statuses, taxes, shipments, and shipping address quotes.  - [Authentication](#authentication) - [Order](#order)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  |  **UI Name** | **Permission** | **Parameter** | | --- | --- | --- | |  Orders | modify | `store_v2_orders` | |  Orders | read-only | `store_v2_orders_read_only` |   ## Order  The Order object contains a record of the purchase agreement between a shopper and a merchant. To learn more about creating orders, see [Orders API Guide](/api-docs/orders/orders-api-overview).  ### Currency Fields  The **default** currency refers to the transactional currency which is the currency the shopper pays in.  The **display** currency refers to the presentational currency used to present prices to the shopper on the storefront.  * `currency_id` - the display currency ID. Depending on the currency selected, the value may be different from the transactional currency. * `currency_code` - the currency code of the display currency used to present prices to the shopper on the storefront. Depending on the currency selected, the value may be different from the transactional currency. * `currency_exchange_rate` - the exchange rate between the store's default currency and the display currency. For orders created using the V2 endpoints, this value is always 1 (only in the storefront this value can be different to 1). * `default_currency_id` - the transactional currency ID. * `default_currency_code` - the currency code of the transactional currency the shopper pays in.  The following additional fields are returned on orders when Multi-Currency is enabled on the store:  * `store_default_currency_code` - the currency code of the store's default currency. * `store_default_to_transactional_exchange_rate` - the exchange rate between the store's default currency and the transactional currency used in the order.  **Example:**  ```json {   ...   \"currency_id\": 4,   \"currency_code\": \"EUR\",   \"currency_exchange_rate\": 1,   \"default_currency_id\": 4,   \"default_currency_code\": \"EUR\",   \"store_default_currency_code\": \"USD\",   \"store_default_to_transactional_exchange_rate\": \"100.0000000000\"   ... } ```
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV2\Model;

use \ArrayAccess;
use \Bigcommerce\OrdersV2\ObjectSerializer;

/**
 * OrderCustomProductPut Class Doc Comment
 *
 * @category Class
 * @description To &#x60;add&#x60; a custom product to an existing order, don&#39;t include &#x60;id&#x60; in the payload. At least one of these fields &#x60;name&#x60;, &#x60;name_customer&#x60;, or &#x60;name_merchant&#x60; must be provided with non-empty value.      To &#x60;update&#x60; an order product line, &#x60;id&#x60; is required. The payload should only contain the fields that needs to be updated. Those fields that are omitted will not be changed.      Note:      - Empty strings &#x60;&#39;&#39;&#x60; and &#x60;null&#x60; are invalid for &#x60;xxx&#x60;, &#x60;xxx_customer&#x60;, and &#x60;xxx_merchant&#x60;.      - &#x60;name&#x60; and &#x60;name_customer&#x60; always hold the same value, updating either &#x60;name&#x60; or &#x60;name_customer&#x60; will change the value for both of those fields.      - If both fields &#x60;name&#x60; and &#x60;name_customer&#x60; are present, they must have same value.      - When updating an existing order product, if both fields &#x60;name&#x60; and &#x60;name_customer&#x60; are omitted from the request, they will not be updated.      - When updating an existing order product, if &#x60;name_merchant&#x60; is omitted from the request, it will not be updated.      - When adding product, if &#x60;name_merchant&#x60; is omitted, it will be set to the value of &#x60;name&#x60; (or &#x60;name_customer&#x60;).      - When adding a new product to an existing order, if both fields &#x60;name&#x60; and &#x60;name_customer&#x60; are omitted, they will be set to the value of &#x60;name_merchant&#x60;.
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderCustomProductPut implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'orderCustomProduct_Put';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'name_customer' => 'string',
        'name_merchant' => 'string',
        'quantity' => 'float',
        'price_ex_tax' => 'float',
        'price_inc_tax' => 'float',
        'sku' => 'string',
        'upc' => 'string',
        'id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'name_customer' => null,
        'name_merchant' => null,
        'quantity' => null,
        'price_ex_tax' => null,
        'price_inc_tax' => null,
        'sku' => null,
        'upc' => null,
        'id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'name' => false,
        'name_customer' => false,
        'name_merchant' => false,
        'quantity' => false,
        'price_ex_tax' => false,
        'price_inc_tax' => false,
        'sku' => false,
        'upc' => false,
        'id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'name_customer' => 'name_customer',
        'name_merchant' => 'name_merchant',
        'quantity' => 'quantity',
        'price_ex_tax' => 'price_ex_tax',
        'price_inc_tax' => 'price_inc_tax',
        'sku' => 'sku',
        'upc' => 'upc',
        'id' => 'id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'name_customer' => 'setNameCustomer',
        'name_merchant' => 'setNameMerchant',
        'quantity' => 'setQuantity',
        'price_ex_tax' => 'setPriceExTax',
        'price_inc_tax' => 'setPriceIncTax',
        'sku' => 'setSku',
        'upc' => 'setUpc',
        'id' => 'setId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'name_customer' => 'getNameCustomer',
        'name_merchant' => 'getNameMerchant',
        'quantity' => 'getQuantity',
        'price_ex_tax' => 'getPriceExTax',
        'price_inc_tax' => 'getPriceIncTax',
        'sku' => 'getSku',
        'upc' => 'getUpc',
        'id' => 'getId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('name_customer', $data ?? [], null);
        $this->setIfExists('name_merchant', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('price_ex_tax', $data ?? [], null);
        $this->setIfExists('price_inc_tax', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('upc', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['quantity'] === null) {
            $invalidProperties[] = "'quantity' can't be null";
        }
        if ($this->container['price_ex_tax'] === null) {
            $invalidProperties[] = "'price_ex_tax' can't be null";
        }
        if ($this->container['price_inc_tax'] === null) {
            $invalidProperties[] = "'price_inc_tax' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name Alias for name_customer. The product name that is shown to customer in storefront.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets name_customer
     *
     * @return string|null
     */
    public function getNameCustomer()
    {
        return $this->container['name_customer'];
    }

    /**
     * Sets name_customer
     *
     * @param string|null $name_customer The product name that is shown to customer in storefront.
     *
     * @return self
     */
    public function setNameCustomer($name_customer)
    {
        if (is_null($name_customer)) {
            throw new \InvalidArgumentException('non-nullable name_customer cannot be null');
        }
        $this->container['name_customer'] = $name_customer;

        return $this;
    }

    /**
     * Gets name_merchant
     *
     * @return string|null
     */
    public function getNameMerchant()
    {
        return $this->container['name_merchant'];
    }

    /**
     * Sets name_merchant
     *
     * @param string|null $name_merchant The product name that is shown to merchant in control panel.
     *
     * @return self
     */
    public function setNameMerchant($name_merchant)
    {
        if (is_null($name_merchant)) {
            throw new \InvalidArgumentException('non-nullable name_merchant cannot be null');
        }
        $this->container['name_merchant'] = $name_merchant;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return float
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param float $quantity quantity
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets price_ex_tax
     *
     * @return float
     */
    public function getPriceExTax()
    {
        return $this->container['price_ex_tax'];
    }

    /**
     * Sets price_ex_tax
     *
     * @param float $price_ex_tax price_ex_tax
     *
     * @return self
     */
    public function setPriceExTax($price_ex_tax)
    {
        if (is_null($price_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable price_ex_tax cannot be null');
        }
        $this->container['price_ex_tax'] = $price_ex_tax;

        return $this;
    }

    /**
     * Gets price_inc_tax
     *
     * @return float
     */
    public function getPriceIncTax()
    {
        return $this->container['price_inc_tax'];
    }

    /**
     * Sets price_inc_tax
     *
     * @param float $price_inc_tax price_inc_tax
     *
     * @return self
     */
    public function setPriceIncTax($price_inc_tax)
    {
        if (is_null($price_inc_tax)) {
            throw new \InvalidArgumentException('non-nullable price_inc_tax cannot be null');
        }
        $this->container['price_inc_tax'] = $price_inc_tax;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku sku
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets upc
     *
     * @return string|null
     */
    public function getUpc()
    {
        return $this->container['upc'];
    }

    /**
     * Sets upc
     *
     * @param string|null $upc upc
     *
     * @return self
     */
    public function setUpc($upc)
    {
        if (is_null($upc)) {
            throw new \InvalidArgumentException('non-nullable upc cannot be null');
        }
        $this->container['upc'] = $upc;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id ID of the product line
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


