<?php
/**
 * OrdersApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V2
 *
 * Manage order coupons, messages, products, shipping addresses, statuses, taxes, shipments, and shipping address quotes.  - [Authentication](#authentication) - [Order](#order)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  |  **UI Name** | **Permission** | **Parameter** | | --- | --- | --- | |  Orders | modify | `store_v2_orders` | |  Orders | read-only | `store_v2_orders_read_only` |   ## Order  The Order object contains a record of the purchase agreement between a shopper and a merchant. To learn more about creating orders, see [Orders API Guide](/api-docs/orders/orders-api-overview).  ### Currency Fields  The **default** currency refers to the transactional currency which is the currency the shopper pays in.  The **display** currency refers to the presentational currency used to present prices to the shopper on the storefront.  * `currency_id` - the display currency ID. Depending on the currency selected, the value may be different from the transactional currency. * `currency_code` - the currency code of the display currency used to present prices to the shopper on the storefront. Depending on the currency selected, the value may be different from the transactional currency. * `currency_exchange_rate` - the exchange rate between the store's default currency and the display currency. For orders created using the V2 endpoints, this value is always 1 (only in the storefront this value can be different to 1). * `default_currency_id` - the transactional currency ID. * `default_currency_code` - the currency code of the transactional currency the shopper pays in.  The following additional fields are returned on orders when Multi-Currency is enabled on the store:  * `store_default_currency_code` - the currency code of the store's default currency. * `store_default_to_transactional_exchange_rate` - the exchange rate between the store's default currency and the transactional currency used in the order.  **Example:**  ```json {   ...   \"currency_id\": 4,   \"currency_code\": \"EUR\",   \"currency_exchange_rate\": 1,   \"default_currency_id\": 4,   \"default_currency_code\": \"EUR\",   \"store_default_currency_code\": \"USD\",   \"store_default_to_transactional_exchange_rate\": \"100.0000000000\"   ... } ```
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\OrdersV2\ApiException;
use Bigcommerce\OrdersV2\Configuration;
use Bigcommerce\OrdersV2\FormDataProcessor;
use Bigcommerce\OrdersV2\HeaderSelector;
use Bigcommerce\OrdersV2\ObjectSerializer;

/**
 * OrdersApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrdersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createAnOrder' => [
            'application/json',
        ],
        'deleteAllOrders' => [
            'application/json',
        ],
        'deleteAnOrder' => [
            'application/json',
        ],
        'getAllOrders' => [
            'application/json',
        ],
        'getAnOrder' => [
            'application/json',
        ],
        'getCountOrder' => [
            'application/json',
        ],
        'updateAnOrder' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createAnOrder
     *
     * Create an Order
     *
     * @param  \Bigcommerce\OrdersV2\Model\OrderPost $order_post order_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createAnOrder'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV2\Model\OrderResp
     */
    public function createAnOrder($order_post, string $contentType = self::contentTypes['createAnOrder'][0])
    {
        list($response) = $this->createAnOrderWithHttpInfo($order_post, $contentType);
        return $response;
    }

    /**
     * Operation createAnOrderWithHttpInfo
     *
     * Create an Order
     *
     * @param  \Bigcommerce\OrdersV2\Model\OrderPost $order_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createAnOrder'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV2\Model\OrderResp, HTTP status code, HTTP response headers (array of strings)
     */
    public function createAnOrderWithHttpInfo($order_post, string $contentType = self::contentTypes['createAnOrder'][0])
    {
        $request = $this->createAnOrderRequest($order_post, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV2\Model\OrderResp',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV2\Model\OrderResp',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV2\Model\OrderResp',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createAnOrderAsync
     *
     * Create an Order
     *
     * @param  \Bigcommerce\OrdersV2\Model\OrderPost $order_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createAnOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAnOrderAsync($order_post, string $contentType = self::contentTypes['createAnOrder'][0])
    {
        return $this->createAnOrderAsyncWithHttpInfo($order_post, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAnOrderAsyncWithHttpInfo
     *
     * Create an Order
     *
     * @param  \Bigcommerce\OrdersV2\Model\OrderPost $order_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createAnOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAnOrderAsyncWithHttpInfo($order_post, string $contentType = self::contentTypes['createAnOrder'][0])
    {
        $returnType = '\Bigcommerce\OrdersV2\Model\OrderResp';
        $request = $this->createAnOrderRequest($order_post, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createAnOrder'
     *
     * @param  \Bigcommerce\OrdersV2\Model\OrderPost $order_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createAnOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createAnOrderRequest($order_post, string $contentType = self::contentTypes['createAnOrder'][0])
    {

        // verify the required parameter 'order_post' is set
        if ($order_post === null || (is_array($order_post) && count($order_post) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_post when calling createAnOrder'
            );
        }


        $resourcePath = '/orders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order_post)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_post));
            } else {
                $httpBody = $order_post;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteAllOrders
     *
     * Delete All Orders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllOrders'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteAllOrders(string $contentType = self::contentTypes['deleteAllOrders'][0])
    {
        $this->deleteAllOrdersWithHttpInfo($contentType);
    }

    /**
     * Operation deleteAllOrdersWithHttpInfo
     *
     * Delete All Orders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllOrders'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAllOrdersWithHttpInfo(string $contentType = self::contentTypes['deleteAllOrders'][0])
    {
        $request = $this->deleteAllOrdersRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteAllOrdersAsync
     *
     * Delete All Orders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAllOrdersAsync(string $contentType = self::contentTypes['deleteAllOrders'][0])
    {
        return $this->deleteAllOrdersAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAllOrdersAsyncWithHttpInfo
     *
     * Delete All Orders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAllOrdersAsyncWithHttpInfo(string $contentType = self::contentTypes['deleteAllOrders'][0])
    {
        $returnType = '';
        $request = $this->deleteAllOrdersRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteAllOrders'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteAllOrdersRequest(string $contentType = self::contentTypes['deleteAllOrders'][0])
    {


        $resourcePath = '/orders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteAnOrder
     *
     * Archive an Order
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAnOrder'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteAnOrder($order_id, string $contentType = self::contentTypes['deleteAnOrder'][0])
    {
        $this->deleteAnOrderWithHttpInfo($order_id, $contentType);
    }

    /**
     * Operation deleteAnOrderWithHttpInfo
     *
     * Archive an Order
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAnOrder'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAnOrderWithHttpInfo($order_id, string $contentType = self::contentTypes['deleteAnOrder'][0])
    {
        $request = $this->deleteAnOrderRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteAnOrderAsync
     *
     * Archive an Order
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAnOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAnOrderAsync($order_id, string $contentType = self::contentTypes['deleteAnOrder'][0])
    {
        return $this->deleteAnOrderAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAnOrderAsyncWithHttpInfo
     *
     * Archive an Order
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAnOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAnOrderAsyncWithHttpInfo($order_id, string $contentType = self::contentTypes['deleteAnOrder'][0])
    {
        $returnType = '';
        $request = $this->deleteAnOrderRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteAnOrder'
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAnOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteAnOrderRequest($order_id, string $contentType = self::contentTypes['deleteAnOrder'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling deleteAnOrder'
            );
        }


        $resourcePath = '/orders/{order_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllOrders
     *
     * Get All Orders
     *
     * @param  int|null $min_id The minimum order ID. (optional)
     * @param  int|null $max_id The maximum order ID. (optional)
     * @param  float|null $min_total The minimum order total in float format. eg. 12.50 (optional)
     * @param  float|null $max_total The maximum order total in float format. eg. 12.50 (optional)
     * @param  int|null $customer_id Customer ID (optional)
     * @param  string|null $email The email of the customer. (optional)
     * @param  int|null $status_id The staus ID of the order. You can get the status id from the &#x60;/orders&#x60; endpoints. (optional)
     * @param  string|null $cart_id The cart ID of the order. (optional)
     * @param  string|null $payment_method The payment method used on the order. (optional)
     * @param  string|null $min_date_created Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_created Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $min_date_modified Minimum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_modified Maximum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string|null $sort Field and direction to sort orders. To specify the direction, add &#x60;:asc&#x60; or &#x60;:desc&#x60; to the end of the query parameter. E.g. &#x60;sort&#x3D;date_created:desc&#x60;. (optional)
     * @param  bool|null $is_deleted If the order was deleted or archived. (optional)
     * @param  int|null $channel_id The Channel ID of the Order. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOrders'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV2\Model\OrderResp[]|string
     */
    public function getAllOrders($min_id = null, $max_id = null, $min_total = null, $max_total = null, $customer_id = null, $email = null, $status_id = null, $cart_id = null, $payment_method = null, $min_date_created = null, $max_date_created = null, $min_date_modified = null, $max_date_modified = null, $page = null, $limit = null, $sort = null, $is_deleted = null, $channel_id = null, string $contentType = self::contentTypes['getAllOrders'][0])
    {
        list($response) = $this->getAllOrdersWithHttpInfo($min_id, $max_id, $min_total, $max_total, $customer_id, $email, $status_id, $cart_id, $payment_method, $min_date_created, $max_date_created, $min_date_modified, $max_date_modified, $page, $limit, $sort, $is_deleted, $channel_id, $contentType);
        return $response;
    }

    /**
     * Operation getAllOrdersWithHttpInfo
     *
     * Get All Orders
     *
     * @param  int|null $min_id The minimum order ID. (optional)
     * @param  int|null $max_id The maximum order ID. (optional)
     * @param  float|null $min_total The minimum order total in float format. eg. 12.50 (optional)
     * @param  float|null $max_total The maximum order total in float format. eg. 12.50 (optional)
     * @param  int|null $customer_id Customer ID (optional)
     * @param  string|null $email The email of the customer. (optional)
     * @param  int|null $status_id The staus ID of the order. You can get the status id from the &#x60;/orders&#x60; endpoints. (optional)
     * @param  string|null $cart_id The cart ID of the order. (optional)
     * @param  string|null $payment_method The payment method used on the order. (optional)
     * @param  string|null $min_date_created Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_created Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $min_date_modified Minimum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_modified Maximum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string|null $sort Field and direction to sort orders. To specify the direction, add &#x60;:asc&#x60; or &#x60;:desc&#x60; to the end of the query parameter. E.g. &#x60;sort&#x3D;date_created:desc&#x60;. (optional)
     * @param  bool|null $is_deleted If the order was deleted or archived. (optional)
     * @param  int|null $channel_id The Channel ID of the Order. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOrders'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV2\Model\OrderResp[]|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllOrdersWithHttpInfo($min_id = null, $max_id = null, $min_total = null, $max_total = null, $customer_id = null, $email = null, $status_id = null, $cart_id = null, $payment_method = null, $min_date_created = null, $max_date_created = null, $min_date_modified = null, $max_date_modified = null, $page = null, $limit = null, $sort = null, $is_deleted = null, $channel_id = null, string $contentType = self::contentTypes['getAllOrders'][0])
    {
        $request = $this->getAllOrdersRequest($min_id, $max_id, $min_total, $max_total, $customer_id, $email, $status_id, $cart_id, $payment_method, $min_date_created, $max_date_created, $min_date_modified, $max_date_modified, $page, $limit, $sort, $is_deleted, $channel_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV2\Model\OrderResp[]',
                        $request,
                        $response,
                    );
                case 204:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV2\Model\OrderResp[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV2\Model\OrderResp[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 204:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getAllOrdersAsync
     *
     * Get All Orders
     *
     * @param  int|null $min_id The minimum order ID. (optional)
     * @param  int|null $max_id The maximum order ID. (optional)
     * @param  float|null $min_total The minimum order total in float format. eg. 12.50 (optional)
     * @param  float|null $max_total The maximum order total in float format. eg. 12.50 (optional)
     * @param  int|null $customer_id Customer ID (optional)
     * @param  string|null $email The email of the customer. (optional)
     * @param  int|null $status_id The staus ID of the order. You can get the status id from the &#x60;/orders&#x60; endpoints. (optional)
     * @param  string|null $cart_id The cart ID of the order. (optional)
     * @param  string|null $payment_method The payment method used on the order. (optional)
     * @param  string|null $min_date_created Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_created Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $min_date_modified Minimum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_modified Maximum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string|null $sort Field and direction to sort orders. To specify the direction, add &#x60;:asc&#x60; or &#x60;:desc&#x60; to the end of the query parameter. E.g. &#x60;sort&#x3D;date_created:desc&#x60;. (optional)
     * @param  bool|null $is_deleted If the order was deleted or archived. (optional)
     * @param  int|null $channel_id The Channel ID of the Order. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllOrdersAsync($min_id = null, $max_id = null, $min_total = null, $max_total = null, $customer_id = null, $email = null, $status_id = null, $cart_id = null, $payment_method = null, $min_date_created = null, $max_date_created = null, $min_date_modified = null, $max_date_modified = null, $page = null, $limit = null, $sort = null, $is_deleted = null, $channel_id = null, string $contentType = self::contentTypes['getAllOrders'][0])
    {
        return $this->getAllOrdersAsyncWithHttpInfo($min_id, $max_id, $min_total, $max_total, $customer_id, $email, $status_id, $cart_id, $payment_method, $min_date_created, $max_date_created, $min_date_modified, $max_date_modified, $page, $limit, $sort, $is_deleted, $channel_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllOrdersAsyncWithHttpInfo
     *
     * Get All Orders
     *
     * @param  int|null $min_id The minimum order ID. (optional)
     * @param  int|null $max_id The maximum order ID. (optional)
     * @param  float|null $min_total The minimum order total in float format. eg. 12.50 (optional)
     * @param  float|null $max_total The maximum order total in float format. eg. 12.50 (optional)
     * @param  int|null $customer_id Customer ID (optional)
     * @param  string|null $email The email of the customer. (optional)
     * @param  int|null $status_id The staus ID of the order. You can get the status id from the &#x60;/orders&#x60; endpoints. (optional)
     * @param  string|null $cart_id The cart ID of the order. (optional)
     * @param  string|null $payment_method The payment method used on the order. (optional)
     * @param  string|null $min_date_created Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_created Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $min_date_modified Minimum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_modified Maximum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string|null $sort Field and direction to sort orders. To specify the direction, add &#x60;:asc&#x60; or &#x60;:desc&#x60; to the end of the query parameter. E.g. &#x60;sort&#x3D;date_created:desc&#x60;. (optional)
     * @param  bool|null $is_deleted If the order was deleted or archived. (optional)
     * @param  int|null $channel_id The Channel ID of the Order. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllOrdersAsyncWithHttpInfo($min_id = null, $max_id = null, $min_total = null, $max_total = null, $customer_id = null, $email = null, $status_id = null, $cart_id = null, $payment_method = null, $min_date_created = null, $max_date_created = null, $min_date_modified = null, $max_date_modified = null, $page = null, $limit = null, $sort = null, $is_deleted = null, $channel_id = null, string $contentType = self::contentTypes['getAllOrders'][0])
    {
        $returnType = '\Bigcommerce\OrdersV2\Model\OrderResp[]';
        $request = $this->getAllOrdersRequest($min_id, $max_id, $min_total, $max_total, $customer_id, $email, $status_id, $cart_id, $payment_method, $min_date_created, $max_date_created, $min_date_modified, $max_date_modified, $page, $limit, $sort, $is_deleted, $channel_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllOrders'
     *
     * @param  int|null $min_id The minimum order ID. (optional)
     * @param  int|null $max_id The maximum order ID. (optional)
     * @param  float|null $min_total The minimum order total in float format. eg. 12.50 (optional)
     * @param  float|null $max_total The maximum order total in float format. eg. 12.50 (optional)
     * @param  int|null $customer_id Customer ID (optional)
     * @param  string|null $email The email of the customer. (optional)
     * @param  int|null $status_id The staus ID of the order. You can get the status id from the &#x60;/orders&#x60; endpoints. (optional)
     * @param  string|null $cart_id The cart ID of the order. (optional)
     * @param  string|null $payment_method The payment method used on the order. (optional)
     * @param  string|null $min_date_created Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_created Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $min_date_modified Minimum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_modified Maximum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string|null $sort Field and direction to sort orders. To specify the direction, add &#x60;:asc&#x60; or &#x60;:desc&#x60; to the end of the query parameter. E.g. &#x60;sort&#x3D;date_created:desc&#x60;. (optional)
     * @param  bool|null $is_deleted If the order was deleted or archived. (optional)
     * @param  int|null $channel_id The Channel ID of the Order. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllOrdersRequest($min_id = null, $max_id = null, $min_total = null, $max_total = null, $customer_id = null, $email = null, $status_id = null, $cart_id = null, $payment_method = null, $min_date_created = null, $max_date_created = null, $min_date_modified = null, $max_date_modified = null, $page = null, $limit = null, $sort = null, $is_deleted = null, $channel_id = null, string $contentType = self::contentTypes['getAllOrders'][0])
    {




















        $resourcePath = '/orders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $min_id,
            'min_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $max_id,
            'max_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $min_total,
            'min_total', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $max_total,
            'max_total', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_id,
            'customer_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $email,
            'email', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status_id,
            'status_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $cart_id,
            'cart_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $payment_method,
            'payment_method', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $min_date_created,
            'min_date_created', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $max_date_created,
            'max_date_created', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $min_date_modified,
            'min_date_modified', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $max_date_modified,
            'max_date_modified', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_deleted,
            'is_deleted', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $channel_id,
            'channel_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAnOrder
     *
     * Get an Order
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAnOrder'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV2\Model\OrderResp|mixed
     */
    public function getAnOrder($order_id, string $contentType = self::contentTypes['getAnOrder'][0])
    {
        list($response) = $this->getAnOrderWithHttpInfo($order_id, $contentType);
        return $response;
    }

    /**
     * Operation getAnOrderWithHttpInfo
     *
     * Get an Order
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAnOrder'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV2\Model\OrderResp|mixed, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAnOrderWithHttpInfo($order_id, string $contentType = self::contentTypes['getAnOrder'][0])
    {
        $request = $this->getAnOrderRequest($order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV2\Model\OrderResp',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        'mixed',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV2\Model\OrderResp',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV2\Model\OrderResp',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'mixed',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getAnOrderAsync
     *
     * Get an Order
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAnOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAnOrderAsync($order_id, string $contentType = self::contentTypes['getAnOrder'][0])
    {
        return $this->getAnOrderAsyncWithHttpInfo($order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAnOrderAsyncWithHttpInfo
     *
     * Get an Order
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAnOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAnOrderAsyncWithHttpInfo($order_id, string $contentType = self::contentTypes['getAnOrder'][0])
    {
        $returnType = '\Bigcommerce\OrdersV2\Model\OrderResp';
        $request = $this->getAnOrderRequest($order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAnOrder'
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAnOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAnOrderRequest($order_id, string $contentType = self::contentTypes['getAnOrder'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling getAnOrder'
            );
        }


        $resourcePath = '/orders/{order_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCountOrder
     *
     * Get a Count of Orders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountOrder'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV2\Model\OrdersCountFull
     */
    public function getCountOrder(string $contentType = self::contentTypes['getCountOrder'][0])
    {
        list($response) = $this->getCountOrderWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getCountOrderWithHttpInfo
     *
     * Get a Count of Orders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountOrder'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV2\Model\OrdersCountFull, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCountOrderWithHttpInfo(string $contentType = self::contentTypes['getCountOrder'][0])
    {
        $request = $this->getCountOrderRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV2\Model\OrdersCountFull',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV2\Model\OrdersCountFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV2\Model\OrdersCountFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCountOrderAsync
     *
     * Get a Count of Orders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCountOrderAsync(string $contentType = self::contentTypes['getCountOrder'][0])
    {
        return $this->getCountOrderAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCountOrderAsyncWithHttpInfo
     *
     * Get a Count of Orders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCountOrderAsyncWithHttpInfo(string $contentType = self::contentTypes['getCountOrder'][0])
    {
        $returnType = '\Bigcommerce\OrdersV2\Model\OrdersCountFull';
        $request = $this->getCountOrderRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCountOrder'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCountOrderRequest(string $contentType = self::contentTypes['getCountOrder'][0])
    {


        $resourcePath = '/orders/count';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateAnOrder
     *
     * Update an Order
     *
     * @param  int $order_id ID of the order (required)
     * @param  \Bigcommerce\OrdersV2\Model\OrderPut $order_put order_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAnOrder'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV2\Model\OrderResp
     */
    public function updateAnOrder($order_id, $order_put, string $contentType = self::contentTypes['updateAnOrder'][0])
    {
        list($response) = $this->updateAnOrderWithHttpInfo($order_id, $order_put, $contentType);
        return $response;
    }

    /**
     * Operation updateAnOrderWithHttpInfo
     *
     * Update an Order
     *
     * @param  int $order_id ID of the order (required)
     * @param  \Bigcommerce\OrdersV2\Model\OrderPut $order_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAnOrder'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV2\Model\OrderResp, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateAnOrderWithHttpInfo($order_id, $order_put, string $contentType = self::contentTypes['updateAnOrder'][0])
    {
        $request = $this->updateAnOrderRequest($order_id, $order_put, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV2\Model\OrderResp',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV2\Model\OrderResp',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV2\Model\OrderResp',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateAnOrderAsync
     *
     * Update an Order
     *
     * @param  int $order_id ID of the order (required)
     * @param  \Bigcommerce\OrdersV2\Model\OrderPut $order_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAnOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAnOrderAsync($order_id, $order_put, string $contentType = self::contentTypes['updateAnOrder'][0])
    {
        return $this->updateAnOrderAsyncWithHttpInfo($order_id, $order_put, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateAnOrderAsyncWithHttpInfo
     *
     * Update an Order
     *
     * @param  int $order_id ID of the order (required)
     * @param  \Bigcommerce\OrdersV2\Model\OrderPut $order_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAnOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAnOrderAsyncWithHttpInfo($order_id, $order_put, string $contentType = self::contentTypes['updateAnOrder'][0])
    {
        $returnType = '\Bigcommerce\OrdersV2\Model\OrderResp';
        $request = $this->updateAnOrderRequest($order_id, $order_put, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateAnOrder'
     *
     * @param  int $order_id ID of the order (required)
     * @param  \Bigcommerce\OrdersV2\Model\OrderPut $order_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAnOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateAnOrderRequest($order_id, $order_put, string $contentType = self::contentTypes['updateAnOrder'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling updateAnOrder'
            );
        }

        // verify the required parameter 'order_put' is set
        if ($order_put === null || (is_array($order_put) && count($order_put) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_put when calling updateAnOrder'
            );
        }


        $resourcePath = '/orders/{order_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($order_put)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($order_put));
            } else {
                $httpBody = $order_put;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
