<?php
/**
 * OrderShippingAddressesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V2
 *
 * Manage order coupons, messages, products, shipping addresses, statuses, taxes, shipments, and shipping address quotes.  - [Authentication](#authentication) - [Order](#order)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  |  **UI Name** | **Permission** | **Parameter** | | --- | --- | --- | |  Orders | modify | `store_v2_orders` | |  Orders | read-only | `store_v2_orders_read_only` |   ## Order  The Order object contains a record of the purchase agreement between a shopper and a merchant. To learn more about creating orders, see [Orders API Guide](/api-docs/orders/orders-api-overview).  ### Currency Fields  The **default** currency refers to the transactional currency which is the currency the shopper pays in.  The **display** currency refers to the presentational currency used to present prices to the shopper on the storefront.  * `currency_id` - the display currency ID. Depending on the currency selected, the value may be different from the transactional currency. * `currency_code` - the currency code of the display currency used to present prices to the shopper on the storefront. Depending on the currency selected, the value may be different from the transactional currency. * `currency_exchange_rate` - the exchange rate between the store's default currency and the display currency. For orders created using the V2 endpoints, this value is always 1 (only in the storefront this value can be different to 1). * `default_currency_id` - the transactional currency ID. * `default_currency_code` - the currency code of the transactional currency the shopper pays in.  The following additional fields are returned on orders when Multi-Currency is enabled on the store:  * `store_default_currency_code` - the currency code of the store's default currency. * `store_default_to_transactional_exchange_rate` - the exchange rate between the store's default currency and the transactional currency used in the order.  **Example:**  ```json {   ...   \"currency_id\": 4,   \"currency_code\": \"EUR\",   \"currency_exchange_rate\": 1,   \"default_currency_id\": 4,   \"default_currency_code\": \"EUR\",   \"store_default_currency_code\": \"USD\",   \"store_default_to_transactional_exchange_rate\": \"100.0000000000\"   ... } ```
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\OrdersV2\ApiException;
use Bigcommerce\OrdersV2\Configuration;
use Bigcommerce\OrdersV2\FormDataProcessor;
use Bigcommerce\OrdersV2\HeaderSelector;
use Bigcommerce\OrdersV2\ObjectSerializer;

/**
 * OrderShippingAddressesApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrderShippingAddressesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getAShippingAddress' => [
            'application/json',
        ],
        'getAllShippingAddresses' => [
            'application/json',
        ],
        'updateAShippingAddress' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getAShippingAddress
     *
     * Get a Shipping Address
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAShippingAddress'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV2\Model\OrderShippingAddress
     */
    public function getAShippingAddress($order_id, $id, string $contentType = self::contentTypes['getAShippingAddress'][0])
    {
        list($response) = $this->getAShippingAddressWithHttpInfo($order_id, $id, $contentType);
        return $response;
    }

    /**
     * Operation getAShippingAddressWithHttpInfo
     *
     * Get a Shipping Address
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAShippingAddress'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV2\Model\OrderShippingAddress, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAShippingAddressWithHttpInfo($order_id, $id, string $contentType = self::contentTypes['getAShippingAddress'][0])
    {
        $request = $this->getAShippingAddressRequest($order_id, $id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV2\Model\OrderShippingAddress',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV2\Model\OrderShippingAddress',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV2\Model\OrderShippingAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getAShippingAddressAsync
     *
     * Get a Shipping Address
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAShippingAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAShippingAddressAsync($order_id, $id, string $contentType = self::contentTypes['getAShippingAddress'][0])
    {
        return $this->getAShippingAddressAsyncWithHttpInfo($order_id, $id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAShippingAddressAsyncWithHttpInfo
     *
     * Get a Shipping Address
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAShippingAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAShippingAddressAsyncWithHttpInfo($order_id, $id, string $contentType = self::contentTypes['getAShippingAddress'][0])
    {
        $returnType = '\Bigcommerce\OrdersV2\Model\OrderShippingAddress';
        $request = $this->getAShippingAddressRequest($order_id, $id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAShippingAddress'
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAShippingAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAShippingAddressRequest($order_id, $id, string $contentType = self::contentTypes['getAShippingAddress'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling getAShippingAddress'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getAShippingAddress'
            );
        }


        $resourcePath = '/orders/{order_id}/shipping_addresses/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllShippingAddresses
     *
     * Get Order Shipping Addresses
     *
     * @param  int $order_id ID of the order (required)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllShippingAddresses'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV2\Model\OrderShippingAddress[]
     */
    public function getAllShippingAddresses($order_id, $page = null, $limit = null, string $contentType = self::contentTypes['getAllShippingAddresses'][0])
    {
        list($response) = $this->getAllShippingAddressesWithHttpInfo($order_id, $page, $limit, $contentType);
        return $response;
    }

    /**
     * Operation getAllShippingAddressesWithHttpInfo
     *
     * Get Order Shipping Addresses
     *
     * @param  int $order_id ID of the order (required)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllShippingAddresses'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV2\Model\OrderShippingAddress[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllShippingAddressesWithHttpInfo($order_id, $page = null, $limit = null, string $contentType = self::contentTypes['getAllShippingAddresses'][0])
    {
        $request = $this->getAllShippingAddressesRequest($order_id, $page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV2\Model\OrderShippingAddress[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV2\Model\OrderShippingAddress[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV2\Model\OrderShippingAddress[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getAllShippingAddressesAsync
     *
     * Get Order Shipping Addresses
     *
     * @param  int $order_id ID of the order (required)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllShippingAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllShippingAddressesAsync($order_id, $page = null, $limit = null, string $contentType = self::contentTypes['getAllShippingAddresses'][0])
    {
        return $this->getAllShippingAddressesAsyncWithHttpInfo($order_id, $page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllShippingAddressesAsyncWithHttpInfo
     *
     * Get Order Shipping Addresses
     *
     * @param  int $order_id ID of the order (required)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllShippingAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllShippingAddressesAsyncWithHttpInfo($order_id, $page = null, $limit = null, string $contentType = self::contentTypes['getAllShippingAddresses'][0])
    {
        $returnType = '\Bigcommerce\OrdersV2\Model\OrderShippingAddress[]';
        $request = $this->getAllShippingAddressesRequest($order_id, $page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllShippingAddresses'
     *
     * @param  int $order_id ID of the order (required)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllShippingAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllShippingAddressesRequest($order_id, $page = null, $limit = null, string $contentType = self::contentTypes['getAllShippingAddresses'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling getAllShippingAddresses'
            );
        }




        $resourcePath = '/orders/{order_id}/shipping_addresses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateAShippingAddress
     *
     * Update a Shipping Address
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $id id (required)
     * @param  \Bigcommerce\OrdersV2\Model\ShippingAddressBase|null $shipping_address_base shipping_address_base (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAShippingAddress'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV2\Model\OrderShippingAddress|\Bigcommerce\OrdersV2\Model\UpdateAShippingAddress400ResponseInner[]|\Bigcommerce\OrdersV2\Model\UpdateAShippingAddress400ResponseInner[]
     */
    public function updateAShippingAddress($order_id, $id, $shipping_address_base = null, string $contentType = self::contentTypes['updateAShippingAddress'][0])
    {
        list($response) = $this->updateAShippingAddressWithHttpInfo($order_id, $id, $shipping_address_base, $contentType);
        return $response;
    }

    /**
     * Operation updateAShippingAddressWithHttpInfo
     *
     * Update a Shipping Address
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $id (required)
     * @param  \Bigcommerce\OrdersV2\Model\ShippingAddressBase|null $shipping_address_base (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAShippingAddress'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV2\Model\OrderShippingAddress|\Bigcommerce\OrdersV2\Model\UpdateAShippingAddress400ResponseInner[]|\Bigcommerce\OrdersV2\Model\UpdateAShippingAddress400ResponseInner[], HTTP status code, HTTP response headers (array of strings)
     */
    public function updateAShippingAddressWithHttpInfo($order_id, $id, $shipping_address_base = null, string $contentType = self::contentTypes['updateAShippingAddress'][0])
    {
        $request = $this->updateAShippingAddressRequest($order_id, $id, $shipping_address_base, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV2\Model\OrderShippingAddress',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV2\Model\UpdateAShippingAddress400ResponseInner[]',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV2\Model\UpdateAShippingAddress400ResponseInner[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV2\Model\OrderShippingAddress',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV2\Model\OrderShippingAddress',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV2\Model\UpdateAShippingAddress400ResponseInner[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV2\Model\UpdateAShippingAddress400ResponseInner[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateAShippingAddressAsync
     *
     * Update a Shipping Address
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $id (required)
     * @param  \Bigcommerce\OrdersV2\Model\ShippingAddressBase|null $shipping_address_base (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAShippingAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAShippingAddressAsync($order_id, $id, $shipping_address_base = null, string $contentType = self::contentTypes['updateAShippingAddress'][0])
    {
        return $this->updateAShippingAddressAsyncWithHttpInfo($order_id, $id, $shipping_address_base, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateAShippingAddressAsyncWithHttpInfo
     *
     * Update a Shipping Address
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $id (required)
     * @param  \Bigcommerce\OrdersV2\Model\ShippingAddressBase|null $shipping_address_base (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAShippingAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAShippingAddressAsyncWithHttpInfo($order_id, $id, $shipping_address_base = null, string $contentType = self::contentTypes['updateAShippingAddress'][0])
    {
        $returnType = '\Bigcommerce\OrdersV2\Model\OrderShippingAddress';
        $request = $this->updateAShippingAddressRequest($order_id, $id, $shipping_address_base, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateAShippingAddress'
     *
     * @param  int $order_id ID of the order (required)
     * @param  string $id (required)
     * @param  \Bigcommerce\OrdersV2\Model\ShippingAddressBase|null $shipping_address_base (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAShippingAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateAShippingAddressRequest($order_id, $id, $shipping_address_base = null, string $contentType = self::contentTypes['updateAShippingAddress'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling updateAShippingAddress'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling updateAShippingAddress'
            );
        }



        $resourcePath = '/orders/{order_id}/shipping_addresses/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($shipping_address_base)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($shipping_address_base));
            } else {
                $httpBody = $shipping_address_base;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
