<?php
/**
 * OrderMessagesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Orders V2
 *
 * Manage order coupons, messages, products, shipping addresses, statuses, taxes, shipments, and shipping address quotes.  - [Authentication](#authentication) - [Order](#order)  ## Authentication  Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` request header.  ```http GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}} Content-Type: application/json X-Auth-Token: {{ACCESS_TOKEN}} ```  ### OAuth Scopes  |  **UI Name** | **Permission** | **Parameter** | | --- | --- | --- | |  Orders | modify | `store_v2_orders` | |  Orders | read-only | `store_v2_orders_read_only` |   ## Order  The Order object contains a record of the purchase agreement between a shopper and a merchant. To learn more about creating orders, see [Orders API Guide](/api-docs/orders/orders-api-overview).  ### Currency Fields  The **default** currency refers to the transactional currency which is the currency the shopper pays in.  The **display** currency refers to the presentational currency used to present prices to the shopper on the storefront.  * `currency_id` - the display currency ID. Depending on the currency selected, the value may be different from the transactional currency. * `currency_code` - the currency code of the display currency used to present prices to the shopper on the storefront. Depending on the currency selected, the value may be different from the transactional currency. * `currency_exchange_rate` - the exchange rate between the store's default currency and the display currency. For orders created using the V2 endpoints, this value is always 1 (only in the storefront this value can be different to 1). * `default_currency_id` - the transactional currency ID. * `default_currency_code` - the currency code of the transactional currency the shopper pays in.  The following additional fields are returned on orders when Multi-Currency is enabled on the store:  * `store_default_currency_code` - the currency code of the store's default currency. * `store_default_to_transactional_exchange_rate` - the exchange rate between the store's default currency and the transactional currency used in the order.  **Example:**  ```json {   ...   \"currency_id\": 4,   \"currency_code\": \"EUR\",   \"currency_exchange_rate\": 1,   \"default_currency_id\": 4,   \"default_currency_code\": \"EUR\",   \"store_default_currency_code\": \"USD\",   \"store_default_to_transactional_exchange_rate\": \"100.0000000000\"   ... } ```
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\OrdersV2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\OrdersV2\ApiException;
use Bigcommerce\OrdersV2\Configuration;
use Bigcommerce\OrdersV2\FormDataProcessor;
use Bigcommerce\OrdersV2\HeaderSelector;
use Bigcommerce\OrdersV2\ObjectSerializer;

/**
 * OrderMessagesApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\OrdersV2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrderMessagesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getOrderMessages' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getOrderMessages
     *
     * Get Order Messages
     *
     * @param  int $order_id ID of the order (required)
     * @param  int|null $min_id The minimum order ID. (optional)
     * @param  int|null $max_id The maximum order ID. (optional)
     * @param  int|null $customer_id Customer ID (optional)
     * @param  string|null $min_date_created Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_created Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  bool|null $is_flagged If the message is [flagged](https://support.bigcommerce.com/s/article/Communicating-with-Customers#Messages). (optional)
     * @param  string|null $status Status of the order message. (optional)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderMessages'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\OrdersV2\Model\OrderMessagesInner[]
     */
    public function getOrderMessages($order_id, $min_id = null, $max_id = null, $customer_id = null, $min_date_created = null, $max_date_created = null, $is_flagged = null, $status = null, $page = null, $limit = null, string $contentType = self::contentTypes['getOrderMessages'][0])
    {
        list($response) = $this->getOrderMessagesWithHttpInfo($order_id, $min_id, $max_id, $customer_id, $min_date_created, $max_date_created, $is_flagged, $status, $page, $limit, $contentType);
        return $response;
    }

    /**
     * Operation getOrderMessagesWithHttpInfo
     *
     * Get Order Messages
     *
     * @param  int $order_id ID of the order (required)
     * @param  int|null $min_id The minimum order ID. (optional)
     * @param  int|null $max_id The maximum order ID. (optional)
     * @param  int|null $customer_id Customer ID (optional)
     * @param  string|null $min_date_created Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_created Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  bool|null $is_flagged If the message is [flagged](https://support.bigcommerce.com/s/article/Communicating-with-Customers#Messages). (optional)
     * @param  string|null $status Status of the order message. (optional)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderMessages'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\OrdersV2\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\OrdersV2\Model\OrderMessagesInner[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrderMessagesWithHttpInfo($order_id, $min_id = null, $max_id = null, $customer_id = null, $min_date_created = null, $max_date_created = null, $is_flagged = null, $status = null, $page = null, $limit = null, string $contentType = self::contentTypes['getOrderMessages'][0])
    {
        $request = $this->getOrderMessagesRequest($order_id, $min_id, $max_id, $customer_id, $min_date_created, $max_date_created, $is_flagged, $status, $page, $limit, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\OrdersV2\Model\OrderMessagesInner[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\OrdersV2\Model\OrderMessagesInner[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\OrdersV2\Model\OrderMessagesInner[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getOrderMessagesAsync
     *
     * Get Order Messages
     *
     * @param  int $order_id ID of the order (required)
     * @param  int|null $min_id The minimum order ID. (optional)
     * @param  int|null $max_id The maximum order ID. (optional)
     * @param  int|null $customer_id Customer ID (optional)
     * @param  string|null $min_date_created Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_created Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  bool|null $is_flagged If the message is [flagged](https://support.bigcommerce.com/s/article/Communicating-with-Customers#Messages). (optional)
     * @param  string|null $status Status of the order message. (optional)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderMessages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderMessagesAsync($order_id, $min_id = null, $max_id = null, $customer_id = null, $min_date_created = null, $max_date_created = null, $is_flagged = null, $status = null, $page = null, $limit = null, string $contentType = self::contentTypes['getOrderMessages'][0])
    {
        return $this->getOrderMessagesAsyncWithHttpInfo($order_id, $min_id, $max_id, $customer_id, $min_date_created, $max_date_created, $is_flagged, $status, $page, $limit, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrderMessagesAsyncWithHttpInfo
     *
     * Get Order Messages
     *
     * @param  int $order_id ID of the order (required)
     * @param  int|null $min_id The minimum order ID. (optional)
     * @param  int|null $max_id The maximum order ID. (optional)
     * @param  int|null $customer_id Customer ID (optional)
     * @param  string|null $min_date_created Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_created Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  bool|null $is_flagged If the message is [flagged](https://support.bigcommerce.com/s/article/Communicating-with-Customers#Messages). (optional)
     * @param  string|null $status Status of the order message. (optional)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderMessages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrderMessagesAsyncWithHttpInfo($order_id, $min_id = null, $max_id = null, $customer_id = null, $min_date_created = null, $max_date_created = null, $is_flagged = null, $status = null, $page = null, $limit = null, string $contentType = self::contentTypes['getOrderMessages'][0])
    {
        $returnType = '\Bigcommerce\OrdersV2\Model\OrderMessagesInner[]';
        $request = $this->getOrderMessagesRequest($order_id, $min_id, $max_id, $customer_id, $min_date_created, $max_date_created, $is_flagged, $status, $page, $limit, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrderMessages'
     *
     * @param  int $order_id ID of the order (required)
     * @param  int|null $min_id The minimum order ID. (optional)
     * @param  int|null $max_id The maximum order ID. (optional)
     * @param  int|null $customer_id Customer ID (optional)
     * @param  string|null $min_date_created Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  string|null $max_date_created Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; (optional)
     * @param  bool|null $is_flagged If the message is [flagged](https://support.bigcommerce.com/s/article/Communicating-with-Customers#Messages). (optional)
     * @param  string|null $status Status of the order message. (optional)
     * @param  float|null $page The page to return in the response. (optional)
     * @param  float|null $limit Number of results to return. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrderMessages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrderMessagesRequest($order_id, $min_id = null, $max_id = null, $customer_id = null, $min_date_created = null, $max_date_created = null, $is_flagged = null, $status = null, $page = null, $limit = null, string $contentType = self::contentTypes['getOrderMessages'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling getOrderMessages'
            );
        }











        $resourcePath = '/orders/{order_id}/messages';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $min_id,
            'min_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $max_id,
            'max_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_id,
            'customer_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $min_date_created,
            'min_date_created', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $max_date_created,
            'max_date_created', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_flagged,
            'is_flagged', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status,
            'status', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
