# Bigcommerce\OrdersV2\OrdersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createAnOrder()**](OrdersApi.md#createAnOrder) | **POST** /orders | Create an Order |
| [**deleteAllOrders()**](OrdersApi.md#deleteAllOrders) | **DELETE** /orders | Delete All Orders |
| [**deleteAnOrder()**](OrdersApi.md#deleteAnOrder) | **DELETE** /orders/{order_id} | Archive an Order |
| [**getAllOrders()**](OrdersApi.md#getAllOrders) | **GET** /orders | Get All Orders |
| [**getAnOrder()**](OrdersApi.md#getAnOrder) | **GET** /orders/{order_id} | Get an Order |
| [**getCountOrder()**](OrdersApi.md#getCountOrder) | **GET** /orders/count | Get a Count of Orders |
| [**updateAnOrder()**](OrdersApi.md#updateAnOrder) | **PUT** /orders/{order_id} | Update an Order |


## `createAnOrder()`

```php
createAnOrder($order_post): \Bigcommerce\OrdersV2\Model\OrderResp
```

Create an Order

Creates an *Order*. To learn more about creating or updating orders, see [Orders Overview](/api-docs/orders/orders-api-overview).  An order can be created with an existing catalog product or a custom product.  **Required Fields**  *   products *   billing_address

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_post = {"billing_address":{"first_name":"Jane","last_name":"Doe","street_1":"123 Main Street","city":"Austin","state":"Texas","zip":"78751","country":"United States","country_iso2":"US","email":"janedoe@email.com"},"products":[{"name":"BigCommerce Coffee Mug","quantity":1,"price_inc_tax":50,"price_ex_tax":45}]}; // \Bigcommerce\OrdersV2\Model\OrderPost

try {
    $result = $apiInstance->createAnOrder($order_post);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->createAnOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_post** | [**\Bigcommerce\OrdersV2\Model\OrderPost**](../Model/OrderPost.md)|  | |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderResp**](../Model/OrderResp.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteAllOrders()`

```php
deleteAllOrders()
```

Delete All Orders

Archives all orders.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $apiInstance->deleteAllOrders();
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->deleteAllOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteAnOrder()`

```php
deleteAnOrder($order_id)
```

Archive an Order

Archives an order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order

try {
    $apiInstance->deleteAnOrder($order_id);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->deleteAnOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllOrders()`

```php
getAllOrders($min_id, $max_id, $min_total, $max_total, $customer_id, $email, $status_id, $cart_id, $payment_method, $min_date_created, $max_date_created, $min_date_modified, $max_date_modified, $page, $limit, $sort, $is_deleted, $channel_id): \Bigcommerce\OrdersV2\Model\OrderResp[]
```

Get All Orders

Gets a list of orders using the filter query.  **Notes**  The default sort is by order id, from lowest to highest.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$min_id = 56; // int | The minimum order ID.
$max_id = 56; // int | The maximum order ID.
$min_total = 3.4; // float | The minimum order total in float format. eg. 12.50
$max_total = 3.4; // float | The maximum order total in float format. eg. 12.50
$customer_id = 56; // int | Customer ID
$email = 'email_example'; // string | The email of the customer.
$status_id = 56; // int | The staus ID of the order. You can get the status id from the `/orders` endpoints.
$cart_id = 'cart_id_example'; // string | The cart ID of the order.
$payment_method = 'payment_method_example'; // string | The payment method used on the order.
$min_date_created = 'min_date_created_example'; // string | Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: `Thu, 20 Apr 2017 11:32:00 -0400`  ISO-8601: `2017-04-20T11:32:00.000-04:00`
$max_date_created = 'max_date_created_example'; // string | Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: `Thu, 20 Apr 2017 11:32:00 -0400`  ISO-8601: `2017-04-20T11:32:00.000-04:00`
$min_date_modified = 'min_date_modified_example'; // string | Minimum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: `Thu, 20 Apr 2017 11:32:00 -0400`  ISO-8601: `2017-04-20T11:32:00.000-04:00`
$max_date_modified = 'max_date_modified_example'; // string | Maximum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: `Thu, 20 Apr 2017 11:32:00 -0400`  ISO-8601: `2017-04-20T11:32:00.000-04:00`
$page = 3.4; // float | The page to return in the response.
$limit = 3.4; // float | Number of results to return.
$sort = 'sort_example'; // string | Field and direction to sort orders. To specify the direction, add `:asc` or `:desc` to the end of the query parameter. E.g. `sort=date_created:desc`.
$is_deleted = True; // bool | If the order was deleted or archived.
$channel_id = 56; // int | The Channel ID of the Order.

try {
    $result = $apiInstance->getAllOrders($min_id, $max_id, $min_total, $max_total, $customer_id, $email, $status_id, $cart_id, $payment_method, $min_date_created, $max_date_created, $min_date_modified, $max_date_modified, $page, $limit, $sort, $is_deleted, $channel_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getAllOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **min_id** | **int**| The minimum order ID. | [optional] |
| **max_id** | **int**| The maximum order ID. | [optional] |
| **min_total** | **float**| The minimum order total in float format. eg. 12.50 | [optional] |
| **max_total** | **float**| The maximum order total in float format. eg. 12.50 | [optional] |
| **customer_id** | **int**| Customer ID | [optional] |
| **email** | **string**| The email of the customer. | [optional] |
| **status_id** | **int**| The staus ID of the order. You can get the status id from the &#x60;/orders&#x60; endpoints. | [optional] |
| **cart_id** | **string**| The cart ID of the order. | [optional] |
| **payment_method** | **string**| The payment method used on the order. | [optional] |
| **min_date_created** | **string**| Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; | [optional] |
| **max_date_created** | **string**| Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; | [optional] |
| **min_date_modified** | **string**| Minimum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; | [optional] |
| **max_date_modified** | **string**| Maximum date the order was modified in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; | [optional] |
| **page** | **float**| The page to return in the response. | [optional] |
| **limit** | **float**| Number of results to return. | [optional] |
| **sort** | **string**| Field and direction to sort orders. To specify the direction, add &#x60;:asc&#x60; or &#x60;:desc&#x60; to the end of the query parameter. E.g. &#x60;sort&#x3D;date_created:desc&#x60;. | [optional] |
| **is_deleted** | **bool**| If the order was deleted or archived. | [optional] |
| **channel_id** | **int**| The Channel ID of the Order. | [optional] |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderResp[]**](../Model/OrderResp.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAnOrder()`

```php
getAnOrder($order_id): \Bigcommerce\OrdersV2\Model\OrderResp
```

Get an Order

Gets an *Order*. To learn more about creating or updating orders, see [Orders Overview](/api-docs/orders/orders-api-overview).

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order

try {
    $result = $apiInstance->getAnOrder($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getAnOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderResp**](../Model/OrderResp.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCountOrder()`

```php
getCountOrder(): \Bigcommerce\OrdersV2\Model\OrdersCountFull
```

Get a Count of Orders

Gets an array of orders in the store organized by order status.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getCountOrder();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->getCountOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Bigcommerce\OrdersV2\Model\OrdersCountFull**](../Model/OrdersCountFull.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateAnOrder()`

```php
updateAnOrder($order_id, $order_put): \Bigcommerce\OrdersV2\Model\OrderResp
```

Update an Order

Updates an *Order*. To learn more about creating or updating orders, see [Orders Overview](/api-docs/orders/orders-api-overview).

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$order_put = {"status_id":0,"customer_id":11,"billing_address":{"first_name":"Jane","last_name":"Doe","street_1":"123 Main Street","city":"Austin","state":"Texas","zip":"78751","country":"United States","country_iso2":"US","email":"janedoe@example.com"},"shipping_addresses":[{"first_name":"Trish","last_name":"Test","company":"Acme Pty Ltd","street_1":"666 Sussex St","city":"Austin","state":"Texas","zip":"78751","country":"United States","country_iso2":"US","email":"elsie@example.com"}],"products":[{"name":"BigCommerce Poster","quantity":1,"price_inc_tax":10.98,"price_ex_tax":10},{"name":"BigCommerce Coffee Mug","quantity":1,"price_inc_tax":50,"price_ex_tax":45},{"product_id":184,"product_options":[{"id":200,"value":"180"},{"id":230,"value":"192"}]}],"customer_locale":"en"}; // \Bigcommerce\OrdersV2\Model\OrderPut

try {
    $result = $apiInstance->updateAnOrder($order_id, $order_put);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrdersApi->updateAnOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **order_put** | [**\Bigcommerce\OrdersV2\Model\OrderPut**](../Model/OrderPut.md)|  | |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderResp**](../Model/OrderResp.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
