# Bigcommerce\OrdersV2\OrderTaxesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getOrderTaxes()**](OrderTaxesApi.md#getOrderTaxes) | **GET** /orders/{order_id}/taxes | Get All Order Taxes |


## `getOrderTaxes()`

```php
getOrderTaxes($order_id, $page, $limit, $details): \Bigcommerce\OrdersV2\Model\OrderTaxesBase[]
```

Get All Order Taxes

Gets all order taxes using `order_id`. Each tax applied to an order. This information can be useful for reporting purposes. Pass in the query parameter `?details=true` to return extra details about order taxes. `order_product_id` and `line_item_type` are also returned.  All values are read-only.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderTaxesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$page = 3.4; // float | The page to return in the response.
$limit = 3.4; // float | Number of results to return.
$details = 'true'; // string | To return detailed tax information, pass in the details query.

try {
    $result = $apiInstance->getOrderTaxes($order_id, $page, $limit, $details);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderTaxesApi->getOrderTaxes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **page** | **float**| The page to return in the response. | [optional] |
| **limit** | **float**| Number of results to return. | [optional] |
| **details** | **string**| To return detailed tax information, pass in the details query. | [optional] [default to &#39;true&#39;] |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderTaxesBase[]**](../Model/OrderTaxesBase.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
