# Bigcommerce\OrdersV2\OrderShippingAddressesQuotesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getShippingQuotes()**](OrderShippingAddressesQuotesApi.md#getShippingQuotes) | **GET** /orders/{order_id}/shipping_addresses/{shipping_address_id}/shipping_quotes | Get Order Shipping Quotes |


## `getShippingQuotes()`

```php
getShippingQuotes($order_id, $shipping_address_id): \Bigcommerce\OrdersV2\Model\ShippingQuotesBase
```

Get Order Shipping Quotes

Gets all shipping quotes associated to an order.  This is a read only endpoint and the output can vary based on the shipping quote. A shipping quote can only be generated using the storefront at this time. Orders that are created in the control panel or via the API return a 204 for this endpoint since a shipping quote is not generated during that process.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderShippingAddressesQuotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$shipping_address_id = 56; // int | Shipping address ID

try {
    $result = $apiInstance->getShippingQuotes($order_id, $shipping_address_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderShippingAddressesQuotesApi->getShippingQuotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **shipping_address_id** | **int**| Shipping address ID | |

### Return type

[**\Bigcommerce\OrdersV2\Model\ShippingQuotesBase**](../Model/ShippingQuotesBase.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `Fixed Shipping`, `UPS Example`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
