# Bigcommerce\OrdersV2\OrderShippingAddressesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getAShippingAddress()**](OrderShippingAddressesApi.md#getAShippingAddress) | **GET** /orders/{order_id}/shipping_addresses/{id} | Get a Shipping Address |
| [**getAllShippingAddresses()**](OrderShippingAddressesApi.md#getAllShippingAddresses) | **GET** /orders/{order_id}/shipping_addresses | Get Order Shipping Addresses |
| [**updateAShippingAddress()**](OrderShippingAddressesApi.md#updateAShippingAddress) | **PUT** /orders/{order_id}/shipping_addresses/{id} | Update a Shipping Address |


## `getAShippingAddress()`

```php
getAShippingAddress($order_id, $id): \Bigcommerce\OrdersV2\Model\OrderShippingAddress
```

Get a Shipping Address

Gets a shipping address associated with an order.  Returned in the response is shipping_quotes object. Please use the Get Shipping Quotes Endpoint. Using the response will return a 204 for the shipping quote.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderShippingAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$id = 'id_example'; // string

try {
    $result = $apiInstance->getAShippingAddress($order_id, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderShippingAddressesApi->getAShippingAddress: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **id** | **string**|  | |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderShippingAddress**](../Model/OrderShippingAddress.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllShippingAddresses()`

```php
getAllShippingAddresses($order_id, $page, $limit): \Bigcommerce\OrdersV2\Model\OrderShippingAddress[]
```

Get Order Shipping Addresses

Get all shipping addresses on an order using the `order_id`.  Returned in the response is shipping_quotes object. Please use the Get Shipping Quotes Endpoint. Using the response will return a 204 for the shipping quote.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderShippingAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$page = 3.4; // float | The page to return in the response.
$limit = 3.4; // float | Number of results to return.

try {
    $result = $apiInstance->getAllShippingAddresses($order_id, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderShippingAddressesApi->getAllShippingAddresses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **page** | **float**| The page to return in the response. | [optional] |
| **limit** | **float**| Number of results to return. | [optional] |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderShippingAddress[]**](../Model/OrderShippingAddress.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateAShippingAddress()`

```php
updateAShippingAddress($order_id, $id, $shipping_address_base): \Bigcommerce\OrdersV2\Model\OrderShippingAddress
```

Update a Shipping Address

Update a shipping address associated with an order.  **Note**: Updating will NOT trigger the recalculation of shipping cost and tax

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderShippingAddressesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$id = 'id_example'; // string
$shipping_address_base = {"first_name":"first","last_name":"last","company":"company","street_1":"street 1","street_2":"street 2","city":"Sydney","zip":"2000","country":"Australia","country_iso2":"AU","state":"New South Wales","email":"email2@bigcommerce.com","phone":468444123}; // \Bigcommerce\OrdersV2\Model\ShippingAddressBase

try {
    $result = $apiInstance->updateAShippingAddress($order_id, $id, $shipping_address_base);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderShippingAddressesApi->updateAShippingAddress: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **id** | **string**|  | |
| **shipping_address_base** | [**\Bigcommerce\OrdersV2\Model\ShippingAddressBase**](../Model/ShippingAddressBase.md)|  | [optional] |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderShippingAddress**](../Model/OrderShippingAddress.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
