# Bigcommerce\OrdersV2\OrderShipmentsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createOrderShipments()**](OrderShipmentsApi.md#createOrderShipments) | **POST** /orders/{order_id}/shipments | Create Order Shipment&#39; |
| [**deleteAllOrderShipments()**](OrderShipmentsApi.md#deleteAllOrderShipments) | **DELETE** /orders/{order_id}/shipments | Delete Order Shipments |
| [**deleteOrderShipment()**](OrderShipmentsApi.md#deleteOrderShipment) | **DELETE** /orders/{order_id}/shipments/{shipment_id} | Delete an Order Shipment |
| [**getAllOrderShipments()**](OrderShipmentsApi.md#getAllOrderShipments) | **GET** /orders/{order_id}/shipments | Get Order Shipments |
| [**getCountShipments()**](OrderShipmentsApi.md#getCountShipments) | **GET** /orders/{order_id}/shipments/count | Get Count of Order Shipments |
| [**getOrderShipment()**](OrderShipmentsApi.md#getOrderShipment) | **GET** /orders/{order_id}/shipments/{shipment_id} | Get a Shipment |
| [**updateOrderShipment()**](OrderShipmentsApi.md#updateOrderShipment) | **PUT** /orders/{order_id}/shipments/{shipment_id} | Update a Shipment |


## `createOrderShipments()`

```php
createOrderShipments($order_id, $order_shipment_post): \Bigcommerce\OrdersV2\Model\OrderShipment
```

Create Order Shipment'

Creates an *Order Shipment*. For more details, see [Shipping an Order](/api-docs/orders/orders-api-overview#shipping-an-order).  **Required Fields** *   order_address_id *   items  **Usage Notes**  Presuming that a valid carrier code is used, a tracking link is generated if either `shipping_provider` or `tracking_carrier` is supplied alongside a tracking number. Providing only the tracking number will result in an unclickable text in the customer facing email.  Acceptable values for `shipping_provider` include an empty string (`\"\"`), auspost, canadapost, endicia, usps, fedex, ups, upsready, upsonline, or shipperhq.  Acceptable values for `tracking_carrier` include an empty string (`\"\"`) or one of the valid tracking-carrier values viewable [here](https://github.com/bigcommerce/dev-docs/blob/development/assets/csv/tracking_carrier_values.csv) and downloadable as a .CSV file [here](https://raw.githubusercontent.com/bigcommerce/dev-docs/development/assets/csv/tracking_carrier_values.csv).

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$order_shipment_post = {"tracking_number":"EJ958083578UK","comments":"Janes Order","order_address_id":"128","shipping_provider":"","items":[{"order_product_id":194,"product_id":0,"quantity":1},{"order_product_id":195,"product_id":0,"quantity":1}]}; // \Bigcommerce\OrdersV2\Model\OrderShipmentPost

try {
    $result = $apiInstance->createOrderShipments($order_id, $order_shipment_post);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderShipmentsApi->createOrderShipments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **order_shipment_post** | [**\Bigcommerce\OrdersV2\Model\OrderShipmentPost**](../Model/OrderShipmentPost.md)|  | |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderShipment**](../Model/OrderShipment.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteAllOrderShipments()`

```php
deleteAllOrderShipments($order_id)
```

Delete Order Shipments

Deletes all shipments associated with an order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order

try {
    $apiInstance->deleteAllOrderShipments($order_id);
} catch (Exception $e) {
    echo 'Exception when calling OrderShipmentsApi->deleteAllOrderShipments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteOrderShipment()`

```php
deleteOrderShipment($order_id, $shipment_id)
```

Delete an Order Shipment

Deletes a shipment associated with an order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$shipment_id = 56; // int | Shipment ID

try {
    $apiInstance->deleteOrderShipment($order_id, $shipment_id);
} catch (Exception $e) {
    echo 'Exception when calling OrderShipmentsApi->deleteOrderShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **shipment_id** | **int**| Shipment ID | |

### Return type

void (empty response body)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllOrderShipments()`

```php
getAllOrderShipments($order_id, $page, $limit): \Bigcommerce\OrdersV2\Model\OrderShipment[]
```

Get Order Shipments

Gets a list of all shipments on an order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$page = 3.4; // float | The page to return in the response.
$limit = 3.4; // float | Number of results to return.

try {
    $result = $apiInstance->getAllOrderShipments($order_id, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderShipmentsApi->getAllOrderShipments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **page** | **float**| The page to return in the response. | [optional] |
| **limit** | **float**| Number of results to return. | [optional] |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderShipment[]**](../Model/OrderShipment.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCountShipments()`

```php
getCountShipments($order_id): \Bigcommerce\OrdersV2\Model\OrderCount
```

Get Count of Order Shipments

Gets a count of the number of shipments that have been made for a single order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order

try {
    $result = $apiInstance->getCountShipments($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderShipmentsApi->getCountShipments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderCount**](../Model/OrderCount.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderShipment()`

```php
getOrderShipment($order_id, $shipment_id): \Bigcommerce\OrdersV2\Model\OrderShipment
```

Get a Shipment

Gets an order shipment.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$shipment_id = 56; // int | Shipment ID

try {
    $result = $apiInstance->getOrderShipment($order_id, $shipment_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderShipmentsApi->getOrderShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **shipment_id** | **int**| Shipment ID | |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderShipment**](../Model/OrderShipment.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateOrderShipment()`

```php
updateOrderShipment($order_id, $shipment_id, $order_shipment_put): \Bigcommerce\OrdersV2\Model\OrderShipment
```

Update a Shipment

Updates an existing shipment associated with an order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$shipment_id = 56; // int | Shipment ID
$order_shipment_put = {"tracking_number":"EJ958083578US","order_address_id":1,"shipping_provider":"","items":[{"order_product_id":15,"quantity":2}]}; // \Bigcommerce\OrdersV2\Model\OrderShipmentPut

try {
    $result = $apiInstance->updateOrderShipment($order_id, $shipment_id, $order_shipment_put);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderShipmentsApi->updateOrderShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **shipment_id** | **int**| Shipment ID | |
| **order_shipment_put** | [**\Bigcommerce\OrdersV2\Model\OrderShipmentPut**](../Model/OrderShipmentPut.md)|  | |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderShipment**](../Model/OrderShipment.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
