# Bigcommerce\OrdersV2\OrderProductsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getAllOrderProducts()**](OrderProductsApi.md#getAllOrderProducts) | **GET** /orders/{order_id}/products | List Order Products |
| [**getAnOrderProduct()**](OrderProductsApi.md#getAnOrderProduct) | **GET** /orders/{order_id}/products/{product_id} | Get an Order Product |


## `getAllOrderProducts()`

```php
getAllOrderProducts($order_id, $page, $limit): \Bigcommerce\OrdersV2\Model\OrderProducts[]
```

List Order Products

Lists all order products on an order using `order_id`. By default, items sort from lowest to highest according to a newly created ID, separate from the `order_id` and the `product_id`.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$page = 3.4; // float | The page to return in the response.
$limit = 3.4; // float | Number of results to return.

try {
    $result = $apiInstance->getAllOrderProducts($order_id, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderProductsApi->getAllOrderProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **page** | **float**| The page to return in the response. | [optional] |
| **limit** | **float**| Number of results to return. | [optional] |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderProducts[]**](../Model/OrderProducts.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAnOrderProduct()`

```php
getAnOrderProduct($order_id, $product_id): \Bigcommerce\OrdersV2\Model\OrderProducts
```

Get an Order Product

Gets a product line item associated with the order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$product_id = 56; // int | ID of the product

try {
    $result = $apiInstance->getAnOrderProduct($order_id, $product_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderProductsApi->getAnOrderProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **product_id** | **int**| ID of the product | |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderProducts**](../Model/OrderProducts.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
