# Bigcommerce\OrdersV2\OrderMessagesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getOrderMessages()**](OrderMessagesApi.md#getOrderMessages) | **GET** /orders/{order_id}/messages | Get Order Messages |


## `getOrderMessages()`

```php
getOrderMessages($order_id, $min_id, $max_id, $customer_id, $min_date_created, $max_date_created, $is_flagged, $status, $page, $limit): \Bigcommerce\OrdersV2\Model\OrderMessagesInner[]
```

Get Order Messages

Gets the messages associated with an order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderMessagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$min_id = 56; // int | The minimum order ID.
$max_id = 56; // int | The maximum order ID.
$customer_id = 56; // int | Customer ID
$min_date_created = 'min_date_created_example'; // string | Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: `Thu, 20 Apr 2017 11:32:00 -0400`  ISO-8601: `2017-04-20T11:32:00.000-04:00`
$max_date_created = 'max_date_created_example'; // string | Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: `Thu, 20 Apr 2017 11:32:00 -0400`  ISO-8601: `2017-04-20T11:32:00.000-04:00`
$is_flagged = True; // bool | If the message is [flagged](https://support.bigcommerce.com/s/article/Communicating-with-Customers#Messages).
$status = 'status_example'; // string | Status of the order message.
$page = 3.4; // float | The page to return in the response.
$limit = 3.4; // float | Number of results to return.

try {
    $result = $apiInstance->getOrderMessages($order_id, $min_id, $max_id, $customer_id, $min_date_created, $max_date_created, $is_flagged, $status, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderMessagesApi->getOrderMessages: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **min_id** | **int**| The minimum order ID. | [optional] |
| **max_id** | **int**| The maximum order ID. | [optional] |
| **customer_id** | **int**| Customer ID | [optional] |
| **min_date_created** | **string**| Minimum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; | [optional] |
| **max_date_created** | **string**| Maximum date the order was created in RFC-2822 or ISO-8601.  RFC-2822: &#x60;Thu, 20 Apr 2017 11:32:00 -0400&#x60;  ISO-8601: &#x60;2017-04-20T11:32:00.000-04:00&#x60; | [optional] |
| **is_flagged** | **bool**| If the message is [flagged](https://support.bigcommerce.com/s/article/Communicating-with-Customers#Messages). | [optional] |
| **status** | **string**| Status of the order message. | [optional] |
| **page** | **float**| The page to return in the response. | [optional] |
| **limit** | **float**| Number of results to return. | [optional] |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderMessagesInner[]**](../Model/OrderMessagesInner.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
