# Bigcommerce\OrdersV2\OrderCouponsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getAllOrderCoupons()**](OrderCouponsApi.md#getAllOrderCoupons) | **GET** /orders/{order_id}/coupons | List Order Coupons |


## `getAllOrderCoupons()`

```php
getAllOrderCoupons($order_id, $page, $limit): \Bigcommerce\OrdersV2\Model\OrderCouponsBase[]
```

List Order Coupons

Lists all order coupons. Optional parameters can be passed in.  |Type `int`|Type Name| |-|-| |`0`|`per_item_discount`| |`1`|`percentage_discount`| |`2`|`per_total_discount`| |`3`|`shipping_discount`| |`4`|`free_shipping`| |`5`|`promotion`|

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderCouponsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$page = 3.4; // float | The page to return in the response.
$limit = 3.4; // float | Number of results to return.

try {
    $result = $apiInstance->getAllOrderCoupons($order_id, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderCouponsApi->getAllOrderCoupons: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**| ID of the order | |
| **page** | **float**| The page to return in the response. | [optional] |
| **limit** | **float**| Number of results to return. | [optional] |

### Return type

[**\Bigcommerce\OrdersV2\Model\OrderCouponsBase[]**](../Model/OrderCouponsBase.md)

### Authorization

[X-Auth-Token](../../README.md#X-Auth-Token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
