# OpenAPIClient-php

Manage order coupons, messages, products, shipping addresses, statuses, taxes, shipments, and shipping address quotes.

- [Authentication](#authentication)
- [Order](#order)

## Authentication

Authenticate requests by including an [OAuth](https://developer.bigcommerce.com/api-docs/getting-started/authentication) `access_token` request header.

```http
GET https://api.bigcommerce.com/stores/{{STORE_HASH}}/v3/{{ENDPOINT}}
Content-Type: application/json
X-Auth-Token: {{ACCESS_TOKEN}}
```

### OAuth Scopes

|  **UI Name** | **Permission** | **Parameter** |
| --- | --- | --- |
|  Orders | modify | `store_v2_orders` |
|  Orders | read-only | `store_v2_orders_read_only` |


## Order

The Order object contains a record of the purchase agreement between a shopper and a merchant. To learn more about creating orders, see [Orders API Guide](/api-docs/orders/orders-api-overview).

### Currency Fields

The **default** currency refers to the transactional currency which is the currency the shopper pays in.

The **display** currency refers to the presentational currency used to present prices to the shopper on the storefront.

* `currency_id` - the display currency ID. Depending on the currency selected, the value may be different from the transactional currency.
* `currency_code` - the currency code of the display currency used to present prices to the shopper on the storefront. Depending on the currency selected, the value may be different from the transactional currency.
* `currency_exchange_rate` - the exchange rate between the store's default currency and the display currency. For orders created using the V2 endpoints, this value is always 1 (only in the storefront this value can be different to 1).
* `default_currency_id` - the transactional currency ID.
* `default_currency_code` - the currency code of the transactional currency the shopper pays in.

The following additional fields are returned on orders when Multi-Currency is enabled on the store:

* `store_default_currency_code` - the currency code of the store's default currency.
* `store_default_to_transactional_exchange_rate` - the exchange rate between the store's default currency and the transactional currency used in the order.

**Example:**

```json
{
  ...
  \"currency_id\": 4,
  \"currency_code\": \"EUR\",
  \"currency_exchange_rate\": 1,
  \"default_currency_id\": 4,
  \"default_currency_code\": \"EUR\",
  \"store_default_currency_code\": \"USD\",
  \"store_default_to_transactional_exchange_rate\": \"100.0000000000\"
  ...
}
```


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/bigcommerce.git"
    }
  ],
  "require": {
    "talisman/bigcommerce": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: X-Auth-Token
$config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKey('X-Auth-Token', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Bigcommerce\OrdersV2\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-Auth-Token', 'Bearer');


$apiInstance = new Bigcommerce\OrdersV2\Api\OrderCouponsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | ID of the order
$page = 3.4; // float | The page to return in the response.
$limit = 3.4; // float | Number of results to return.

try {
    $result = $apiInstance->getAllOrderCoupons($order_id, $page, $limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderCouponsApi->getAllOrderCoupons: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OrderCouponsApi* | [**getAllOrderCoupons**](docs/Api/OrderCouponsApi.md#getallordercoupons) | **GET** /orders/{order_id}/coupons | List Order Coupons
*OrderMessagesApi* | [**getOrderMessages**](docs/Api/OrderMessagesApi.md#getordermessages) | **GET** /orders/{order_id}/messages | Get Order Messages
*OrderProductsApi* | [**getAllOrderProducts**](docs/Api/OrderProductsApi.md#getallorderproducts) | **GET** /orders/{order_id}/products | List Order Products
*OrderProductsApi* | [**getAnOrderProduct**](docs/Api/OrderProductsApi.md#getanorderproduct) | **GET** /orders/{order_id}/products/{product_id} | Get an Order Product
*OrderShipmentsApi* | [**createOrderShipments**](docs/Api/OrderShipmentsApi.md#createordershipments) | **POST** /orders/{order_id}/shipments | Create Order Shipment&#39;
*OrderShipmentsApi* | [**deleteAllOrderShipments**](docs/Api/OrderShipmentsApi.md#deleteallordershipments) | **DELETE** /orders/{order_id}/shipments | Delete Order Shipments
*OrderShipmentsApi* | [**deleteOrderShipment**](docs/Api/OrderShipmentsApi.md#deleteordershipment) | **DELETE** /orders/{order_id}/shipments/{shipment_id} | Delete an Order Shipment
*OrderShipmentsApi* | [**getAllOrderShipments**](docs/Api/OrderShipmentsApi.md#getallordershipments) | **GET** /orders/{order_id}/shipments | Get Order Shipments
*OrderShipmentsApi* | [**getCountShipments**](docs/Api/OrderShipmentsApi.md#getcountshipments) | **GET** /orders/{order_id}/shipments/count | Get Count of Order Shipments
*OrderShipmentsApi* | [**getOrderShipment**](docs/Api/OrderShipmentsApi.md#getordershipment) | **GET** /orders/{order_id}/shipments/{shipment_id} | Get a Shipment
*OrderShipmentsApi* | [**updateOrderShipment**](docs/Api/OrderShipmentsApi.md#updateordershipment) | **PUT** /orders/{order_id}/shipments/{shipment_id} | Update a Shipment
*OrderShippingAddressesApi* | [**getAShippingAddress**](docs/Api/OrderShippingAddressesApi.md#getashippingaddress) | **GET** /orders/{order_id}/shipping_addresses/{id} | Get a Shipping Address
*OrderShippingAddressesApi* | [**getAllShippingAddresses**](docs/Api/OrderShippingAddressesApi.md#getallshippingaddresses) | **GET** /orders/{order_id}/shipping_addresses | Get Order Shipping Addresses
*OrderShippingAddressesApi* | [**updateAShippingAddress**](docs/Api/OrderShippingAddressesApi.md#updateashippingaddress) | **PUT** /orders/{order_id}/shipping_addresses/{id} | Update a Shipping Address
*OrderShippingAddressesQuotesApi* | [**getShippingQuotes**](docs/Api/OrderShippingAddressesQuotesApi.md#getshippingquotes) | **GET** /orders/{order_id}/shipping_addresses/{shipping_address_id}/shipping_quotes | Get Order Shipping Quotes
*OrderStatusApi* | [**getAOrderStatus**](docs/Api/OrderStatusApi.md#getaorderstatus) | **GET** /order_statuses/{status_id} | Get a Single Order Status by Id
*OrderStatusApi* | [**getOrderStatus**](docs/Api/OrderStatusApi.md#getorderstatus) | **GET** /order_statuses | Get All Order Statuses
*OrderTaxesApi* | [**getOrderTaxes**](docs/Api/OrderTaxesApi.md#getordertaxes) | **GET** /orders/{order_id}/taxes | Get All Order Taxes
*OrdersApi* | [**createAnOrder**](docs/Api/OrdersApi.md#createanorder) | **POST** /orders | Create an Order
*OrdersApi* | [**deleteAllOrders**](docs/Api/OrdersApi.md#deleteallorders) | **DELETE** /orders | Delete All Orders
*OrdersApi* | [**deleteAnOrder**](docs/Api/OrdersApi.md#deleteanorder) | **DELETE** /orders/{order_id} | Archive an Order
*OrdersApi* | [**getAllOrders**](docs/Api/OrdersApi.md#getallorders) | **GET** /orders | Get All Orders
*OrdersApi* | [**getAnOrder**](docs/Api/OrdersApi.md#getanorder) | **GET** /orders/{order_id} | Get an Order
*OrdersApi* | [**getCountOrder**](docs/Api/OrdersApi.md#getcountorder) | **GET** /orders/count | Get a Count of Orders
*OrdersApi* | [**updateAnOrder**](docs/Api/OrdersApi.md#updateanorder) | **PUT** /orders/{order_id} | Update an Order

## Models

- [BillingAddressBase](docs/Model/BillingAddressBase.md)
- [BillingAddressFull](docs/Model/BillingAddressFull.md)
- [CouponsResource](docs/Model/CouponsResource.md)
- [FormFields](docs/Model/FormFields.md)
- [OrderCatalogProductPost](docs/Model/OrderCatalogProductPost.md)
- [OrderCatalogProductPostProductOptionsInner](docs/Model/OrderCatalogProductPostProductOptionsInner.md)
- [OrderCatalogProductPut](docs/Model/OrderCatalogProductPut.md)
- [OrderCount](docs/Model/OrderCount.md)
- [OrderCouponsBase](docs/Model/OrderCouponsBase.md)
- [OrderCustomProductPost](docs/Model/OrderCustomProductPost.md)
- [OrderCustomProductPut](docs/Model/OrderCustomProductPut.md)
- [OrderMessagesInner](docs/Model/OrderMessagesInner.md)
- [OrderPost](docs/Model/OrderPost.md)
- [OrderPostAllOfProducts](docs/Model/OrderPostAllOfProducts.md)
- [OrderProductAppliedDiscounts](docs/Model/OrderProductAppliedDiscounts.md)
- [OrderProductOptions](docs/Model/OrderProductOptions.md)
- [OrderProducts](docs/Model/OrderProducts.md)
- [OrderPut](docs/Model/OrderPut.md)
- [OrderResp](docs/Model/OrderResp.md)
- [OrderRespOnly](docs/Model/OrderRespOnly.md)
- [OrderShared](docs/Model/OrderShared.md)
- [OrderShipment](docs/Model/OrderShipment.md)
- [OrderShipmentItemsInner](docs/Model/OrderShipmentItemsInner.md)
- [OrderShipmentPost](docs/Model/OrderShipmentPost.md)
- [OrderShipmentPostItemsInner](docs/Model/OrderShipmentPostItemsInner.md)
- [OrderShipmentPut](docs/Model/OrderShipmentPut.md)
- [OrderShippingAddress](docs/Model/OrderShippingAddress.md)
- [OrderStatusBase](docs/Model/OrderStatusBase.md)
- [OrderTaxesBase](docs/Model/OrderTaxesBase.md)
- [OrdersCountFull](docs/Model/OrdersCountFull.md)
- [OrdersCountStatus](docs/Model/OrdersCountStatus.md)
- [ProductsResource](docs/Model/ProductsResource.md)
- [ShippingAddressBase](docs/Model/ShippingAddressBase.md)
- [ShippingAddressesResource](docs/Model/ShippingAddressesResource.md)
- [ShippingQuotesBase](docs/Model/ShippingQuotesBase.md)
- [ShippingQuotesResource](docs/Model/ShippingQuotesResource.md)
- [UpdateAShippingAddress400ResponseInner](docs/Model/UpdateAShippingAddress400ResponseInner.md)

## Authorization

Authentication schemes defined for the API:
### X-Auth-Token

- **Type**: API key
- **API key parameter name**: X-Auth-Token
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: ``
    - Package version: `2`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
