# OpenAPIClient-php

Read form fields on a BigCommerce hosted storefront.

For info about API accounts, see our [Guide to API Accounts](/docs/start/authentication/api-accounts).

For info about authenticating BigCommerce APIs, see [Authentication and Example Requests](/docs/start/authentication#same-origin-cors-authentication).

> #### Warning
> Breaking changes may be introduced to this endpoint while in beta.


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/bigcommerce.git"
    }
  ],
  "require": {
    "talisman/bigcommerce": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Bigcommerce\StorefrontFormFields\Api\FormFieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$filter = 'filter_example'; // string

try {
    $result = $apiInstance->getFormFields($filter);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FormFieldsApi->getFormFields: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://your_store.example.com/api/storefront*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*FormFieldsApi* | [**getFormFields**](docs/Api/FormFieldsApi.md#getformfields) | **GET** /form-fields | Get Form Fields

## Models

- [FormField](docs/Model/FormField.md)
- [FormFieldGroups](docs/Model/FormFieldGroups.md)
- [FormFieldOptions](docs/Model/FormFieldOptions.md)
- [FormFieldOptionsItemsInner](docs/Model/FormFieldOptionsItemsInner.md)

## Authorization
Endpoints do not require authorization.

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: ``
    - Package version: `3`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
