<?php
/**
 * CustomerFull
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Customers V3
 *
 * Create and manage customers.  - [Authentication](#authentication) - [Resources](#resources)  ## Authentication  Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes  | UI Name                                      | Permission | Parameter                                     | |----------------------------------------------|------------|-----------------------------------------------| | Customers                                    | modify     | `store_v2_customers`                          | | Customers                                    | read-only  | `store_v2_customers_read_only`                |  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Resources * [Customer and Subscribers Overview](/api-docs/customers/customers-subscribers-overview).
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CustomersV3\Model;

use \ArrayAccess;
use \Bigcommerce\CustomersV3\ObjectSerializer;

/**
 * CustomerFull Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CustomerFull implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'customer_Full';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'email' => 'string',
        'first_name' => 'string',
        'last_name' => 'string',
        'company' => 'string',
        'phone' => 'string',
        'registration_ip_address' => 'string',
        'notes' => 'string',
        'tax_exempt_category' => 'string',
        'customer_group_id' => 'int',
        'id' => 'int',
        'date_modified' => '\DateTime',
        'date_created' => '\DateTime',
        'address_count' => 'int',
        'attribute_count' => 'int',
        'authentication' => '\Bigcommerce\CustomersV3\Model\CustomerAuthenticationBase',
        'addresses' => '\Bigcommerce\CustomersV3\Model\AddressFull[]',
        'attributes' => '\Bigcommerce\CustomersV3\Model\AttributeFull[]',
        'form_fields' => '\Bigcommerce\CustomersV3\Model\FormFieldValueFull[]',
        'store_credit_amounts' => '\Bigcommerce\CustomersV3\Model\CustomerStoredCreditAmountsInner[]',
        'accepts_product_review_abandoned_cart_emails' => 'bool',
        'channel_ids' => 'int[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'email' => null,
        'first_name' => null,
        'last_name' => null,
        'company' => null,
        'phone' => null,
        'registration_ip_address' => null,
        'notes' => null,
        'tax_exempt_category' => null,
        'customer_group_id' => 'int32',
        'id' => 'int32',
        'date_modified' => 'date-time',
        'date_created' => 'date-time',
        'address_count' => 'int32',
        'attribute_count' => 'int32',
        'authentication' => null,
        'addresses' => null,
        'attributes' => null,
        'form_fields' => null,
        'store_credit_amounts' => null,
        'accepts_product_review_abandoned_cart_emails' => null,
        'channel_ids' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'email' => false,
        'first_name' => false,
        'last_name' => false,
        'company' => false,
        'phone' => false,
        'registration_ip_address' => false,
        'notes' => false,
        'tax_exempt_category' => false,
        'customer_group_id' => false,
        'id' => false,
        'date_modified' => false,
        'date_created' => false,
        'address_count' => false,
        'attribute_count' => false,
        'authentication' => false,
        'addresses' => false,
        'attributes' => false,
        'form_fields' => false,
        'store_credit_amounts' => false,
        'accepts_product_review_abandoned_cart_emails' => false,
        'channel_ids' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'email' => 'email',
        'first_name' => 'first_name',
        'last_name' => 'last_name',
        'company' => 'company',
        'phone' => 'phone',
        'registration_ip_address' => 'registration_ip_address',
        'notes' => 'notes',
        'tax_exempt_category' => 'tax_exempt_category',
        'customer_group_id' => 'customer_group_id',
        'id' => 'id',
        'date_modified' => 'date_modified',
        'date_created' => 'date_created',
        'address_count' => 'address_count',
        'attribute_count' => 'attribute_count',
        'authentication' => 'authentication',
        'addresses' => 'addresses',
        'attributes' => 'attributes',
        'form_fields' => 'form_fields',
        'store_credit_amounts' => 'store_credit_amounts',
        'accepts_product_review_abandoned_cart_emails' => 'accepts_product_review_abandoned_cart_emails',
        'channel_ids' => 'channel_ids'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'email' => 'setEmail',
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'company' => 'setCompany',
        'phone' => 'setPhone',
        'registration_ip_address' => 'setRegistrationIpAddress',
        'notes' => 'setNotes',
        'tax_exempt_category' => 'setTaxExemptCategory',
        'customer_group_id' => 'setCustomerGroupId',
        'id' => 'setId',
        'date_modified' => 'setDateModified',
        'date_created' => 'setDateCreated',
        'address_count' => 'setAddressCount',
        'attribute_count' => 'setAttributeCount',
        'authentication' => 'setAuthentication',
        'addresses' => 'setAddresses',
        'attributes' => 'setAttributes',
        'form_fields' => 'setFormFields',
        'store_credit_amounts' => 'setStoreCreditAmounts',
        'accepts_product_review_abandoned_cart_emails' => 'setAcceptsProductReviewAbandonedCartEmails',
        'channel_ids' => 'setChannelIds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'email' => 'getEmail',
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'company' => 'getCompany',
        'phone' => 'getPhone',
        'registration_ip_address' => 'getRegistrationIpAddress',
        'notes' => 'getNotes',
        'tax_exempt_category' => 'getTaxExemptCategory',
        'customer_group_id' => 'getCustomerGroupId',
        'id' => 'getId',
        'date_modified' => 'getDateModified',
        'date_created' => 'getDateCreated',
        'address_count' => 'getAddressCount',
        'attribute_count' => 'getAttributeCount',
        'authentication' => 'getAuthentication',
        'addresses' => 'getAddresses',
        'attributes' => 'getAttributes',
        'form_fields' => 'getFormFields',
        'store_credit_amounts' => 'getStoreCreditAmounts',
        'accepts_product_review_abandoned_cart_emails' => 'getAcceptsProductReviewAbandonedCartEmails',
        'channel_ids' => 'getChannelIds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('first_name', $data ?? [], null);
        $this->setIfExists('last_name', $data ?? [], null);
        $this->setIfExists('company', $data ?? [], null);
        $this->setIfExists('phone', $data ?? [], null);
        $this->setIfExists('registration_ip_address', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('tax_exempt_category', $data ?? [], null);
        $this->setIfExists('customer_group_id', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('date_modified', $data ?? [], null);
        $this->setIfExists('date_created', $data ?? [], null);
        $this->setIfExists('address_count', $data ?? [], null);
        $this->setIfExists('attribute_count', $data ?? [], null);
        $this->setIfExists('authentication', $data ?? [], null);
        $this->setIfExists('addresses', $data ?? [], null);
        $this->setIfExists('attributes', $data ?? [], null);
        $this->setIfExists('form_fields', $data ?? [], null);
        $this->setIfExists('store_credit_amounts', $data ?? [], null);
        $this->setIfExists('accepts_product_review_abandoned_cart_emails', $data ?? [], null);
        $this->setIfExists('channel_ids', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['email']) && (mb_strlen($this->container['email']) > 255)) {
            $invalidProperties[] = "invalid value for 'email', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['email']) && (mb_strlen($this->container['email']) < 3)) {
            $invalidProperties[] = "invalid value for 'email', the character length must be bigger than or equal to 3.";
        }

        if (!is_null($this->container['first_name']) && (mb_strlen($this->container['first_name']) > 100)) {
            $invalidProperties[] = "invalid value for 'first_name', the character length must be smaller than or equal to 100.";
        }

        if (!is_null($this->container['first_name']) && (mb_strlen($this->container['first_name']) < 0)) {
            $invalidProperties[] = "invalid value for 'first_name', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['last_name']) && (mb_strlen($this->container['last_name']) > 100)) {
            $invalidProperties[] = "invalid value for 'last_name', the character length must be smaller than or equal to 100.";
        }

        if (!is_null($this->container['last_name']) && (mb_strlen($this->container['last_name']) < 0)) {
            $invalidProperties[] = "invalid value for 'last_name', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['company']) && (mb_strlen($this->container['company']) > 255)) {
            $invalidProperties[] = "invalid value for 'company', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['company']) && (mb_strlen($this->container['company']) < 0)) {
            $invalidProperties[] = "invalid value for 'company', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['phone']) && (mb_strlen($this->container['phone']) > 50)) {
            $invalidProperties[] = "invalid value for 'phone', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['phone']) && (mb_strlen($this->container['phone']) < 0)) {
            $invalidProperties[] = "invalid value for 'phone', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['registration_ip_address']) && (mb_strlen($this->container['registration_ip_address']) > 30)) {
            $invalidProperties[] = "invalid value for 'registration_ip_address', the character length must be smaller than or equal to 30.";
        }

        if (!is_null($this->container['registration_ip_address']) && (mb_strlen($this->container['registration_ip_address']) < 0)) {
            $invalidProperties[] = "invalid value for 'registration_ip_address', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['tax_exempt_category']) && (mb_strlen($this->container['tax_exempt_category']) > 255)) {
            $invalidProperties[] = "invalid value for 'tax_exempt_category', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['tax_exempt_category']) && (mb_strlen($this->container['tax_exempt_category']) < 0)) {
            $invalidProperties[] = "invalid value for 'tax_exempt_category', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['addresses']) && (count($this->container['addresses']) > 10)) {
            $invalidProperties[] = "invalid value for 'addresses', number of items must be less than or equal to 10.";
        }

        if (!is_null($this->container['attributes']) && (count($this->container['attributes']) > 10)) {
            $invalidProperties[] = "invalid value for 'attributes', number of items must be less than or equal to 10.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email The email of the customer. Must be unique.
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        if ((mb_strlen($email) > 255)) {
            throw new \InvalidArgumentException('invalid length for $email when calling CustomerFull., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($email) < 3)) {
            throw new \InvalidArgumentException('invalid length for $email when calling CustomerFull., must be bigger than or equal to 3.');
        }

        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets first_name
     *
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param string|null $first_name The first name of the customer.
     *
     * @return self
     */
    public function setFirstName($first_name)
    {
        if (is_null($first_name)) {
            throw new \InvalidArgumentException('non-nullable first_name cannot be null');
        }
        if ((mb_strlen($first_name) > 100)) {
            throw new \InvalidArgumentException('invalid length for $first_name when calling CustomerFull., must be smaller than or equal to 100.');
        }
        if ((mb_strlen($first_name) < 0)) {
            throw new \InvalidArgumentException('invalid length for $first_name when calling CustomerFull., must be bigger than or equal to 0.');
        }

        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets last_name
     *
     * @return string|null
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param string|null $last_name The last name of the customer.
     *
     * @return self
     */
    public function setLastName($last_name)
    {
        if (is_null($last_name)) {
            throw new \InvalidArgumentException('non-nullable last_name cannot be null');
        }
        if ((mb_strlen($last_name) > 100)) {
            throw new \InvalidArgumentException('invalid length for $last_name when calling CustomerFull., must be smaller than or equal to 100.');
        }
        if ((mb_strlen($last_name) < 0)) {
            throw new \InvalidArgumentException('invalid length for $last_name when calling CustomerFull., must be bigger than or equal to 0.');
        }

        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets company
     *
     * @return string|null
     */
    public function getCompany()
    {
        return $this->container['company'];
    }

    /**
     * Sets company
     *
     * @param string|null $company The company of the customer.
     *
     * @return self
     */
    public function setCompany($company)
    {
        if (is_null($company)) {
            throw new \InvalidArgumentException('non-nullable company cannot be null');
        }
        if ((mb_strlen($company) > 255)) {
            throw new \InvalidArgumentException('invalid length for $company when calling CustomerFull., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($company) < 0)) {
            throw new \InvalidArgumentException('invalid length for $company when calling CustomerFull., must be bigger than or equal to 0.');
        }

        $this->container['company'] = $company;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string|null $phone The phone number of the customer.
     *
     * @return self
     */
    public function setPhone($phone)
    {
        if (is_null($phone)) {
            throw new \InvalidArgumentException('non-nullable phone cannot be null');
        }
        if ((mb_strlen($phone) > 50)) {
            throw new \InvalidArgumentException('invalid length for $phone when calling CustomerFull., must be smaller than or equal to 50.');
        }
        if ((mb_strlen($phone) < 0)) {
            throw new \InvalidArgumentException('invalid length for $phone when calling CustomerFull., must be bigger than or equal to 0.');
        }

        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets registration_ip_address
     *
     * @return string|null
     */
    public function getRegistrationIpAddress()
    {
        return $this->container['registration_ip_address'];
    }

    /**
     * Sets registration_ip_address
     *
     * @param string|null $registration_ip_address The IP address from which this customer was registered.
     *
     * @return self
     */
    public function setRegistrationIpAddress($registration_ip_address)
    {
        if (is_null($registration_ip_address)) {
            throw new \InvalidArgumentException('non-nullable registration_ip_address cannot be null');
        }
        if ((mb_strlen($registration_ip_address) > 30)) {
            throw new \InvalidArgumentException('invalid length for $registration_ip_address when calling CustomerFull., must be smaller than or equal to 30.');
        }
        if ((mb_strlen($registration_ip_address) < 0)) {
            throw new \InvalidArgumentException('invalid length for $registration_ip_address when calling CustomerFull., must be bigger than or equal to 0.');
        }

        $this->container['registration_ip_address'] = $registration_ip_address;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes The customer notes.
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            throw new \InvalidArgumentException('non-nullable notes cannot be null');
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets tax_exempt_category
     *
     * @return string|null
     */
    public function getTaxExemptCategory()
    {
        return $this->container['tax_exempt_category'];
    }

    /**
     * Sets tax_exempt_category
     *
     * @param string|null $tax_exempt_category The tax exempt category code for the customer.
     *
     * @return self
     */
    public function setTaxExemptCategory($tax_exempt_category)
    {
        if (is_null($tax_exempt_category)) {
            throw new \InvalidArgumentException('non-nullable tax_exempt_category cannot be null');
        }
        if ((mb_strlen($tax_exempt_category) > 255)) {
            throw new \InvalidArgumentException('invalid length for $tax_exempt_category when calling CustomerFull., must be smaller than or equal to 255.');
        }
        if ((mb_strlen($tax_exempt_category) < 0)) {
            throw new \InvalidArgumentException('invalid length for $tax_exempt_category when calling CustomerFull., must be bigger than or equal to 0.');
        }

        $this->container['tax_exempt_category'] = $tax_exempt_category;

        return $this;
    }

    /**
     * Gets customer_group_id
     *
     * @return int|null
     */
    public function getCustomerGroupId()
    {
        return $this->container['customer_group_id'];
    }

    /**
     * Sets customer_group_id
     *
     * @param int|null $customer_group_id ID of the group which this customer belongs to.
     *
     * @return self
     */
    public function setCustomerGroupId($customer_group_id)
    {
        if (is_null($customer_group_id)) {
            throw new \InvalidArgumentException('non-nullable customer_group_id cannot be null');
        }
        $this->container['customer_group_id'] = $customer_group_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id The unique numeric ID of the customer.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets date_modified
     *
     * @return \DateTime|null
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     *
     * @param \DateTime|null $date_modified The date on which the customer was modified.
     *
     * @return self
     */
    public function setDateModified($date_modified)
    {
        if (is_null($date_modified)) {
            throw new \InvalidArgumentException('non-nullable date_modified cannot be null');
        }
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets date_created
     *
     * @return \DateTime|null
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     *
     * @param \DateTime|null $date_created The date of which the customer was created.
     *
     * @return self
     */
    public function setDateCreated($date_created)
    {
        if (is_null($date_created)) {
            throw new \InvalidArgumentException('non-nullable date_created cannot be null');
        }
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets address_count
     *
     * @return int|null
     */
    public function getAddressCount()
    {
        return $this->container['address_count'];
    }

    /**
     * Sets address_count
     *
     * @param int|null $address_count Total number of customer addresses
     *
     * @return self
     */
    public function setAddressCount($address_count)
    {
        if (is_null($address_count)) {
            throw new \InvalidArgumentException('non-nullable address_count cannot be null');
        }
        $this->container['address_count'] = $address_count;

        return $this;
    }

    /**
     * Gets attribute_count
     *
     * @return int|null
     */
    public function getAttributeCount()
    {
        return $this->container['attribute_count'];
    }

    /**
     * Sets attribute_count
     *
     * @param int|null $attribute_count Total number of customer attributes
     *
     * @return self
     */
    public function setAttributeCount($attribute_count)
    {
        if (is_null($attribute_count)) {
            throw new \InvalidArgumentException('non-nullable attribute_count cannot be null');
        }
        $this->container['attribute_count'] = $attribute_count;

        return $this;
    }

    /**
     * Gets authentication
     *
     * @return \Bigcommerce\CustomersV3\Model\CustomerAuthenticationBase|null
     */
    public function getAuthentication()
    {
        return $this->container['authentication'];
    }

    /**
     * Sets authentication
     *
     * @param \Bigcommerce\CustomersV3\Model\CustomerAuthenticationBase|null $authentication authentication
     *
     * @return self
     */
    public function setAuthentication($authentication)
    {
        if (is_null($authentication)) {
            throw new \InvalidArgumentException('non-nullable authentication cannot be null');
        }
        $this->container['authentication'] = $authentication;

        return $this;
    }

    /**
     * Gets addresses
     *
     * @return \Bigcommerce\CustomersV3\Model\AddressFull[]|null
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     *
     * @param \Bigcommerce\CustomersV3\Model\AddressFull[]|null $addresses Array of customer addresses. Limited to 10
     *
     * @return self
     */
    public function setAddresses($addresses)
    {
        if (is_null($addresses)) {
            throw new \InvalidArgumentException('non-nullable addresses cannot be null');
        }

        if ((count($addresses) > 10)) {
            throw new \InvalidArgumentException('invalid value for $addresses when calling CustomerFull., number of items must be less than or equal to 10.');
        }
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return \Bigcommerce\CustomersV3\Model\AttributeFull[]|null
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param \Bigcommerce\CustomersV3\Model\AttributeFull[]|null $attributes Array of customer attributes. Limited to 10
     *
     * @return self
     */
    public function setAttributes($attributes)
    {
        if (is_null($attributes)) {
            throw new \InvalidArgumentException('non-nullable attributes cannot be null');
        }

        if ((count($attributes) > 10)) {
            throw new \InvalidArgumentException('invalid value for $attributes when calling CustomerFull., number of items must be less than or equal to 10.');
        }
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets form_fields
     *
     * @return \Bigcommerce\CustomersV3\Model\FormFieldValueFull[]|null
     */
    public function getFormFields()
    {
        return $this->container['form_fields'];
    }

    /**
     * Sets form_fields
     *
     * @param \Bigcommerce\CustomersV3\Model\FormFieldValueFull[]|null $form_fields Array of form fields. Controlled by `formfields` parameter.
     *
     * @return self
     */
    public function setFormFields($form_fields)
    {
        if (is_null($form_fields)) {
            throw new \InvalidArgumentException('non-nullable form_fields cannot be null');
        }
        $this->container['form_fields'] = $form_fields;

        return $this;
    }

    /**
     * Gets store_credit_amounts
     *
     * @return \Bigcommerce\CustomersV3\Model\CustomerStoredCreditAmountsInner[]|null
     */
    public function getStoreCreditAmounts()
    {
        return $this->container['store_credit_amounts'];
    }

    /**
     * Sets store_credit_amounts
     *
     * @param \Bigcommerce\CustomersV3\Model\CustomerStoredCreditAmountsInner[]|null $store_credit_amounts Store credit.
     *
     * @return self
     */
    public function setStoreCreditAmounts($store_credit_amounts)
    {
        if (is_null($store_credit_amounts)) {
            throw new \InvalidArgumentException('non-nullable store_credit_amounts cannot be null');
        }
        $this->container['store_credit_amounts'] = $store_credit_amounts;

        return $this;
    }

    /**
     * Gets accepts_product_review_abandoned_cart_emails
     *
     * @return bool|null
     */
    public function getAcceptsProductReviewAbandonedCartEmails()
    {
        return $this->container['accepts_product_review_abandoned_cart_emails'];
    }

    /**
     * Sets accepts_product_review_abandoned_cart_emails
     *
     * @param bool|null $accepts_product_review_abandoned_cart_emails It determines if the customer is signed up to receive either product review or abandoned cart emails or recieve both emails.
     *
     * @return self
     */
    public function setAcceptsProductReviewAbandonedCartEmails($accepts_product_review_abandoned_cart_emails)
    {
        if (is_null($accepts_product_review_abandoned_cart_emails)) {
            throw new \InvalidArgumentException('non-nullable accepts_product_review_abandoned_cart_emails cannot be null');
        }
        $this->container['accepts_product_review_abandoned_cart_emails'] = $accepts_product_review_abandoned_cart_emails;

        return $this;
    }

    /**
     * Gets channel_ids
     *
     * @return int[]|null
     */
    public function getChannelIds()
    {
        return $this->container['channel_ids'];
    }

    /**
     * Sets channel_ids
     *
     * @param int[]|null $channel_ids Array of channel ids the Customer has access to.
     *
     * @return self
     */
    public function setChannelIds($channel_ids)
    {
        if (is_null($channel_ids)) {
            throw new \InvalidArgumentException('non-nullable channel_ids cannot be null');
        }
        $this->container['channel_ids'] = $channel_ids;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


