<?php
/**
 * CustomersApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Customers V3
 *
 * Create and manage customers.  - [Authentication](#authentication) - [Resources](#resources)  ## Authentication  Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes  | UI Name                                      | Permission | Parameter                                     | |----------------------------------------------|------------|-----------------------------------------------| | Customers                                    | modify     | `store_v2_customers`                          | | Customers                                    | read-only  | `store_v2_customers_read_only`                |  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Resources * [Customer and Subscribers Overview](/api-docs/customers/customers-subscribers-overview).
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CustomersV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CustomersV3\ApiException;
use Bigcommerce\CustomersV3\Configuration;
use Bigcommerce\CustomersV3\FormDataProcessor;
use Bigcommerce\CustomersV3\HeaderSelector;
use Bigcommerce\CustomersV3\ObjectSerializer;

/**
 * CustomersApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'customersDelete' => [
            'application/json',
        ],
        'customersGet' => [
            'application/json',
        ],
        'customersPost' => [
            'application/json',
        ],
        'customersPut' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation customersDelete
     *
     * Delete Customers
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersDelete'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function customersDelete($id_in, string $contentType = self::contentTypes['customersDelete'][0])
    {
        $this->customersDeleteWithHttpInfo($id_in, $contentType);
    }

    /**
     * Operation customersDeleteWithHttpInfo
     *
     * Delete Customers
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersDelete'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersDeleteWithHttpInfo($id_in, string $contentType = self::contentTypes['customersDelete'][0])
    {
        $request = $this->customersDeleteRequest($id_in, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersDeleteAsync
     *
     * Delete Customers
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersDeleteAsync($id_in, string $contentType = self::contentTypes['customersDelete'][0])
    {
        return $this->customersDeleteAsyncWithHttpInfo($id_in, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersDeleteAsyncWithHttpInfo
     *
     * Delete Customers
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersDeleteAsyncWithHttpInfo($id_in, string $contentType = self::contentTypes['customersDelete'][0])
    {
        $returnType = '';
        $request = $this->customersDeleteRequest($id_in, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersDelete'
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersDeleteRequest($id_in, string $contentType = self::contentTypes['customersDelete'][0])
    {

        // verify the required parameter 'id_in' is set
        if ($id_in === null || (is_array($id_in) && count($id_in) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id_in when calling customersDelete'
            );
        }


        $resourcePath = '/customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_in,
            'id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customersGet
     *
     * Get All Customers
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int[]|null $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (optional)
     * @param  string[]|null $company_in Filter items by company. &#x60;company:in&#x3D;bigcommerce,commongood&#x60; (optional)
     * @param  string[]|null $customer_group_id_in Filter items by customer_group_id. &#x60;customer_group_id:in&#x3D;5,6&#x60; (optional)
     * @param  \DateTime|null $date_created Filter items by date_created. &#x60;date_created&#x3D;2018-09-05T13:43:54&#x60; (optional)
     * @param  string|null $date_created_max Filter items by maximum date_created. &#x60;date_created:max&#x3D;2018-09-10&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by date_created. &#x60;date_created:min&#x3D;2018-09-05&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by date_modified. &#x60;date_modified&#x3D;2018-09-05T13:45:03&#x60; (optional)
     * @param  string|null $date_modified_min Filter items by mininum date_modified. &#x60;date_modified:min&#x3D;2019-09-04T:00:00:00&#x60; or &#x60;date_modified:min&#x3D;2019-09-04&#x60; (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum date_modified &#x60;date_modified:max&#x3D;2018-09-05T13:45:03&#x60; or &#x60;date_modified:max&#x3D;2019-09-04&#x60; (optional)
     * @param  string|null $email_in Filter items by email. &#x60;email:in&#x3D;janedoe@example.com&#x60; (optional)
     * @param  string[]|null $name_in Filter items by first_name and last_name. &#x60;name&#x3D;james moriarty&#x60; (optional)
     * @param  string[]|null $name_like Filter items by substring in first_name and last_name. &#x60;name:like&#x3D;moriarty, sherlock&#x60; Concatenates the first_name and last_name fields. (optional)
     * @param  int[]|null $registration_ip_address_in Filter items by registration_ip_address. If the customer was created using the API, then registration address is blank. &#x60;registration_ip_address:in&#x3D;12.345.6.789&#x60; (optional)
     * @param  string|null $include Indicates whether to include customer sub-resources:  * &#x60;addresses&#x60; - customer addresses  * &#x60;storecredit&#x60; - store credit  * &#x60;attributes&#x60; - customer attributes and address attributes  * &#x60;formfields&#x60; - customer and address form fields   &#x60;include&#x3D;addresses,storecredit,attributes,formfields&#x60; (optional)
     * @param  string|null $sort Sort items by date_created or last_name: * &#x60;date_created:asc&#x60; - date created, ascending * &#x60;date_created:desc&#x60; - date created, descending * &#x60;last_name:asc&#x60; - last name, ascending * &#x60;last_name:desc&#x60; - last name, descending  Example: &#x60;sort&#x3D;last_name:asc&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersGet'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\CustomersGet200Response
     */
    public function customersGet($page = null, $limit = null, $id_in = null, $company_in = null, $customer_group_id_in = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_min = null, $date_modified_max = null, $email_in = null, $name_in = null, $name_like = null, $registration_ip_address_in = null, $include = null, $sort = null, string $contentType = self::contentTypes['customersGet'][0])
    {
        list($response) = $this->customersGetWithHttpInfo($page, $limit, $id_in, $company_in, $customer_group_id_in, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_min, $date_modified_max, $email_in, $name_in, $name_like, $registration_ip_address_in, $include, $sort, $contentType);
        return $response;
    }

    /**
     * Operation customersGetWithHttpInfo
     *
     * Get All Customers
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int[]|null $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (optional)
     * @param  string[]|null $company_in Filter items by company. &#x60;company:in&#x3D;bigcommerce,commongood&#x60; (optional)
     * @param  string[]|null $customer_group_id_in Filter items by customer_group_id. &#x60;customer_group_id:in&#x3D;5,6&#x60; (optional)
     * @param  \DateTime|null $date_created Filter items by date_created. &#x60;date_created&#x3D;2018-09-05T13:43:54&#x60; (optional)
     * @param  string|null $date_created_max Filter items by maximum date_created. &#x60;date_created:max&#x3D;2018-09-10&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by date_created. &#x60;date_created:min&#x3D;2018-09-05&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by date_modified. &#x60;date_modified&#x3D;2018-09-05T13:45:03&#x60; (optional)
     * @param  string|null $date_modified_min Filter items by mininum date_modified. &#x60;date_modified:min&#x3D;2019-09-04T:00:00:00&#x60; or &#x60;date_modified:min&#x3D;2019-09-04&#x60; (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum date_modified &#x60;date_modified:max&#x3D;2018-09-05T13:45:03&#x60; or &#x60;date_modified:max&#x3D;2019-09-04&#x60; (optional)
     * @param  string|null $email_in Filter items by email. &#x60;email:in&#x3D;janedoe@example.com&#x60; (optional)
     * @param  string[]|null $name_in Filter items by first_name and last_name. &#x60;name&#x3D;james moriarty&#x60; (optional)
     * @param  string[]|null $name_like Filter items by substring in first_name and last_name. &#x60;name:like&#x3D;moriarty, sherlock&#x60; Concatenates the first_name and last_name fields. (optional)
     * @param  int[]|null $registration_ip_address_in Filter items by registration_ip_address. If the customer was created using the API, then registration address is blank. &#x60;registration_ip_address:in&#x3D;12.345.6.789&#x60; (optional)
     * @param  string|null $include Indicates whether to include customer sub-resources:  * &#x60;addresses&#x60; - customer addresses  * &#x60;storecredit&#x60; - store credit  * &#x60;attributes&#x60; - customer attributes and address attributes  * &#x60;formfields&#x60; - customer and address form fields   &#x60;include&#x3D;addresses,storecredit,attributes,formfields&#x60; (optional)
     * @param  string|null $sort Sort items by date_created or last_name: * &#x60;date_created:asc&#x60; - date created, ascending * &#x60;date_created:desc&#x60; - date created, descending * &#x60;last_name:asc&#x60; - last name, ascending * &#x60;last_name:desc&#x60; - last name, descending  Example: &#x60;sort&#x3D;last_name:asc&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersGet'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\CustomersGet200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersGetWithHttpInfo($page = null, $limit = null, $id_in = null, $company_in = null, $customer_group_id_in = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_min = null, $date_modified_max = null, $email_in = null, $name_in = null, $name_like = null, $registration_ip_address_in = null, $include = null, $sort = null, string $contentType = self::contentTypes['customersGet'][0])
    {
        $request = $this->customersGetRequest($page, $limit, $id_in, $company_in, $customer_group_id_in, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_min, $date_modified_max, $email_in, $name_in, $name_like, $registration_ip_address_in, $include, $sort, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\CustomersGet200Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\CustomersGet200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\CustomersGet200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersGetAsync
     *
     * Get All Customers
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int[]|null $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (optional)
     * @param  string[]|null $company_in Filter items by company. &#x60;company:in&#x3D;bigcommerce,commongood&#x60; (optional)
     * @param  string[]|null $customer_group_id_in Filter items by customer_group_id. &#x60;customer_group_id:in&#x3D;5,6&#x60; (optional)
     * @param  \DateTime|null $date_created Filter items by date_created. &#x60;date_created&#x3D;2018-09-05T13:43:54&#x60; (optional)
     * @param  string|null $date_created_max Filter items by maximum date_created. &#x60;date_created:max&#x3D;2018-09-10&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by date_created. &#x60;date_created:min&#x3D;2018-09-05&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by date_modified. &#x60;date_modified&#x3D;2018-09-05T13:45:03&#x60; (optional)
     * @param  string|null $date_modified_min Filter items by mininum date_modified. &#x60;date_modified:min&#x3D;2019-09-04T:00:00:00&#x60; or &#x60;date_modified:min&#x3D;2019-09-04&#x60; (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum date_modified &#x60;date_modified:max&#x3D;2018-09-05T13:45:03&#x60; or &#x60;date_modified:max&#x3D;2019-09-04&#x60; (optional)
     * @param  string|null $email_in Filter items by email. &#x60;email:in&#x3D;janedoe@example.com&#x60; (optional)
     * @param  string[]|null $name_in Filter items by first_name and last_name. &#x60;name&#x3D;james moriarty&#x60; (optional)
     * @param  string[]|null $name_like Filter items by substring in first_name and last_name. &#x60;name:like&#x3D;moriarty, sherlock&#x60; Concatenates the first_name and last_name fields. (optional)
     * @param  int[]|null $registration_ip_address_in Filter items by registration_ip_address. If the customer was created using the API, then registration address is blank. &#x60;registration_ip_address:in&#x3D;12.345.6.789&#x60; (optional)
     * @param  string|null $include Indicates whether to include customer sub-resources:  * &#x60;addresses&#x60; - customer addresses  * &#x60;storecredit&#x60; - store credit  * &#x60;attributes&#x60; - customer attributes and address attributes  * &#x60;formfields&#x60; - customer and address form fields   &#x60;include&#x3D;addresses,storecredit,attributes,formfields&#x60; (optional)
     * @param  string|null $sort Sort items by date_created or last_name: * &#x60;date_created:asc&#x60; - date created, ascending * &#x60;date_created:desc&#x60; - date created, descending * &#x60;last_name:asc&#x60; - last name, ascending * &#x60;last_name:desc&#x60; - last name, descending  Example: &#x60;sort&#x3D;last_name:asc&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersGetAsync($page = null, $limit = null, $id_in = null, $company_in = null, $customer_group_id_in = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_min = null, $date_modified_max = null, $email_in = null, $name_in = null, $name_like = null, $registration_ip_address_in = null, $include = null, $sort = null, string $contentType = self::contentTypes['customersGet'][0])
    {
        return $this->customersGetAsyncWithHttpInfo($page, $limit, $id_in, $company_in, $customer_group_id_in, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_min, $date_modified_max, $email_in, $name_in, $name_like, $registration_ip_address_in, $include, $sort, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersGetAsyncWithHttpInfo
     *
     * Get All Customers
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int[]|null $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (optional)
     * @param  string[]|null $company_in Filter items by company. &#x60;company:in&#x3D;bigcommerce,commongood&#x60; (optional)
     * @param  string[]|null $customer_group_id_in Filter items by customer_group_id. &#x60;customer_group_id:in&#x3D;5,6&#x60; (optional)
     * @param  \DateTime|null $date_created Filter items by date_created. &#x60;date_created&#x3D;2018-09-05T13:43:54&#x60; (optional)
     * @param  string|null $date_created_max Filter items by maximum date_created. &#x60;date_created:max&#x3D;2018-09-10&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by date_created. &#x60;date_created:min&#x3D;2018-09-05&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by date_modified. &#x60;date_modified&#x3D;2018-09-05T13:45:03&#x60; (optional)
     * @param  string|null $date_modified_min Filter items by mininum date_modified. &#x60;date_modified:min&#x3D;2019-09-04T:00:00:00&#x60; or &#x60;date_modified:min&#x3D;2019-09-04&#x60; (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum date_modified &#x60;date_modified:max&#x3D;2018-09-05T13:45:03&#x60; or &#x60;date_modified:max&#x3D;2019-09-04&#x60; (optional)
     * @param  string|null $email_in Filter items by email. &#x60;email:in&#x3D;janedoe@example.com&#x60; (optional)
     * @param  string[]|null $name_in Filter items by first_name and last_name. &#x60;name&#x3D;james moriarty&#x60; (optional)
     * @param  string[]|null $name_like Filter items by substring in first_name and last_name. &#x60;name:like&#x3D;moriarty, sherlock&#x60; Concatenates the first_name and last_name fields. (optional)
     * @param  int[]|null $registration_ip_address_in Filter items by registration_ip_address. If the customer was created using the API, then registration address is blank. &#x60;registration_ip_address:in&#x3D;12.345.6.789&#x60; (optional)
     * @param  string|null $include Indicates whether to include customer sub-resources:  * &#x60;addresses&#x60; - customer addresses  * &#x60;storecredit&#x60; - store credit  * &#x60;attributes&#x60; - customer attributes and address attributes  * &#x60;formfields&#x60; - customer and address form fields   &#x60;include&#x3D;addresses,storecredit,attributes,formfields&#x60; (optional)
     * @param  string|null $sort Sort items by date_created or last_name: * &#x60;date_created:asc&#x60; - date created, ascending * &#x60;date_created:desc&#x60; - date created, descending * &#x60;last_name:asc&#x60; - last name, ascending * &#x60;last_name:desc&#x60; - last name, descending  Example: &#x60;sort&#x3D;last_name:asc&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersGetAsyncWithHttpInfo($page = null, $limit = null, $id_in = null, $company_in = null, $customer_group_id_in = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_min = null, $date_modified_max = null, $email_in = null, $name_in = null, $name_like = null, $registration_ip_address_in = null, $include = null, $sort = null, string $contentType = self::contentTypes['customersGet'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\CustomersGet200Response';
        $request = $this->customersGetRequest($page, $limit, $id_in, $company_in, $customer_group_id_in, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_min, $date_modified_max, $email_in, $name_in, $name_like, $registration_ip_address_in, $include, $sort, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersGet'
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int[]|null $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (optional)
     * @param  string[]|null $company_in Filter items by company. &#x60;company:in&#x3D;bigcommerce,commongood&#x60; (optional)
     * @param  string[]|null $customer_group_id_in Filter items by customer_group_id. &#x60;customer_group_id:in&#x3D;5,6&#x60; (optional)
     * @param  \DateTime|null $date_created Filter items by date_created. &#x60;date_created&#x3D;2018-09-05T13:43:54&#x60; (optional)
     * @param  string|null $date_created_max Filter items by maximum date_created. &#x60;date_created:max&#x3D;2018-09-10&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by date_created. &#x60;date_created:min&#x3D;2018-09-05&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by date_modified. &#x60;date_modified&#x3D;2018-09-05T13:45:03&#x60; (optional)
     * @param  string|null $date_modified_min Filter items by mininum date_modified. &#x60;date_modified:min&#x3D;2019-09-04T:00:00:00&#x60; or &#x60;date_modified:min&#x3D;2019-09-04&#x60; (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum date_modified &#x60;date_modified:max&#x3D;2018-09-05T13:45:03&#x60; or &#x60;date_modified:max&#x3D;2019-09-04&#x60; (optional)
     * @param  string|null $email_in Filter items by email. &#x60;email:in&#x3D;janedoe@example.com&#x60; (optional)
     * @param  string[]|null $name_in Filter items by first_name and last_name. &#x60;name&#x3D;james moriarty&#x60; (optional)
     * @param  string[]|null $name_like Filter items by substring in first_name and last_name. &#x60;name:like&#x3D;moriarty, sherlock&#x60; Concatenates the first_name and last_name fields. (optional)
     * @param  int[]|null $registration_ip_address_in Filter items by registration_ip_address. If the customer was created using the API, then registration address is blank. &#x60;registration_ip_address:in&#x3D;12.345.6.789&#x60; (optional)
     * @param  string|null $include Indicates whether to include customer sub-resources:  * &#x60;addresses&#x60; - customer addresses  * &#x60;storecredit&#x60; - store credit  * &#x60;attributes&#x60; - customer attributes and address attributes  * &#x60;formfields&#x60; - customer and address form fields   &#x60;include&#x3D;addresses,storecredit,attributes,formfields&#x60; (optional)
     * @param  string|null $sort Sort items by date_created or last_name: * &#x60;date_created:asc&#x60; - date created, ascending * &#x60;date_created:desc&#x60; - date created, descending * &#x60;last_name:asc&#x60; - last name, ascending * &#x60;last_name:desc&#x60; - last name, descending  Example: &#x60;sort&#x3D;last_name:asc&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersGetRequest($page = null, $limit = null, $id_in = null, $company_in = null, $customer_group_id_in = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_min = null, $date_modified_max = null, $email_in = null, $name_in = null, $name_like = null, $registration_ip_address_in = null, $include = null, $sort = null, string $contentType = self::contentTypes['customersGet'][0])
    {



















        $resourcePath = '/customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_in,
            'id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $company_in,
            'company:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_group_id_in,
            'customer_group_id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created,
            'date_created', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created_max,
            'date_created:max', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created_min,
            'date_created:min', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified,
            'date_modified', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified_min,
            'date_modified:min', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified_max,
            'date_modified:max', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $email_in,
            'email:in', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name_in,
            'name:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name_like,
            'name:like', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $registration_ip_address_in,
            'registration_ip_address:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include,
            'include', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customersPost
     *
     * Create Customers
     *
     * @param  \Bigcommerce\CustomersV3\Model\CustomerPost[] $customer_post  (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersPost'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\CustomersGet200Response|\Bigcommerce\CustomersV3\Model\ErrorResponse
     */
    public function customersPost($customer_post, string $contentType = self::contentTypes['customersPost'][0])
    {
        list($response) = $this->customersPostWithHttpInfo($customer_post, $contentType);
        return $response;
    }

    /**
     * Operation customersPostWithHttpInfo
     *
     * Create Customers
     *
     * @param  \Bigcommerce\CustomersV3\Model\CustomerPost[] $customer_post  (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersPost'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\CustomersGet200Response|\Bigcommerce\CustomersV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersPostWithHttpInfo($customer_post, string $contentType = self::contentTypes['customersPost'][0])
    {
        $request = $this->customersPostRequest($customer_post, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\CustomersGet200Response',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\CustomersGet200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\CustomersGet200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersPostAsync
     *
     * Create Customers
     *
     * @param  \Bigcommerce\CustomersV3\Model\CustomerPost[] $customer_post  (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersPostAsync($customer_post, string $contentType = self::contentTypes['customersPost'][0])
    {
        return $this->customersPostAsyncWithHttpInfo($customer_post, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersPostAsyncWithHttpInfo
     *
     * Create Customers
     *
     * @param  \Bigcommerce\CustomersV3\Model\CustomerPost[] $customer_post  (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersPostAsyncWithHttpInfo($customer_post, string $contentType = self::contentTypes['customersPost'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\CustomersGet200Response';
        $request = $this->customersPostRequest($customer_post, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersPost'
     *
     * @param  \Bigcommerce\CustomersV3\Model\CustomerPost[] $customer_post  (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersPostRequest($customer_post, string $contentType = self::contentTypes['customersPost'][0])
    {

        // verify the required parameter 'customer_post' is set
        if ($customer_post === null || (is_array($customer_post) && count($customer_post) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_post when calling customersPost'
            );
        }


        $resourcePath = '/customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($customer_post)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($customer_post));
            } else {
                $httpBody = $customer_post;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customersPut
     *
     * Update Customers
     *
     * @param  \Bigcommerce\CustomersV3\Model\CustomerPut[]|null $customer_put customer_put (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersPut'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\CustomersGet200Response|\Bigcommerce\CustomersV3\Model\ErrorResponse
     */
    public function customersPut($customer_put = null, string $contentType = self::contentTypes['customersPut'][0])
    {
        list($response) = $this->customersPutWithHttpInfo($customer_put, $contentType);
        return $response;
    }

    /**
     * Operation customersPutWithHttpInfo
     *
     * Update Customers
     *
     * @param  \Bigcommerce\CustomersV3\Model\CustomerPut[]|null $customer_put (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersPut'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\CustomersGet200Response|\Bigcommerce\CustomersV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersPutWithHttpInfo($customer_put = null, string $contentType = self::contentTypes['customersPut'][0])
    {
        $request = $this->customersPutRequest($customer_put, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\CustomersGet200Response',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\CustomersGet200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\CustomersGet200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersPutAsync
     *
     * Update Customers
     *
     * @param  \Bigcommerce\CustomersV3\Model\CustomerPut[]|null $customer_put (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersPutAsync($customer_put = null, string $contentType = self::contentTypes['customersPut'][0])
    {
        return $this->customersPutAsyncWithHttpInfo($customer_put, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersPutAsyncWithHttpInfo
     *
     * Update Customers
     *
     * @param  \Bigcommerce\CustomersV3\Model\CustomerPut[]|null $customer_put (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersPutAsyncWithHttpInfo($customer_put = null, string $contentType = self::contentTypes['customersPut'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\CustomersGet200Response';
        $request = $this->customersPutRequest($customer_put, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersPut'
     *
     * @param  \Bigcommerce\CustomersV3\Model\CustomerPut[]|null $customer_put (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersPutRequest($customer_put = null, string $contentType = self::contentTypes['customersPut'][0])
    {



        $resourcePath = '/customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($customer_put)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($customer_put));
            } else {
                $httpBody = $customer_put;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
