<?php
/**
 * CustomerFormFieldValuesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Customers V3
 *
 * Create and manage customers.  - [Authentication](#authentication) - [Resources](#resources)  ## Authentication  Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes  | UI Name                                      | Permission | Parameter                                     | |----------------------------------------------|------------|-----------------------------------------------| | Customers                                    | modify     | `store_v2_customers`                          | | Customers                                    | read-only  | `store_v2_customers_read_only`                |  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Resources * [Customer and Subscribers Overview](/api-docs/customers/customers-subscribers-overview).
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CustomersV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CustomersV3\ApiException;
use Bigcommerce\CustomersV3\Configuration;
use Bigcommerce\CustomersV3\FormDataProcessor;
use Bigcommerce\CustomersV3\HeaderSelector;
use Bigcommerce\CustomersV3\ObjectSerializer;

/**
 * CustomerFormFieldValuesApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomerFormFieldValuesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'customerFormFieldValuePUT' => [
            'application/json',
        ],
        'customerFormFieldsGet' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation customerFormFieldValuePUT
     *
     * Upsert Customer Form Field Values
     *
     * @param  \Bigcommerce\CustomersV3\Model\FormFieldValueFull[]|null $form_field_value_full form_field_value_full (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerFormFieldValuePUT'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response|\Bigcommerce\CustomersV3\Model\ErrorResponse
     */
    public function customerFormFieldValuePUT($form_field_value_full = null, string $contentType = self::contentTypes['customerFormFieldValuePUT'][0])
    {
        list($response) = $this->customerFormFieldValuePUTWithHttpInfo($form_field_value_full, $contentType);
        return $response;
    }

    /**
     * Operation customerFormFieldValuePUTWithHttpInfo
     *
     * Upsert Customer Form Field Values
     *
     * @param  \Bigcommerce\CustomersV3\Model\FormFieldValueFull[]|null $form_field_value_full (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerFormFieldValuePUT'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response|\Bigcommerce\CustomersV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customerFormFieldValuePUTWithHttpInfo($form_field_value_full = null, string $contentType = self::contentTypes['customerFormFieldValuePUT'][0])
    {
        $request = $this->customerFormFieldValuePUTRequest($form_field_value_full, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customerFormFieldValuePUTAsync
     *
     * Upsert Customer Form Field Values
     *
     * @param  \Bigcommerce\CustomersV3\Model\FormFieldValueFull[]|null $form_field_value_full (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerFormFieldValuePUT'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customerFormFieldValuePUTAsync($form_field_value_full = null, string $contentType = self::contentTypes['customerFormFieldValuePUT'][0])
    {
        return $this->customerFormFieldValuePUTAsyncWithHttpInfo($form_field_value_full, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customerFormFieldValuePUTAsyncWithHttpInfo
     *
     * Upsert Customer Form Field Values
     *
     * @param  \Bigcommerce\CustomersV3\Model\FormFieldValueFull[]|null $form_field_value_full (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerFormFieldValuePUT'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customerFormFieldValuePUTAsyncWithHttpInfo($form_field_value_full = null, string $contentType = self::contentTypes['customerFormFieldValuePUT'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response';
        $request = $this->customerFormFieldValuePUTRequest($form_field_value_full, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customerFormFieldValuePUT'
     *
     * @param  \Bigcommerce\CustomersV3\Model\FormFieldValueFull[]|null $form_field_value_full (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerFormFieldValuePUT'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customerFormFieldValuePUTRequest($form_field_value_full = null, string $contentType = self::contentTypes['customerFormFieldValuePUT'][0])
    {



        $resourcePath = '/customers/form-field-values';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($form_field_value_full)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($form_field_value_full));
            } else {
                $httpBody = $form_field_value_full;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customerFormFieldsGet
     *
     * Get Customer Form Field Values
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int|null $customer_id Filter by the customer ID. (optional)
     * @param  int|null $address_id Filter by the ID of the customer address. (optional)
     * @param  string|null $field_name Filter by the field name. (optional)
     * @param  string|null $field_type Filter by the field type.  * &#x60;checkboxes&#x60; - checkboxes field  * &#x60;date&#x60; - date field  * &#x60;multiline&#x60; - multiline text field  * &#x60;numbers&#x60; - numbers only field  * &#x60;password&#x60; - password field  * &#x60;radiobuttons&#x60; - radio buttons field  * &#x60;text&#x60; - text field  * &#x60;picklist&#x60; - pick list field (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerFormFieldsGet'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response|\Bigcommerce\CustomersV3\Model\ErrorResponse
     */
    public function customerFormFieldsGet($page = null, $limit = null, $customer_id = null, $address_id = null, $field_name = null, $field_type = null, string $contentType = self::contentTypes['customerFormFieldsGet'][0])
    {
        list($response) = $this->customerFormFieldsGetWithHttpInfo($page, $limit, $customer_id, $address_id, $field_name, $field_type, $contentType);
        return $response;
    }

    /**
     * Operation customerFormFieldsGetWithHttpInfo
     *
     * Get Customer Form Field Values
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int|null $customer_id Filter by the customer ID. (optional)
     * @param  int|null $address_id Filter by the ID of the customer address. (optional)
     * @param  string|null $field_name Filter by the field name. (optional)
     * @param  string|null $field_type Filter by the field type.  * &#x60;checkboxes&#x60; - checkboxes field  * &#x60;date&#x60; - date field  * &#x60;multiline&#x60; - multiline text field  * &#x60;numbers&#x60; - numbers only field  * &#x60;password&#x60; - password field  * &#x60;radiobuttons&#x60; - radio buttons field  * &#x60;text&#x60; - text field  * &#x60;picklist&#x60; - pick list field (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerFormFieldsGet'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response|\Bigcommerce\CustomersV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customerFormFieldsGetWithHttpInfo($page = null, $limit = null, $customer_id = null, $address_id = null, $field_name = null, $field_type = null, string $contentType = self::contentTypes['customerFormFieldsGet'][0])
    {
        $request = $this->customerFormFieldsGetRequest($page, $limit, $customer_id, $address_id, $field_name, $field_type, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customerFormFieldsGetAsync
     *
     * Get Customer Form Field Values
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int|null $customer_id Filter by the customer ID. (optional)
     * @param  int|null $address_id Filter by the ID of the customer address. (optional)
     * @param  string|null $field_name Filter by the field name. (optional)
     * @param  string|null $field_type Filter by the field type.  * &#x60;checkboxes&#x60; - checkboxes field  * &#x60;date&#x60; - date field  * &#x60;multiline&#x60; - multiline text field  * &#x60;numbers&#x60; - numbers only field  * &#x60;password&#x60; - password field  * &#x60;radiobuttons&#x60; - radio buttons field  * &#x60;text&#x60; - text field  * &#x60;picklist&#x60; - pick list field (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerFormFieldsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customerFormFieldsGetAsync($page = null, $limit = null, $customer_id = null, $address_id = null, $field_name = null, $field_type = null, string $contentType = self::contentTypes['customerFormFieldsGet'][0])
    {
        return $this->customerFormFieldsGetAsyncWithHttpInfo($page, $limit, $customer_id, $address_id, $field_name, $field_type, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customerFormFieldsGetAsyncWithHttpInfo
     *
     * Get Customer Form Field Values
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int|null $customer_id Filter by the customer ID. (optional)
     * @param  int|null $address_id Filter by the ID of the customer address. (optional)
     * @param  string|null $field_name Filter by the field name. (optional)
     * @param  string|null $field_type Filter by the field type.  * &#x60;checkboxes&#x60; - checkboxes field  * &#x60;date&#x60; - date field  * &#x60;multiline&#x60; - multiline text field  * &#x60;numbers&#x60; - numbers only field  * &#x60;password&#x60; - password field  * &#x60;radiobuttons&#x60; - radio buttons field  * &#x60;text&#x60; - text field  * &#x60;picklist&#x60; - pick list field (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerFormFieldsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customerFormFieldsGetAsyncWithHttpInfo($page = null, $limit = null, $customer_id = null, $address_id = null, $field_name = null, $field_type = null, string $contentType = self::contentTypes['customerFormFieldsGet'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\CustomerFormFieldsGet200Response';
        $request = $this->customerFormFieldsGetRequest($page, $limit, $customer_id, $address_id, $field_name, $field_type, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customerFormFieldsGet'
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int|null $customer_id Filter by the customer ID. (optional)
     * @param  int|null $address_id Filter by the ID of the customer address. (optional)
     * @param  string|null $field_name Filter by the field name. (optional)
     * @param  string|null $field_type Filter by the field type.  * &#x60;checkboxes&#x60; - checkboxes field  * &#x60;date&#x60; - date field  * &#x60;multiline&#x60; - multiline text field  * &#x60;numbers&#x60; - numbers only field  * &#x60;password&#x60; - password field  * &#x60;radiobuttons&#x60; - radio buttons field  * &#x60;text&#x60; - text field  * &#x60;picklist&#x60; - pick list field (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customerFormFieldsGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customerFormFieldsGetRequest($page = null, $limit = null, $customer_id = null, $address_id = null, $field_name = null, $field_type = null, string $contentType = self::contentTypes['customerFormFieldsGet'][0])
    {








        $resourcePath = '/customers/form-field-values';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_id,
            'customer_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $address_id,
            'address_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $field_name,
            'field_name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $field_type,
            'field_type', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
