<?php
/**
 * CustomerConsentApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Customers V3
 *
 * Create and manage customers.  - [Authentication](#authentication) - [Resources](#resources)  ## Authentication  Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes  | UI Name                                      | Permission | Parameter                                     | |----------------------------------------------|------------|-----------------------------------------------| | Customers                                    | modify     | `store_v2_customers`                          | | Customers                                    | read-only  | `store_v2_customers_read_only`                |  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Resources * [Customer and Subscribers Overview](/api-docs/customers/customers-subscribers-overview).
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CustomersV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CustomersV3\ApiException;
use Bigcommerce\CustomersV3\Configuration;
use Bigcommerce\CustomersV3\FormDataProcessor;
use Bigcommerce\CustomersV3\HeaderSelector;
use Bigcommerce\CustomersV3\ObjectSerializer;

/**
 * CustomerConsentApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomerConsentApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'customersConsentByCustomerIdGET' => [
            'application/json',
        ],
        'customersConsentByCustomerIdPUT' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation customersConsentByCustomerIdGET
     *
     * Get Customer Consent
     *
     * @param  string $customer_id  (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersConsentByCustomerIdGET'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\ConsentFull|\Bigcommerce\CustomersV3\Model\ErrorResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse
     */
    public function customersConsentByCustomerIdGET($customer_id, string $contentType = self::contentTypes['customersConsentByCustomerIdGET'][0])
    {
        list($response) = $this->customersConsentByCustomerIdGETWithHttpInfo($customer_id, $contentType);
        return $response;
    }

    /**
     * Operation customersConsentByCustomerIdGETWithHttpInfo
     *
     * Get Customer Consent
     *
     * @param  string $customer_id  (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersConsentByCustomerIdGET'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\ConsentFull|\Bigcommerce\CustomersV3\Model\ErrorResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersConsentByCustomerIdGETWithHttpInfo($customer_id, string $contentType = self::contentTypes['customersConsentByCustomerIdGET'][0])
    {
        $request = $this->customersConsentByCustomerIdGETRequest($customer_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ConsentFull',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 403:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\ConsentFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ConsentFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersConsentByCustomerIdGETAsync
     *
     * Get Customer Consent
     *
     * @param  string $customer_id  (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersConsentByCustomerIdGET'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersConsentByCustomerIdGETAsync($customer_id, string $contentType = self::contentTypes['customersConsentByCustomerIdGET'][0])
    {
        return $this->customersConsentByCustomerIdGETAsyncWithHttpInfo($customer_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersConsentByCustomerIdGETAsyncWithHttpInfo
     *
     * Get Customer Consent
     *
     * @param  string $customer_id  (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersConsentByCustomerIdGET'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersConsentByCustomerIdGETAsyncWithHttpInfo($customer_id, string $contentType = self::contentTypes['customersConsentByCustomerIdGET'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\ConsentFull';
        $request = $this->customersConsentByCustomerIdGETRequest($customer_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersConsentByCustomerIdGET'
     *
     * @param  string $customer_id  (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersConsentByCustomerIdGET'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersConsentByCustomerIdGETRequest($customer_id, string $contentType = self::contentTypes['customersConsentByCustomerIdGET'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling customersConsentByCustomerIdGET'
            );
        }


        $resourcePath = '/customers/{customerId}/consent';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customersConsentByCustomerIdPUT
     *
     * Update Customer Consent
     *
     * @param  string $customer_id  (required)
     * @param  \Bigcommerce\CustomersV3\Model\DeclareCustomerConsentRequest|null $declare_customer_consent_request declare_customer_consent_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersConsentByCustomerIdPUT'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\ConsentFull|\Bigcommerce\CustomersV3\Model\ErrorResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse
     */
    public function customersConsentByCustomerIdPUT($customer_id, $declare_customer_consent_request = null, string $contentType = self::contentTypes['customersConsentByCustomerIdPUT'][0])
    {
        list($response) = $this->customersConsentByCustomerIdPUTWithHttpInfo($customer_id, $declare_customer_consent_request, $contentType);
        return $response;
    }

    /**
     * Operation customersConsentByCustomerIdPUTWithHttpInfo
     *
     * Update Customer Consent
     *
     * @param  string $customer_id  (required)
     * @param  \Bigcommerce\CustomersV3\Model\DeclareCustomerConsentRequest|null $declare_customer_consent_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersConsentByCustomerIdPUT'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\ConsentFull|\Bigcommerce\CustomersV3\Model\ErrorResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersConsentByCustomerIdPUTWithHttpInfo($customer_id, $declare_customer_consent_request = null, string $contentType = self::contentTypes['customersConsentByCustomerIdPUT'][0])
    {
        $request = $this->customersConsentByCustomerIdPUTRequest($customer_id, $declare_customer_consent_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ConsentFull',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 403:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\ConsentFull',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ConsentFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersConsentByCustomerIdPUTAsync
     *
     * Update Customer Consent
     *
     * @param  string $customer_id  (required)
     * @param  \Bigcommerce\CustomersV3\Model\DeclareCustomerConsentRequest|null $declare_customer_consent_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersConsentByCustomerIdPUT'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersConsentByCustomerIdPUTAsync($customer_id, $declare_customer_consent_request = null, string $contentType = self::contentTypes['customersConsentByCustomerIdPUT'][0])
    {
        return $this->customersConsentByCustomerIdPUTAsyncWithHttpInfo($customer_id, $declare_customer_consent_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersConsentByCustomerIdPUTAsyncWithHttpInfo
     *
     * Update Customer Consent
     *
     * @param  string $customer_id  (required)
     * @param  \Bigcommerce\CustomersV3\Model\DeclareCustomerConsentRequest|null $declare_customer_consent_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersConsentByCustomerIdPUT'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersConsentByCustomerIdPUTAsyncWithHttpInfo($customer_id, $declare_customer_consent_request = null, string $contentType = self::contentTypes['customersConsentByCustomerIdPUT'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\ConsentFull';
        $request = $this->customersConsentByCustomerIdPUTRequest($customer_id, $declare_customer_consent_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersConsentByCustomerIdPUT'
     *
     * @param  string $customer_id  (required)
     * @param  \Bigcommerce\CustomersV3\Model\DeclareCustomerConsentRequest|null $declare_customer_consent_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersConsentByCustomerIdPUT'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersConsentByCustomerIdPUTRequest($customer_id, $declare_customer_consent_request = null, string $contentType = self::contentTypes['customersConsentByCustomerIdPUT'][0])
    {

        // verify the required parameter 'customer_id' is set
        if ($customer_id === null || (is_array($customer_id) && count($customer_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_id when calling customersConsentByCustomerIdPUT'
            );
        }



        $resourcePath = '/customers/{customerId}/consent';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($customer_id !== null) {
            $resourcePath = str_replace(
                '{' . 'customerId' . '}',
                ObjectSerializer::toPathValue($customer_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($declare_customer_consent_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($declare_customer_consent_request));
            } else {
                $httpBody = $declare_customer_consent_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
