<?php
/**
 * CustomerAttributesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Customers V3
 *
 * Create and manage customers.  - [Authentication](#authentication) - [Resources](#resources)  ## Authentication  Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes  | UI Name                                      | Permission | Parameter                                     | |----------------------------------------------|------------|-----------------------------------------------| | Customers                                    | modify     | `store_v2_customers`                          | | Customers                                    | read-only  | `store_v2_customers_read_only`                |  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Resources * [Customer and Subscribers Overview](/api-docs/customers/customers-subscribers-overview).
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CustomersV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CustomersV3\ApiException;
use Bigcommerce\CustomersV3\Configuration;
use Bigcommerce\CustomersV3\FormDataProcessor;
use Bigcommerce\CustomersV3\HeaderSelector;
use Bigcommerce\CustomersV3\ObjectSerializer;

/**
 * CustomerAttributesApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomerAttributesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'customersAttributesDelete' => [
            'application/json',
        ],
        'customersAttributesGet' => [
            'application/json',
        ],
        'customersAttributesPost' => [
            'application/json',
        ],
        'customersAttributesPut' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation customersAttributesDelete
     *
     * Delete Customer Attributes
     *
     * @param  int[] $id_in Filter items by ID. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesDelete'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function customersAttributesDelete($id_in, string $contentType = self::contentTypes['customersAttributesDelete'][0])
    {
        $this->customersAttributesDeleteWithHttpInfo($id_in, $contentType);
    }

    /**
     * Operation customersAttributesDeleteWithHttpInfo
     *
     * Delete Customer Attributes
     *
     * @param  int[] $id_in Filter items by ID. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesDelete'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersAttributesDeleteWithHttpInfo($id_in, string $contentType = self::contentTypes['customersAttributesDelete'][0])
    {
        $request = $this->customersAttributesDeleteRequest($id_in, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersAttributesDeleteAsync
     *
     * Delete Customer Attributes
     *
     * @param  int[] $id_in Filter items by ID. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributesDeleteAsync($id_in, string $contentType = self::contentTypes['customersAttributesDelete'][0])
    {
        return $this->customersAttributesDeleteAsyncWithHttpInfo($id_in, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersAttributesDeleteAsyncWithHttpInfo
     *
     * Delete Customer Attributes
     *
     * @param  int[] $id_in Filter items by ID. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributesDeleteAsyncWithHttpInfo($id_in, string $contentType = self::contentTypes['customersAttributesDelete'][0])
    {
        $returnType = '';
        $request = $this->customersAttributesDeleteRequest($id_in, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersAttributesDelete'
     *
     * @param  int[] $id_in Filter items by ID. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersAttributesDeleteRequest($id_in, string $contentType = self::contentTypes['customersAttributesDelete'][0])
    {

        // verify the required parameter 'id_in' is set
        if ($id_in === null || (is_array($id_in) && count($id_in) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id_in when calling customersAttributesDelete'
            );
        }


        $resourcePath = '/customers/attributes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_in,
            'id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customersAttributesGet
     *
     * Get All Customer Attributes
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  string|null $name Filter items by customer attribute name &#x60;name&#x3D;Date+Joined&#x60; (optional)
     * @param  string|null $name_like Filter items by substring in customer attribute name. &#x60;name:like&#x3D;join&#x60; (optional)
     * @param  string|null $type The type of the customer attribute. (optional)
     * @param  \DateTime|null $date_created Filter items by &#x60;date_created&#x60;. &#x60;date_created&#x3D;2021-01-07T20:28:16Z&#x60; (optional)
     * @param  \DateTime|null $date_created_max Filter items by maximum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by minimum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified_min Filter items by minimum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesGet'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\CustomerAttributesResponse
     */
    public function customersAttributesGet($page = null, $limit = null, $name = null, $name_like = null, $type = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, string $contentType = self::contentTypes['customersAttributesGet'][0])
    {
        list($response) = $this->customersAttributesGetWithHttpInfo($page, $limit, $name, $name_like, $type, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_max, $date_modified_min, $contentType);
        return $response;
    }

    /**
     * Operation customersAttributesGetWithHttpInfo
     *
     * Get All Customer Attributes
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  string|null $name Filter items by customer attribute name &#x60;name&#x3D;Date+Joined&#x60; (optional)
     * @param  string|null $name_like Filter items by substring in customer attribute name. &#x60;name:like&#x3D;join&#x60; (optional)
     * @param  string|null $type The type of the customer attribute. (optional)
     * @param  \DateTime|null $date_created Filter items by &#x60;date_created&#x60;. &#x60;date_created&#x3D;2021-01-07T20:28:16Z&#x60; (optional)
     * @param  \DateTime|null $date_created_max Filter items by maximum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by minimum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified_min Filter items by minimum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesGet'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\CustomerAttributesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersAttributesGetWithHttpInfo($page = null, $limit = null, $name = null, $name_like = null, $type = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, string $contentType = self::contentTypes['customersAttributesGet'][0])
    {
        $request = $this->customersAttributesGetRequest($page, $limit, $name, $name_like, $type, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_max, $date_modified_min, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersAttributesGetAsync
     *
     * Get All Customer Attributes
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  string|null $name Filter items by customer attribute name &#x60;name&#x3D;Date+Joined&#x60; (optional)
     * @param  string|null $name_like Filter items by substring in customer attribute name. &#x60;name:like&#x3D;join&#x60; (optional)
     * @param  string|null $type The type of the customer attribute. (optional)
     * @param  \DateTime|null $date_created Filter items by &#x60;date_created&#x60;. &#x60;date_created&#x3D;2021-01-07T20:28:16Z&#x60; (optional)
     * @param  \DateTime|null $date_created_max Filter items by maximum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by minimum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified_min Filter items by minimum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributesGetAsync($page = null, $limit = null, $name = null, $name_like = null, $type = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, string $contentType = self::contentTypes['customersAttributesGet'][0])
    {
        return $this->customersAttributesGetAsyncWithHttpInfo($page, $limit, $name, $name_like, $type, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_max, $date_modified_min, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersAttributesGetAsyncWithHttpInfo
     *
     * Get All Customer Attributes
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  string|null $name Filter items by customer attribute name &#x60;name&#x3D;Date+Joined&#x60; (optional)
     * @param  string|null $name_like Filter items by substring in customer attribute name. &#x60;name:like&#x3D;join&#x60; (optional)
     * @param  string|null $type The type of the customer attribute. (optional)
     * @param  \DateTime|null $date_created Filter items by &#x60;date_created&#x60;. &#x60;date_created&#x3D;2021-01-07T20:28:16Z&#x60; (optional)
     * @param  \DateTime|null $date_created_max Filter items by maximum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by minimum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified_min Filter items by minimum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributesGetAsyncWithHttpInfo($page = null, $limit = null, $name = null, $name_like = null, $type = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, string $contentType = self::contentTypes['customersAttributesGet'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse';
        $request = $this->customersAttributesGetRequest($page, $limit, $name, $name_like, $type, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_max, $date_modified_min, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersAttributesGet'
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  string|null $name Filter items by customer attribute name &#x60;name&#x3D;Date+Joined&#x60; (optional)
     * @param  string|null $name_like Filter items by substring in customer attribute name. &#x60;name:like&#x3D;join&#x60; (optional)
     * @param  string|null $type The type of the customer attribute. (optional)
     * @param  \DateTime|null $date_created Filter items by &#x60;date_created&#x60;. &#x60;date_created&#x3D;2021-01-07T20:28:16Z&#x60; (optional)
     * @param  \DateTime|null $date_created_max Filter items by maximum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by minimum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified_min Filter items by minimum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersAttributesGetRequest($page = null, $limit = null, $name = null, $name_like = null, $type = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, string $contentType = self::contentTypes['customersAttributesGet'][0])
    {













        $resourcePath = '/customers/attributes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name_like,
            'name:like', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $type,
            'type', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created,
            'date_created', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created_max,
            'date_created:max', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created_min,
            'date_created:min', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified,
            'date_modified', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified_max,
            'date_modified:max', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified_min,
            'date_modified:min', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customersAttributesPost
     *
     * Create a Customer Attribute
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttributePost[] $attribute_post attribute_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesPost'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\CustomerAttributesResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse
     */
    public function customersAttributesPost($attribute_post, string $contentType = self::contentTypes['customersAttributesPost'][0])
    {
        list($response) = $this->customersAttributesPostWithHttpInfo($attribute_post, $contentType);
        return $response;
    }

    /**
     * Operation customersAttributesPostWithHttpInfo
     *
     * Create a Customer Attribute
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttributePost[] $attribute_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesPost'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\CustomerAttributesResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersAttributesPostWithHttpInfo($attribute_post, string $contentType = self::contentTypes['customersAttributesPost'][0])
    {
        $request = $this->customersAttributesPostRequest($attribute_post, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersAttributesPostAsync
     *
     * Create a Customer Attribute
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttributePost[] $attribute_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributesPostAsync($attribute_post, string $contentType = self::contentTypes['customersAttributesPost'][0])
    {
        return $this->customersAttributesPostAsyncWithHttpInfo($attribute_post, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersAttributesPostAsyncWithHttpInfo
     *
     * Create a Customer Attribute
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttributePost[] $attribute_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributesPostAsyncWithHttpInfo($attribute_post, string $contentType = self::contentTypes['customersAttributesPost'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse';
        $request = $this->customersAttributesPostRequest($attribute_post, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersAttributesPost'
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttributePost[] $attribute_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersAttributesPostRequest($attribute_post, string $contentType = self::contentTypes['customersAttributesPost'][0])
    {

        // verify the required parameter 'attribute_post' is set
        if ($attribute_post === null || (is_array($attribute_post) && count($attribute_post) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $attribute_post when calling customersAttributesPost'
            );
        }


        $resourcePath = '/customers/attributes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($attribute_post)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($attribute_post));
            } else {
                $httpBody = $attribute_post;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customersAttributesPut
     *
     * Update a Customer Attribute
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttributePut[] $attribute_put attribute_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesPut'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\CustomerAttributesResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse
     */
    public function customersAttributesPut($attribute_put, string $contentType = self::contentTypes['customersAttributesPut'][0])
    {
        list($response) = $this->customersAttributesPutWithHttpInfo($attribute_put, $contentType);
        return $response;
    }

    /**
     * Operation customersAttributesPutWithHttpInfo
     *
     * Update a Customer Attribute
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttributePut[] $attribute_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesPut'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\CustomerAttributesResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersAttributesPutWithHttpInfo($attribute_put, string $contentType = self::contentTypes['customersAttributesPut'][0])
    {
        $request = $this->customersAttributesPutRequest($attribute_put, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersAttributesPutAsync
     *
     * Update a Customer Attribute
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttributePut[] $attribute_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributesPutAsync($attribute_put, string $contentType = self::contentTypes['customersAttributesPut'][0])
    {
        return $this->customersAttributesPutAsyncWithHttpInfo($attribute_put, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersAttributesPutAsyncWithHttpInfo
     *
     * Update a Customer Attribute
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttributePut[] $attribute_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributesPutAsyncWithHttpInfo($attribute_put, string $contentType = self::contentTypes['customersAttributesPut'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\CustomerAttributesResponse';
        $request = $this->customersAttributesPutRequest($attribute_put, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersAttributesPut'
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttributePut[] $attribute_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributesPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersAttributesPutRequest($attribute_put, string $contentType = self::contentTypes['customersAttributesPut'][0])
    {

        // verify the required parameter 'attribute_put' is set
        if ($attribute_put === null || (is_array($attribute_put) && count($attribute_put) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $attribute_put when calling customersAttributesPut'
            );
        }


        $resourcePath = '/customers/attributes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($attribute_put)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($attribute_put));
            } else {
                $httpBody = $attribute_put;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
