<?php
/**
 * CustomerAttributeValuesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Customers V3
 *
 * Create and manage customers.  - [Authentication](#authentication) - [Resources](#resources)  ## Authentication  Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes  | UI Name                                      | Permission | Parameter                                     | |----------------------------------------------|------------|-----------------------------------------------| | Customers                                    | modify     | `store_v2_customers`                          | | Customers                                    | read-only  | `store_v2_customers_read_only`                |  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Resources * [Customer and Subscribers Overview](/api-docs/customers/customers-subscribers-overview).
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CustomersV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CustomersV3\ApiException;
use Bigcommerce\CustomersV3\Configuration;
use Bigcommerce\CustomersV3\FormDataProcessor;
use Bigcommerce\CustomersV3\HeaderSelector;
use Bigcommerce\CustomersV3\ObjectSerializer;

/**
 * CustomerAttributeValuesApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomerAttributeValuesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'customersAttributeValuesDelete' => [
            'application/json',
        ],
        'customersAttributeValuesGet' => [
            'application/json',
        ],
        'customersAttributeValuesPut' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation customersAttributeValuesDelete
     *
     * Delete Customer Attribute Values
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesDelete'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function customersAttributeValuesDelete($id_in, string $contentType = self::contentTypes['customersAttributeValuesDelete'][0])
    {
        $this->customersAttributeValuesDeleteWithHttpInfo($id_in, $contentType);
    }

    /**
     * Operation customersAttributeValuesDeleteWithHttpInfo
     *
     * Delete Customer Attribute Values
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesDelete'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersAttributeValuesDeleteWithHttpInfo($id_in, string $contentType = self::contentTypes['customersAttributeValuesDelete'][0])
    {
        $request = $this->customersAttributeValuesDeleteRequest($id_in, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersAttributeValuesDeleteAsync
     *
     * Delete Customer Attribute Values
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributeValuesDeleteAsync($id_in, string $contentType = self::contentTypes['customersAttributeValuesDelete'][0])
    {
        return $this->customersAttributeValuesDeleteAsyncWithHttpInfo($id_in, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersAttributeValuesDeleteAsyncWithHttpInfo
     *
     * Delete Customer Attribute Values
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributeValuesDeleteAsyncWithHttpInfo($id_in, string $contentType = self::contentTypes['customersAttributeValuesDelete'][0])
    {
        $returnType = '';
        $request = $this->customersAttributeValuesDeleteRequest($id_in, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersAttributeValuesDelete'
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersAttributeValuesDeleteRequest($id_in, string $contentType = self::contentTypes['customersAttributeValuesDelete'][0])
    {

        // verify the required parameter 'id_in' is set
        if ($id_in === null || (is_array($id_in) && count($id_in) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id_in when calling customersAttributeValuesDelete'
            );
        }


        $resourcePath = '/customers/attribute-values';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_in,
            'id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customersAttributeValuesGet
     *
     * Get All Customer Attribute Values
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int[]|null $customer_id_in Filter items by the customer ID. &#x60;customer_id:in&#x3D;23,24,55&#x60; (optional)
     * @param  int[]|null $attribute_id_in Filter items by the attribute ID. &#x60;attribute_id:in&#x3D;1,2&#x60; (optional)
     * @param  string|null $name Filter items by the attribute name. &#x60;name&#x3D;age&#x60; (optional)
     * @param  \DateTime|null $date_created Filter items by &#x60;date_created&#x60;. &#x60;date_created&#x3D;2018-09-05T13:43:54&#x60; (optional)
     * @param  string|null $date_created_max Filter items by maximum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by minimum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. &#x60;date_modified&#x3D;2018-09-05T13:45:03&#x60; (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string|null $date_modified_min Filter items by mininum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesGet'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse
     */
    public function customersAttributeValuesGet($page = null, $limit = null, $customer_id_in = null, $attribute_id_in = null, $name = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, string $contentType = self::contentTypes['customersAttributeValuesGet'][0])
    {
        list($response) = $this->customersAttributeValuesGetWithHttpInfo($page, $limit, $customer_id_in, $attribute_id_in, $name, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_max, $date_modified_min, $contentType);
        return $response;
    }

    /**
     * Operation customersAttributeValuesGetWithHttpInfo
     *
     * Get All Customer Attribute Values
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int[]|null $customer_id_in Filter items by the customer ID. &#x60;customer_id:in&#x3D;23,24,55&#x60; (optional)
     * @param  int[]|null $attribute_id_in Filter items by the attribute ID. &#x60;attribute_id:in&#x3D;1,2&#x60; (optional)
     * @param  string|null $name Filter items by the attribute name. &#x60;name&#x3D;age&#x60; (optional)
     * @param  \DateTime|null $date_created Filter items by &#x60;date_created&#x60;. &#x60;date_created&#x3D;2018-09-05T13:43:54&#x60; (optional)
     * @param  string|null $date_created_max Filter items by maximum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by minimum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. &#x60;date_modified&#x3D;2018-09-05T13:45:03&#x60; (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string|null $date_modified_min Filter items by mininum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesGet'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersAttributeValuesGetWithHttpInfo($page = null, $limit = null, $customer_id_in = null, $attribute_id_in = null, $name = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, string $contentType = self::contentTypes['customersAttributeValuesGet'][0])
    {
        $request = $this->customersAttributeValuesGetRequest($page, $limit, $customer_id_in, $attribute_id_in, $name, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_max, $date_modified_min, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersAttributeValuesGetAsync
     *
     * Get All Customer Attribute Values
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int[]|null $customer_id_in Filter items by the customer ID. &#x60;customer_id:in&#x3D;23,24,55&#x60; (optional)
     * @param  int[]|null $attribute_id_in Filter items by the attribute ID. &#x60;attribute_id:in&#x3D;1,2&#x60; (optional)
     * @param  string|null $name Filter items by the attribute name. &#x60;name&#x3D;age&#x60; (optional)
     * @param  \DateTime|null $date_created Filter items by &#x60;date_created&#x60;. &#x60;date_created&#x3D;2018-09-05T13:43:54&#x60; (optional)
     * @param  string|null $date_created_max Filter items by maximum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by minimum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. &#x60;date_modified&#x3D;2018-09-05T13:45:03&#x60; (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string|null $date_modified_min Filter items by mininum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributeValuesGetAsync($page = null, $limit = null, $customer_id_in = null, $attribute_id_in = null, $name = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, string $contentType = self::contentTypes['customersAttributeValuesGet'][0])
    {
        return $this->customersAttributeValuesGetAsyncWithHttpInfo($page, $limit, $customer_id_in, $attribute_id_in, $name, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_max, $date_modified_min, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersAttributeValuesGetAsyncWithHttpInfo
     *
     * Get All Customer Attribute Values
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int[]|null $customer_id_in Filter items by the customer ID. &#x60;customer_id:in&#x3D;23,24,55&#x60; (optional)
     * @param  int[]|null $attribute_id_in Filter items by the attribute ID. &#x60;attribute_id:in&#x3D;1,2&#x60; (optional)
     * @param  string|null $name Filter items by the attribute name. &#x60;name&#x3D;age&#x60; (optional)
     * @param  \DateTime|null $date_created Filter items by &#x60;date_created&#x60;. &#x60;date_created&#x3D;2018-09-05T13:43:54&#x60; (optional)
     * @param  string|null $date_created_max Filter items by maximum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by minimum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. &#x60;date_modified&#x3D;2018-09-05T13:45:03&#x60; (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string|null $date_modified_min Filter items by mininum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributeValuesGetAsyncWithHttpInfo($page = null, $limit = null, $customer_id_in = null, $attribute_id_in = null, $name = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, string $contentType = self::contentTypes['customersAttributeValuesGet'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse';
        $request = $this->customersAttributeValuesGetRequest($page, $limit, $customer_id_in, $attribute_id_in, $name, $date_created, $date_created_max, $date_created_min, $date_modified, $date_modified_max, $date_modified_min, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersAttributeValuesGet'
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  int[]|null $customer_id_in Filter items by the customer ID. &#x60;customer_id:in&#x3D;23,24,55&#x60; (optional)
     * @param  int[]|null $attribute_id_in Filter items by the attribute ID. &#x60;attribute_id:in&#x3D;1,2&#x60; (optional)
     * @param  string|null $name Filter items by the attribute name. &#x60;name&#x3D;age&#x60; (optional)
     * @param  \DateTime|null $date_created Filter items by &#x60;date_created&#x60;. &#x60;date_created&#x3D;2018-09-05T13:43:54&#x60; (optional)
     * @param  string|null $date_created_max Filter items by maximum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_created_min Filter items by minimum &#x60;date_created&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  \DateTime|null $date_modified Filter items by &#x60;date_modified&#x60;. &#x60;date_modified&#x3D;2018-09-05T13:45:03&#x60; (optional)
     * @param  \DateTime|null $date_modified_max Filter items by maximum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string|null $date_modified_min Filter items by mininum &#x60;date_modified&#x60;. ISO 8601 full-date is required, ISO 8601 full-time is not required. UNIX timestamp also accepted. &#x60;date_created&#x3D;2021-01-07&#x60; or &#x60;date_created&#x3D;1610051296000&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersAttributeValuesGetRequest($page = null, $limit = null, $customer_id_in = null, $attribute_id_in = null, $name = null, $date_created = null, $date_created_max = null, $date_created_min = null, $date_modified = null, $date_modified_max = null, $date_modified_min = null, string $contentType = self::contentTypes['customersAttributeValuesGet'][0])
    {













        $resourcePath = '/customers/attribute-values';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_id_in,
            'customer_id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attribute_id_in,
            'attribute_id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name,
            'name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created,
            'date_created', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created_max,
            'date_created:max', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_created_min,
            'date_created:min', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified,
            'date_modified', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified_max,
            'date_modified:max', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_modified_min,
            'date_modified:min', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customersAttributeValuesPut
     *
     * Upsert Customer Attribute Values
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttribueValueBase[] $attribue_value_base attribue_value_base (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesPut'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse
     */
    public function customersAttributeValuesPut($attribue_value_base, string $contentType = self::contentTypes['customersAttributeValuesPut'][0])
    {
        list($response) = $this->customersAttributeValuesPutWithHttpInfo($attribue_value_base, $contentType);
        return $response;
    }

    /**
     * Operation customersAttributeValuesPutWithHttpInfo
     *
     * Upsert Customer Attribute Values
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttribueValueBase[] $attribue_value_base (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesPut'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersAttributeValuesPutWithHttpInfo($attribue_value_base, string $contentType = self::contentTypes['customersAttributeValuesPut'][0])
    {
        $request = $this->customersAttributeValuesPutRequest($attribue_value_base, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersAttributeValuesPutAsync
     *
     * Upsert Customer Attribute Values
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttribueValueBase[] $attribue_value_base (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributeValuesPutAsync($attribue_value_base, string $contentType = self::contentTypes['customersAttributeValuesPut'][0])
    {
        return $this->customersAttributeValuesPutAsyncWithHttpInfo($attribue_value_base, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersAttributeValuesPutAsyncWithHttpInfo
     *
     * Upsert Customer Attribute Values
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttribueValueBase[] $attribue_value_base (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAttributeValuesPutAsyncWithHttpInfo($attribue_value_base, string $contentType = self::contentTypes['customersAttributeValuesPut'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\CustomerAttributeValueCollectionResponse';
        $request = $this->customersAttributeValuesPutRequest($attribue_value_base, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersAttributeValuesPut'
     *
     * @param  \Bigcommerce\CustomersV3\Model\AttribueValueBase[] $attribue_value_base (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAttributeValuesPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersAttributeValuesPutRequest($attribue_value_base, string $contentType = self::contentTypes['customersAttributeValuesPut'][0])
    {

        // verify the required parameter 'attribue_value_base' is set
        if ($attribue_value_base === null || (is_array($attribue_value_base) && count($attribue_value_base) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $attribue_value_base when calling customersAttributeValuesPut'
            );
        }


        $resourcePath = '/customers/attribute-values';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($attribue_value_base)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($attribue_value_base));
            } else {
                $httpBody = $attribue_value_base;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
