<?php
/**
 * CustomerAddressesApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Customers V3
 *
 * Create and manage customers.  - [Authentication](#authentication) - [Resources](#resources)  ## Authentication  Requests can be authenticated by sending an `access_token` via `X-Auth-Token` HTTP header:  ```http GET /stores/store_hash/v3/catalog/summary host: api.bigcommerce.com Accept: application/json X-Auth-Token: {access_token} ```  |Header|Parameter|Description| |-|-|-| |`X-Auth-Token`|`access_token `|Obtained by creating an API account or installing an app in a BigCommerce control panel.|  ### OAuth Scopes  | UI Name                                      | Permission | Parameter                                     | |----------------------------------------------|------------|-----------------------------------------------| | Customers                                    | modify     | `store_v2_customers`                          | | Customers                                    | read-only  | `store_v2_customers_read_only`                |  For more information on Authenticating BigCommerce APIs, see: [Authentication](https://developer.bigcommerce.com/api-docs/getting-started/authentication).  ## Resources * [Customer and Subscribers Overview](/api-docs/customers/customers-subscribers-overview).
 *
 * The version of the OpenAPI document: 
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Bigcommerce\CustomersV3\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Bigcommerce\CustomersV3\ApiException;
use Bigcommerce\CustomersV3\Configuration;
use Bigcommerce\CustomersV3\FormDataProcessor;
use Bigcommerce\CustomersV3\HeaderSelector;
use Bigcommerce\CustomersV3\ObjectSerializer;

/**
 * CustomerAddressesApi Class Doc Comment
 *
 * @category Class
 * @package  Bigcommerce\CustomersV3
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomerAddressesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'customersAddressesDelete' => [
            'application/json',
        ],
        'customersAddressesGet' => [
            'application/json',
        ],
        'customersAddressesPost' => [
            'application/json',
        ],
        'customersAddressesPut' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation customersAddressesDelete
     *
     * Delete a Customer Address
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesDelete'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function customersAddressesDelete($id_in, string $contentType = self::contentTypes['customersAddressesDelete'][0])
    {
        $this->customersAddressesDeleteWithHttpInfo($id_in, $contentType);
    }

    /**
     * Operation customersAddressesDeleteWithHttpInfo
     *
     * Delete a Customer Address
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesDelete'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersAddressesDeleteWithHttpInfo($id_in, string $contentType = self::contentTypes['customersAddressesDelete'][0])
    {
        $request = $this->customersAddressesDeleteRequest($id_in, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersAddressesDeleteAsync
     *
     * Delete a Customer Address
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAddressesDeleteAsync($id_in, string $contentType = self::contentTypes['customersAddressesDelete'][0])
    {
        return $this->customersAddressesDeleteAsyncWithHttpInfo($id_in, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersAddressesDeleteAsyncWithHttpInfo
     *
     * Delete a Customer Address
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAddressesDeleteAsyncWithHttpInfo($id_in, string $contentType = self::contentTypes['customersAddressesDelete'][0])
    {
        $returnType = '';
        $request = $this->customersAddressesDeleteRequest($id_in, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersAddressesDelete'
     *
     * @param  int[] $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesDelete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersAddressesDeleteRequest($id_in, string $contentType = self::contentTypes['customersAddressesDelete'][0])
    {

        // verify the required parameter 'id_in' is set
        if ($id_in === null || (is_array($id_in) && count($id_in) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id_in when calling customersAddressesDelete'
            );
        }


        $resourcePath = '/customers/addresses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_in,
            'id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customersAddressesGet
     *
     * Get All Customer Addresses
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  string[]|null $company_in Filter items by company. &#x60;company:in&#x3D;bigcommerce,commongood&#x60; (optional)
     * @param  string[]|null $name_in Filter items by first_name and last_name. &#x60;name:in&#x3D;James+Moriarty&#x60; (optional)
     * @param  int[]|null $customer_id_in Filter by the ID of the customer. Also accepts comma-separated IDs to filter for multiple customers. &#x60;customer_id:in&#x3D;23,24,55&#x60; (optional)
     * @param  string|null $include Indicates whether to include customer address sub-resources: * &#x60;formfields&#x60; - address form fields &#x60;include&#x3D;formfields&#x60; (optional)
     * @param  int[]|null $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesGet'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\AddressCollectionResponse
     */
    public function customersAddressesGet($page = null, $limit = null, $company_in = null, $name_in = null, $customer_id_in = null, $include = null, $id_in = null, string $contentType = self::contentTypes['customersAddressesGet'][0])
    {
        list($response) = $this->customersAddressesGetWithHttpInfo($page, $limit, $company_in, $name_in, $customer_id_in, $include, $id_in, $contentType);
        return $response;
    }

    /**
     * Operation customersAddressesGetWithHttpInfo
     *
     * Get All Customer Addresses
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  string[]|null $company_in Filter items by company. &#x60;company:in&#x3D;bigcommerce,commongood&#x60; (optional)
     * @param  string[]|null $name_in Filter items by first_name and last_name. &#x60;name:in&#x3D;James+Moriarty&#x60; (optional)
     * @param  int[]|null $customer_id_in Filter by the ID of the customer. Also accepts comma-separated IDs to filter for multiple customers. &#x60;customer_id:in&#x3D;23,24,55&#x60; (optional)
     * @param  string|null $include Indicates whether to include customer address sub-resources: * &#x60;formfields&#x60; - address form fields &#x60;include&#x3D;formfields&#x60; (optional)
     * @param  int[]|null $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesGet'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\AddressCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersAddressesGetWithHttpInfo($page = null, $limit = null, $company_in = null, $name_in = null, $customer_id_in = null, $include = null, $id_in = null, string $contentType = self::contentTypes['customersAddressesGet'][0])
    {
        $request = $this->customersAddressesGetRequest($page, $limit, $company_in, $name_in, $customer_id_in, $include, $id_in, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\AddressCollectionResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\AddressCollectionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\AddressCollectionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersAddressesGetAsync
     *
     * Get All Customer Addresses
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  string[]|null $company_in Filter items by company. &#x60;company:in&#x3D;bigcommerce,commongood&#x60; (optional)
     * @param  string[]|null $name_in Filter items by first_name and last_name. &#x60;name:in&#x3D;James+Moriarty&#x60; (optional)
     * @param  int[]|null $customer_id_in Filter by the ID of the customer. Also accepts comma-separated IDs to filter for multiple customers. &#x60;customer_id:in&#x3D;23,24,55&#x60; (optional)
     * @param  string|null $include Indicates whether to include customer address sub-resources: * &#x60;formfields&#x60; - address form fields &#x60;include&#x3D;formfields&#x60; (optional)
     * @param  int[]|null $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAddressesGetAsync($page = null, $limit = null, $company_in = null, $name_in = null, $customer_id_in = null, $include = null, $id_in = null, string $contentType = self::contentTypes['customersAddressesGet'][0])
    {
        return $this->customersAddressesGetAsyncWithHttpInfo($page, $limit, $company_in, $name_in, $customer_id_in, $include, $id_in, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersAddressesGetAsyncWithHttpInfo
     *
     * Get All Customer Addresses
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  string[]|null $company_in Filter items by company. &#x60;company:in&#x3D;bigcommerce,commongood&#x60; (optional)
     * @param  string[]|null $name_in Filter items by first_name and last_name. &#x60;name:in&#x3D;James+Moriarty&#x60; (optional)
     * @param  int[]|null $customer_id_in Filter by the ID of the customer. Also accepts comma-separated IDs to filter for multiple customers. &#x60;customer_id:in&#x3D;23,24,55&#x60; (optional)
     * @param  string|null $include Indicates whether to include customer address sub-resources: * &#x60;formfields&#x60; - address form fields &#x60;include&#x3D;formfields&#x60; (optional)
     * @param  int[]|null $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAddressesGetAsyncWithHttpInfo($page = null, $limit = null, $company_in = null, $name_in = null, $customer_id_in = null, $include = null, $id_in = null, string $contentType = self::contentTypes['customersAddressesGet'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\AddressCollectionResponse';
        $request = $this->customersAddressesGetRequest($page, $limit, $company_in, $name_in, $customer_id_in, $include, $id_in, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersAddressesGet'
     *
     * @param  int|null $page Page number. &#x60;page&#x3D;1&#x60; (optional)
     * @param  float|null $limit Items count per page. &#x60;limit&#x3D;50&#x60; (optional)
     * @param  string[]|null $company_in Filter items by company. &#x60;company:in&#x3D;bigcommerce,commongood&#x60; (optional)
     * @param  string[]|null $name_in Filter items by first_name and last_name. &#x60;name:in&#x3D;James+Moriarty&#x60; (optional)
     * @param  int[]|null $customer_id_in Filter by the ID of the customer. Also accepts comma-separated IDs to filter for multiple customers. &#x60;customer_id:in&#x3D;23,24,55&#x60; (optional)
     * @param  string|null $include Indicates whether to include customer address sub-resources: * &#x60;formfields&#x60; - address form fields &#x60;include&#x3D;formfields&#x60; (optional)
     * @param  int[]|null $id_in Filter items by ID. &#x60;id:in&#x3D;4,5,6&#x60; (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesGet'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersAddressesGetRequest($page = null, $limit = null, $company_in = null, $name_in = null, $customer_id_in = null, $include = null, $id_in = null, string $contentType = self::contentTypes['customersAddressesGet'][0])
    {









        $resourcePath = '/customers/addresses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $company_in,
            'company:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $name_in,
            'name:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $customer_id_in,
            'customer_id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include,
            'include', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id_in,
            'id:in', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customersAddressesPost
     *
     * Create a Customer Address
     *
     * @param  \Bigcommerce\CustomersV3\Model\AddressPost[] $address_post address_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesPost'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\AddressCollectionResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse
     */
    public function customersAddressesPost($address_post, string $contentType = self::contentTypes['customersAddressesPost'][0])
    {
        list($response) = $this->customersAddressesPostWithHttpInfo($address_post, $contentType);
        return $response;
    }

    /**
     * Operation customersAddressesPostWithHttpInfo
     *
     * Create a Customer Address
     *
     * @param  \Bigcommerce\CustomersV3\Model\AddressPost[] $address_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesPost'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\AddressCollectionResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersAddressesPostWithHttpInfo($address_post, string $contentType = self::contentTypes['customersAddressesPost'][0])
    {
        $request = $this->customersAddressesPostRequest($address_post, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\AddressCollectionResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\AddressCollectionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\AddressCollectionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersAddressesPostAsync
     *
     * Create a Customer Address
     *
     * @param  \Bigcommerce\CustomersV3\Model\AddressPost[] $address_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAddressesPostAsync($address_post, string $contentType = self::contentTypes['customersAddressesPost'][0])
    {
        return $this->customersAddressesPostAsyncWithHttpInfo($address_post, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersAddressesPostAsyncWithHttpInfo
     *
     * Create a Customer Address
     *
     * @param  \Bigcommerce\CustomersV3\Model\AddressPost[] $address_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAddressesPostAsyncWithHttpInfo($address_post, string $contentType = self::contentTypes['customersAddressesPost'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\AddressCollectionResponse';
        $request = $this->customersAddressesPostRequest($address_post, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersAddressesPost'
     *
     * @param  \Bigcommerce\CustomersV3\Model\AddressPost[] $address_post (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesPost'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersAddressesPostRequest($address_post, string $contentType = self::contentTypes['customersAddressesPost'][0])
    {

        // verify the required parameter 'address_post' is set
        if ($address_post === null || (is_array($address_post) && count($address_post) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $address_post when calling customersAddressesPost'
            );
        }


        $resourcePath = '/customers/addresses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($address_post)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($address_post));
            } else {
                $httpBody = $address_post;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation customersAddressesPut
     *
     * Update a Customer Address
     *
     * @param  \Bigcommerce\CustomersV3\Model\AddressPut[] $address_put address_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesPut'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Bigcommerce\CustomersV3\Model\AddressCollectionResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse
     */
    public function customersAddressesPut($address_put, string $contentType = self::contentTypes['customersAddressesPut'][0])
    {
        list($response) = $this->customersAddressesPutWithHttpInfo($address_put, $contentType);
        return $response;
    }

    /**
     * Operation customersAddressesPutWithHttpInfo
     *
     * Update a Customer Address
     *
     * @param  \Bigcommerce\CustomersV3\Model\AddressPut[] $address_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesPut'] to see the possible values for this operation
     *
     * @throws \Bigcommerce\CustomersV3\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Bigcommerce\CustomersV3\Model\AddressCollectionResponse|\Bigcommerce\CustomersV3\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function customersAddressesPutWithHttpInfo($address_put, string $contentType = self::contentTypes['customersAddressesPut'][0])
    {
        $request = $this->customersAddressesPutRequest($address_put, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\AddressCollectionResponse',
                        $request,
                        $response,
                    );
                case 422:
                    return $this->handleResponseWithDataType(
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Bigcommerce\CustomersV3\Model\AddressCollectionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\AddressCollectionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Bigcommerce\CustomersV3\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation customersAddressesPutAsync
     *
     * Update a Customer Address
     *
     * @param  \Bigcommerce\CustomersV3\Model\AddressPut[] $address_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAddressesPutAsync($address_put, string $contentType = self::contentTypes['customersAddressesPut'][0])
    {
        return $this->customersAddressesPutAsyncWithHttpInfo($address_put, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation customersAddressesPutAsyncWithHttpInfo
     *
     * Update a Customer Address
     *
     * @param  \Bigcommerce\CustomersV3\Model\AddressPut[] $address_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function customersAddressesPutAsyncWithHttpInfo($address_put, string $contentType = self::contentTypes['customersAddressesPut'][0])
    {
        $returnType = '\Bigcommerce\CustomersV3\Model\AddressCollectionResponse';
        $request = $this->customersAddressesPutRequest($address_put, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'customersAddressesPut'
     *
     * @param  \Bigcommerce\CustomersV3\Model\AddressPut[] $address_put (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['customersAddressesPut'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function customersAddressesPutRequest($address_put, string $contentType = self::contentTypes['customersAddressesPut'][0])
    {

        // verify the required parameter 'address_put' is set
        if ($address_put === null || (is_array($address_put) && count($address_put) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $address_put when calling customersAddressesPut'
            );
        }


        $resourcePath = '/customers/addresses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($address_put)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($address_put));
            } else {
                $httpBody = $address_put;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('X-Auth-Token');
        if ($apiKey !== null) {
            $headers['X-Auth-Token'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
